/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NonAsciiCharactersInspectionFormUi;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.charset.Native2AsciiCharset;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.io.IOUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonAsciiCharactersInspection
extends LocalInspectionTool {
    public boolean CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_NOT_ASCII_STRING_LITERAL;
    public boolean CHECK_FOR_NOT_ASCII_COMMENT;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME = true;
    public boolean CHECK_FOR_DIFFERENT_LANGUAGES_IN_STRING;
    public boolean CHECK_FOR_FILES_CONTAINING_BOM;

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "NonAsciiCharacters";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(2);
        }
        if (!NonAsciiCharactersInspection.isFileWorthIt(session2.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NonAsciiCharactersInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new PsiElementVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                PsiElement identifier;
                PsiElement parent;
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME || NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) && (parent = element2.getParent()) instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)parent).getNameIdentifier()) != null) {
                    String text2 = element2.getText();
                    if (identifier == element2 || text2.equals(identifier.getText())) {
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_IDENTIFIER_NAME) {
                            NonAsciiCharactersInspection.checkAscii(element2, text2, holder, "an identifier");
                        }
                        if (NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_IDENTIFIER_NAME) {
                            NonAsciiCharactersInspection.checkSameLanguage(element2, text2, holder);
                        }
                    }
                }
                if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_COMMENT && element2 instanceof PsiComment) {
                    NonAsciiCharactersInspection.checkAsciiRange(element2, element2.getText(), holder, "a comment");
                }
                if (element2 instanceof PsiLiteralValue) {
                    String text3 = element2.getText();
                    if (NonAsciiCharactersInspection.this.CHECK_FOR_NOT_ASCII_STRING_LITERAL) {
                        NonAsciiCharactersInspection.checkAsciiRange(element2, text3, holder, "a string literal");
                    }
                    if (NonAsciiCharactersInspection.this.CHECK_FOR_DIFFERENT_LANGUAGES_IN_STRING) {
                        NonAsciiCharactersInspection.checkSameLanguage(element2, text3, holder);
                    }
                }
            }

            public void visitFile(@NotNull PsiFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitFile(file2);
                if (NonAsciiCharactersInspection.this.CHECK_FOR_FILES_CONTAINING_BOM) {
                    byte[] bom;
                    VirtualFile virtualFile = file2.getVirtualFile();
                    byte[] byArray = bom = virtualFile == null ? null : virtualFile.getBOM();
                    if (bom != null) {
                        String hex = IntStream.range(0, bom.length).map(i2 -> bom[i2]).mapToObj(b -> StringUtil.toUpperCase((String)Integer.toString(b & 0xFF, 16))).collect(Collectors.joining());
                        Charset charsetFromBOM = CharsetToolkit.guessFromBOM((byte[])bom);
                        holder.registerProblem((PsiElement)file2, LangBundle.message((String)"inspection.message.file.contains.bom", (Object[])new Object[]{hex, charsetFromBOM == null ? "" : LangBundle.message((String)"inspection.message.charset.signature", (Object[])new Object[]{charsetFromBOM.displayName()})}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/NonAsciiCharactersInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitFile";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isFileWorthIt(@NotNull PsiFile file2) {
        if (file2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(4);
        }
        if (InjectedLanguageManager.getInstance((Project)file2.getProject()).isInjectedFragment(file2)) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        CharSequence text2 = file2.getViewProvider().getContents();
        Charset charset = LoadTextUtil.extractCharsetFromFileContent(file2.getProject(), virtualFile, text2);
        return !(charset instanceof Native2AsciiCharset);
    }

    private static void checkSameLanguage(@NotNull PsiElement element2, @NotNull String text2, @NotNull ProblemsHolder holder) {
        Set scripts;
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(5);
        }
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(7);
        }
        if ((scripts = text2.codePoints().mapToObj(Character.UnicodeScript::of).filter(script -> !script.equals((Object)Character.UnicodeScript.COMMON)).collect(Collectors.toSet())).size() > 1) {
            ArrayList list2 = new ArrayList(scripts);
            Collections.sort(list2);
            holder.registerProblem(element2, LangBundle.message((String)"inspection.message.symbols.from.different.languages.found", (Object[])new Object[]{list2}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkAscii(@NotNull PsiElement element2, @NotNull String text2, @NotNull ProblemsHolder holder, @NotNull String where) {
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(8);
        }
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(10);
        }
        if (where == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(11);
        }
        if (!IOUtil.isAscii((String)text2)) {
            holder.registerProblem(element2, LangBundle.message((String)"inspection.message.non.ascii.characters.in", (Object[])new Object[]{where}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static void checkAsciiRange(@NotNull PsiElement element2, @NotNull String text2, @NotNull ProblemsHolder holder, @NotNull String where) {
        if (element2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(13);
        }
        if (holder == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(14);
        }
        if (where == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(15);
        }
        int errorCount = 0;
        int start2 = -1;
        for (int i2 = 0; i2 <= text2.length(); ++i2) {
            char c;
            char c2 = c = i2 >= text2.length() ? (char)'\u0000' : text2.charAt(i2);
            if (i2 == text2.length() || c < '\u0080') {
                if (start2 == -1) continue;
                TextRange range2 = new TextRange(start2, i2);
                String message2 = LangBundle.message((String)"inspection.message.non.ascii.characters.in", (Object[])new Object[]{where});
                holder.registerProblem(element2, range2, message2, new LocalQuickFix[0]);
                start2 = -1;
                if (errorCount++ <= 200) continue;
                break;
            }
            if (start2 != -1) continue;
            start2 = i2;
        }
    }

    @NotNull
    public JComponent createOptionsPanel() {
        DialogPanel dialogPanel = new NonAsciiCharactersInspectionFormUi((InspectionProfileEntry)this).getPanel();
        if (dialogPanel == null) {
            NonAsciiCharactersInspection.$$$reportNull$$$0(16);
        }
        return dialogPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NonAsciiCharactersInspection";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NonAsciiCharactersInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isFileWorthIt";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkSameLanguage";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkAscii";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkAsciiRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

