/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.intellij.ProjectTopics;
import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectResultsConsumer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionToolCmdlineOptionHelpProvider;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ex.ApplicationInspectionProfileManagerBase;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.ReportConverterUtil;
import com.intellij.codeInspection.ex.XSLTReportConverter;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.targets.QodanaConfig;
import com.intellij.codeInspection.targets.QodanaKt;
import com.intellij.codeInspection.targets.QodanaProfile;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.conversion.ConversionListener;
import com.intellij.conversion.ConversionService;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommandLineInspectionProgressReporter;
import com.intellij.ide.CommandLineInspectionProjectConfigurator;
import com.intellij.ide.impl.PatchProjectUtil;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.VcsPreservingExecutor;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

public final class InspectionApplication
implements CommandLineInspectionProgressReporter {
    static final Logger LOG = Logger.getInstance(InspectionApplication.class);
    InspectionToolCmdlineOptionHelpProvider myHelpProvider;
    public String myProjectPath;
    public String myOutPath;
    String mySourceDirectory;
    public String myStubProfile;
    public String myProfileName;
    public String myProfilePath;
    public boolean myRunWithEditorSettings;
    public boolean myRunGlobalToolsOnly;
    public boolean myAnalyzeChanges;
    boolean myPathProfiling;
    boolean myQodanaRun;
    public QodanaConfig myQodanaConfig;
    private int myVerboseLevel;
    private final Map<String, List<Range>> diffMap = new ConcurrentHashMap<String, List<Range>>();
    private final MultiMap<Pair<String, Integer>, String> originalWarnings = MultiMap.createConcurrent();
    private final AsyncPromise<Void> isMappingLoaded = new AsyncPromise();
    public String myOutputFormat;
    public InspectionProfileImpl myInspectionProfile;
    public String myTargets;
    public boolean myErrorCodeRequired = true;
    public String myScopePattern;
    Map<Path, Long> myCompleteProfile;

    public void startup() {
        if (this.myProjectPath == null) {
            this.reportError("Project to inspect is not defined");
            this.printHelp();
        }
        if (this.myProfileName == null && this.myProfilePath == null && this.myStubProfile == null) {
            this.reportError("Profile to inspect with is not defined");
            this.printHelp();
        }
        ApplicationManagerEx.getApplicationEx().setSaveAllowed(false);
        try {
            this.execute();
        }
        catch (Throwable e) {
            LOG.error(e);
            this.reportError(e.getMessage());
            this.gracefulExit();
            return;
        }
        if (this.myErrorCodeRequired) {
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
    }

    public void enablePathProfiling() {
        this.myPathProfiling = true;
    }

    public Map<Path, Long> getPathProfile() {
        return this.myCompleteProfile;
    }

    public void execute() throws Exception {
        ApplicationInfoEx appInfo = (ApplicationInfoEx)ApplicationInfo.getInstance();
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.starting.up", (Object[])new Object[]{appInfo.getFullApplicationName() + " (build " + appInfo.getBuild().asString() + ")"}));
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        Disposable disposable2 = Disposer.newDisposable();
        try {
            this.run(Paths.get(FileUtil.toCanonicalPath((String)this.myProjectPath), new String[0]), disposable2);
        }
        finally {
            Disposer.dispose((Disposable)disposable2);
        }
    }

    private void printHelp() {
        assert (this.myHelpProvider != null);
        this.myHelpProvider.printHelpAndExit();
    }

    @NotNull
    private CommandLineInspectionProjectConfigurator.ConfiguratorContext configuratorContext(final @NotNull Path projectPath, final @Nullable AnalysisScope scope) {
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(0);
        }
        return new CommandLineInspectionProjectConfigurator.ConfiguratorContext(){

            @Override
            @NotNull
            public ProgressIndicator getProgressIndicator() {
                return new ProgressIndicatorBase();
            }

            @Override
            @Nullable
            public AnalysisScope getAnalyzerScope() {
                return scope;
            }

            @Override
            @NotNull
            public CommandLineInspectionProgressReporter getLogger() {
                InspectionApplication inspectionApplication = InspectionApplication.this;
                if (inspectionApplication == null) {
                    1.$$$reportNull$$$0(0);
                }
                return inspectionApplication;
            }

            @Override
            @NotNull
            public Path getProjectPath() {
                Path path = projectPath;
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                return path;
            }

            @Override
            @NotNull
            public Predicate<Path> getFilesFilter() {
                com.google.common.base.Predicate predicate2 = Predicates.alwaysTrue();
                if (predicate2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return predicate2;
            }

            @Override
            @NotNull
            public Predicate<VirtualFile> getVirtualFilesFilter() {
                com.google.common.base.Predicate predicate2 = Predicates.alwaysTrue();
                if (predicate2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                return predicate2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/codeInspection/InspectionApplication$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLogger";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProjectPath";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFilesFilter";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVirtualFilesFilter";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private void run(@NotNull Path projectPath, @NotNull Disposable parentDisposable) throws IOException, JDOMException, InterruptedException, ExecutionException {
        InspectionsReportConverter reportConverter;
        VirtualFile vfsProject;
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(1);
        }
        if (parentDisposable == null) {
            InspectionApplication.$$$reportNull$$$0(2);
        }
        if ((vfsProject = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)projectPath.toString()))) == null) {
            this.reportError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{projectPath}));
            this.printHelp();
        }
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.opening.project", (Object[])new Object[0]));
        if (ConversionService.getInstance().convertSilently(projectPath, this.createConversionListener()).openingIsCanceled()) {
            this.gracefulExit();
            return;
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getExtensionList()) {
            CommandLineInspectionProjectConfigurator.ConfiguratorContext context;
            if (!configurator.isApplicable(context = this.configuratorContext(projectPath, null))) continue;
            configurator.configureEnvironment(context);
        }
        if (Boolean.getBoolean("log.project.structure.changes") && (reportConverter = ReportConverterUtil.getReportConverter(this.myOutputFormat)) != null) {
            this.addRootChangesListener(parentDisposable, reportConverter);
        }
        AtomicReference projectRef = new AtomicReference();
        ProgressManager.getInstance().runProcess(() -> projectRef.set(ProjectUtil.openOrImport(projectPath)), (ProgressIndicator)this.createProcessIndicator());
        Project project = (Project)projectRef.get();
        if (project == null) {
            this.reportError("Unable to open project");
            this.gracefulExit();
            return;
        }
        InspectionApplication.waitAllStartupActivitiesPassed(project);
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, () -> this.isMappingLoaded.setResult(null));
        Disposer.register((Disposable)parentDisposable, () -> InspectionApplication.closeProject(project));
        ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().refreshWithoutFileWatcher(false));
        ApplicationManager.getApplication().invokeAndWait(() -> PatchProjectUtil.patchProject(project));
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        this.reportMessageNoLineBreak(1, InspectionsBundle.message((String)"inspection.application.initializing.project", (Object[])new Object[0]));
        this.loadQodanaConfig(projectPath);
        if (this.myInspectionProfile == null) {
            this.myInspectionProfile = this.loadInspectionProfile(project);
        }
        this.myQodanaConfig.updateToolsScopes(this.myInspectionProfile, project);
        AnalysisScope scope = this.getAnalysisScope(project);
        if (scope == null) {
            return;
        }
        LOG.info("Used scope: " + scope);
        if (this.myQodanaRun) {
            QodanaKt.runAnalysisByQodana(this, projectPath, project, this.myInspectionProfile, scope);
        } else {
            this.runAnalysisOnScope(projectPath, parentDisposable, project, this.myInspectionProfile, scope);
        }
    }

    private void loadQodanaConfig(Path projectPath) {
        if (this.myQodanaRun) {
            this.myQodanaConfig = QodanaConfig.Companion.load(projectPath);
            this.myQodanaConfig.copyToLog(projectPath);
        } else {
            this.myQodanaConfig = QodanaConfig.EMPTY;
        }
    }

    @Nullable
    private AnalysisScope getAnalysisScope(@NotNull Project project) throws ExecutionException, InterruptedException {
        GlobalSearchScope qodanaScope;
        GlobalSearchScope scope;
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(3);
        }
        if (this.myAnalyzeChanges) {
            List<VirtualFile> files2 = this.getChangedFiles(project);
            scope = GlobalSearchScope.filesWithoutLibrariesScope((Project)project, files2);
        } else if (this.myScopePattern != null) {
            try {
                PackageSet packageSet = PackageSetFactory.getInstance().compile(this.myScopePattern);
                NamedScope namedScope = new NamedScope("commandLineScope", AllIcons.Ide.LocalScope, packageSet);
                scope = GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope);
            }
            catch (ParsingException e) {
                LOG.error("Error of scope parsing", (Throwable)e);
                this.gracefulExit();
                return null;
            }
        } else if (this.mySourceDirectory == null) {
            String scopeName = System.getProperty("idea.analyze.scope");
            NamedScope namedScope = scopeName != null ? NamedScopesHolder.getScope((Project)project, (String)scopeName) : null;
            scope = namedScope != null ? GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope) : GlobalSearchScope.projectScope((Project)project);
        } else {
            this.mySourceDirectory = this.mySourceDirectory.replace(File.separatorChar, '/');
            VirtualFile vfsDir = LocalFileSystem.getInstance().findFileByPath(this.mySourceDirectory);
            if (vfsDir == null) {
                this.reportError(InspectionsBundle.message((String)"inspection.application.directory.cannot.be.found", (Object[])new Object[]{this.mySourceDirectory}));
                this.printHelp();
            }
            scope = GlobalSearchScopesCore.directoriesScope((Project)project, (boolean)true, (VirtualFile[])new VirtualFile[]{Objects.requireNonNull(vfsDir)});
        }
        if (this.myQodanaConfig != null && (qodanaScope = this.myQodanaConfig.getGlobalScope(project)) != null) {
            scope = qodanaScope.intersectWith((SearchScope)scope);
        }
        return new AnalysisScope((SearchScope)scope, project);
    }

    private void addRootChangesListener(Disposable parentDisposable, final InspectionsReportConverter reportConverter) {
        MessageBusConnection applicationBus = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        applicationBus.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                InspectionApplication.subscribeToRootChanges(project, reportConverter);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/InspectionApplication$2", "projectOpened"));
            }
        });
    }

    private static void subscribeToRootChanges(final Project project, final InspectionsReportConverter reportConverter) {
        final Path rootLogDir = Paths.get(PathManager.getLogPath(), new String[0]).resolve("projectStructureChanges");
        rootLogDir.toFile().mkdirs();
        final AtomicInteger counter = new AtomicInteger(0);
        reportConverter.projectData(project, rootLogDir.resolve("state0"));
        MessageBusConnection connection = project.getMessageBus().connect();
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                int i2 = counter.incrementAndGet();
                reportConverter.projectData(project, rootLogDir.resolve("state" + i2));
                LOG.info("Project structure update written. Change number " + i2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInspection/InspectionApplication$3", "rootsChanged"));
            }
        });
    }

    private List<VirtualFile> getChangedFiles(@NotNull Project project) throws ExecutionException, InterruptedException {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(4);
        }
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        CompletableFuture future2 = new CompletableFuture();
        changeListManager.invokeAfterUpdateWithModal(false, null, () -> {
            try {
                List files2 = changeListManager.getAffectedFiles();
                for (VirtualFile file2 : files2) {
                    this.reportMessage(0, "modified file" + file2.getPath());
                }
                future2.complete(files2);
            }
            catch (Throwable e) {
                future2.completeExceptionally(e);
            }
        });
        return (List)future2.get();
    }

    private static void waitAllStartupActivitiesPassed(@NotNull Project project) throws InterruptedException, ExecutionException {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(!ApplicationManager.getApplication().isDispatchThread());
        LOG.info("Waiting for startup activities");
        int timeout = Registry.intValue((String)"batch.inspections.startup.activities.timeout", (int)180);
        try {
            StartupManagerEx.getInstanceEx(project).getAllActivitiesPassedFuture().get(timeout, TimeUnit.MINUTES);
            LOG.info("Startup activities finished");
        }
        catch (TimeoutException e) {
            String threads = ThreadDumper.dumpThreadsToString();
            throw new RuntimeException(String.format("Cannot process startup activities in %s minutes. ", timeout) + "You can try to increase batch.inspections.startup.activities.timeout registry value. Thread dumps\n: " + threads, e);
        }
    }

    @NotNull
    public GlobalInspectionContextEx createGlobalInspectionContext(Project project) {
        InspectionManagerBase im = (InspectionManagerBase)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextEx context = (GlobalInspectionContextEx)im.createNewGlobalContext();
        context.setExternalProfile(this.myInspectionProfile);
        if (this.myPathProfiling) {
            context.startPathProfiling();
        }
        im.setProfile(this.myInspectionProfile.getName());
        GlobalInspectionContextEx globalInspectionContextEx = context;
        if (globalInspectionContextEx == null) {
            InspectionApplication.$$$reportNull$$$0(6);
        }
        return globalInspectionContextEx;
    }

    public void runAnalysisOnScope(Path projectPath, @NotNull Disposable parentDisposable, Project project, InspectionProfileImpl inspectionProfile, AnalysisScope scope) throws IOException {
        Path resultsDataPath;
        InspectionsReportConverter reportConverter;
        if (parentDisposable == null) {
            InspectionApplication.$$$reportNull$$$0(7);
        }
        this.reportMessage(1, InspectionsBundle.message((String)"inspection.done", (Object[])new Object[0]));
        if (!this.myRunWithEditorSettings) {
            this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.chosen.profile.log.message", (Object[])new Object[]{inspectionProfile.getName()}));
        }
        if ((reportConverter = ReportConverterUtil.getReportConverter(this.myOutputFormat)) == null && this.myOutputFormat != null && this.myOutputFormat.endsWith(".xsl")) {
            reportConverter = new XSLTReportConverter(this.myOutputFormat);
        }
        try {
            resultsDataPath = ReportConverterUtil.getResultsDataPath(parentDisposable, reportConverter, this.myOutPath);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            System.err.println("Cannot create tmp directory.");
            System.exit(1);
            return;
        }
        this.runAnalysis(project, projectPath, inspectionProfile, scope, reportConverter, resultsDataPath);
    }

    public void configureProject(@NotNull Path projectPath, @NotNull Project project, @NotNull AnalysisScope scope) {
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(8);
        }
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            InspectionApplication.$$$reportNull$$$0(10);
        }
        for (CommandLineInspectionProjectConfigurator configurator : CommandLineInspectionProjectConfigurator.EP_NAME.getIterable()) {
            CommandLineInspectionProjectConfigurator.ConfiguratorContext context;
            if (!configurator.isApplicable(context = this.configuratorContext(projectPath, scope))) continue;
            configurator.configureProject(project, context);
        }
        InspectionApplication.waitForInvokeLaterActivities();
    }

    private static void waitForInvokeLaterActivities() {
        ApplicationManager.getApplication().invokeAndWait(() -> {}, ModalityState.any());
    }

    private void runAnalysis(Project project, Path projectPath, InspectionProfileImpl inspectionProfile, AnalysisScope scope, InspectionsReportConverter reportConverter, Path resultsDataPath) throws IOException {
        GlobalInspectionContextEx context = this.createGlobalInspectionContext(project);
        if (this.myAnalyzeChanges) {
            AnalysisScope baseScope = scope;
            GlobalInspectionContextEx baseContext = this.createGlobalInspectionContext(project);
            scope = this.runAnalysisOnCodeWithoutChanges(project, baseContext, () -> this.runUnderProgress(project, projectPath, baseContext, baseScope, resultsDataPath, new ArrayList()));
            this.setupSecondAnalysisHandler(project, context);
        }
        ArrayList<Path> inspectionsResults = new ArrayList<Path>();
        this.runUnderProgress(project, projectPath, context, scope, resultsDataPath, inspectionsResults);
        Path descriptionsFile = resultsDataPath.resolve(".descriptions.xml");
        InspectionsResultUtil.describeInspections(descriptionsFile, this.myRunWithEditorSettings ? null : inspectionProfile.getName(), inspectionProfile);
        inspectionsResults.add(descriptionsFile);
        this.saveProfile(context);
        if (reportConverter != null) {
            try {
                List results = ContainerUtil.map2List(inspectionsResults, path -> path.toFile());
                reportConverter.convert(resultsDataPath.toString(), this.myOutPath, context.getTools(), results);
                InspectResultsConsumer.runConsumers(context.getTools(), results, project);
                if (this.myOutPath != null) {
                    reportConverter.projectData(project, Paths.get(this.myOutPath, new String[0]).resolve("projectStructure"));
                }
            }
            catch (InspectionsReportConverter.ConversionException e) {
                this.reportError("\n" + e.getMessage());
                this.printHelp();
            }
        }
    }

    private void saveProfile(GlobalInspectionContextEx context) {
        if (!this.myPathProfiling) {
            return;
        }
        Map<Path, Long> profile = context.getPathProfile();
        HashMap<Path, Long> completeProfile = new HashMap<Path, Long>();
        profile.forEach((path, millis) -> {
            while (path != null) {
                completeProfile.merge((Path)path, (Long)millis, Long::sum);
                path = path.getParent();
            }
        });
        this.myCompleteProfile = completeProfile;
    }

    @NotNull
    public AnalysisScope runAnalysisOnCodeWithoutChanges(Project project, GlobalInspectionContextEx context, Runnable analysisRunner) {
        VirtualFile[] changes = ChangesUtil.getFilesFromChanges((Collection)ChangeListManager.getInstance((Project)project).getAllChanges());
        this.setupFirstAnalysisHandler(context);
        DumbService dumbService = DumbService.getInstance((Project)project);
        while (dumbService.isDumb()) {
            LockSupport.parkNanos(50000000L);
        }
        if (ProjectLevelVcsManager.getInstance((Project)project).getAllVcsRoots().length == 0) {
            try {
                this.isMappingLoaded.blockingGet(60000);
            }
            catch (ExecutionException | TimeoutException e) {
                this.reportError("Cannot initialize vcs mapping");
                this.gracefulExit();
            }
        }
        InspectionApplication.runAnalysisAfterShelvingSync(project, ChangeListManager.getInstance((Project)project).getAffectedFiles(), this.createProcessIndicator(), () -> {
            InspectionApplication.syncProject(project, changes);
            analysisRunner.run();
        });
        InspectionApplication.syncProject(project, changes);
        List files2 = ChangeListManager.getInstance((Project)project).getAffectedFiles();
        if (this.myVerboseLevel == 3) {
            for (VirtualFile file2 : files2) {
                this.reportMessage(1, "modified after unshelving: " + file2.getPath());
            }
        }
        return new AnalysisScope(project, (Collection)files2);
    }

    private static void syncProject(Project project, VirtualFile[] changes) {
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])changes);
        WriteAction.runAndWait(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
    }

    private void setupFirstAnalysisHandler(GlobalInspectionContextEx context) {
        if (this.myVerboseLevel > 0) {
            this.reportMessage(1, "Running first analysis stage...");
        }
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplication.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            this.originalWarnings.putValue((Object)Pair.create((Object)((VirtualFile)fileAndLine.first).getPath(), (Object)((Integer)fileAndLine.second)), (Object)description);
            return false;
        });
        context.setReportedProblemFilter((element2, descriptors2) -> {
            List problemDescriptors = StreamEx.of((Object[])descriptors2).select(ProblemDescriptorBase.class).toList();
            if (!problemDescriptors.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)problemDescriptors.get(0);
                VirtualFile file2 = problemDescriptor.getContainingFile();
                if (file2 == null) {
                    return false;
                }
                int lineNumber = problemDescriptor.getLineNumber();
                for (ProblemDescriptorBase it : problemDescriptors) {
                    this.originalWarnings.putValue((Object)Pair.create((Object)file2.getPath(), (Object)lineNumber), (Object)it.toString());
                }
            }
            return false;
        });
    }

    public void setupSecondAnalysisHandler(Project project, GlobalInspectionContextEx context) {
        if (this.myVerboseLevel > 0) {
            this.reportMessage(1, "Running second analysis stage...");
        }
        this.printBeforeSecondStageProblems();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        context.setGlobalReportedProblemFilter((entity, description) -> {
            if (!(entity instanceof RefElement)) {
                return false;
            }
            Pair<VirtualFile, Integer> fileAndLine = InspectionApplication.findFileAndLineByRefElement((RefElement)entity);
            if (fileAndLine == null) {
                return false;
            }
            return this.secondAnalysisFilter(changeListManager, description, (VirtualFile)fileAndLine.first, (Integer)fileAndLine.second);
        });
        context.setReportedProblemFilter((element2, descriptors2) -> {
            List any = StreamEx.of((Object[])descriptors2).select(ProblemDescriptorBase.class).toList();
            if (!any.isEmpty()) {
                ProblemDescriptorBase problemDescriptor = (ProblemDescriptorBase)any.get(0);
                String text2 = problemDescriptor.toString();
                VirtualFile file2 = problemDescriptor.getContainingFile();
                if (file2 == null) {
                    return true;
                }
                int line = problemDescriptor.getLineNumber();
                return this.secondAnalysisFilter(changeListManager, text2, file2, line);
            }
            return true;
        });
    }

    @Nullable
    private static Pair<VirtualFile, Integer> findFileAndLineByRefElement(RefElement refElement) {
        PsiElement element2 = refElement.getPsiElement();
        PsiFile psiFile = element2.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        int line = (Integer)ReadAction.compute(() -> {
            Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            return document == null ? -1 : document.getLineNumber(element2.getTextRange().getStartOffset());
        });
        return Pair.create((Object)virtualFile, (Object)line);
    }

    private boolean secondAnalysisFilter(ChangeListManager changeListManager, String text2, VirtualFile file2, int line) {
        List<Range> ranges = this.getOrComputeUnchangedRanges(file2, changeListManager);
        Optional first = StreamEx.of(ranges).findFirst(it -> it.start1 <= line && line < it.end1);
        if (first.isEmpty()) {
            this.logNotFiltered(text2, file2, line, -1);
            return true;
        }
        Range originRange = (Range)first.get();
        int position = originRange.start2 + line - originRange.start1;
        Collection problems = this.originalWarnings.get((Object)Pair.create((Object)file2.getPath(), (Object)position));
        if (problems.stream().anyMatch(it -> Objects.equals(it, text2))) {
            return false;
        }
        this.logNotFiltered(text2, file2, line, position);
        return true;
    }

    private void logNotFiltered(String text2, VirtualFile file2, int line, int position) {
        if (text2.contains("unused")) {
            return;
        }
        this.reportMessage(3, "Not filtered: ");
        this.reportMessage(3, file2.getPath() + ":" + (line + 1) + " Original: " + (position + 1));
        this.reportMessage(3, "\t\t" + text2);
    }

    private void printBeforeSecondStageProblems() {
        if (this.myVerboseLevel == 3) {
            this.reportMessage(3, "Old warnings:");
            ArrayList<Map.Entry> entries2 = new ArrayList<Map.Entry>(this.originalWarnings.entrySet());
            this.reportMessage(3, "total size: " + entries2.size());
            entries2.sort(Comparator.comparing(o -> (String)((Pair)o.getKey()).first).thenComparingInt(o -> (Integer)((Pair)o.getKey()).second));
            for (Map.Entry entry : entries2) {
                this.reportMessage(3, (String)((Pair)entry.getKey()).first + ":" + ((Integer)((Pair)entry.getKey()).second + 1));
                for (String value2 : (Collection)entry.getValue()) {
                    this.reportMessage(3, "\t\t" + value2);
                }
            }
        }
    }

    private void runUnderProgress(@NotNull Project project, @NotNull Path projectPath, @NotNull GlobalInspectionContextEx context, @NotNull AnalysisScope scope, @NotNull Path resultsDataPath, @NotNull List<? super Path> inspectionsResults) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(11);
        }
        if (projectPath == null) {
            InspectionApplication.$$$reportNull$$$0(12);
        }
        if (context == null) {
            InspectionApplication.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            InspectionApplication.$$$reportNull$$$0(14);
        }
        if (resultsDataPath == null) {
            InspectionApplication.$$$reportNull$$$0(15);
        }
        if (inspectionsResults == null) {
            InspectionApplication.$$$reportNull$$$0(16);
        }
        ProgressManager.getInstance().runProcess(() -> {
            this.configureProject(projectPath, project, scope);
            if (!GlobalInspectionContextUtil.canRunInspections(project, false, () -> {})) {
                this.gracefulExit();
                return;
            }
            context.launchInspectionsOffline(scope, resultsDataPath, this.myRunGlobalToolsOnly, inspectionsResults);
            this.reportMessage(1, "\n" + InspectionsBundle.message((String)"inspection.capitalized.done", (Object[])new Object[0]) + "\n");
            if (!this.myErrorCodeRequired) {
                InspectionApplication.closeProject(project);
            }
        }, (ProgressIndicator)this.createProcessIndicator());
    }

    @NotNull
    private ProgressIndicatorBase createProcessIndicator() {
        return new ProgressIndicatorBase(){
            private String lastPrefix = "";
            private int myLastPercent = -1;
            {
                this.setText("");
            }

            @Override
            public void setText(String text2) {
                if (InspectionApplication.this.myVerboseLevel == 0) {
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 1) {
                    if (text2 == null) {
                        return;
                    }
                    String prefix = InspectionApplication.getPrefix(text2);
                    if (prefix == null) {
                        return;
                    }
                    if (prefix.equals(this.lastPrefix)) {
                        InspectionApplication.this.reportMessageNoLineBreak(1, ".");
                        return;
                    }
                    this.lastPrefix = prefix;
                    InspectionApplication.this.reportMessage(1, "");
                    InspectionApplication.this.reportMessage(1, prefix);
                    return;
                }
                if (InspectionApplication.this.myVerboseLevel == 3) {
                    if (text2 == null) {
                        return;
                    }
                    if (!this.isIndeterminate() && this.getFraction() > 0.0) {
                        int percent = (int)(this.getFraction() * 100.0);
                        if (this.myLastPercent == percent) {
                            return;
                        }
                        String prefix = InspectionApplication.getPrefix(text2);
                        this.myLastPercent = percent;
                        String msg = (prefix != null ? prefix : InspectionsBundle.message((String)"inspection.display.name", (Object[])new Object[0])) + " " + percent + "%";
                        InspectionApplication.this.reportMessage(2, msg);
                    }
                    return;
                }
                InspectionApplication.this.reportMessage(2, text2);
            }
        };
    }

    private static void runAnalysisAfterShelvingSync(Project project, List<? extends VirtualFile> files2, ProgressIndicator progressIndicator, Runnable afterShelve) {
        Set versionedRoots = StreamEx.of(files2).map(it -> ProjectLevelVcsManager.getInstance((Project)project).getVcsRootFor(it)).nonNull().toSet();
        String message2 = VcsBundle.message((String)"searching.for.code.smells.freezing.process", (Object[])new Object[0]);
        VcsPreservingExecutor.executeOperation((Project)project, (Collection)versionedRoots, (String)message2, (ProgressIndicator)progressIndicator, (Runnable)afterShelve);
    }

    public void gracefulExit() {
        if (!this.myErrorCodeRequired) {
            throw new RuntimeException("Failed to proceed");
        }
        System.exit(1);
    }

    private static void closeProject(@NotNull Project project) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (!project.isDisposed()) {
                if (Boolean.getBoolean("inspect.save.project.settings")) {
                    StoreUtil.saveSettings((ComponentManager)project, true);
                }
                ProjectManagerEx.getInstanceEx().forceCloseProject(project);
            }
        });
    }

    @NotNull
    public InspectionProfileImpl loadInspectionProfile(@NotNull Project project) throws IOException, JDOMException {
        QodanaProfile qodanaProfile;
        InspectionProfileImpl profile;
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(18);
        }
        if ((profile = this.loadInspectionProfile(project, this.myProfileName, this.myProfilePath, "command line")) != null) {
            InspectionProfileImpl inspectionProfileImpl = profile;
            if (inspectionProfileImpl == null) {
                InspectionApplication.$$$reportNull$$$0(19);
            }
            return inspectionProfileImpl;
        }
        if (this.myQodanaRun && (profile = this.loadInspectionProfile(project, (qodanaProfile = this.myQodanaConfig.getProfile()).getName(), qodanaProfile.getPath(), "qodana.yaml")) != null) {
            InspectionProfileImpl inspectionProfileImpl = profile;
            if (inspectionProfileImpl == null) {
                InspectionApplication.$$$reportNull$$$0(20);
            }
            return inspectionProfileImpl;
        }
        if (this.myStubProfile != null && !this.myRunWithEditorSettings) {
            profile = this.loadProfileByName(project, this.myStubProfile);
            if (profile != null) {
                InspectionProfileImpl inspectionProfileImpl = profile;
                if (inspectionProfileImpl == null) {
                    InspectionApplication.$$$reportNull$$$0(21);
                }
                return inspectionProfileImpl;
            }
            profile = this.loadProfileByPath(this.myStubProfile);
            if (profile != null) {
                InspectionProfileImpl inspectionProfileImpl = profile;
                if (inspectionProfileImpl == null) {
                    InspectionApplication.$$$reportNull$$$0(22);
                }
                return inspectionProfileImpl;
            }
        }
        if (this.myQodanaRun && (profile = this.loadInspectionProfile(project, "qodana.recommended", "", "qodana default inspection profile")) != null) {
            InspectionProfileImpl inspectionProfileImpl = profile;
            if (inspectionProfileImpl == null) {
                InspectionApplication.$$$reportNull$$$0(23);
            }
            return inspectionProfileImpl;
        }
        profile = InspectionProjectProfileManager.getInstance(project).getCurrentProfile();
        this.reportError("Using default project profile");
        InspectionProfileImpl inspectionProfileImpl = profile;
        if (inspectionProfileImpl == null) {
            InspectionApplication.$$$reportNull$$$0(24);
        }
        return inspectionProfileImpl;
    }

    @Nullable
    public InspectionProfileImpl loadInspectionProfile(@NotNull Project project, @Nullable String profileName, @Nullable String profilePath, @NotNull String configSource) throws IOException, JDOMException {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(25);
        }
        if (configSource == null) {
            InspectionApplication.$$$reportNull$$$0(26);
        }
        if (profileName != null && !profileName.isEmpty()) {
            InspectionProfileImpl inspectionProfile = this.loadProfileByName(project, profileName);
            if (inspectionProfile == null) {
                this.reportError("Profile with configured name (" + profileName + ") was not found (neither in project nor in config directory). Configured by: " + configSource);
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        if (profilePath != null && !profilePath.isEmpty()) {
            InspectionProfileImpl inspectionProfile = this.loadProfileByPath(profilePath);
            if (inspectionProfile == null) {
                this.reportError("Failed to load profile from '" + profilePath + "'. Configured by: " + configSource);
                this.gracefulExit();
                return null;
            }
            return inspectionProfile;
        }
        return null;
    }

    @Nullable
    public InspectionProfileImpl loadProfileByPath(@NotNull String profilePath) throws IOException, JDOMException {
        InspectionProfileImpl inspectionProfile;
        if (profilePath == null) {
            InspectionApplication.$$$reportNull$$$0(27);
        }
        if ((inspectionProfile = ApplicationInspectionProfileManagerBase.getInstanceBase().loadProfile(profilePath)) != null) {
            this.reportMessage(1, "Loaded profile '" + inspectionProfile.getName() + "' from file '" + profilePath + "'");
        }
        return inspectionProfile;
    }

    @Nullable
    public InspectionProfileImpl loadProfileByName(@NotNull Project project, @NotNull String profileName) {
        if (project == null) {
            InspectionApplication.$$$reportNull$$$0(28);
        }
        if (profileName == null) {
            InspectionApplication.$$$reportNull$$$0(29);
        }
        InspectionProfileManager.getInstance().getProfiles();
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(project);
        InspectionProfileImpl inspectionProfile = profileManager.getProfile(profileName, false);
        if (inspectionProfile != null) {
            this.reportMessage(1, "Loaded shared project profile '" + profileName + "'");
        } else {
            for (InspectionProfileImpl profile : profileManager.getProfiles()) {
                if (!Comparing.strEqual((String)profile.getName(), (String)profileName)) continue;
                inspectionProfile = profile;
                this.reportMessage(1, "Loaded local profile '" + profileName + "'");
                break;
            }
        }
        return inspectionProfile;
    }

    private ConversionListener createConversionListener() {
        return new ConversionListener(){

            @Override
            public void conversionNeeded() {
                InspectionApplication.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.has.older.format.and.will.be.converted", (Object[])new Object[0]));
            }

            @Override
            public void successfullyConverted(@NotNull Path backupDir) {
                if (backupDir == null) {
                    5.$$$reportNull$$$0(0);
                }
                InspectionApplication.this.reportMessage(1, InspectionsBundle.message((String)"inspection.application.project.was.successfully.converted.old.project.files.were.saved.to.0", (Object[])new Object[]{backupDir.toString()}));
            }

            @Override
            public void error(@NotNull String message2) {
                if (message2 == null) {
                    5.$$$reportNull$$$0(1);
                }
                InspectionApplication.this.reportError(InspectionsBundle.message((String)"inspection.application.cannot.convert.project.0", (Object[])new Object[]{message2}));
            }

            @Override
            public void cannotWriteToFiles(@NotNull List<? extends Path> readonlyFiles) {
                if (readonlyFiles == null) {
                    5.$$$reportNull$$$0(2);
                }
                StringBuilder files2 = new StringBuilder();
                for (Path path : readonlyFiles) {
                    files2.append(path.toString()).append("; ");
                }
                InspectionApplication.this.reportError(InspectionsBundle.message((String)"inspection.application.cannot.convert.the.project.the.following.files.are.read.only.0", (Object[])new Object[]{files2.toString()}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "backupDir";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "readonlyFiles";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplication$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "successfullyConverted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "error";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "cannotWriteToFiles";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Nullable
    public static String getPrefix(@NotNull String text2) {
        int idx;
        if (text2 == null) {
            InspectionApplication.$$$reportNull$$$0(30);
        }
        if ((idx = text2.indexOf(" in ")) == -1) {
            idx = text2.indexOf(" of ");
        }
        return idx == -1 ? text2 : text2.substring(0, idx);
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void reportMessageNoLineBreak(int minVerboseLevel, String message2) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message2);
        }
    }

    @Override
    public void reportError(String message2) {
        System.err.println(message2);
    }

    @Override
    public void reportMessage(int minVerboseLevel, String message2) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message2);
        }
    }

    private List<Range> getOrComputeUnchangedRanges(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        if (virtualFile == null) {
            InspectionApplication.$$$reportNull$$$0(31);
        }
        if (changeListManager == null) {
            InspectionApplication.$$$reportNull$$$0(32);
        }
        return this.diffMap.computeIfAbsent(virtualFile.getPath(), key -> InspectionApplication.computeDiff(virtualFile, changeListManager));
    }

    private static List<Range> computeDiff(@NotNull VirtualFile virtualFile, @NotNull ChangeListManager changeListManager) {
        if (virtualFile == null) {
            InspectionApplication.$$$reportNull$$$0(33);
        }
        if (changeListManager == null) {
            InspectionApplication.$$$reportNull$$$0(34);
        }
        try {
            Change change = changeListManager.getChange(virtualFile);
            if (change == null) {
                return Collections.emptyList();
            }
            ContentRevision revision = change.getBeforeRevision();
            if (revision == null) {
                return Collections.emptyList();
            }
            String oldContent = revision.getContent();
            if (oldContent == null) {
                return Collections.emptyList();
            }
            String newContent = VfsUtilCore.loadText((VirtualFile)virtualFile);
            return Lists.newArrayList(RangesBuilder.compareLines(newContent, oldContent, LineOffsetsUtil.create(newContent), LineOffsetsUtil.create(oldContent)).iterateUnchanged());
        }
        catch (VcsException | IOException e) {
            LOG.error("Couldn't load content", e);
            return Collections.emptyList();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 17: 
            case 18: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/InspectionApplication";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultsDataPath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionsResults";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configSource";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profilePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profileName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/InspectionApplication";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGlobalInspectionContext";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "loadInspectionProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "configuratorContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnalysisScope";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChangedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "waitAllStartupActivitiesPassed";
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runAnalysisOnScope";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgress";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "closeProject";
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadInspectionProfile";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadProfileByPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "loadProfileByName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOrComputeUnchangedRanges";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "computeDiff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

