/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionToolResultExporter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextEx;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.AggregateResultsExporter;
import com.intellij.codeInspection.ui.GlobalReportedProblemFilter;
import com.intellij.codeInspection.ui.ReportedProblemFilter;
import com.intellij.codeInspection.ui.util.SynchronizedBidiMultiMap;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultInspectionToolResultExporter
implements InspectionToolResultExporter {
    protected static final Logger LOG = Logger.getInstance(DefaultInspectionToolResultExporter.class);
    @NonNls
    public static final String INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT = "problem_class";
    @NonNls
    public static final String INSPECTION_RESULTS_SEVERITY_ATTRIBUTE = "severity";
    @NonNls
    public static final String INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE = "attribute_key";
    @NonNls
    public static final String INSPECTION_RESULTS_ID_ATTRIBUTE = "id";
    @NonNls
    public static final String INSPECTION_RESULTS_DESCRIPTION_ELEMENT = "description";
    @NonNls
    public static final String INSPECTION_RESULTS_HINTS_ELEMENT = "hints";
    @NonNls
    public static final String INSPECTION_RESULTS_HINT_ELEMENT = "hint";
    @NonNls
    public static final String INSPECTION_RESULTS_VALUE_ATTRIBUTE = "value";
    @NonNls
    public static final String INSPECTION_RESULTS_LANGUAGE = "language";
    @NotNull
    protected final InspectionToolWrapper myToolWrapper;
    @NotNull
    protected final GlobalInspectionContextEx myContext;
    private final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myExcludedElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myProblemElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> mySuppressedElements;
    protected final SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> myResolvedElements;
    protected final Map<String, Set<RefEntity>> myContents;
    private static final Object WRITER_LOCK = new Object();

    public DefaultInspectionToolResultExporter(@NotNull InspectionToolWrapper toolWrapper, @NotNull GlobalInspectionContextEx context) {
        if (toolWrapper == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(0);
        }
        if (context == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(1);
        }
        this.myExcludedElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.myProblemElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.mySuppressedElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.myResolvedElements = DefaultInspectionToolResultExporter.createBidiMap();
        this.myContents = Collections.synchronizedMap(new HashMap(1));
        this.myToolWrapper = toolWrapper;
        this.myContext = context;
    }

    @Override
    @NotNull
    public InspectionToolWrapper getToolWrapper() {
        InspectionToolWrapper inspectionToolWrapper = this.myToolWrapper;
        if (inspectionToolWrapper == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(2);
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public RefManager getRefManager() {
        RefManager refManager = this.getContext().getRefManager();
        if (refManager == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(3);
        }
        return refManager;
    }

    @Override
    @NotNull
    public SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> getProblemElements() {
        SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> synchronizedBidiMultiMap = this.myProblemElements;
        if (synchronizedBidiMultiMap == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(4);
        }
        return synchronizedBidiMultiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeOutput(CommonProblemDescriptor @NotNull [] descriptions, @NotNull RefEntity refElement) throws IOException {
        InspectionEP inspectionEP;
        if (refElement == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(5);
        }
        if (descriptions == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(6);
        }
        Object object = (inspectionEP = this.myToolWrapper.getExtension()) != null ? inspectionEP : WRITER_LOCK;
        synchronized (object) {
            Path file2 = InspectionsResultUtil.getInspectionResultFile(this.myContext.getOutputPath(), this.myToolWrapper.getShortName());
            boolean exists = Files.exists(file2, new LinkOption[0]);
            Files.createDirectories(file2.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(file2, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);){
                if (!exists) {
                    ((Writer)writer).write(60);
                    writer.write("problems");
                    ((Writer)writer).write(32);
                    writer.write("is_local_tool");
                    ((Writer)writer).write(61);
                    ((Writer)writer).write(34);
                    writer.write(Boolean.toString(this.myToolWrapper instanceof LocalInspectionToolWrapper));
                    ((Writer)writer).write(34);
                    ((Writer)writer).write(62);
                    ((Writer)writer).write(10);
                }
                this.exportResults(descriptions, refElement, (? super Element p) -> {
                    try {
                        JbXmlOutputter.collapseMacrosAndWrite(p, (ComponentManager)this.getContext().getProject(), writer);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                });
                ((Writer)writer).write(10);
            }
        }
    }

    @Override
    public void exportResults(final @NotNull Consumer<? super Element> resultConsumer, final @NotNull Predicate<? super RefEntity> excludedEntities, final @NotNull Predicate<? super CommonProblemDescriptor> excludedDescriptors) {
        if (resultConsumer == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(7);
        }
        if (excludedEntities == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(8);
        }
        if (excludedDescriptors == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(9);
        }
        this.getRefManager().iterate(new RefVisitor(){

            public void visitElement(@NotNull RefEntity elem) {
                if (elem == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!excludedEntities.test(elem)) {
                    DefaultInspectionToolResultExporter.this.exportResults((Consumer<? super Element>)resultConsumer, elem, (Predicate<? super CommonProblemDescriptor>)excludedDescriptors);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elem", "com/intellij/codeInspection/DefaultInspectionToolResultExporter$1", "visitElement"));
            }
        });
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myContext.getProject();
        if (project == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(10);
        }
        return project;
    }

    @Override
    public void exportResults(@NotNull Consumer<? super Element> resultConsumer, @NotNull RefEntity refEntity, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        CommonProblemDescriptor[] descriptions;
        if (resultConsumer == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(11);
        }
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(12);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(13);
        }
        if ((descriptions = this.getProblemElements().get(refEntity)) != null) {
            this.exportResults(descriptions, refEntity, resultConsumer, isDescriptorExcluded);
        }
    }

    public void exportResults(CommonProblemDescriptor @NotNull [] descriptors2, @NotNull RefEntity refEntity, @NotNull Consumer<? super Element> problemSink) {
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(14);
        }
        if (problemSink == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(15);
        }
        if (descriptors2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(16);
        }
        this.exportResults(descriptors2, refEntity, problemSink, problem -> false);
    }

    protected void exportResults(CommonProblemDescriptor @NotNull [] descriptors2, @NotNull RefEntity refEntity, @NotNull Consumer<? super Element> problemSink, @NotNull Predicate<? super CommonProblemDescriptor> isDescriptorExcluded) {
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(17);
        }
        if (problemSink == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(18);
        }
        if (isDescriptorExcluded == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(19);
        }
        if (descriptors2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(20);
        }
        for (CommonProblemDescriptor descriptor2 : descriptors2) {
            if (isDescriptorExcluded.test((CommonProblemDescriptor)descriptor2)) continue;
            int line = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getLineNumber() : -1;
            Element element2 = null;
            try {
                element2 = refEntity.getRefManager().export(refEntity, line);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            if (element2 == null) {
                return;
            }
            this.exportResult(refEntity, descriptor2, element2);
            problemSink.accept((Element)element2);
        }
    }

    private void exportResult(@NotNull RefEntity refEntity, @NotNull CommonProblemDescriptor descriptor2, @NotNull Element element2) {
        if (refEntity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(21);
        }
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(22);
        }
        if (element2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(23);
        }
        PsiElement psiElement = descriptor2 instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor2).getPsiElement() : null;
        try {
            TextRange textRange;
            @NonNls Element problemClassElement = new Element(INSPECTION_RESULTS_PROBLEM_CLASS_ELEMENT);
            problemClassElement.setAttribute(INSPECTION_RESULTS_ID_ATTRIBUTE, this.myToolWrapper.getShortName());
            problemClassElement.addContent(DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(this.myToolWrapper.getDisplayName()));
            HighlightSeverity severity = InspectionToolResultExporter.getSeverity(refEntity, psiElement, this);
            SeverityRegistrar severityRegistrar = this.myContext.getCurrentProfile().getProfileManager().getSeverityRegistrar();
            HighlightInfoType type = descriptor2 instanceof ProblemDescriptor ? ProblemDescriptorUtil.highlightTypeFromDescriptor((ProblemDescriptor)descriptor2, severity, severityRegistrar) : ProblemDescriptorUtil.getHighlightInfoType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING, severity, severityRegistrar);
            problemClassElement.setAttribute(INSPECTION_RESULTS_SEVERITY_ATTRIBUTE, type.getSeverity(psiElement).getName());
            problemClassElement.setAttribute(INSPECTION_RESULTS_ATTRIBUTE_KEY_ATTRIBUTE, type.getAttributesKey().getExternalName());
            element2.addContent(problemClassElement);
            if (this.myToolWrapper instanceof GlobalInspectionToolWrapper) {
                GlobalInspectionTool globalInspectionTool = (GlobalInspectionTool)((GlobalInspectionToolWrapper)this.myToolWrapper).getTool();
                QuickFix[] fixes = descriptor2.getFixes();
                if (fixes != null) {
                    @NonNls Element hintsElement = new Element(INSPECTION_RESULTS_HINTS_ELEMENT);
                    for (QuickFix fix : fixes) {
                        String hint = globalInspectionTool.getHint(fix);
                        if (hint == null) continue;
                        @NonNls Element hintElement = new Element(INSPECTION_RESULTS_HINT_ELEMENT);
                        hintElement.setAttribute(INSPECTION_RESULTS_VALUE_ATTRIBUTE, DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(hint));
                        hintsElement.addContent(hintElement);
                    }
                    element2.addContent(hintsElement);
                }
            }
            @NonNls String template = descriptor2.getDescriptionTemplate();
            String highlightedText = ProblemDescriptorUtil.extractHighlightedText(descriptor2, psiElement);
            @NonNls String problemText = StringUtil.replace((String)StringUtil.replace((String)template, (String)"#ref", (String)(psiElement != null ? highlightedText : "")), (String)" #loc ", (String)" ");
            Element descriptionElement = new Element(INSPECTION_RESULTS_DESCRIPTION_ELEMENT);
            descriptionElement.addContent(DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(problemText));
            element2.addContent(descriptionElement);
            Element highLightedElement = new Element("highlighted_element");
            highLightedElement.addContent(DefaultInspectionToolResultExporter.sanitizeIllegalXmlChars(highlightedText));
            element2.addContent(highLightedElement);
            Element language = new Element(INSPECTION_RESULTS_LANGUAGE);
            language.addContent(psiElement != null ? psiElement.getLanguage().getID() : "");
            element2.addContent(language);
            if (descriptor2 instanceof ProblemDescriptorBase && (textRange = ((ProblemDescriptorBase)descriptor2).getTextRangeForNavigation()) != null) {
                int offset = textRange.getStartOffset() - ((ProblemDescriptorBase)descriptor2).getLineStartOffset();
                int length = textRange.getLength();
                element2.addContent(new Element("offset").addContent(String.valueOf(offset)));
                element2.addContent(new Element("length").addContent(String.valueOf(length)));
            }
        }
        catch (RuntimeException e) {
            String message2 = "Cannot save results for " + refEntity.getName() + ", inspection which caused problem: " + this.myToolWrapper.getShortName() + ", problem descriptor " + descriptor2;
            if (psiElement != null) {
                message2 = message2 + ", element class: " + psiElement.getClass() + ", containing file: " + psiElement.getContainingFile();
            }
            LOG.error(message2, (Throwable)e);
        }
    }

    private static String sanitizeIllegalXmlChars(String text2) {
        if (Verifier.checkCharacterData((String)text2) == null) {
            return text2;
        }
        return text2.codePoints().map(cp -> Verifier.isXMLCharacter((int)cp) ? cp : 63).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }

    protected String getSeverityDelegateName() {
        return this.getToolWrapper().getShortName();
    }

    @NotNull
    public GlobalInspectionContextEx getContext() {
        GlobalInspectionContextEx globalInspectionContextEx = this.myContext;
        if (globalInspectionContextEx == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(24);
        }
        return globalInspectionContextEx;
    }

    @NotNull
    private static SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor> createBidiMap() {
        return new SynchronizedBidiMultiMap<RefEntity, CommonProblemDescriptor>(){

            @Override
            @NotNull
            protected ArrayFactory<CommonProblemDescriptor> arrayFactory() {
                ArrayFactory arrayFactory = CommonProblemDescriptor.ARRAY_FACTORY;
                if (arrayFactory == null) {
                    2.$$$reportNull$$$0(0);
                }
                return arrayFactory;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DefaultInspectionToolResultExporter$2", "arrayFactory"));
            }
        };
    }

    @Override
    @Nullable
    public HighlightSeverity getSeverity(@NotNull RefElement element2) {
        if (element2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(25);
        }
        return (HighlightSeverity)ReadAction.nonBlocking(() -> {
            PsiFile psiElement = ((RefElement)element2.getRefManager().getRefinedElement((RefEntity)element2)).getPointer().getContainingFile();
            if (psiElement != null) {
                GlobalInspectionContextEx context = this.getContext();
                String shortName = this.getSeverityDelegateName();
                Tools tools = context.getTools().get(shortName);
                if (tools != null) {
                    for (ScopeToolState state : tools.getTools()) {
                        InspectionToolWrapper toolWrapper = state.getTool();
                        if (toolWrapper != this.getToolWrapper()) continue;
                        return context.getCurrentProfile().getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement).getSeverity();
                    }
                }
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(context.getProject()).getCurrentProfile();
                HighlightDisplayLevel level = profile.getErrorLevel(HighlightDisplayKey.find((String)shortName), (PsiElement)psiElement);
                return level.getSeverity();
            }
            return null;
        }).executeSynchronously();
    }

    @Override
    public boolean isExcluded(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(26);
        }
        return this.myExcludedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isExcluded(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(27);
        }
        Object[] excluded = this.myExcludedElements.get(entity);
        Object[] problems = this.myProblemElements.get(entity);
        return excluded != null && problems != null && Comparing.equal((Object)ContainerUtil.set((Object[])excluded), (Object)ContainerUtil.set((Object[])problems));
    }

    @Override
    public void amnesty(@NotNull RefEntity element2) {
        if (element2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(28);
        }
        this.myExcludedElements.remove(element2);
    }

    @Override
    public void exclude(@NotNull RefEntity element2) {
        if (element2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(29);
        }
        this.myExcludedElements.put(element2, (CommonProblemDescriptor[])this.myProblemElements.getOrDefault(element2, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY));
    }

    @Override
    public void amnesty(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(30);
        }
        this.myExcludedElements.removeValue(descriptor2);
    }

    @Override
    public void exclude(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity;
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(31);
        }
        if ((entity = (RefEntity)ObjectUtils.chooseNotNull((Object)this.myProblemElements.getKeyFor(descriptor2), (Object)this.myResolvedElements.getKeyFor(descriptor2))) != null) {
            this.myExcludedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public void suppressProblem(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity removed;
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(32);
        }
        if ((removed = this.myProblemElements.removeValue(descriptor2)) != null) {
            this.mySuppressedElements.put(removed, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public void suppressProblem(@NotNull RefEntity entity) {
        CommonProblemDescriptor[] removed;
        if (entity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(33);
        }
        if ((removed = this.myProblemElements.remove(entity)) != null) {
            this.mySuppressedElements.put(entity, (CommonProblemDescriptor[])removed);
        }
    }

    @Override
    public synchronized void updateContent() {
        this.myContents.clear();
        this.updateProblemElements();
    }

    protected void updateProblemElements() {
        Set<Object> elements;
        if (this.filterResolvedItems()) {
            elements = this.getProblemElements().keys().stream().filter(entity -> !this.isExcluded((RefEntity)entity)).collect(Collectors.toSet());
        } else {
            elements = new HashSet<RefEntity>(this.getProblemElements().keys());
            elements.addAll(this.getResolvedElements());
            elements.addAll(this.mySuppressedElements.keys());
        }
        for (RefEntity refEntity : elements) {
            String groupName = refEntity instanceof RefElement ? refEntity.getRefManager().getGroupName((RefElement)refEntity) : refEntity.getQualifiedName();
            this.registerContentEntry(refEntity, groupName);
        }
    }

    protected boolean filterResolvedItems() {
        return false;
    }

    protected void registerContentEntry(RefEntity element2, String packageName) {
        GlobalReportedProblemFilter globalReportedProblemFilter = this.myContext.getGlobalReportedProblemFilter();
        if (globalReportedProblemFilter == null || globalReportedProblemFilter.shouldReportProblem(element2, this.getToolWrapper().getShortName())) {
            Set content2 = this.myContents.computeIfAbsent(packageName, k -> new HashSet());
            content2.add(element2);
        }
    }

    public void addProblemElement(@Nullable RefEntity refElement, CommonProblemDescriptor ... descriptions) {
        if (descriptions == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(34);
        }
        this.addProblemElement(refElement, true, descriptions);
    }

    @Override
    public void addProblemElement(@Nullable RefEntity refElement, boolean filterSuppressed, CommonProblemDescriptor ... descriptors2) {
        if (descriptors2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(35);
        }
        if (refElement == null || descriptors2.length == 0) {
            return;
        }
        ReportedProblemFilter filter = this.myContext.getReportedProblemFilter();
        if (filter != null && !filter.shouldReportProblem(refElement, descriptors2)) {
            return;
        }
        DefaultInspectionToolResultExporter.checkFromSameFile(refElement, descriptors2);
        if (filterSuppressed) {
            if (this.myContext.getOutputPath() == null || !(this.myToolWrapper instanceof LocalInspectionToolWrapper) || this instanceof AggregateResultsExporter) {
                this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors2);
            } else {
                this.addLocalInspectionProblem(refElement, descriptors2);
            }
        } else {
            this.myProblemElements.put(refElement, (CommonProblemDescriptor[])descriptors2);
        }
    }

    public void addLocalInspectionProblem(@NotNull RefEntity refElement, CommonProblemDescriptor @NotNull [] descriptors2) {
        if (refElement == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(36);
        }
        if (descriptors2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(37);
        }
        try {
            this.writeOutput(descriptors2, refElement);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void checkFromSameFile(RefEntity element2, CommonProblemDescriptor[] descriptors2) {
        if (!(element2 instanceof RefElement)) {
            return;
        }
        SmartPsiElementPointer pointer = ((RefElement)element2).getPointer();
        if (pointer == null) {
            return;
        }
        VirtualFile entityFile = DefaultInspectionToolResultExporter.ensureNotInjectedFile(pointer.getVirtualFile());
        if (entityFile == null) {
            return;
        }
        for (CommonProblemDescriptor d : descriptors2) {
            VirtualFile file2;
            if (!(d instanceof ProblemDescriptorBase) || (file2 = ((ProblemDescriptorBase)d).getContainingFile()) == null) continue;
            LOG.assertTrue(DefaultInspectionToolResultExporter.ensureNotInjectedFile(file2).equals(entityFile), (Object)("descriptor and containing entity files should be the same; descriptor: " + d.getDescriptionTemplate()));
        }
    }

    public RefEntity getElement(@NotNull CommonProblemDescriptor descriptor2) {
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(38);
        }
        return this.myProblemElements.getKeyFor(descriptor2);
    }

    @Contract(value="null -> null")
    private static VirtualFile ensureNotInjectedFile(VirtualFile file2) {
        return file2 instanceof VirtualFileWindow ? ((VirtualFileWindow)file2).getDelegate() : file2;
    }

    @Override
    @NotNull
    public Collection<CommonProblemDescriptor> getProblemDescriptors() {
        Collection<CommonProblemDescriptor> collection = this.myProblemElements.getValues();
        if (collection == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(39);
        }
        return collection;
    }

    public void resolveProblem(@NotNull CommonProblemDescriptor descriptor2) {
        RefEntity entity;
        if (descriptor2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(40);
        }
        if ((entity = this.myProblemElements.removeValue(descriptor2)) != null) {
            this.myResolvedElements.put(entity, (CommonProblemDescriptor[])new CommonProblemDescriptor[]{descriptor2});
        }
    }

    @Override
    public boolean isProblemResolved(@Nullable CommonProblemDescriptor descriptor2) {
        return this.myResolvedElements.containsValue(descriptor2);
    }

    @Override
    public boolean isProblemResolved(@Nullable RefEntity entity) {
        return this.myResolvedElements.containsKey(entity) && !this.myProblemElements.containsKey(entity);
    }

    @Override
    @NotNull
    public Collection<RefEntity> getResolvedElements() {
        Collection<RefEntity> collection = this.myResolvedElements.keys();
        if (collection == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(41);
        }
        return collection;
    }

    @Override
    public CommonProblemDescriptor @NotNull [] getResolvedProblems(@NotNull RefEntity entity) {
        if (entity == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(42);
        }
        CommonProblemDescriptor[] commonProblemDescriptorArray = this.myResolvedElements.getOrDefault(entity, (CommonProblemDescriptor[])CommonProblemDescriptor.EMPTY_ARRAY);
        if (commonProblemDescriptorArray == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(43);
        }
        return commonProblemDescriptorArray;
    }

    @Override
    public synchronized boolean hasReportedProblems() {
        return !this.myContents.isEmpty();
    }

    @Override
    @NotNull
    public Map<String, Set<RefEntity>> getContent() {
        Map<String, Set<RefEntity>> map2 = this.myContents;
        if (map2 == null) {
            DefaultInspectionToolResultExporter.$$$reportNull$$$0(44);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 24: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 24: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 24: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/DefaultInspectionToolResultExporter";
                break;
            }
            case 5: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 6: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptions";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedEntities";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDescriptors";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refEntity";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isDescriptorExcluded";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemSink";
                break;
            }
            case 16: 
            case 20: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 22: 
            case 26: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 23: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: 
            case 33: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/DefaultInspectionToolResultExporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemDescriptors";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedElements";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedProblems";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 24: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeOutput";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "exportResults";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "exportResult";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSeverity";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 28: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "amnesty";
                break;
            }
            case 29: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "exclude";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "suppressProblem";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addProblemElement";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addLocalInspectionProblem";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolveProblem";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedProblems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: 
            case 24: 
            case 39: 
            case 41: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

