/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.postfix.settings.PostfixEditTemplateDialog;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateCheckedTreeNode;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.template.postfix.templates.editable.DefaultPostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixChangedBuiltinTemplate;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesCheckboxTree
extends CheckboxTree
implements Disposable {
    private static final Factory<Set<PostfixTemplateCheckedTreeNode>> myNodesComparator = () -> new TreeSet((o1, o2) -> {
        PostfixTemplate template1 = o1.getTemplate();
        PostfixTemplate template2 = o2.getTemplate();
        int compare = Comparing.compare((Comparable)((Object)template1.getPresentableName()), (Comparable)((Object)template2.getPresentableName()));
        return compare != 0 ? compare : Comparing.compare((Comparable)((Object)template1.getId()), (Comparable)((Object)template2.getId()));
    });
    @NotNull
    private final CheckedTreeNode myRoot;
    @NotNull
    private final DefaultTreeModel myModel = (DefaultTreeModel)this.getModel();

    public PostfixTemplatesCheckboxTree() {
        super(PostfixTemplatesCheckboxTree.getRenderer(), new CheckedTreeNode(null));
        this.myRoot = (CheckedTreeNode)this.myModel.getRoot();
        TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PostfixTemplatesCheckboxTree.this.selectionChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$1", "valueChanged"));
            }
        };
        this.getSelectionModel().addTreeSelectionListener(selectionListener);
        Disposer.register((Disposable)this, () -> this.getSelectionModel().removeTreeSelectionListener(selectionListener));
        DoubleClickListener doubleClickListener = new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                TreePath location;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (location = PostfixTemplatesCheckboxTree.this.getClosestPathForLocation(event.getX(), event.getY())) != null && PostfixTemplatesCheckboxTree.this.doubleClick(location.getLastPathComponent());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$2", "onDoubleClick"));
            }
        };
        doubleClickListener.installOn((Component)((Object)this));
        Disposer.register((Disposable)this, () -> doubleClickListener.uninstall((Component)((Object)this)));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    protected void onDoubleClick(CheckedTreeNode node) {
        this.doubleClick(node);
    }

    private boolean doubleClick(@Nullable Object node) {
        if (node instanceof PostfixTemplateCheckedTreeNode && PostfixTemplatesCheckboxTree.isEditable(((PostfixTemplateCheckedTreeNode)((Object)node)).getTemplate())) {
            this.editTemplate((PostfixTemplateCheckedTreeNode)((Object)node));
            return true;
        }
        return false;
    }

    public void dispose() {
        UIUtil.dispose((Component)((Object)this));
    }

    @NotNull
    private static CheckboxTree.CheckboxTreeCellRenderer getRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String example;
                SimpleTextAttributes attributes;
                if (!(value2 instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value2;
                Color background = UIUtil.getTreeBackground((boolean)selected2, (boolean)true);
                PostfixTemplateCheckedTreeNode templateNode = (PostfixTemplateCheckedTreeNode)((Object)ObjectUtils.tryCast((Object)node, PostfixTemplateCheckedTreeNode.class));
                if (templateNode != null) {
                    JBColor fgColor = templateNode.isChanged() || templateNode.isNew() ? JBColor.BLUE : null;
                    attributes = new SimpleTextAttributes(0, (Color)fgColor);
                } else {
                    attributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                }
                this.getTextRenderer().append(StringUtil.notNullize((String)value2.toString()), new SimpleTextAttributes(background, attributes.getFgColor(), (Color)JBColor.RED, attributes.getStyle()));
                if (templateNode != null && StringUtil.isNotEmpty((String)(example = templateNode.getTemplate().getExample()))) {
                    this.getTextRenderer().append("  " + example, new SimpleTextAttributes(128, (Color)JBColor.GRAY), false);
                }
            }
        };
    }

    protected void selectionChanged() {
    }

    public void initTree(@NotNull MultiMap<PostfixTemplateProvider, PostfixTemplate> providerToTemplates) {
        if (providerToTemplates == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(0);
        }
        this.myRoot.removeAllChildren();
        HashMap languageToNodes = new HashMap();
        for (Map.Entry entry : providerToTemplates.entrySet()) {
            PostfixTemplateProvider provider2 = (PostfixTemplateProvider)entry.getKey();
            String languageId = PostfixTemplatesCheckboxTree.getProvidersToLanguages().get(provider2);
            Set nodes = (Set)ContainerUtil.getOrCreate(languageToNodes, (Object)languageId, myNodesComparator);
            for (PostfixTemplate template : (Collection)entry.getValue()) {
                nodes.add(new PostfixTemplateCheckedTreeNode(template, provider2, false));
            }
        }
        for (Map.Entry entry : languageToNodes.entrySet()) {
            DefaultMutableTreeNode languageNode = this.findOrCreateLanguageNode((String)entry.getKey());
            for (PostfixTemplateCheckedTreeNode node : (Set)entry.getValue()) {
                languageNode.add((MutableTreeNode)((Object)new PostfixTemplateCheckedTreeNode(node.getTemplate(), node.getTemplateProvider(), false)));
            }
        }
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        TreeUtil.expandAll((JTree)((Object)this));
    }

    @Nullable
    public PostfixTemplate getSelectedTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        return PostfixTemplatesCheckboxTree.getTemplateFromPath(path);
    }

    @Nullable
    private static PostfixTemplate getTemplateFromPath(@Nullable TreePath path) {
        if (path == null || !(path.getLastPathComponent() instanceof PostfixTemplateCheckedTreeNode)) {
            return null;
        }
        return ((PostfixTemplateCheckedTreeNode)((Object)path.getLastPathComponent())).getTemplate();
    }

    @NotNull
    public MultiMap<PostfixTemplateProvider, PostfixTemplate> getEditableTemplates() {
        MultiMap result2 = MultiMap.createSet();
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)node -> {
            PostfixTemplate template = node.getTemplate();
            PostfixTemplateProvider provider2 = node.getTemplateProvider();
            if (PostfixTemplatesCheckboxTree.isEditable(template) && (!template.isBuiltin() || template instanceof PostfixChangedBuiltinTemplate)) {
                result2.putValue((Object)provider2, (Object)template);
            }
        }));
        MultiMap multiMap = result2;
        if (multiMap == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    @NotNull
    public Map<String, Set<String>> getDisabledTemplatesState() {
        HashMap<String, Set<String>> result2 = new HashMap<String, Set<String>>();
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)template -> {
            if (!template.isChecked()) {
                Set templatesForProvider = (Set)ContainerUtil.getOrCreate((Map)result2, (Object)template.getTemplateProvider().getId(), PostfixTemplatesSettings.SET_FACTORY);
                templatesForProvider.add(template.getTemplate().getId());
            }
        }));
        HashMap<String, Set<String>> hashMap = result2;
        if (hashMap == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    public void setDisabledTemplatesState(@NotNull Map<String, Set<String>> providerToDisabledTemplates) {
        if (providerToDisabledTemplates == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(3);
        }
        TreeState treeState = TreeState.createOn((JTree)((Object)this), (DefaultMutableTreeNode)this.myRoot);
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)template -> {
            Set disabledTemplates = (Set)providerToDisabledTemplates.get(template.getTemplateProvider().getId());
            String key = template.getTemplate().getId();
            if (disabledTemplates != null && disabledTemplates.contains(key)) {
                template.setChecked(false);
                return;
            }
            template.setChecked(true);
        }));
        this.myModel.nodeStructureChanged((TreeNode)this.myRoot);
        treeState.applyTo((JTree)((Object)this));
        TreeUtil.expandAll((JTree)((Object)this));
    }

    public void selectTemplate(@NotNull PostfixTemplate postfixTemplate, @NotNull PostfixTemplateProvider provider2) {
        if (postfixTemplate == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(4);
        }
        if (provider2 == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(5);
        }
        this.visitTemplateNodes((Consumer<? super PostfixTemplateCheckedTreeNode>)((Consumer)template -> {
            if (provider2.getId().equals(template.getTemplateProvider().getId()) && postfixTemplate.getKey().equals(template.getTemplate().getKey())) {
                TreeUtil.selectInTree((DefaultMutableTreeNode)((Object)template), (boolean)true, (JTree)((Object)this), (boolean)true);
            }
        }));
    }

    private void visitTemplateNodes(@NotNull Consumer<? super PostfixTemplateCheckedTreeNode> consumer2) {
        if (consumer2 == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(6);
        }
        Enumeration languages = this.myRoot.children();
        while (languages.hasMoreElements()) {
            CheckedTreeNode langNode = (CheckedTreeNode)languages.nextElement();
            Enumeration templates = langNode.children();
            while (templates.hasMoreElements()) {
                Object template = templates.nextElement();
                if (!(template instanceof PostfixTemplateCheckedTreeNode)) continue;
                consumer2.consume((Object)((PostfixTemplateCheckedTreeNode)((Object)template)));
            }
        }
    }

    public void addTemplate(@NotNull AnActionButton button2) {
        if (button2 == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(7);
        }
        DefaultActionGroup group2 = new DefaultActionGroup();
        for (final Map.Entry<PostfixTemplateProvider, String> entry : PostfixTemplatesCheckboxTree.getProvidersToLanguages().entrySet()) {
            final PostfixTemplateProvider provider2 = entry.getKey();
            final String providerName = provider2.getPresentableName();
            if (StringUtil.isEmpty((String)providerName)) continue;
            group2.add((AnAction)new DumbAwareAction(providerName){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    PostfixEditTemplateDialog dialog2;
                    PostfixTemplateEditor editor;
                    if (e == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if ((editor = provider2.createEditor(null)) != null && (dialog2 = new PostfixEditTemplateDialog((Component)((Object)PostfixTemplatesCheckboxTree.this), editor, providerName, null)).showAndGet()) {
                        String templateKey = dialog2.getTemplateName();
                        String templateId = PostfixTemplatesUtils.generateTemplateId(templateKey, provider2);
                        PostfixTemplate createdTemplate = editor.createTemplate(templateId, templateKey);
                        PostfixTemplateCheckedTreeNode createdNode = new PostfixTemplateCheckedTreeNode(createdTemplate, provider2, true);
                        DefaultMutableTreeNode languageNode = PostfixTemplatesCheckboxTree.this.findOrCreateLanguageNode((String)entry.getValue());
                        languageNode.add((MutableTreeNode)((Object)createdNode));
                        PostfixTemplatesCheckboxTree.this.myModel.nodeStructureChanged(languageNode);
                        TreeUtil.selectNode((JTree)((Object)PostfixTemplatesCheckboxTree.this), (TreeNode)((Object)createdNode));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$4", "actionPerformed"));
                }
            });
        }
        DataContext context = DataManager.getInstance().getDataContext((Component)button2.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group2, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show(Objects.requireNonNull(button2.getPreferredPopupPoint()));
    }

    public boolean canEditSelectedTemplate() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        return (selectionPaths == null || selectionPaths.length <= 1) && PostfixTemplatesCheckboxTree.isEditable(this.getSelectedTemplate());
    }

    public void editSelectedTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof PostfixTemplateCheckedTreeNode) {
            this.editTemplate((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent));
        }
    }

    private void editTemplate(@NotNull PostfixTemplateCheckedTreeNode lastPathComponent) {
        if (lastPathComponent == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(8);
        }
        PostfixTemplate template = lastPathComponent.getTemplate();
        PostfixTemplateProvider provider2 = lastPathComponent.getTemplateProvider();
        if (PostfixTemplatesCheckboxTree.isEditable(template)) {
            String providerName;
            PostfixEditTemplateDialog dialog2;
            PostfixTemplate templateToEdit = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getDelegate() : template;
            PostfixTemplateEditor editor = provider2.createEditor(templateToEdit);
            if (editor == null) {
                editor = new DefaultPostfixTemplateEditor(provider2, templateToEdit);
            }
            if ((dialog2 = new PostfixEditTemplateDialog((Component)((Object)this), editor, providerName = StringUtil.notNullize((String)provider2.getPresentableName()), templateToEdit)).showAndGet()) {
                PostfixTemplate newTemplate = editor.createTemplate(template.getId(), dialog2.getTemplateName());
                if (newTemplate.equals(template)) {
                    return;
                }
                if (template.isBuiltin()) {
                    PostfixTemplate builtin = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate() : templateToEdit;
                    lastPathComponent.setTemplate(new PostfixChangedBuiltinTemplate(newTemplate, builtin));
                } else {
                    lastPathComponent.setTemplate(newTemplate);
                }
                this.myModel.nodeStructureChanged((TreeNode)((Object)lastPathComponent));
                this.selectionChanged();
            }
        }
    }

    public boolean canDuplicateSelectedTemplate() {
        TreePath[] selectionPaths = this.getSelectionModel().getSelectionPaths();
        if (selectionPaths != null && selectionPaths.length > 1) {
            return false;
        }
        PostfixTemplate selectedTemplate = this.getSelectedTemplate();
        if (!PostfixTemplatesCheckboxTree.isEditable(selectedTemplate)) {
            return false;
        }
        PostfixTemplateProvider provider2 = selectedTemplate.getProvider();
        if (provider2 == null) {
            return false;
        }
        PostfixTemplateEditor editor = provider2.createEditor(selectedTemplate);
        if (editor != null) {
            Disposer.dispose((Disposable)editor);
            return true;
        }
        return false;
    }

    public void duplicateSelectedTemplate() {
        TreePath path = this.getSelectionModel().getSelectionPath();
        Object lastPathComponent = path.getLastPathComponent();
        if (lastPathComponent instanceof PostfixTemplateCheckedTreeNode) {
            PostfixTemplate template = ((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent)).getTemplate();
            PostfixTemplateProvider provider2 = ((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent)).getTemplateProvider();
            String languageId = PostfixTemplatesCheckboxTree.getProvidersToLanguages().get(provider2);
            if (PostfixTemplatesCheckboxTree.isEditable(template) && languageId != null) {
                PostfixTemplate templateToEdit = template instanceof PostfixChangedBuiltinTemplate ? ((PostfixChangedBuiltinTemplate)template).getDelegate() : template;
                PostfixTemplateEditor editor = provider2.createEditor(templateToEdit);
                if (editor == null) {
                    return;
                }
                String providerName = StringUtil.notNullize((String)provider2.getPresentableName());
                PostfixEditTemplateDialog dialog2 = new PostfixEditTemplateDialog((Component)((Object)this), editor, providerName, templateToEdit);
                if (dialog2.showAndGet()) {
                    String templateKey = dialog2.getTemplateName();
                    PostfixTemplate newTemplate = editor.createTemplate(PostfixTemplatesUtils.generateTemplateId(templateKey, provider2), templateKey);
                    PostfixTemplateCheckedTreeNode createdNode = new PostfixTemplateCheckedTreeNode(newTemplate, provider2, true);
                    DefaultMutableTreeNode languageNode = this.findOrCreateLanguageNode(languageId);
                    languageNode.insert((MutableTreeNode)((Object)createdNode), languageNode.getIndex((TreeNode)((Object)((PostfixTemplateCheckedTreeNode)((Object)lastPathComponent)))) + 1);
                    this.myModel.nodeStructureChanged(languageNode);
                    TreeUtil.selectNode((JTree)((Object)this), (TreeNode)((Object)createdNode));
                }
            }
        }
    }

    public boolean canRemoveSelectedTemplates() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return false;
        }
        for (TreePath path : paths) {
            PostfixTemplate template = PostfixTemplatesCheckboxTree.getTemplateFromPath(path);
            if (!PostfixTemplatesCheckboxTree.isEditable(template) || template.isBuiltin() && !(template instanceof PostfixChangedBuiltinTemplate)) continue;
            return true;
        }
        return false;
    }

    public void removeSelectedTemplates() {
        TreePath[] paths = this.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (TreePath path : paths) {
            PostfixTemplateCheckedTreeNode lastPathComponent = (PostfixTemplateCheckedTreeNode)((Object)ObjectUtils.tryCast((Object)path.getLastPathComponent(), PostfixTemplateCheckedTreeNode.class));
            if (lastPathComponent == null) continue;
            PostfixTemplate template = lastPathComponent.getTemplate();
            if (template instanceof PostfixChangedBuiltinTemplate) {
                lastPathComponent.setTemplate(((PostfixChangedBuiltinTemplate)template).getBuiltinTemplate());
                this.myModel.nodeStructureChanged((TreeNode)((Object)lastPathComponent));
                continue;
            }
            if (!PostfixTemplatesCheckboxTree.isEditable(template) || template.isBuiltin()) continue;
            TreeUtil.removeLastPathComponent((JTree)((Object)this), (TreePath)path);
        }
    }

    private static boolean isEditable(@Nullable PostfixTemplate template) {
        return template != null && template.isEditable() && template.getKey().startsWith(".");
    }

    @NotNull
    private DefaultMutableTreeNode findOrCreateLanguageNode(String languageId) {
        DefaultMutableTreeNode find = TreeUtil.findNode((DefaultMutableTreeNode)this.myRoot, n -> n instanceof LangTreeNode && languageId.equals(((LangTreeNode)((Object)((Object)n))).getLanguageId()));
        if (find != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = find;
            if (defaultMutableTreeNode == null) {
                PostfixTemplatesCheckboxTree.$$$reportNull$$$0(9);
            }
            return defaultMutableTreeNode;
        }
        Language language = Language.findLanguageByID((String)languageId);
        String languageName = language != null ? language.getDisplayName() : languageId;
        LangTreeNode languageNode = new LangTreeNode(languageName, languageId);
        this.myRoot.add((MutableTreeNode)((Object)languageNode));
        LangTreeNode langTreeNode = languageNode;
        if (langTreeNode == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(10);
        }
        return langTreeNode;
    }

    @NotNull
    private static Map<PostfixTemplateProvider, String> getProvidersToLanguages() {
        HashMap<PostfixTemplateProvider, String> myProviderToLanguage = new HashMap<PostfixTemplateProvider, String>();
        for (LanguageExtensionPoint extension2 : LanguagePostfixTemplate.EP_NAME.getExtensionList()) {
            PostfixTemplateProvider provider2 = (PostfixTemplateProvider)extension2.getInstance();
            myProviderToLanguage.put(provider2, extension2.getKey());
        }
        HashMap<PostfixTemplateProvider, String> hashMap = myProviderToLanguage;
        if (hashMap == null) {
            PostfixTemplatesCheckboxTree.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToTemplates";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerToDisabledTemplates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfixTemplate";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastPathComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditableTemplates";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledTemplatesState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateLanguageNode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvidersToLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initTree";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setDisabledTemplatesState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectTemplate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitTemplateNodes";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addTemplate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "editTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LangTreeNode
    extends CheckedTreeNode {
        @NotNull
        private final String myLanguageId;

        LangTreeNode(@NotNull String languageName, @NotNull String languageId) {
            if (languageName == null) {
                LangTreeNode.$$$reportNull$$$0(0);
            }
            if (languageId == null) {
                LangTreeNode.$$$reportNull$$$0(1);
            }
            super((Object)languageName);
            this.myLanguageId = languageId;
        }

        @NotNull
        public String getLanguageId() {
            String string = this.myLanguageId;
            if (string == null) {
                LangTreeNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageId";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$LangTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplatesCheckboxTree$LangTreeNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguageId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

