/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.ide.DataManager;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateEditorUtil {
    private TemplateEditorUtil() {
    }

    public static Editor createEditor(boolean isReadOnly, CharSequence text2) {
        return TemplateEditorUtil.createEditor(isReadOnly, text2, null);
    }

    public static Editor createEditor(boolean isReadOnly, CharSequence text2, @Nullable TemplateContext context) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        return TemplateEditorUtil.createEditor(isReadOnly, TemplateEditorUtil.createDocument(text2, context, project), project);
    }

    private static Document createDocument(CharSequence text2, @Nullable TemplateContext context, Project project) {
        if (context != null) {
            for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
                if (!context.isEnabled(type)) continue;
                return type.createDocument(text2, project);
            }
        }
        return EditorFactory.getInstance().createDocument(text2);
    }

    public static Editor createEditor(boolean isReadOnly, Document document, Project project) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = isReadOnly ? editorFactory.createViewer(document, project) : editorFactory.createEditor(document, project);
        editor.getContentComponent().setFocusable(!isReadOnly);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        EditorColorsScheme scheme2 = editor.getColorsScheme();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, scheme2, project);
            ((EditorEx)editor).setHighlighter(highlighter);
        }
        return editor;
    }

    public static void setHighlighter(Editor editor, @Nullable TemplateContext templateContext) {
        SyntaxHighlighter highlighter = null;
        if (templateContext != null) {
            for (TemplateContextType type : TemplateManagerImpl.getAllContextTypes()) {
                if (templateContext.isEnabled(type) && (highlighter = type.createHighlighter()) != null) break;
            }
        }
        TemplateEditorUtil.setHighlighter((EditorEx)editor, highlighter);
    }

    public static void setHighlighter(@NotNull Editor editor, @Nullable TemplateContextType templateContextType) {
        if (editor == null) {
            TemplateEditorUtil.$$$reportNull$$$0(0);
        }
        TemplateEditorUtil.setHighlighter((EditorEx)editor, templateContextType != null ? templateContextType.createHighlighter() : null);
    }

    private static void setHighlighter(EditorEx editor, @Nullable SyntaxHighlighter highlighter) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        LayeredLexerEditorHighlighter layeredHighlighter = new LayeredLexerEditorHighlighter((SyntaxHighlighter)new TemplateHighlighter(), editorColorsScheme);
        layeredHighlighter.registerLayer(TemplateTokenType.TEXT, new LayerDescriptor((SyntaxHighlighter)ObjectUtils.notNull((Object)highlighter, (Object)new PlainSyntaxHighlighter()), ""));
        editor.setHighlighter(layeredHighlighter);
    }

    public static void disposeTemplateEditor(@Nullable Editor templateEditor) {
        if (templateEditor != null && !templateEditor.isDisposed()) {
            PsiFile psiFile;
            Project project = templateEditor.getProject();
            if (project != null && !project.isDisposed() && (psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(templateEditor.getDocument())) != null) {
                DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled(psiFile, true);
            }
            EditorFactory.getInstance().releaseEditor(templateEditor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/template/impl/TemplateEditorUtil", "setHighlighter"));
    }

    private static class TemplateHighlighter
    extends SyntaxHighlighterBase {
        private final Lexer myLexer = new MergingLexerAdapter((Lexer)new TemplateTextLexer(), TokenSet.create((IElementType[])new IElementType[]{TemplateTokenType.TEXT}));

        TemplateHighlighter() {
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            Lexer lexer = this.myLexer;
            if (lexer == null) {
                TemplateHighlighter.$$$reportNull$$$0(0);
            }
            return lexer;
        }

        public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
            TextAttributesKey[] textAttributesKeyArray = tokenType == TemplateTokenType.VARIABLE ? TemplateHighlighter.pack((TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES) : TextAttributesKey.EMPTY_ARRAY;
            if (textAttributesKeyArray == null) {
                TemplateHighlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/template/impl/TemplateEditorUtil$TemplateHighlighter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightingLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenHighlights";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

