/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupActionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementAction;
import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.LiveTemplatesConfigurable;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.PlatformIcons;

public class LiveTemplateLookupActionProvider
implements LookupActionProvider {
    @Override
    public void fillActions(LookupElement element2, final Lookup lookup2, Consumer<LookupElementAction> consumer2) {
        if (element2 instanceof LiveTemplateLookupElementImpl) {
            final TemplateImpl template = ((LiveTemplateLookupElementImpl)element2).getTemplate();
            final TemplateImpl templateFromSettings = TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName());
            if (templateFromSettings != null) {
                consumer2.consume((Object)new LookupElementAction(PlatformIcons.EDIT, CodeInsightBundle.message((String)"action.text.edit.live.template.settings", (Object[])new Object[0])){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        Project project = lookup2.getProject();
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (project.isDisposed()) {
                                return;
                            }
                            LiveTemplatesConfigurable configurable2 = new LiveTemplatesConfigurable();
                            ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, () -> configurable2.getTemplateListPanel().editTemplate(template));
                        });
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
                consumer2.consume((Object)new LookupElementAction(AllIcons.Actions.Cancel, CodeInsightBundle.message((String)"action.text.disable.live.template", (Object[])new Object[]{template.getKey()})){

                    @Override
                    public LookupElementAction.Result performLookupAction() {
                        ApplicationManager.getApplication().invokeLater(() -> templateFromSettings.setDeactivated(true));
                        return LookupElementAction.Result.HIDE_LOOKUP;
                    }
                });
            }
        }
    }
}

