/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ElementPreviewProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ImageOrColorPreviewManager
implements Disposable,
EditorMouseMotionListener,
EditorFactoryListener {
    private static final Logger LOG = Logger.getInstance(ImageOrColorPreviewManager.class);
    private static final Key<KeyListener> EDITOR_LISTENER_ADDED = Key.create((String)"previewManagerListenerAdded");
    private final Alarm alarm = new Alarm();
    @Nullable
    private Collection<PsiElement> myElements;

    ImageOrColorPreviewManager() {
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(0);
        }
        this.registerListeners(event.getEditor());
    }

    public void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(1);
        }
        if ((editor = event.getEditor()).isOneLineMode()) {
            return;
        }
        KeyListener keyListener = (KeyListener)EDITOR_LISTENER_ADDED.get((UserDataHolder)editor);
        if (keyListener != null) {
            EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, null);
            editor.getContentComponent().removeKeyListener(keyListener);
            editor.removeEditorMouseMotionListener((EditorMouseMotionListener)this);
        }
    }

    private void registerListeners(final Editor editor) {
        if (editor.isOneLineMode()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !ImageOrColorPreviewManager.isSupportedFile(psiFile)) {
            return;
        }
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)this);
        KeyAdapter keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                PointerInfo pointerInfo;
                if (e.getKeyCode() == 16 && !editor.isOneLineMode() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location, editor.getContentComponent());
                    int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(location));
                    ImageOrColorPreviewManager.this.alarm.cancelAllRequests();
                    ImageOrColorPreviewManager.this.alarm.addRequest((Runnable)new PreviewRequest(editor, offset, true), 100);
                }
            }
        };
        editor.getContentComponent().addKeyListener(keyListener);
        EDITOR_LISTENER_ADDED.set((UserDataHolder)editor, (Object)keyListener);
    }

    private static boolean isSupportedFile(PsiFile psiFile) {
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            for (ElementPreviewProvider provider2 : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                if (!provider2.isSupportedFile(file2)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    private static Collection<PsiElement> getPsiElementsAt(Editor editor, int offset) {
        Document document;
        if (editor.isDisposed()) {
            Set<PsiElement> set2 = Collections.emptySet();
            if (set2 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(2);
            }
            return set2;
        }
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            Set<PsiElement> set3 = Collections.emptySet();
            if (set3 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(3);
            }
            return set3;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        PsiFile psiFile = documentManager.getPsiFile(document = editor.getDocument());
        if (psiFile == null || psiFile instanceof PsiCompiledElement || !psiFile.isValid()) {
            Set<PsiElement> set4 = Collections.emptySet();
            if (set4 == null) {
                ImageOrColorPreviewManager.$$$reportNull$$$0(4);
            }
            return set4;
        }
        Set elements = ContainerUtil.createWeakSet();
        if (documentManager.isCommitted(document)) {
            ContainerUtil.addIfNotNull((Collection)elements, (Object)InjectedLanguageUtil.findElementAtNoCommit(psiFile, offset));
        }
        for (PsiFile file2 : psiFile.getViewProvider().getAllFiles()) {
            ContainerUtil.addIfNotNull((Collection)elements, (Object)file2.findElementAt(offset));
        }
        Set set5 = elements;
        if (set5 == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(5);
        }
        return set5;
    }

    public void dispose() {
        this.alarm.cancelAllRequests();
        this.myElements = null;
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Editor editor;
        if (event == null) {
            ImageOrColorPreviewManager.$$$reportNull$$$0(6);
        }
        if ((editor = event.getEditor()).isOneLineMode()) {
            return;
        }
        this.alarm.cancelAllRequests();
        Collection<PsiElement> elements = this.myElements;
        if (elements == null && event.getMouseEvent().isShiftDown()) {
            this.alarm.addRequest((Runnable)new PreviewRequest(editor, event.getOffset(), false), 100);
        } else if (elements != null && !((Boolean)SlowOperations.allowSlowOperations(() -> ImageOrColorPreviewManager.getPsiElementsAt(editor, event.getOffset()).equals(elements))).booleanValue()) {
            this.myElements = null;
            for (ElementPreviewProvider provider2 : ElementPreviewProvider.EP_NAME.getExtensionList()) {
                try {
                    for (PsiElement element2 : elements) {
                        provider2.hide(element2, editor);
                    }
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/preview/ImageOrColorPreviewManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementsAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "editorCreated";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "editorReleased";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class PreviewRequest
    implements Runnable {
        private final Editor editor;
        private final int offset;
        private final boolean keyTriggered;

        PreviewRequest(Editor editor, int offset, boolean keyTriggered) {
            this.editor = editor;
            this.offset = offset;
            this.keyTriggered = keyTriggered;
        }

        @Override
        public void run() {
            SlowOperations.allowSlowOperations(() -> this.doRun());
        }

        private void doRun() {
            Collection<PsiElement> elements = ImageOrColorPreviewManager.getPsiElementsAt(this.editor, this.offset);
            if (elements.equals(ImageOrColorPreviewManager.this.myElements)) {
                return;
            }
            for (PsiElement element2 : elements) {
                if (element2 == null || !element2.isValid()) {
                    return;
                }
                if (PsiDocumentManager.getInstance((Project)element2.getProject()).isUncommited(this.editor.getDocument()) || DumbService.getInstance((Project)element2.getProject()).isDumb()) {
                    return;
                }
                for (ElementPreviewProvider provider2 : (ElementPreviewProvider[])ElementPreviewProvider.EP_NAME.getExtensions()) {
                    if (!provider2.isSupportedFile(element2.getContainingFile())) continue;
                    try {
                        provider2.show(element2, this.editor, this.editor.offsetToXY(this.offset), this.keyTriggered);
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
            ImageOrColorPreviewManager.this.myElements = elements;
        }
    }
}

