/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation.impl;

import com.intellij.codeInsight.navigation.UtilKt;
import com.intellij.navigation.NavigationTarget;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.navigation.TargetPopupPresentationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/codeInsight/navigation/impl/PsiFileNavigationTarget;", "Lcom/intellij/navigation/NavigationTarget;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "getTargetPresentation", "Lcom/intellij/navigation/TargetPopupPresentation;", "isValid", "", "intellij.platform.lang.impl"})
public final class PsiFileNavigationTarget
implements NavigationTarget {
    private final PsiFile psiFile;

    public boolean isValid() {
        return this.psiFile.isValid();
    }

    @NotNull
    public Navigatable getNavigatable() {
        return (Navigatable)this.psiFile;
    }

    @NotNull
    public TargetPopupPresentation getTargetPresentation() {
        PsiDirectory psiDirectory;
        Project project = this.psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiFile.project");
        Project project2 = project;
        String string = this.psiFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"psiFile.name");
        TargetPopupPresentationBuilder targetPopupPresentationBuilder = TargetPopupPresentation.Companion.builder(string).icon(this.psiFile.getIcon(0)).containerText((psiDirectory = this.psiFile.getParent()) != null && (psiDirectory = psiDirectory.getVirtualFile()) != null ? psiDirectory.getPresentableUrl() : null);
        Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentationBuilder, (String)"TargetPopupPresentation\n\u2026tualFile?.presentableUrl)");
        TargetPopupPresentationBuilder builder2 = targetPopupPresentationBuilder;
        VirtualFile virtualFile = this.psiFile.getVirtualFile();
        if (virtualFile == null) {
            TargetPopupPresentation targetPopupPresentation = builder2.presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentation, (String)"builder.presentation()");
            return targetPopupPresentation;
        }
        VirtualFile file2 = virtualFile;
        TargetPopupPresentationBuilder targetPopupPresentationBuilder2 = builder2.backgroundColor(VfsPresentationUtil.getFileBackgroundColor(project2, file2)).presentableTextAttributes(UtilKt.fileStatusAttributes(project2, file2));
        Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentationBuilder2, (String)"builder\n      .backgroun\u2026ttributes(project, file))");
        builder2 = targetPopupPresentationBuilder2;
        Pair<String, Icon> pair = UtilKt.fileLocation(project2, file2);
        if (pair == null) {
            TargetPopupPresentation targetPopupPresentation = builder2.presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentation, (String)"builder.presentation()");
            return targetPopupPresentation;
        }
        Pair<String, Icon> locationAndIcon = pair;
        TargetPopupPresentationBuilder targetPopupPresentationBuilder3 = builder2.locationText((String)locationAndIcon.first, (Icon)locationAndIcon.second);
        Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentationBuilder3, (String)"builder.locationText(loc\u2026, locationAndIcon.second)");
        builder2 = targetPopupPresentationBuilder3;
        TargetPopupPresentation targetPopupPresentation = builder2.presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentation, (String)"builder.presentation()");
        return targetPopupPresentation;
    }

    public PsiFileNavigationTarget(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
    }
}

