/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.PsiElementModuleRenderer;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.TargetPopupPresentation;
import com.intellij.navigation.TargetPopupPresentationBuilder;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a5\u0010\u0002\u001a\u001f\u0012\u000e\u0012\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u0006\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\r*\u00020\u0011H\u0002\u001a\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0004*\u00020\u0011H\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"CONTAINER_PATTERN", "Ljava/util/regex/Pattern;", "fileLocation", "Lcom/intellij/openapi/util/Pair;", "", "Lorg/jetbrains/annotations/Nls;", "Lorg/jetbrains/annotations/NotNull;", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatusAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "targetPopupPresentation", "Lcom/intellij/navigation/TargetPopupPresentation;", "itemPresentation", "Lcom/intellij/navigation/ItemPresentation;", "element", "Lcom/intellij/psi/PsiElement;", "getColoredAttributes", "getContainerText", "intellij.platform.lang.impl"})
public final class UtilKt {
    private static final Pattern CONTAINER_PATTERN;

    @NotNull
    public static final TargetPopupPresentation targetPopupPresentation(@NotNull ItemPresentation itemPresentation) {
        Intrinsics.checkNotNullParameter((Object)itemPresentation, (String)"itemPresentation");
        String string = itemPresentation.getPresentableText();
        if (string == null) {
            string = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"itemPresentation.presentableText ?: \"\"");
        TargetPopupPresentation targetPopupPresentation = TargetPopupPresentation.Companion.builder(string).icon(itemPresentation.getIcon(false)).presentableTextAttributes(UtilKt.getColoredAttributes(itemPresentation)).containerText(UtilKt.getContainerText(itemPresentation)).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentation, (String)"TargetPopupPresentation\n\u2026xt())\n    .presentation()");
        return targetPopupPresentation;
    }

    private static final TextAttributes getColoredAttributes(ItemPresentation $this$getColoredAttributes) {
        ColoredItemPresentation coloredPresentation;
        ColoredItemPresentation coloredItemPresentation;
        ItemPresentation itemPresentation = $this$getColoredAttributes;
        if (!(itemPresentation instanceof ColoredItemPresentation)) {
            itemPresentation = null;
        }
        if ((coloredItemPresentation = (coloredPresentation = (ColoredItemPresentation)itemPresentation)) == null || (coloredItemPresentation = coloredItemPresentation.getTextAttributesKey()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)coloredItemPresentation, (String)"coloredPresentation?.tex\u2026ributesKey ?: return null");
        ColoredItemPresentation textAttributesKey = coloredItemPresentation;
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        return editorColorsManager.getSchemeForCurrentUITheme().getAttributes((TextAttributesKey)textAttributesKey);
    }

    @Nls
    private static final String getContainerText(ItemPresentation $this$getContainerText) {
        String string = $this$getContainerText.getLocationString();
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"locationString ?: return null");
        String locationString = string;
        Matcher matcher = CONTAINER_PATTERN.matcher(locationString);
        return matcher.matches() ? matcher.group(2) : locationString;
    }

    @NotNull
    public static final TargetPopupPresentation targetPopupPresentation(@NotNull PsiElement element2) {
        TextAttributes textAttributes;
        Color color;
        Object object;
        TargetPopupPresentationBuilder targetPopupPresentationBuilder;
        boolean bl;
        boolean bl2;
        VirtualFile virtualFile;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
        Project project2 = project;
        PsiFile psiFile = element2.getContainingFile();
        VirtualFile file2 = psiFile != null ? psiFile.getVirtualFile() : null;
        PsiElement psiElement = element2;
        if (!(psiElement instanceof NavigationItem)) {
            psiElement = null;
        }
        NavigationItem navigationItem = (NavigationItem)psiElement;
        Object itemPresentation = navigationItem != null ? navigationItem.getPresentation() : null;
        Object object3 = itemPresentation;
        if (object3 == null || (object3 = object3.getPresentableText()) == null) {
            PsiElement psiElement2 = element2;
            if (!(psiElement2 instanceof PsiNamedElement)) {
                psiElement2 = null;
            }
            PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement2;
            object3 = object2 = psiNamedElement != null ? psiNamedElement.getName() : null;
        }
        if (object3 == null) {
            String string = element2.getText();
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        }
        Object presentableText2 = object2;
        DefaultListCellRenderer defaultListCellRenderer = PsiElementListCellRenderer.getModuleRenderer(element2);
        Component component2 = defaultListCellRenderer != null ? defaultListCellRenderer.getListCellRendererComponent((JList<?>)new JList(), element2, -1, false, false) : null;
        if (!(component2 instanceof JLabel)) {
            component2 = null;
        }
        JLabel moduleRendererComponent = (JLabel)component2;
        TargetPopupPresentationBuilder targetPopupPresentationBuilder2 = TargetPopupPresentation.Companion.builder((String)presentableText2);
        VirtualFile virtualFile2 = file2;
        if (virtualFile2 != null) {
            virtualFile = virtualFile2;
            bl2 = false;
            bl = false;
            VirtualFile virtualFile3 = virtualFile;
            targetPopupPresentationBuilder = targetPopupPresentationBuilder2;
            boolean bl3 = false;
            object = VfsPresentationUtil.getFileBackgroundColor(project2, file2);
            targetPopupPresentationBuilder2 = targetPopupPresentationBuilder;
            color = object;
        } else {
            color = null;
        }
        ItemPresentation itemPresentation2 = itemPresentation;
        TargetPopupPresentationBuilder targetPopupPresentationBuilder3 = targetPopupPresentationBuilder2.backgroundColor(color).icon(element2.getIcon(3)).presentableTextAttributes((TextAttributes)(itemPresentation2 != null ? UtilKt.getColoredAttributes(itemPresentation2) : null));
        ItemPresentation itemPresentation3 = itemPresentation;
        Object object4 = itemPresentation3 != null ? UtilKt.getContainerText(itemPresentation3) : null;
        VirtualFile virtualFile4 = file2;
        if (virtualFile4 != null) {
            virtualFile = virtualFile4;
            bl2 = false;
            bl = false;
            VirtualFile it = virtualFile;
            object = object4;
            targetPopupPresentationBuilder = targetPopupPresentationBuilder3;
            boolean bl4 = false;
            TextAttributes textAttributes2 = UtilKt.fileStatusAttributes(project2, file2);
            targetPopupPresentationBuilder3 = targetPopupPresentationBuilder;
            object4 = object;
            textAttributes = textAttributes2;
        } else {
            textAttributes = null;
        }
        JLabel jLabel = moduleRendererComponent;
        JLabel jLabel2 = moduleRendererComponent;
        TargetPopupPresentation targetPopupPresentation = targetPopupPresentationBuilder3.containerText((String)object4, textAttributes).locationText(jLabel != null ? jLabel.getText() : null, jLabel2 != null ? jLabel2.getIcon() : null).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPopupPresentation, (String)"TargetPopupPresentation\n\u2026icon)\n    .presentation()");
        return targetPopupPresentation;
    }

    @ApiStatus.Experimental
    @Nullable
    public static final TextAttributes fileStatusAttributes(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file2);
        Color fileColor = fileStatus != null ? fileStatus.getColor() : null;
        boolean hasProblem = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(file2);
        return hasProblem ? new TextAttributes(fileColor, null, (Color)JBColor.red, EffectType.WAVE_UNDERSCORE, 0) : (fileColor != null ? new TextAttributes(fileColor, null, null, null, 0) : null);
    }

    @ApiStatus.Experimental
    @Nullable
    public static final Pair<String, Icon> fileLocation(@NotNull Project project, @NotNull VirtualFile file2) {
        Module module;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        return fileIndex.isInLibrary(file2) ? new PsiElementModuleRenderer().libraryLocation(fileIndex, file2) : ((module = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project)) != null ? PsiElementModuleRenderer.projectLocation(file2, module, fileIndex) : null);
    }

    static {
        Pattern pattern = Pattern.compile("(\\(in |\\()?([^)]*)(\\))?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(\"(\\\\(in |\\\\()?([^)]*)(\\\\))?\")");
        CONTAINER_PATTERN = pattern;
    }
}

