/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class MethodUpDownUtil {
    private MethodUpDownUtil() {
    }

    public static int[] getNavigationOffsets(PsiFile file2, int caretOffset) {
        for (MethodNavigationOffsetProvider provider2 : MethodNavigationOffsetProvider.EP_NAME.getExtensionList()) {
            int[] offsets2 = provider2.getMethodNavigationOffsets(file2, caretOffset);
            if (offsets2 == null || offsets2.length <= 0) continue;
            return offsets2;
        }
        HashSet array2 = new HashSet();
        MethodUpDownUtil.addNavigationElements(array2, file2);
        return MethodUpDownUtil.offsetsFromElements(array2);
    }

    public static int[] offsetsFromElements(Collection<? extends PsiElement> array2) {
        IntArrayList offsets2 = new IntArrayList(array2.size());
        for (PsiElement psiElement : array2) {
            int offset = psiElement.getTextOffset();
            assert (offset >= 0) : psiElement + " (" + psiElement.getClass() + "); offset: " + offset;
            offsets2.add(offset);
        }
        offsets2.sort(null);
        return offsets2.toIntArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addNavigationElements(Collection<? super PsiElement> array2, PsiFile element2) {
        StructureViewBuilder structureViewBuilder = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(element2);
        if (structureViewBuilder instanceof TreeBasedStructureViewBuilder) {
            TreeBasedStructureViewBuilder builder2 = (TreeBasedStructureViewBuilder)structureViewBuilder;
            StructureViewModel model2 = builder2.createStructureViewModel(null);
            try {
                MethodUpDownUtil.addStructureViewElements((TreeElement)model2.getRoot(), array2, element2);
            }
            finally {
                Disposer.dispose((Disposable)model2);
            }
        }
    }

    private static void addStructureViewElements(TreeElement parent, Collection<? super PsiElement> array2, @NotNull PsiFile file2) {
        if (file2 == null) {
            MethodUpDownUtil.$$$reportNull$$$0(0);
        }
        for (TreeElement treeElement : parent.getChildren()) {
            Object value2 = ((StructureViewTreeElement)treeElement).getValue();
            if (value2 instanceof PsiElement) {
                PsiElement element2 = (PsiElement)value2;
                if (array2.contains(element2) || !file2.equals(element2.getContainingFile())) continue;
                array2.add((PsiElement)element2);
            }
            MethodUpDownUtil.addStructureViewElements(treeElement, array2, file2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/navigation/MethodUpDownUtil", "addStructureViewElements"));
    }
}

