/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.CharTailType;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.CommaTailType;
import com.intellij.codeInsight.lookup.DefaultLookupItemRenderer;
import com.intellij.codeInsight.lookup.EqTailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.codeInsight.lookup.impl.ElementLookupRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LookupItem<T>
extends MutableLookupElement
implements Comparable {
    public static final ClassConditionKey<LookupItem> CLASS_CONDITION_KEY = ClassConditionKey.create(LookupItem.class);
    public static final Object HIGHLIGHTED_ATTR = Key.create((String)"highlighted");
    public static final Object ICON_ATTR = Key.create((String)"icon");
    public static final Object TYPE_TEXT_ATTR = Key.create((String)"typeText");
    public static final Object TAIL_TEXT_ATTR = Key.create((String)"tailText");
    public static final Object TAIL_TEXT_SMALL_ATTR = Key.create((String)"tailTextSmall");
    public static final Object FORCE_QUALIFY = Key.create((String)"FORCE_QUALIFY");
    public static final Object CASE_INSENSITIVE = Key.create((String)"CASE_INSENSITIVE");
    public static final Key<TailType> TAIL_TYPE_ATTR = Key.create((String)"myTailType");
    private Object myObject;
    private String myLookupString;
    private InsertHandler myInsertHandler;
    private double myPriority;
    private Map<Object, Object> myAttributes;
    public static final LookupItem[] EMPTY_ARRAY = new LookupItem[0];
    private final Set<String> myAllLookupStrings;
    private String myPresentable;
    private AutoCompletionPolicy myAutoCompletionPolicy;

    @Deprecated
    public LookupItem(T o, @NotNull @NonNls String lookupString) {
        if (lookupString == null) {
            LookupItem.$$$reportNull$$$0(0);
        }
        this.myAttributes = null;
        this.myAllLookupStrings = new HashSet<String>();
        this.myAutoCompletionPolicy = AutoCompletionPolicy.SETTINGS_DEPENDENT;
        this.setObject(o);
        this.setLookupString(lookupString);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static LookupItem fromString(String s) {
        return new LookupItem<String>(s, s);
    }

    public void setObject(@NotNull T o) {
        if (o == null) {
            LookupItem.$$$reportNull$$$0(1);
        }
        this.myObject = o;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LookupItem) {
            LookupItem item = (LookupItem)o;
            return Comparing.equal((Object)this.myObject, (Object)item.myObject) && Objects.equals(this.myLookupString, item.myLookupString) && Comparing.equal(this.myAllLookupStrings, item.myAllLookupStrings) && Comparing.equal(this.myAttributes, item.myAttributes);
        }
        return false;
    }

    public int hashCode() {
        T object = this.getObject();
        assert (object != this) : this.getClass().getName();
        return this.myAllLookupStrings.hashCode() * 239 + object.hashCode();
    }

    public String toString() {
        return this.getLookupString();
    }

    @NotNull
    public T getObject() {
        Object object = this.myObject;
        if (object == null) {
            LookupItem.$$$reportNull$$$0(2);
        }
        return (T)object;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            LookupItem.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setLookupString(@NotNull String lookupString) {
        if (lookupString == null) {
            LookupItem.$$$reportNull$$$0(4);
        }
        this.myAllLookupStrings.remove("");
        this.myLookupString = lookupString;
        this.myAllLookupStrings.add(lookupString);
    }

    public Object getAttribute(Object key) {
        if (this.myAttributes != null) {
            return this.myAttributes.get(key);
        }
        return null;
    }

    public <T> T getAttribute(Key<T> key) {
        if (this.myAttributes != null) {
            return (T)this.myAttributes.get(key);
        }
        return null;
    }

    public void setAttribute(Object key, Object value2) {
        if (value2 == null && this.myAttributes != null) {
            this.myAttributes.remove(key);
            return;
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<Object, Object>(5);
        }
        this.myAttributes.put(key, value2);
    }

    public <T> void setAttribute(Key<T> key, T value2) {
        if (value2 == null && this.myAttributes != null) {
            this.myAttributes.remove(key);
            return;
        }
        if (this.myAttributes == null) {
            this.myAttributes = new HashMap<Object, Object>(5);
        }
        this.myAttributes.put(key, value2);
    }

    public InsertHandler<? extends LookupItem> getInsertHandler() {
        return this.myInsertHandler;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        InsertHandler<LookupItem> handler2;
        if (context == null) {
            LookupItem.$$$reportNull$$$0(5);
        }
        if ((handler2 = this.getInsertHandler()) != null) {
            handler2.handleInsert(context, (LookupElement)this);
        }
        if (this.getTailType() != TailType.UNKNOWN && this.myInsertHandler == null) {
            context.setAddCompletionChar(false);
            TailType type = LookupItem.handleCompletionChar(context.getEditor(), this, context.getCompletionChar());
            type.processTail(context.getEditor(), context.getTailOffset());
        }
    }

    @Nullable
    public static TailType getDefaultTailType(char completionChar) {
        switch (completionChar) {
            case '.': {
                return new CharTailType('.', false);
            }
            case ',': {
                return CommaTailType.INSTANCE;
            }
            case ';': {
                return TailType.SEMICOLON;
            }
            case '=': {
                return EqTailType.INSTANCE;
            }
            case ' ': {
                return TailType.SPACE;
            }
            case ':': {
                return TailType.CASE_COLON;
            }
        }
        return null;
    }

    @NotNull
    public static TailType handleCompletionChar(@NotNull Editor editor, @NotNull LookupElement lookupElement, char completionChar) {
        LookupItem item;
        TailType attr;
        TailType type;
        if (editor == null) {
            LookupItem.$$$reportNull$$$0(6);
        }
        if (lookupElement == null) {
            LookupItem.$$$reportNull$$$0(7);
        }
        if ((type = LookupItem.getDefaultTailType(completionChar)) != null) {
            TailType tailType = type;
            if (tailType == null) {
                LookupItem.$$$reportNull$$$0(8);
            }
            return tailType;
        }
        if (lookupElement instanceof LookupItem && (attr = (item = (LookupItem)lookupElement).getAttribute(TAIL_TYPE_ATTR)) != null) {
            TailType tailType = attr;
            if (tailType == null) {
                LookupItem.$$$reportNull$$$0(9);
            }
            return tailType;
        }
        TailType tailType = TailType.NONE;
        if (tailType == null) {
            LookupItem.$$$reportNull$$$0(10);
        }
        return tailType;
    }

    @NotNull
    public TailType getTailType() {
        TailType tailType = this.getAttribute(TAIL_TYPE_ATTR);
        TailType tailType2 = tailType != null ? tailType : TailType.UNKNOWN;
        if (tailType2 == null) {
            LookupItem.$$$reportNull$$$0(11);
        }
        return tailType2;
    }

    @NotNull
    public LookupItem<T> setTailType(@NotNull TailType type) {
        if (type == null) {
            LookupItem.$$$reportNull$$$0(12);
        }
        this.setAttribute((Key<T>)TAIL_TYPE_ATTR, (T)type);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            LookupItem.$$$reportNull$$$0(13);
        }
        return lookupItem;
    }

    public int compareTo(@NotNull Object o) {
        if (o == null) {
            LookupItem.$$$reportNull$$$0(14);
        }
        if (o instanceof String) {
            return this.getLookupString().compareTo((String)o);
        }
        if (!(o instanceof LookupItem)) {
            throw new RuntimeException("Trying to compare LookupItem with " + o.getClass() + "!!!");
        }
        return this.getLookupString().compareTo(((LookupItem)o).getLookupString());
    }

    public LookupItem<T> setInsertHandler(@NotNull InsertHandler<? extends LookupElement> handler2) {
        if (handler2 == null) {
            LookupItem.$$$reportNull$$$0(15);
        }
        this.myInsertHandler = handler2;
        return this;
    }

    public void renderElement(LookupElementPresentation presentation2) {
        for (ElementLookupRenderer renderer : ElementLookupRenderer.EP_NAME.getExtensionList()) {
            T object;
            if (!renderer.handlesItem(object = this.getObject())) continue;
            renderer.renderElement(this, object, presentation2);
            return;
        }
        DefaultLookupItemRenderer.INSTANCE.renderElement(this, presentation2);
    }

    public LookupItem<T> setBold() {
        this.setAttribute(HIGHLIGHTED_ATTR, "");
        return this;
    }

    public LookupItem<T> forceQualify() {
        this.setAttribute(FORCE_QUALIFY, "");
        return this;
    }

    public LookupItem<T> setAutoCompletionPolicy(AutoCompletionPolicy policy) {
        this.myAutoCompletionPolicy = policy;
        return this;
    }

    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return this.myAutoCompletionPolicy;
    }

    @NotNull
    public LookupItem<T> setIcon(Icon icon2) {
        this.setAttribute(ICON_ATTR, icon2);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            LookupItem.$$$reportNull$$$0(16);
        }
        return lookupItem;
    }

    @NotNull
    public LookupItem<T> setPriority(double priority) {
        this.myPriority = priority;
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            LookupItem.$$$reportNull$$$0(17);
        }
        return lookupItem;
    }

    public final double getPriority() {
        return this.myPriority;
    }

    @NotNull
    public LookupItem<T> setPresentableText(@NotNull String displayText) {
        if (displayText == null) {
            LookupItem.$$$reportNull$$$0(18);
        }
        this.myPresentable = displayText;
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            LookupItem.$$$reportNull$$$0(19);
        }
        return lookupItem;
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentable;
    }

    @NotNull
    public LookupItem<T> setTailText(String text2, boolean grayed) {
        this.setAttribute(TAIL_TEXT_ATTR, text2);
        this.setAttribute(TAIL_TEXT_SMALL_ATTR, Boolean.TRUE);
        LookupItem lookupItem = this;
        if (lookupItem == null) {
            LookupItem.$$$reportNull$$$0(20);
        }
        return lookupItem;
    }

    public LookupItem<T> addLookupStrings(String ... additionalLookupStrings) {
        ContainerUtil.addAll(this.myAllLookupStrings, (Object[])additionalLookupStrings);
        return this;
    }

    public Set<String> getAllLookupStrings() {
        return this.myAllLookupStrings;
    }

    public boolean isCaseSensitive() {
        return !Boolean.TRUE.equals(this.getAttribute(CASE_INSENSITIVE));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/lookup/LookupItem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/lookup/LookupItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "handleCompletionChar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTailType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setTailType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setPriority";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setPresentableText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "setTailText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setObject";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setLookupString";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleCompletionChar";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTailType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setInsertHandler";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setPresentableText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

