/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.preview;

import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewResult;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewModel;", "", "()V", "Companion", "intellij.platform.lang.impl"})
public final class IntentionPreviewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewModel$Companion;", "", "()V", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "text", "", "lineShift", "", "maxLine", "createEditors", "", "result", "Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewResult;", "getEditorBackground", "Ljava/awt/Color;", "getOffset", "fileText", "lineNumber", "reformatRange", "", "psiFileCopy", "Lcom/intellij/psi/PsiFile;", "lineFragment", "Lcom/intellij/diff/fragments/LineFragment;", "DiffInfo", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final void reformatRange(@NotNull Project project, @NotNull PsiFile psiFileCopy, @NotNull LineFragment lineFragment) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFileCopy, (String)"psiFileCopy");
            Intrinsics.checkNotNullParameter((Object)lineFragment, (String)"lineFragment");
            int start2 = lineFragment.getStartOffset2();
            int end = lineFragment.getEndOffset2();
            if (start2 >= end) {
                return;
            }
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            FileViewProvider fileViewProvider = psiFileCopy.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"psiFileCopy.viewProvider");
            Document document = fileDocumentManager.getDocument(fileViewProvider.getVirtualFile());
            if (document != null) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(project, psiFileCopy, start2, end){
                final /* synthetic */ Project $project;
                final /* synthetic */ PsiFile $psiFileCopy;
                final /* synthetic */ int $start;
                final /* synthetic */ int $end;

                public final void run() {
                    CodeStyleManager.getInstance((Project)this.$project).reformatRange((PsiElement)this.$psiFileCopy, this.$start, this.$end, true);
                }
                {
                    this.$project = project;
                    this.$psiFileCopy = psiFile;
                    this.$start = n;
                    this.$end = n2;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<EditorEx> createEditors(@NotNull Project project, @Nullable IntentionPreviewResult result2) {
            boolean $i$f$filter;
            Iterable $this$filter$iv;
            boolean bl;
            List diffs;
            Object element$iv$iv;
            Iterable $this$mapNotNullTo$iv$iv;
            Collection destination$iv$iv;
            block17: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                if (result2 == null) {
                    return CollectionsKt.emptyList();
                }
                PsiFile psiFileCopy = result2.getPsiFile();
                List<LineFragment> lines2 = result2.getLineFragments();
                if (psiFileCopy == null) {
                    return CollectionsKt.emptyList();
                }
                Iterable $this$forEach$iv = lines2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LineFragment lineFragment = (LineFragment)element$iv;
                    boolean bl2 = false;
                    Companion.reformatRange(project, psiFileCopy, lineFragment);
                }
                String fileText = psiFileCopy.getText();
                String origText = result2.getOrigFile().getText();
                List list2 = ComparisonManager.getInstance().compareLines((CharSequence)origText, (CharSequence)fileText, ComparisonPolicy.TRIM_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"ComparisonManager.getIns\u2026ogressIndicator.INSTANCE)");
                List diff = list2;
                Iterable $this$mapNotNull$iv = diff;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach2 = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    DiffInfo diffInfo;
                    Object element$iv$iv$iv;
                    element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl3 = false;
                    LineFragment fragment = (LineFragment)element$iv$iv;
                    boolean bl4 = false;
                    String string = fileText;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fileText");
                    LineFragment lineFragment = fragment;
                    Intrinsics.checkNotNullExpressionValue((Object)lineFragment, (String)"fragment");
                    int start2 = Companion.getOffset(string, lineFragment.getStartLine2());
                    int end = Companion.getOffset(fileText, fragment.getEndLine2());
                    if (start2 > end) {
                        diffInfo = null;
                    } else {
                        String string2 = fileText;
                        boolean bl5 = false;
                        String string3 = string2.substring(start2, end);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String text2 = StringsKt.trimIndent((String)StringsKt.trimEnd((String)StringsKt.trimStart((String)string3, (char[])new char[]{'\n'}), (char[])new char[]{'\n'}));
                        boolean deleted = StringsKt.isBlank((CharSequence)text2);
                        if (deleted) {
                            String string4 = origText;
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"origText");
                            start2 = Companion.getOffset(string4, fragment.getStartLine1());
                            end = Companion.getOffset(origText, fragment.getEndLine1());
                            if (start2 >= end) {
                                diffInfo = null;
                            } else {
                                String string5 = origText;
                                boolean bl6 = false;
                                String string6 = string5.substring(start2, end);
                                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                text2 = StringsKt.trimIndent((String)StringsKt.trimEnd((String)StringsKt.trimStart((String)string6, (char[])new char[]{'\n'}), (char[])new char[]{'\n'}));
                                diffInfo = StringsKt.isBlank((CharSequence)text2) ? null : new DiffInfo(text2, fragment.getStartLine1(), fragment.getEndLine1() - fragment.getStartLine1(), true);
                            }
                        } else {
                            diffInfo = new DiffInfo(text2, fragment.getStartLine1(), fragment.getEndLine2() - fragment.getStartLine2(), false);
                        }
                    }
                    if (diffInfo == null) continue;
                    DiffInfo diffInfo2 = diffInfo;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    DiffInfo it$iv$iv = diffInfo2;
                    boolean bl9 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                diffs = (List)destination$iv$iv;
                Iterable $this$any$iv = diffs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        DiffInfo info = (DiffInfo)element$iv;
                        boolean bl10 = false;
                        if (!(!info.getDeleted())) continue;
                        bl = true;
                        break block17;
                    }
                    bl = false;
                }
            }
            if (bl) {
                void $this$filterTo$iv$iv;
                $this$filter$iv = diffs;
                $i$f$filter = false;
                $this$mapNotNullTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    DiffInfo info = (DiffInfo)element$iv$iv2;
                    boolean bl11 = false;
                    if (!(!info.getDeleted())) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                diffs = (List)destination$iv$iv;
            }
            $this$filter$iv = diffs;
            $i$f$filter = false;
            if (!$this$filter$iv.isEmpty()) {
                void $this$mapTo$iv$iv;
                DiffInfo last = (DiffInfo)CollectionsKt.last((List)diffs);
                int maxLine = last.getStartLine() + last.getLength();
                Iterable $this$map$iv = diffs;
                boolean $i$f$map = false;
                Iterable $i$f$filterTo = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    element$iv$iv = (DiffInfo)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl12 = false;
                    FileType fileType = result2.getOrigFile().getFileType();
                    Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"result.origFile.fileType");
                    EditorEx editorEx = it.createEditor(project, fileType, maxLine);
                    collection.add(editorEx);
                }
                return (List)destination$iv$iv2;
            }
            return CollectionsKt.emptyList();
        }

        private final int getOffset(String fileText, int lineNumber) {
            int n = StringUtil.lineColToOffset((CharSequence)fileText, (int)lineNumber, (int)0);
            boolean bl = false;
            boolean bl2 = false;
            int pos = n;
            boolean bl3 = false;
            return pos == -1 ? fileText.length() : pos;
        }

        private final EditorEx createEditor(Project project, FileType fileType, String text2, int lineShift, int maxLine) {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Document document = editorFactory.createDocument((CharSequence)text2);
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editorFactory.createDocument(text)");
            Document document2 = document;
            Editor editor = editorFactory.createEditor(document2, project, fileType, false);
            if (editor == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
            }
            Object object = (EditorEx)editor;
            boolean bl = false;
            boolean bl2 = false;
            Object $this$apply = object;
            boolean bl3 = false;
            $this$apply.setBorder((Border)JBUI.Borders.empty((int)2, (int)0, (int)2, (int)0));
            EditorEx editor2 = object;
            object = editor2.getSettings();
            bl = false;
            bl2 = false;
            $this$apply = object;
            boolean bl4 = false;
            $this$apply.setLineNumbersShown(true);
            $this$apply.setCaretRowShown(false);
            $this$apply.setLineMarkerAreaShown(false);
            $this$apply.setFoldingOutlineShown(false);
            $this$apply.setAdditionalColumnsCount(4);
            $this$apply.setAdditionalLinesCount(0);
            $this$apply.setRightMarginShown(false);
            $this$apply.setUseSoftWraps(false);
            $this$apply.setAdditionalPageAtBottom(false);
            editor2.setBackgroundColor(this.getEditorBackground());
            EditorSettings editorSettings = editor2.getSettings();
            Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
            editorSettings.setUseSoftWraps(true);
            editor2.getScrollingModel().disableAnimation();
            object = editor2.getGutterComponentEx();
            bl = false;
            bl2 = false;
            $this$apply = object;
            boolean bl5 = false;
            ((EditorGutterComponentEx)$this$apply).setPaintBackground(false);
            $this$apply.setLineNumberConverter(new LineNumberConverter(lineShift, maxLine){
                final /* synthetic */ int $lineShift$inlined;
                final /* synthetic */ int $maxLine$inlined;
                {
                    this.$lineShift$inlined = n;
                    this.$maxLine$inlined = n2;
                }

                @Nullable
                public Integer convert(@NotNull Editor editor, int line) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    return line + this.$lineShift$inlined;
                }

                @Nullable
                public Integer getMaxLineNumber(@NotNull Editor editor) {
                    Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                    return this.$maxLine$inlined;
                }
            });
            return editor2;
        }

        private final Color getEditorBackground() {
            EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
            EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
            Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
            EditorColorsScheme colorsScheme = editorColorsScheme;
            Color color = colorsScheme.getColor(EditorColors.CARET_ROW_COLOR);
            if (color == null) {
                Color color2 = colorsScheme.getDefaultBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"colorsScheme.defaultBackground");
            }
            return color;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J1\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005J\u0013\u0010\u001d\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/codeInsight/intention/impl/preview/IntentionPreviewModel$Companion$DiffInfo;", "", "fileText", "", "startLine", "", "length", "deleted", "", "(Ljava/lang/String;IIZ)V", "getDeleted", "()Z", "getFileText", "()Ljava/lang/String;", "getLength", "()I", "getStartLine", "component1", "component2", "component3", "component4", "copy", "createEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "maxLine", "equals", "other", "hashCode", "toString", "intellij.platform.lang.impl"})
        private static final class DiffInfo {
            @NotNull
            private final String fileText;
            private final int startLine;
            private final int length;
            private final boolean deleted;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final EditorEx createEditor(@NotNull Project project, @NotNull FileType fileType, int maxLine) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
                EditorEx editor = Companion.createEditor(project, fileType, this.fileText, this.startLine, maxLine);
                if (this.deleted) {
                    EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
                    Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"editor.colorsScheme");
                    EditorColorsScheme colorsScheme = editorColorsScheme;
                    TextAttributes attributes = new TextAttributes(null, null, colorsScheme.getDefaultForeground(), EffectType.STRIKEOUT, 0);
                    DocumentEx documentEx = editor.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"editor.document");
                    DocumentEx document = documentEx;
                    int lineCount = document.getLineCount();
                    int n = 0;
                    int n2 = lineCount;
                    while (n < n2) {
                        int start2;
                        void line;
                        int end = document.getLineEndOffset((int)line) - 1;
                        for (start2 = document.getLineStartOffset((int)line); start2 <= end && Character.isWhitespace(this.fileText.charAt(start2)); ++start2) {
                        }
                        while (start2 <= end && Character.isWhitespace(this.fileText.charAt(end))) {
                            --end;
                        }
                        if (start2 <= end) {
                            editor.getMarkupModel().addRangeHighlighter(start2, end + 1, 5001, attributes, HighlighterTargetArea.EXACT_RANGE);
                        }
                        ++line;
                    }
                }
                return editor;
            }

            @NotNull
            public final String getFileText() {
                return this.fileText;
            }

            public final int getStartLine() {
                return this.startLine;
            }

            public final int getLength() {
                return this.length;
            }

            public final boolean getDeleted() {
                return this.deleted;
            }

            public DiffInfo(@NotNull String fileText, int startLine, int length, boolean deleted) {
                Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
                this.fileText = fileText;
                this.startLine = startLine;
                this.length = length;
                this.deleted = deleted;
            }

            @NotNull
            public final String component1() {
                return this.fileText;
            }

            public final int component2() {
                return this.startLine;
            }

            public final int component3() {
                return this.length;
            }

            public final boolean component4() {
                return this.deleted;
            }

            @NotNull
            public final DiffInfo copy(@NotNull String fileText, int startLine, int length, boolean deleted) {
                Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
                return new DiffInfo(fileText, startLine, length, deleted);
            }

            public static /* synthetic */ DiffInfo copy$default(DiffInfo diffInfo, String string, int n, int n2, boolean bl, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    string = diffInfo.fileText;
                }
                if ((n3 & 2) != 0) {
                    n = diffInfo.startLine;
                }
                if ((n3 & 4) != 0) {
                    n2 = diffInfo.length;
                }
                if ((n3 & 8) != 0) {
                    bl = diffInfo.deleted;
                }
                return diffInfo.copy(string, n, n2, bl);
            }

            @NotNull
            public String toString() {
                return "DiffInfo(fileText=" + this.fileText + ", startLine=" + this.startLine + ", length=" + this.length + ", deleted=" + this.deleted + ")";
            }

            public int hashCode() {
                String string = this.fileText;
                int n = (((string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.startLine)) * 31 + Integer.hashCode(this.length)) * 31;
                int n2 = this.deleted ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                return n + n2;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof DiffInfo)) break block3;
                        DiffInfo diffInfo = (DiffInfo)object;
                        if (!Intrinsics.areEqual((Object)this.fileText, (Object)diffInfo.fileText) || this.startLine != diffInfo.startLine || this.length != diffInfo.length || this.deleted != diffInfo.deleted) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

