/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerImpl;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.packageDependencies.ui.TreeExpansionMonitor;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public abstract class IntentionSettingsTree {
    private JComponent myComponent;
    private CheckboxTree myTree;
    private FilterComponent myFilter;
    private final Map<IntentionActionMetaData, Boolean> myIntentionToCheckStatus = new HashMap<IntentionActionMetaData, Boolean>();
    private JPanel myNorthPanel;

    protected IntentionSettingsTree() {
        this.initTree();
    }

    public JTree getTree() {
        return this.myTree;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void initTree() {
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(true){

            public void customizeRenderer(JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (!(value2 instanceof CheckedTreeNode)) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)value2;
                SimpleTextAttributes attributes = node.getUserObject() instanceof IntentionActionMetaData ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
                String text2 = IntentionSettingsTree.getNodeText(node);
                Color background = UIUtil.getTreeBackground((boolean)selected2, (boolean)true);
                UIUtil.changeBackGround((Component)((Object)this), (Color)background);
                SearchUtil.appendFragments(IntentionSettingsTree.this.myFilter != null ? IntentionSettingsTree.this.myFilter.getFilter() : null, text2, attributes.getStyle(), attributes.getFgColor(), background, (SimpleColoredComponent)this.getTextRenderer());
            }
        }, new CheckedTreeNode(null));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                Object userObject = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                IntentionSettingsTree.this.selectionChanged(userObject);
            }
        });
        this.myFilter = new MyFilterComponent();
        this.myComponent = new JPanel(new BorderLayout());
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree));
        this.myNorthPanel = new JPanel(new BorderLayout());
        this.myNorthPanel.add((Component)this.myFilter, "Center");
        this.myNorthPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)2));
        DefaultActionGroup group2 = new DefaultActionGroup();
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        group2.add(actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        group2.add(actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        this.myNorthPanel.add((Component)ActionManager.getInstance().createActionToolbar("IntentionSettingsTree", (ActionGroup)group2, true).getComponent(), "West");
        this.myComponent.add((Component)this.myNorthPanel, "North");
        this.myComponent.add((Component)scrollPane, "Center");
        this.myFilter.reset();
    }

    protected abstract void selectionChanged(Object var1);

    protected abstract List<IntentionActionMetaData> filterModel(String var1, boolean var2);

    public void filter(List<IntentionActionMetaData> intentionsToShow) {
        this.refreshCheckStatus((CheckedTreeNode)this.myTree.getModel().getRoot());
        this.reset(IntentionSettingsTree.copyAndSort(intentionsToShow));
    }

    public void reset() {
        IntentionManagerImpl intentionManager = (IntentionManagerImpl)IntentionManager.getInstance();
        while (intentionManager.hasActiveRequests()) {
            TimeoutUtil.sleep((long)100L);
        }
        IntentionManagerSettings intentionManagerSettings = IntentionManagerSettings.getInstance();
        this.myIntentionToCheckStatus.clear();
        List<IntentionActionMetaData> intentions = intentionManagerSettings.getMetaData();
        for (IntentionActionMetaData metaData : intentions) {
            this.myIntentionToCheckStatus.put(metaData, intentionManagerSettings.isEnabled(metaData));
        }
        this.reset(IntentionSettingsTree.copyAndSort(intentions));
    }

    private void reset(@NotNull List<IntentionActionMetaData> sortedIntentions) {
        if (sortedIntentions == null) {
            IntentionSettingsTree.$$$reportNull$$$0(0);
        }
        CheckedTreeNode root = new CheckedTreeNode(null);
        DefaultTreeModel treeModel = (DefaultTreeModel)this.myTree.getModel();
        for (IntentionActionMetaData metaData : sortedIntentions) {
            CheckedTreeNode node = root;
            for (String name : metaData.myCategory) {
                CheckedTreeNode child2 = IntentionSettingsTree.findChild((TreeNode)node, name);
                if (child2 == null) {
                    CheckedTreeNode newChild = new CheckedTreeNode((Object)name);
                    treeModel.insertNodeInto((MutableTreeNode)newChild, (MutableTreeNode)node, node.getChildCount());
                    child2 = newChild;
                }
                node = child2;
            }
            treeModel.insertNodeInto((MutableTreeNode)new CheckedTreeNode((Object)metaData), (MutableTreeNode)node, node.getChildCount());
        }
        this.resetCheckMark(root);
        treeModel.setRoot((TreeNode)root);
        treeModel.nodeChanged((TreeNode)root);
        TreeUtil.expandAll((JTree)((Object)this.myTree));
        this.myTree.setSelectionRow(0);
    }

    public void selectIntention(String familyName) {
        CheckedTreeNode child2 = IntentionSettingsTree.findChildRecursively((TreeNode)this.getRoot(), familyName);
        if (child2 != null) {
            TreePath path = new TreePath(child2.getPath());
            TreeUtil.selectPath((JTree)((Object)this.myTree), (TreePath)path);
        }
    }

    @NotNull
    private static List<IntentionActionMetaData> copyAndSort(@NotNull List<IntentionActionMetaData> intentionsToShow) {
        if (intentionsToShow == null) {
            IntentionSettingsTree.$$$reportNull$$$0(1);
        }
        ArrayList<IntentionActionMetaData> copy2 = new ArrayList<IntentionActionMetaData>(intentionsToShow);
        copy2.sort((data1, data2) -> {
            String[] category1 = data1.myCategory;
            String[] category2 = data2.myCategory;
            int result2 = ArrayUtil.lexicographicCompare((String[])category1, (String[])category2);
            if (result2 != 0) {
                return result2;
            }
            return data1.getFamily().compareTo(data2.getFamily());
        });
        ArrayList<IntentionActionMetaData> arrayList = copy2;
        if (arrayList == null) {
            IntentionSettingsTree.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private CheckedTreeNode getRoot() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    private boolean resetCheckMark(final CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData metaData = (IntentionActionMetaData)userObject;
            Boolean b = this.myIntentionToCheckStatus.get(metaData);
            boolean enabled = b == Boolean.TRUE;
            root.setChecked(enabled);
            return enabled;
        }
        root.setChecked(false);
        IntentionSettingsTree.visitChildren((TreeNode)root, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                if (IntentionSettingsTree.this.resetCheckMark(node)) {
                    root.setChecked(true);
                }
            }
        });
        return root.isChecked();
    }

    private static CheckedTreeNode findChild(TreeNode node, final String name) {
        final Ref found = new Ref();
        IntentionSettingsTree.visitChildren(node, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                String text2 = IntentionSettingsTree.getNodeText(node);
                if (name.equals(text2)) {
                    found.set((Object)node);
                }
            }
        });
        return (CheckedTreeNode)found.get();
    }

    private static CheckedTreeNode findChildRecursively(TreeNode node, final String name) {
        final Ref found = new Ref();
        IntentionSettingsTree.visitChildren(node, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                if (found.get() != null) {
                    return;
                }
                Object userObject = node.getUserObject();
                if (userObject instanceof IntentionActionMetaData) {
                    String text2 = IntentionSettingsTree.getNodeText(node);
                    if (name.equals(text2)) {
                        found.set((Object)node);
                    }
                } else {
                    CheckedTreeNode child2 = IntentionSettingsTree.findChildRecursively((TreeNode)node, name);
                    if (child2 != null) {
                        found.set((Object)child2);
                    }
                }
            }
        });
        return (CheckedTreeNode)found.get();
    }

    private static String getNodeText(CheckedTreeNode node) {
        Object userObject = node.getUserObject();
        String text2 = userObject instanceof String ? (String)userObject : (userObject instanceof IntentionActionMetaData ? ((IntentionActionMetaData)userObject).getFamily() : "???");
        return text2;
    }

    public void apply() {
        CheckedTreeNode root = this.getRoot();
        IntentionSettingsTree.apply(root);
    }

    private void refreshCheckStatus(CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData actionMetaData = (IntentionActionMetaData)userObject;
            this.myIntentionToCheckStatus.put(actionMetaData, root.isChecked());
        } else {
            IntentionSettingsTree.visitChildren((TreeNode)root, new CheckedNodeVisitor(){

                @Override
                public void visit(CheckedTreeNode node) {
                    IntentionSettingsTree.this.refreshCheckStatus(node);
                }
            });
        }
    }

    private static void apply(CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData actionMetaData = (IntentionActionMetaData)userObject;
            IntentionManagerSettings.getInstance().setEnabled(actionMetaData, root.isChecked());
        } else {
            IntentionSettingsTree.visitChildren((TreeNode)root, new CheckedNodeVisitor(){

                @Override
                public void visit(CheckedTreeNode node) {
                    IntentionSettingsTree.apply(node);
                }
            });
        }
    }

    public boolean isModified() {
        return IntentionSettingsTree.isModified(this.getRoot());
    }

    private static boolean isModified(CheckedTreeNode root) {
        Object userObject = root.getUserObject();
        if (userObject instanceof IntentionActionMetaData) {
            IntentionActionMetaData actionMetaData = (IntentionActionMetaData)userObject;
            boolean enabled = IntentionManagerSettings.getInstance().isEnabled(actionMetaData);
            return enabled != root.isChecked();
        }
        final boolean[] modified = new boolean[]{false};
        IntentionSettingsTree.visitChildren((TreeNode)root, new CheckedNodeVisitor(){

            @Override
            public void visit(CheckedTreeNode node) {
                modified[0] = modified[0] | IntentionSettingsTree.isModified(node);
            }
        });
        return modified[0];
    }

    public void dispose() {
        this.myFilter.dispose();
    }

    public void setFilter(String filter) {
        this.myFilter.setFilter(filter);
    }

    public String getFilter() {
        return this.myFilter.getFilter();
    }

    private static void visitChildren(TreeNode node, CheckedNodeVisitor visitor) {
        Enumeration<? extends TreeNode> children2 = node.children();
        while (children2.hasMoreElements()) {
            CheckedTreeNode child2 = (CheckedTreeNode)children2.nextElement();
            visitor.visit(child2);
        }
    }

    public JPanel getToolbarPanel() {
        return this.myNorthPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedIntentions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionsToShow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/config/IntentionSettingsTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/config/IntentionSettingsTree";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndSort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "copyAndSort";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFilterComponent
    extends FilterComponent {
        private final TreeExpansionMonitor<DefaultMutableTreeNode> myExpansionMonitor;

        MyFilterComponent() {
            super("INTENTION_FILTER_HISTORY", 10);
            this.myExpansionMonitor = TreeExpansionMonitor.install((JTree)((Object)IntentionSettingsTree.this.myTree));
        }

        public void filter() {
            String filter = this.getFilter();
            if (filter != null && filter.length() > 0 && !this.myExpansionMonitor.isFreeze()) {
                this.myExpansionMonitor.freeze();
            }
            IntentionSettingsTree.this.filter(IntentionSettingsTree.this.filterModel(filter, true));
            if (IntentionSettingsTree.this.myTree != null) {
                List expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)IntentionSettingsTree.this.myTree));
                ((DefaultTreeModel)IntentionSettingsTree.this.myTree.getModel()).reload();
                TreeUtil.restoreExpandedPaths((JTree)((Object)IntentionSettingsTree.this.myTree), (List)expandedPaths);
            }
            SwingUtilities.invokeLater(() -> {
                IntentionSettingsTree.this.myTree.setSelectionRow(0);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)IntentionSettingsTree.this.myTree), true));
            });
            TreeUtil.expandAll((JTree)((Object)IntentionSettingsTree.this.myTree));
            if (filter == null || filter.length() == 0) {
                TreeUtil.collapseAll((JTree)((Object)IntentionSettingsTree.this.myTree), (int)0);
                this.myExpansionMonitor.restore();
            }
        }

        protected void onlineFilter() {
            String filter = this.getFilter();
            if (filter != null && filter.length() > 0 && !this.myExpansionMonitor.isFreeze()) {
                this.myExpansionMonitor.freeze();
            }
            IntentionSettingsTree.this.filter(IntentionSettingsTree.this.filterModel(filter, true));
            TreeUtil.expandAll((JTree)((Object)IntentionSettingsTree.this.myTree));
            if (filter == null || filter.length() == 0) {
                TreeUtil.collapseAll((JTree)((Object)IntentionSettingsTree.this.myTree), (int)0);
                this.myExpansionMonitor.restore();
            }
        }
    }

    static interface CheckedNodeVisitor {
        public void visit(CheckedTreeNode var1);
    }
}

