/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionUsagePanel;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerConfigurableProxy;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class IntentionDescriptionPanel {
    private static final Logger LOG = Logger.getInstance(IntentionDescriptionPanel.class);
    private JPanel myPanel;
    private JPanel myAfterPanel;
    private JPanel myBeforePanel;
    private JEditorPane myDescriptionBrowser;
    private JPanel myPoweredByPanel;
    private JPanel myDescriptionPanel;
    private final List<IntentionUsagePanel> myBeforeUsagePanels;
    private final List<IntentionUsagePanel> myAfterUsagePanels;
    @NonNls
    private static final String BEFORE_TEMPLATE = "before.java.template";
    @NonNls
    private static final String AFTER_TEMPLATE = "after.java.template";

    public IntentionDescriptionPanel() {
        this.$$$setupUI$$$();
        this.myBeforeUsagePanels = new ArrayList<IntentionUsagePanel>();
        this.myAfterUsagePanels = new ArrayList<IntentionUsagePanel>();
        this.myBeforePanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"border.title.before", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myAfterPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"border.title.after", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myPoweredByPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)CodeInsightBundle.message((String)"powered.by", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.myDescriptionBrowser.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                BrowserUtil.browse((URL)e.getURL());
            }
        });
    }

    private boolean readHTML(String text2) {
        try {
            this.myDescriptionBrowser.read(new StringReader(text2), null);
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private String toHTML(@NlsContexts.HintText String text2) {
        HintHint hintHint = new HintHint(this.myDescriptionBrowser, new Point(0, 0));
        hintHint.setFont(StartupUiUtil.getLabelFont());
        return HintUtil.prepareHintText(text2, hintHint);
    }

    public void reset(IntentionActionMetaData actionMetaData, String filter) {
        try {
            TextDescriptor url = actionMetaData.getDescription();
            String description = StringUtil.isEmpty((String)url.getText()) ? this.toHTML(CodeInsightBundle.message((String)"under.construction.string", (Object[])new Object[0])) : SearchUtil.markup(this.toHTML(url.getText()), filter);
            this.readHTML(description);
            this.setupPoweredByPanel(actionMetaData);
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeUsagePanels, actionMetaData.getExampleUsagesBefore());
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterUsagePanels, actionMetaData.getExampleUsagesAfter());
            SwingUtilities.invokeLater(() -> this.myPanel.revalidate());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void setupPoweredByPanel(IntentionActionMetaData actionMetaData) {
        boolean isCustomPlugin;
        PluginId pluginId = actionMetaData == null ? null : actionMetaData.getPluginId();
        this.myPoweredByPanel.removeAll();
        IdeaPluginDescriptorImpl pluginDescriptor = (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(pluginId);
        ApplicationInfoEx appInfo = ApplicationInfoEx.getInstanceEx();
        boolean bl = isCustomPlugin = pluginDescriptor != null && pluginDescriptor.isBundled() && !appInfo.isEssentialPlugin(pluginId);
        if (isCustomPlugin) {
            HyperlinkLabel label2 = new HyperlinkLabel(CodeInsightBundle.message((String)"powered.by.plugin", (Object[])new Object[]{pluginDescriptor.getName()}));
            label2.addHyperlinkListener(__ -> PluginManagerConfigurableProxy.showPluginConfigurable(null, ProjectManager.getInstance().getDefaultProject(), pluginDescriptor));
            this.myPoweredByPanel.add((Component)label2, "Center");
        }
        this.myPoweredByPanel.setVisible(isCustomPlugin);
    }

    public void reset(String intentionCategory) {
        try {
            this.readHTML(this.toHTML(CodeInsightBundle.message((String)"intention.settings.category.text", (Object[])new Object[]{intentionCategory})));
            this.setupPoweredByPanel(null);
            String pathForPackage = this.getClass().getPackage().getName().replace('.', '/');
            ResourceTextDescriptor beforeTemplate = new ResourceTextDescriptor(this.getClass().getClassLoader(), pathForPackage + "/before.java.template");
            IntentionDescriptionPanel.showUsages(this.myBeforePanel, this.myBeforeUsagePanels, new TextDescriptor[]{beforeTemplate});
            ResourceTextDescriptor afterTemplate = new ResourceTextDescriptor(this.getClass().getClassLoader(), pathForPackage + "/after.java.template");
            IntentionDescriptionPanel.showUsages(this.myAfterPanel, this.myAfterUsagePanels, new TextDescriptor[]{afterTemplate});
            SwingUtilities.invokeLater(() -> this.myPanel.revalidate());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void showUsages(JPanel panel2, List<IntentionUsagePanel> usagePanels, TextDescriptor @Nullable [] exampleUsages) throws IOException {
        boolean reuse;
        GridBagConstraints gb = null;
        boolean bl = reuse = exampleUsages != null && panel2.getComponents().length == exampleUsages.length;
        if (!reuse) {
            IntentionDescriptionPanel.disposeUsagePanels(usagePanels);
            panel2.setLayout(new GridBagLayout());
            panel2.removeAll();
            gb = new GridBagConstraints();
            gb.anchor = 18;
            gb.fill = 1;
            gb.gridheight = 0;
            gb.gridwidth = 1;
            gb.gridx = 0;
            gb.gridy = 0;
            gb.insets = new Insets(0, 0, 0, 0);
            gb.ipadx = 5;
            gb.ipady = 5;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
        }
        if (exampleUsages != null) {
            for (int i2 = 0; i2 < exampleUsages.length; ++i2) {
                IntentionUsagePanel usagePanel;
                TextDescriptor exampleUsage = exampleUsages[i2];
                String name = exampleUsage.getFileName();
                FileTypeManagerEx fileTypeManager = FileTypeManagerEx.getInstanceEx();
                String extension2 = fileTypeManager.getExtension(name);
                FileType fileType = fileTypeManager.getFileTypeByExtension(extension2);
                if (reuse) {
                    usagePanel = (IntentionUsagePanel)panel2.getComponent(i2);
                } else {
                    usagePanel = new IntentionUsagePanel();
                    usagePanels.add(usagePanel);
                }
                usagePanel.reset(exampleUsage.getText(), fileType);
                if (reuse) continue;
                panel2.add((Component)usagePanel, gb);
                ++gb.gridx;
            }
        }
        panel2.revalidate();
        panel2.repaint();
    }

    public JPanel getComponent() {
        return this.myPanel;
    }

    public void dispose() {
        IntentionDescriptionPanel.disposeUsagePanels(this.myBeforeUsagePanels);
        IntentionDescriptionPanel.disposeUsagePanels(this.myAfterUsagePanels);
    }

    private static void disposeUsagePanels(List<? extends IntentionUsagePanel> usagePanels) {
        for (IntentionUsagePanel intentionUsagePanel : usagePanels) {
            Disposer.dispose((Disposable)intentionUsagePanel);
        }
        usagePanels.clear();
    }

    public void init(int preferredWidth) {
        double height = (this.myDescriptionPanel.getSize().getHeight() + this.myBeforePanel.getSize().getHeight() + this.myAfterPanel.getSize().getHeight()) / 3.0;
        Dimension newd = new Dimension(preferredWidth, (int)height);
        this.myDescriptionPanel.setSize(newd);
        this.myDescriptionPanel.setPreferredSize(newd);
        this.myDescriptionPanel.setMaximumSize(newd);
        this.myDescriptionPanel.setMinimumSize(newd);
        this.myBeforePanel.setSize(newd);
        this.myBeforePanel.setPreferredSize(newd);
        this.myBeforePanel.setMaximumSize(newd);
        this.myBeforePanel.setMinimumSize(newd);
        this.myAfterPanel.setSize(newd);
        this.myAfterPanel.setPreferredSize(newd);
        this.myAfterPanel.setMaximumSize(newd);
        this.myAfterPanel.setMinimumSize(newd);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JEditorPane jEditorPane;
        JPanel jPanel5;
        JPanel jPanel6;
        this.myPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDescriptionPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.setAlignmentY(0.2f);
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndentWithoutInsets");
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDescriptionBrowser = jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jBScrollPane.setViewportView(jEditorPane);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myAfterPanel = jPanel4 = new JPanel();
        jPanel7.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBeforePanel = jPanel3 = new JPanel();
        jPanel7.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPoweredByPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel6.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

