/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InsetValueProvider;
import com.intellij.codeInsight.hints.presentation.PresentationUtilKt;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.openapi.editor.markup.TextAttributes;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J*\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00180\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006("}, d2={"Lcom/intellij/codeInsight/hints/presentation/DynamicInsetPresentation;", "Lcom/intellij/codeInsight/hints/presentation/StaticDelegatePresentation;", "presentation", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "valueProvider", "Lcom/intellij/codeInsight/hints/presentation/InsetValueProvider;", "(Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Lcom/intellij/codeInsight/hints/presentation/InsetValueProvider;)V", "down", "", "getDown", "()I", "height", "getHeight", "isPresentationUnderCursor", "", "left", "getLeft", "right", "getRight", "top", "getTop", "width", "getWidth", "handleMouse", "", "original", "Ljava/awt/Point;", "action", "Lkotlin/Function2;", "mouseClicked", "event", "Ljava/awt/event/MouseEvent;", "translated", "mouseExited", "mouseMoved", "paint", "g", "Ljava/awt/Graphics2D;", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.platform.lang.impl"})
public final class DynamicInsetPresentation
extends StaticDelegatePresentation {
    private boolean isPresentationUnderCursor;
    private final InsetValueProvider valueProvider;

    private final int getLeft() {
        return this.valueProvider.getLeft();
    }

    private final int getRight() {
        return this.valueProvider.getRight();
    }

    private final int getTop() {
        return this.valueProvider.getTop();
    }

    private final int getDown() {
        return this.valueProvider.getDown();
    }

    @Override
    public int getWidth() {
        return this.getPresentation().getWidth() + this.getLeft() + this.getRight();
    }

    @Override
    public int getHeight() {
        return this.getPresentation().getHeight() + this.getTop() + this.getDown();
    }

    @Override
    public void paint(@NotNull Graphics2D g, @NotNull TextAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        PresentationUtilKt.withTranslated(g, this.getLeft(), this.getTop(), (Function0<Unit>)((Function0)new Function0<Unit>(this, g, attributes){
            final /* synthetic */ DynamicInsetPresentation this$0;
            final /* synthetic */ Graphics2D $g;
            final /* synthetic */ TextAttributes $attributes;

            public final void invoke() {
                this.this$0.getPresentation().paint(this.$g, this.$attributes);
            }
            {
                this.this$0 = dynamicInsetPresentation;
                this.$g = graphics2D;
                this.$attributes = textAttributes;
                super(0);
            }
        }));
    }

    private final void handleMouse(Point original, Function2<? super InlayPresentation, ? super Point, Unit> action2) {
        boolean cursorIsOutOfBounds;
        int x = original.x;
        int y = original.y;
        boolean bl = cursorIsOutOfBounds = x < this.getLeft() || x >= this.getLeft() + this.getPresentation().getWidth() || y < this.getTop() || y >= this.getTop() + this.getPresentation().getHeight();
        if (cursorIsOutOfBounds) {
            if (this.isPresentationUnderCursor) {
                this.getPresentation().mouseExited();
                this.isPresentationUnderCursor = false;
            }
            return;
        }
        Point translated = PresentationUtilKt.translateNew(original, -this.getLeft(), -this.getTop());
        action2.invoke((Object)this.getPresentation(), (Object)translated);
    }

    @Override
    public void mouseClicked(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                presentation2.mouseClicked(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    @Override
    public void mouseMoved(@NotNull MouseEvent event, @NotNull Point translated) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        this.handleMouse(translated, (Function2<? super InlayPresentation, ? super Point, Unit>)((Function2)new Function2<InlayPresentation, Point, Unit>(event){
            final /* synthetic */ MouseEvent $event;

            public final void invoke(@NotNull InlayPresentation presentation2, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                presentation2.mouseMoved(this.$event, point);
            }
            {
                this.$event = mouseEvent;
                super(2);
            }
        }));
    }

    @Override
    public void mouseExited() {
        this.getPresentation().mouseExited();
        this.isPresentationUnderCursor = false;
    }

    public DynamicInsetPresentation(@NotNull InlayPresentation presentation2, @NotNull InsetValueProvider valueProvider) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)valueProvider, (String)"valueProvider");
        super(presentation2);
        this.valueProvider = valueProvider;
    }
}

