/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SelectionQuotingTypedHandler
extends TypedHandlerDelegate {
    private static final ExtensionPointName<UnquotingFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionUnquotingFilter");
    private static final ExtensionPointName<DequotingFilter> OLD_EP_NAME = ExtensionPointName.create((String)"com.intellij.selectionDequotingFilter");

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        char selectedChar;
        String selectedText;
        if (project == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(2);
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c) && (selectedText = selectionModel.getSelectedText()) != null && selectedText.length() == 1 && SelectionQuotingTypedHandler.isSimilarDelimiters(selectedChar = selectedText.charAt(0), c) && selectedChar != c && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor, selectedText, c) && SelectionQuotingTypedHandler.replaceQuotesBySelected(c, editor, file2, selectionModel, selectedChar)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                SelectionQuotingTypedHandler.$$$reportNull$$$0(3);
            }
            return result2;
        }
        if (CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && selectionModel.hasSelection() && SelectionQuotingTypedHandler.isDelimiter(c) && !StringUtil.isEmpty((String)(selectedText = selectionModel.getSelectedText()))) {
            int selectionStart = selectionModel.getSelectionStart();
            int selectionEnd = selectionModel.getSelectionEnd();
            if (selectedText.length() > 1) {
                char firstChar = selectedText.charAt(0);
                char lastChar = selectedText.charAt(selectedText.length() - 1);
                if (SelectionQuotingTypedHandler.isSimilarDelimiters(firstChar, c) && lastChar == SelectionQuotingTypedHandler.getMatchingDelimiter(firstChar) && (SelectionQuotingTypedHandler.isQuote(firstChar) || firstChar != c) && !SelectionQuotingTypedHandler.shouldSkipReplacementOfQuotesOrBraces(file2, editor, selectedText, c) && !SelectionQuotingTypedHandler.containsQuoteInside(selectedText, lastChar)) {
                    selectedText = selectedText.substring(1, selectedText.length() - 1);
                }
            }
            int caretOffset = selectionModel.getSelectionStart();
            char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
            String newText = c + selectedText + c2;
            boolean ltrSelection = selectionModel.getLeadSelectionOffset() != selectionModel.getSelectionEnd();
            boolean restoreStickySelection = editor instanceof EditorEx && ((EditorEx)editor).isStickySelection();
            selectionModel.removeSelection();
            editor.getDocument().replaceString(selectionStart, selectionEnd, (CharSequence)newText);
            int startOffset = caretOffset + 1;
            int endOffset = caretOffset + newText.length() - 1;
            int length = editor.getDocument().getTextLength();
            if (endOffset <= length) {
                if (restoreStickySelection) {
                    EditorEx editorEx = (EditorEx)editor;
                    CaretModel caretModel = editorEx.getCaretModel();
                    caretModel.moveToOffset(ltrSelection ? startOffset : endOffset);
                    editorEx.setStickySelection(true);
                    caretModel.moveToOffset(ltrSelection ? endOffset : startOffset);
                } else {
                    if (ltrSelection || editor instanceof EditorWindow) {
                        editor.getSelectionModel().setSelection(startOffset, endOffset);
                    } else {
                        editor.getSelectionModel().setSelection(endOffset, startOffset);
                    }
                    editor.getCaretModel().moveToOffset(ltrSelection ? endOffset : startOffset);
                }
                if (c == '{') {
                    int startOffsetToReformat = startOffset - 1;
                    int endOffsetToReformat = length > endOffset ? endOffset + 1 : endOffset;
                    CodeStyleManager.getInstance((Project)project).reformatText(file2, startOffsetToReformat, endOffsetToReformat);
                }
            }
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
            if (result3 == null) {
                SelectionQuotingTypedHandler.$$$reportNull$$$0(4);
            }
            return result3;
        }
        TypedHandlerDelegate.Result result4 = super.beforeSelectionRemoved(c, project, editor, file2);
        if (result4 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(5);
        }
        return result4;
    }

    private static boolean containsQuoteInside(String selectedText, char quote) {
        return selectedText.indexOf(quote, 1) != selectedText.length() - 1;
    }

    private static boolean replaceQuotesBySelected(char c, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull SelectionModel selectionModel, char selectedChar) {
        if (editor == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(7);
        }
        if (selectionModel == null) {
            SelectionQuotingTypedHandler.$$$reportNull$$$0(8);
        }
        int selectionStart = selectionModel.getSelectionStart();
        for (PsiElement element2 = file2.findElementAt(selectionStart); element2 != null; element2 = element2.getParent()) {
            TextRange textRange = element2.getTextRange();
            if (textRange != null && textRange.getLength() >= 2) {
                Document document;
                CharSequence charsSequence;
                int matchingCharOffset;
                boolean isAtStart;
                boolean bl = isAtStart = textRange.getStartOffset() == selectionStart;
                if ((isAtStart || textRange.getEndOffset() == selectionStart + 1 && SelectionQuotingTypedHandler.isQuote(c)) && (matchingCharOffset = isAtStart ? textRange.getEndOffset() - 1 : textRange.getStartOffset()) < (charsSequence = (document = editor.getDocument()).getCharsSequence()).length()) {
                    boolean otherQuoteMatchesSelected;
                    char matchingChar = charsSequence.charAt(matchingCharOffset);
                    boolean bl2 = isAtStart ? matchingChar == SelectionQuotingTypedHandler.getMatchingDelimiter(selectedChar) : (otherQuoteMatchesSelected = selectedChar == SelectionQuotingTypedHandler.getMatchingDelimiter(matchingChar));
                    if (otherQuoteMatchesSelected && !SelectionQuotingTypedHandler.containsQuoteInside(document.getText(textRange), charsSequence.charAt(textRange.getEndOffset() - 1))) {
                        SelectionQuotingTypedHandler.replaceChar(document, textRange.getStartOffset(), c);
                        char c2 = SelectionQuotingTypedHandler.getMatchingDelimiter(c);
                        SelectionQuotingTypedHandler.replaceChar(document, textRange.getEndOffset() - 1, c2);
                        editor.getCaretModel().moveToOffset(selectionModel.getSelectionEnd());
                        selectionModel.removeSelection();
                        return true;
                    }
                }
            }
            if (element2 instanceof PsiFile) break;
        }
        return false;
    }

    public static boolean shouldSkipReplacementOfQuotesOrBraces(PsiFile psiFile, Editor editor, String selectedText, char c) {
        return EP_NAME.getExtensionList().stream().anyMatch(filter -> filter.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c)) || OLD_EP_NAME.getExtensionList().stream().anyMatch(filter -> filter.skipReplacementQuotesOrBraces(psiFile, editor, selectedText, c));
    }

    private static char getMatchingDelimiter(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        if (c == '<') {
            return '>';
        }
        return c;
    }

    private static boolean isDelimiter(char c) {
        return SelectionQuotingTypedHandler.isBracket(c) || SelectionQuotingTypedHandler.isQuote(c);
    }

    private static boolean isBracket(char c) {
        return c == '(' || c == '{' || c == '[' || c == '<';
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'' || c == '`';
    }

    private static boolean isSimilarDelimiters(char c1, char c2) {
        return SelectionQuotingTypedHandler.isBracket(c1) && SelectionQuotingTypedHandler.isBracket(c2) || SelectionQuotingTypedHandler.isQuote(c1) && SelectionQuotingTypedHandler.isQuote(c2);
    }

    private static void replaceChar(Document document, int offset, char newChar) {
        document.replaceString(offset, offset + 1, (CharSequence)String.valueOf(newChar));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/SelectionQuotingTypedHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/SelectionQuotingTypedHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replaceQuotesBySelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public static abstract class DequotingFilter
    extends UnquotingFilter {
    }

    public static abstract class UnquotingFilter {
        public abstract boolean skipReplacementQuotesOrBraces(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull String var3, char var4);
    }
}

