/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.DocumentUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentCopyPastePreProcessor
implements CopyPastePreProcessor {
    @Override
    @Nullable
    public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
        return null;
    }

    @Override
    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file2, Editor editor, String text2, RawText rawText) {
        Language language = file2.getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (commenter == null) {
            String string = text2;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        String lineCommentPrefix = commenter.getLineCommentPrefix();
        if (lineCommentPrefix == null) {
            String string = text2;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        Document document = editor.getDocument();
        int offset = editor.getSelectionModel().getSelectionStart();
        if (DocumentUtil.isAtLineEnd(offset, editor.getDocument()) && text2.startsWith("\n")) {
            String string = text2;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(2);
            }
            return string;
        }
        int lineStartOffset = DocumentUtil.getLineStartOffset(offset, document);
        CharSequence chars = document.getImmutableCharSequence();
        int firstNonWsLineOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)lineStartOffset, (String)" \t");
        if (offset < firstNonWsLineOffset + lineCommentPrefix.length() || !CharArrayUtil.regionMatches((CharSequence)chars, (int)firstNonWsLineOffset, (CharSequence)lineCommentPrefix)) {
            String string = text2;
            if (string == null) {
                LineCommentCopyPastePreProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((PsiFile)file2);
        String lineStartReplacement = "\n" + chars.subSequence(lineStartOffset, firstNonWsLineOffset + lineCommentPrefix.length()) + (codeStyleSettings.getCommonSettings((Language)language).LINE_COMMENT_ADD_SPACE ? " " : "");
        String string = StringUtil.trimTrailing((String)text2, (char)'\n').replace("\n", lineStartReplacement);
        if (string == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(5);
        }
        if (project == null) {
            LineCommentCopyPastePreProcessor.$$$reportNull$$$0(6);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/LineCommentCopyPastePreProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

