/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.codeInsight.editorActions.QuoteHandler;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackspaceHandler
extends EditorWriteActionHandler.ForEachCaret {
    private static final Logger LOGGER = Logger.getInstance(BackspaceHandler.class);
    protected final EditorActionHandler myOriginalHandler;

    public BackspaceHandler(EditorActionHandler originalHandler) {
        this.myOriginalHandler = originalHandler;
    }

    public void executeWriteAction(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            BackspaceHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            BackspaceHandler.$$$reportNull$$$0(1);
        }
        if (!this.handleBackspace(editor, caret, dataContext, false)) {
            this.myOriginalHandler.execute(editor, caret, dataContext);
        }
    }

    protected boolean handleBackspace(Editor editor, Caret caret, DataContext dataContext, boolean toWordStart) {
        HighlighterIterator iterator2;
        int injectedOffset;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file2 == null) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = DocumentUtil.getPreviousCodePointOffset(editor.getDocument(), editor.getCaretModel().getOffset());
        if (offset < 0) {
            return false;
        }
        CharSequence chars = editor.getDocument().getCharsSequence();
        int c = Character.codePointAt(chars, offset);
        Editor injectedEditor = TypedHandler.injectedEditorIfCharTypedIsSignificant(c, editor, file2);
        Editor originalEditor = editor;
        if (injectedEditor != editor && BackspaceHandler.isOffsetInsideInjected(injectedEditor, injectedOffset = injectedEditor.getCaretModel().getOffset())) {
            file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(injectedEditor.getDocument());
            editor = injectedEditor;
            offset = DocumentUtil.getPreviousCodePointOffset(injectedEditor.getDocument(), injectedOffset);
        }
        List delegates = BackspaceHandlerDelegate.EP_NAME.getExtensionList();
        if (!toWordStart && Character.isBmpCodePoint(c)) {
            for (BackspaceHandlerDelegate delegate2 : delegates) {
                delegate2.beforeCharDeleted((char)c, file2, editor);
            }
        }
        FileType fileType = file2.getFileType();
        QuoteHandler quoteHandler = TypedHandler.getQuoteHandler(file2, editor);
        HighlighterIterator hiterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        boolean wasClosingQuote = quoteHandler != null && quoteHandler.isClosingQuote(hiterator, offset);
        this.myOriginalHandler.execute(originalEditor, caret, dataContext);
        if (!toWordStart && Character.isBmpCodePoint(c)) {
            for (BackspaceHandlerDelegate delegate3 : delegates) {
                if (!delegate3.charDeleted((char)c, file2, editor)) continue;
                return true;
            }
        }
        if (offset >= editor.getDocument().getTextLength()) {
            return true;
        }
        chars = editor.getDocument().getCharsSequence();
        if ((c == 40 || c == 91 || c == 123) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            boolean matched;
            char c1 = chars.charAt(offset);
            if (c1 != BackspaceHandler.getRightChar((char)c)) {
                return true;
            }
            iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, iterator2);
            if (!braceMatcher.isLBraceToken(iterator2, chars, fileType) && !braceMatcher.isRBraceToken(iterator2, chars, fileType)) {
                return true;
            }
            int rparenOffset = BraceMatchingUtil.findRightmostRParen(iterator2, iterator2.getTokenType(), chars, fileType);
            if (rparenOffset >= 0 && (matched = BraceMatchingUtil.matchBrace(chars, fileType, iterator2 = ((EditorEx)editor).getHighlighter().createIterator(rparenOffset), false, true))) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        } else if ((c == 34 || c == 39 || c == 96) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_QUOTE) {
            char c1 = chars.charAt(offset);
            if (c1 != c) {
                return true;
            }
            if (wasClosingQuote) {
                return true;
            }
            iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
            if (quoteHandler == null || !quoteHandler.isOpeningQuote(iterator2, offset)) {
                return true;
            }
            editor.getDocument().deleteString(offset, offset + 1);
        }
        return true;
    }

    public static char getRightChar(char c) {
        if (c == '(') {
            return ')';
        }
        if (c == '[') {
            return ']';
        }
        if (c == '{') {
            return '}';
        }
        assert (false);
        return c;
    }

    private static boolean isOffsetInsideInjected(Editor injectedEditor, int injectedOffset) {
        TextRange rangeToEdit;
        if (injectedOffset == 0 || injectedOffset >= injectedEditor.getDocument().getTextLength()) {
            return false;
        }
        PsiFile injectedFile = ((EditorWindow)injectedEditor).getInjectedFile();
        InjectedLanguageManager ilm = InjectedLanguageManager.getInstance((Project)injectedFile.getProject());
        List editables = ilm.intersectWithAllEditableFragments(injectedFile, rangeToEdit = new TextRange(injectedOffset - 1, injectedOffset + 1));
        return editables.size() == 1 && ((TextRange)editables.get(0)).equals((Object)rangeToEdit);
    }

    @NotNull
    static Language getLanguageAtCursorPosition(PsiFile file2, Editor editor) {
        Language language;
        PsiElement element2 = file2.findElementAt(editor.getCaretModel().getOffset());
        Language language2 = language = element2 != null ? PsiUtilCore.findLanguageFromElement((PsiElement)element2) : Language.ANY;
        if (language != Language.ANY) {
            Language language3 = language;
            if (language3 == null) {
                BackspaceHandler.$$$reportNull$$$0(2);
            }
            return language3;
        }
        Language language4 = file2.getLanguage();
        if (language4 == null) {
            BackspaceHandler.$$$reportNull$$$0(3);
        }
        return language4;
    }

    @Nullable
    public static LogicalPosition getBackspaceUnindentPosition(PsiFile file2, Editor editor) {
        Language language;
        if (editor.getSelectionModel().hasSelection()) {
            return null;
        }
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        if (caretPos.column == 0) {
            return null;
        }
        if (!BackspaceHandler.isWhitespaceBeforeCaret(editor)) {
            return null;
        }
        CommonCodeStyleSettings.IndentOptions fileIndentOptions = CodeStyle.getIndentOptions((PsiFile)file2);
        int indent = fileIndentOptions.INDENT_SIZE;
        if (!fileIndentOptions.isOverrideLanguageOptions() && (language = BackspaceHandler.getLanguageAtCursorPosition(file2, editor)) != file2.getLanguage()) {
            indent = CodeStyle.getSettings((PsiFile)file2).getLanguageIndentOptions((Language)language).INDENT_SIZE;
        }
        int column = indent > 0 ? (caretPos.column - 1) / indent * indent : 0;
        return new LogicalPosition(caretPos.line, column);
    }

    public static void deleteToTargetPosition(@NotNull Editor editor, @NotNull LogicalPosition pos) {
        if (editor == null) {
            BackspaceHandler.$$$reportNull$$$0(4);
        }
        if (pos == null) {
            BackspaceHandler.$$$reportNull$$$0(5);
        }
        LogicalPosition logicalPosition = editor.getCaretModel().getLogicalPosition();
        if (logicalPosition.line != pos.line) {
            LOGGER.error("Unexpected caret position: " + logicalPosition + ", target indent position: " + pos);
            return;
        }
        if (pos.column < logicalPosition.column) {
            int targetOffset = editor.logicalPositionToOffset(pos);
            int offset = editor.getCaretModel().getOffset();
            editor.getCaretModel().getCurrentCaret().setSelection(targetOffset, offset, false);
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            editor.getCaretModel().moveToLogicalPosition(pos);
        } else if (pos.column > logicalPosition.column) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeatSymbol((char)' ', (int)(pos.column - logicalPosition.column)));
        }
    }

    public static boolean isWhitespaceBeforeCaret(Editor editor) {
        LogicalPosition caretPos = editor.getCaretModel().getLogicalPosition();
        CharSequence charSeq = editor.getDocument().getCharsSequence();
        for (int pos = 0; pos < caretPos.column; ++pos) {
            char c;
            LogicalPosition checkPos = new LogicalPosition(caretPos.line, pos);
            int offset = editor.logicalPositionToOffset(checkPos);
            if (offset >= charSeq.length() || (c = charSeq.charAt(offset)) == '\t' || c == ' ' || c == '\n') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/BackspaceHandler";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/BackspaceHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageAtCursorPosition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeWriteAction";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteToTargetPosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

