/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocFontSizePopup;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItemUpdater;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.codeInsight.documentation.render.DocRenderMouseEventBridge;
import com.intellij.codeInsight.documentation.render.DocRenderPassFactory;
import com.intellij.codeInsight.documentation.render.DocRenderSelectionManager;
import com.intellij.codeInsight.documentation.render.DocRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorInlayFoldingMapper;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DocRenderItem {
    private static final Key<DocRenderItem> OUR_ITEM = Key.create((String)"doc.render.item");
    private static final Key<Collection<DocRenderItem>> OUR_ITEMS = Key.create((String)"doc.render.items");
    private static final Key<Disposable> LISTENERS_DISPOSABLE = Key.create((String)"doc.render.listeners.disposable");
    private static final int INLAY_BATCH_MODE_THRESHOLD = 100;
    final Editor editor;
    final RangeHighlighter highlighter;
    @Nls
    String textToRender;
    private FoldRegion foldRegion;
    Inlay<DocRenderer> inlay;

    static boolean isValidRange(@NotNull Document document, @NotNull TextRange range2) {
        if (document == null) {
            DocRenderItem.$$$reportNull$$$0(0);
        }
        if (range2 == null) {
            DocRenderItem.$$$reportNull$$$0(1);
        }
        CharSequence text2 = document.getImmutableCharSequence();
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        return endLine < document.getLineCount() - 1 && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)text2.subSequence(document.getLineStartOffset(startLine), startOffset)) && CharArrayUtil.containsOnlyWhiteSpaces((CharSequence)text2.subSequence(endOffset, document.getLineEndOffset(endLine)));
    }

    static void setItemsToEditor(@NotNull Editor editor, @NotNull DocRenderPassFactory.Items itemsToSet, boolean collapseNewItems) {
        ArrayList items;
        ArrayList existing;
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(2);
        }
        if (itemsToSet == null) {
            DocRenderItem.$$$reportNull$$$0(3);
        }
        if ((existing = (ArrayList)editor.getUserData(OUR_ITEMS)) == null) {
            if (itemsToSet.isEmpty()) {
                return;
            }
            items = new ArrayList();
            editor.putUserData(OUR_ITEMS, items);
        } else {
            items = existing;
        }
        DocRenderItem.keepScrollingPositionWhile(editor, () -> {
            ArrayList<Runnable> inlayTasks = new ArrayList<Runnable>();
            ArrayList<Runnable> foldingTasks = new ArrayList<Runnable>();
            ArrayList<DocRenderItem> itemsToUpdateInlays = new ArrayList<DocRenderItem>();
            ArrayList<String> itemsToUpdateText = new ArrayList<String>();
            boolean updated = false;
            Iterator it = items.iterator();
            while (it.hasNext()) {
                DocRenderPassFactory.Item matchingNewItem;
                DocRenderItem existingItem = (DocRenderItem)it.next();
                DocRenderPassFactory.Item item = matchingNewItem = existingItem.isValid() ? itemsToSet.removeItem((Segment)existingItem.highlighter) : null;
                if (matchingNewItem == null) {
                    updated |= existingItem.remove(inlayTasks, foldingTasks);
                    it.remove();
                    continue;
                }
                if (matchingNewItem.textToRender != null && !matchingNewItem.textToRender.equals(existingItem.textToRender)) {
                    itemsToUpdateInlays.add(existingItem);
                    itemsToUpdateText.add(matchingNewItem.textToRender);
                    continue;
                }
                existingItem.updateIcon();
            }
            ArrayList<DocRenderItem> newRenderItems = new ArrayList<DocRenderItem>();
            for (DocRenderPassFactory.Item item : itemsToSet) {
                DocRenderItem newItem = new DocRenderItem(editor, item.textRange, collapseNewItems ? null : item.textToRender);
                newRenderItems.add(newItem);
                if (!collapseNewItems) continue;
                updated |= newItem.toggle(inlayTasks, foldingTasks);
                itemsToUpdateInlays.add(newItem);
                itemsToUpdateText.add(item.textToRender);
            }
            editor.getInlayModel().execute(inlayTasks.size() > 100, () -> inlayTasks.forEach(Runnable::run));
            editor.getFoldingModel().runBatchFoldingOperation(() -> foldingTasks.forEach(Runnable::run), true, false);
            newRenderItems.forEach(DocRenderItem::cleanup);
            for (int i2 = 0; i2 < itemsToUpdateInlays.size(); ++i2) {
                ((DocRenderItem)itemsToUpdateInlays.get((int)i2)).textToRender = (String)itemsToUpdateText.get(i2);
            }
            DocRenderItem.updateInlays(itemsToUpdateInlays, true);
            items.addAll(newRenderItems);
            return updated;
        });
        DocRenderItem.setupListeners(editor, items.isEmpty());
    }

    private static void setupListeners(final @NotNull Editor editor, boolean disable) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(4);
        }
        if (disable) {
            Disposable listenersDisposable = (Disposable)editor.getUserData(LISTENERS_DISPOSABLE);
            if (listenersDisposable != null) {
                Disposer.dispose((Disposable)listenersDisposable);
                editor.putUserData(LISTENERS_DISPOSABLE, null);
            }
        } else if (editor.getUserData(LISTENERS_DISPOSABLE) == null) {
            MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
            connection.setDefaultHandler(() -> DocRenderItem.updateInlays(editor, true));
            connection.subscribe(EditorColorsManager.TOPIC);
            connection.subscribe(LafManagerListener.TOPIC);
            EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

                public void editorReleased(@NotNull EditorFactoryEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getEditor() == editor) {
                        DocRenderItem.setItemsToEditor(editor, new DocRenderPassFactory.Items(), false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/documentation/render/DocRenderItem$1", "editorReleased"));
                }
            }, (Disposable)connection);
            editor.getCaretModel().addCaretListener((CaretListener)new MyCaretListener(), (Disposable)connection);
            DocRenderSelectionManager selectionManager = new DocRenderSelectionManager(editor);
            Disposer.register((Disposable)connection, (Disposable)selectionManager);
            DocRenderMouseEventBridge mouseEventBridge = new DocRenderMouseEventBridge(selectionManager);
            editor.addEditorMouseListener((EditorMouseListener)mouseEventBridge, (Disposable)connection);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)mouseEventBridge, (Disposable)connection);
            IconVisibilityController iconVisibilityController = new IconVisibilityController();
            editor.addEditorMouseListener((EditorMouseListener)iconVisibilityController, (Disposable)connection);
            editor.addEditorMouseMotionListener((EditorMouseMotionListener)iconVisibilityController, (Disposable)connection);
            editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)iconVisibilityController, (Disposable)connection);
            Disposer.register((Disposable)connection, (Disposable)iconVisibilityController);
            editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)new MyVisibleAreaListener(editor), (Disposable)connection);
            editor.getInlayModel().addListener((InlayModel.Listener)new MyInlayListener(), (Disposable)connection);
            Disposer.register((Disposable)connection, () -> DocRenderer.clearCachedLoadingPane(editor));
            editor.putUserData(LISTENERS_DISPOSABLE, (Object)connection);
        }
    }

    private static void keepScrollingPositionWhile(@NotNull Editor editor, @NotNull BooleanSupplier task2) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(5);
        }
        if (task2 == null) {
            DocRenderItem.$$$reportNull$$$0(6);
        }
        EditorScrollingPositionKeeper keeper = new EditorScrollingPositionKeeper(editor);
        keeper.savePosition();
        if (task2.getAsBoolean()) {
            keeper.restorePosition(false);
        }
    }

    @Nullable
    public static DocRenderItem getItemAroundOffset(@NotNull Editor editor, int offset) {
        Collection items;
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(7);
        }
        if ((items = (Collection)editor.getUserData(OUR_ITEMS)) == null || items.isEmpty()) {
            return null;
        }
        Document document = editor.getDocument();
        if (offset < 0 || offset > document.getTextLength()) {
            return null;
        }
        int line = document.getLineNumber(offset);
        DocRenderItem itemOnAdjacentLine = items.stream().filter(i2 -> {
            if (!i2.isValid()) {
                return false;
            }
            int startLine = document.getLineNumber(i2.highlighter.getStartOffset());
            int endLine = document.getLineNumber(i2.highlighter.getEndOffset());
            return line >= startLine - 1 && line <= endLine + 1;
        }).min(Comparator.comparingInt(i2 -> i2.highlighter.getStartOffset())).orElse(null);
        if (itemOnAdjacentLine != null) {
            return itemOnAdjacentLine;
        }
        Project project = editor.getProject();
        if (project == null) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        DocRenderItem foundItem = null;
        int foundStartOffset = 0;
        for (DocRenderItem item : items) {
            TextRange ownerTextRange;
            PsiElement owner;
            PsiDocCommentBase comment;
            if (!item.isValid() || (comment = item.getComment()) == null || (owner = comment.getOwner()) == null || (ownerTextRange = owner.getTextRange()) == null || !ownerTextRange.containsOffset(offset)) continue;
            int startOffset = ownerTextRange.getStartOffset();
            if (foundItem != null && foundStartOffset >= startOffset) continue;
            foundItem = item;
            foundStartOffset = startOffset;
        }
        return foundItem;
    }

    static void resetToDefaultState(@NotNull Editor editor) {
        Collection items;
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(8);
        }
        if ((items = (Collection)editor.getUserData(OUR_ITEMS)) == null) {
            return;
        }
        boolean editorSetting = DocRenderManager.isDocRenderingEnabled(editor);
        DocRenderItem.keepScrollingPositionWhile(editor, () -> {
            ArrayList<Runnable> inlayTasks = new ArrayList<Runnable>();
            ArrayList<Runnable> foldingTasks = new ArrayList<Runnable>();
            boolean updated = false;
            for (DocRenderItem item : items) {
                if (!item.isValid() || item.inlay == null != editorSetting) continue;
                updated |= item.toggle(inlayTasks, foldingTasks);
            }
            editor.getInlayModel().execute(inlayTasks.size() > 100, () -> inlayTasks.forEach(Runnable::run));
            editor.getFoldingModel().runBatchFoldingOperation(() -> foldingTasks.forEach(Runnable::run), true, false);
            items.forEach(DocRenderItem::cleanup);
            return updated;
        });
    }

    public static EditorCustomElementRenderer createDemoRenderer(@NotNull Editor editor) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(9);
        }
        DocRenderItem item = new DocRenderItem(editor, new TextRange(0, 0), CodeInsightBundle.message((String)"documentation.rendered.documentation.with.href.link", (Object[])new Object[0]));
        return new DocRenderer(item);
    }

    private DocRenderItem(@NotNull Editor editor, @NotNull TextRange textRange, @Nullable @Nls String textToRender) {
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(10);
        }
        if (textRange == null) {
            DocRenderItem.$$$reportNull$$$0(11);
        }
        this.editor = editor;
        this.textToRender = textToRender;
        this.highlighter = editor.getMarkupModel().addRangeHighlighter(null, textRange.getStartOffset(), textRange.getEndOffset(), 0, HighlighterTargetArea.EXACT_RANGE);
        this.updateIcon();
    }

    private boolean isValid() {
        return this.highlighter.isValid() && this.highlighter.getStartOffset() < this.highlighter.getEndOffset() && new RelevantOffsets(this.highlighter).match(this.foldRegion, this.inlay);
    }

    private void cleanup() {
        if (this.foldRegion == null && this.inlay != null && this.inlay.isValid()) {
            Disposer.dispose(this.inlay);
            this.inlay = null;
        }
    }

    private boolean remove(@NotNull Collection<Runnable> inlayTasks, @NotNull Collection<Runnable> foldingTasks) {
        if (inlayTasks == null) {
            DocRenderItem.$$$reportNull$$$0(12);
        }
        if (foldingTasks == null) {
            DocRenderItem.$$$reportNull$$$0(13);
        }
        boolean updated = false;
        this.highlighter.dispose();
        if (this.foldRegion != null && this.foldRegion.isValid()) {
            foldingTasks.add(() -> this.foldRegion.getEditor().getFoldingModel().removeFoldRegion(this.foldRegion));
            updated = true;
        }
        if (this.inlay != null && this.inlay.isValid()) {
            inlayTasks.add(() -> Disposer.dispose(this.inlay));
            updated = true;
        }
        return updated;
    }

    void toggle() {
        this.toggle(null, null);
    }

    boolean toggle(@Nullable Collection<Runnable> inlayTasks, @Nullable Collection<Runnable> foldingTasks) {
        assert (inlayTasks == null == (foldingTasks == null));
        if (!(this.editor instanceof EditorEx)) {
            return false;
        }
        FoldingModelEx foldingModel = ((EditorEx)this.editor).getFoldingModel();
        if (this.foldRegion == null) {
            if (this.textToRender == null && foldingTasks == null) {
                this.generateHtmlInBackgroundAndToggle();
                return false;
            }
            RelevantOffsets offsets2 = new RelevantOffsets(this.highlighter);
            Runnable inlayTask = () -> {
                this.inlay = this.editor.getInlayModel().addBlockElement(offsets2.inlayOffset, false, true, -100, (EditorCustomElementRenderer)new DocRenderer(this));
            };
            Runnable foldingTask = () -> {
                this.foldRegion = foldingModel.createFoldRegion(offsets2.foldStartOffset, offsets2.foldEndOffset, "", null, true);
                if (this.foldRegion != null) {
                    this.foldRegion.putUserData(OUR_ITEM, (Object)this);
                }
            };
            if (inlayTasks == null || this.textToRender != null) {
                inlayTask.run();
            } else {
                inlayTasks.add(inlayTask);
            }
            if (foldingTasks == null) {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
                this.cleanup();
            } else {
                foldingTasks.add(foldingTask);
            }
        } else {
            Runnable inlayTask = () -> {
                Disposer.dispose(this.inlay);
                this.inlay = null;
            };
            Runnable foldingTask = () -> {
                int startOffset = this.foldRegion.getStartOffset();
                int endOffset = this.foldRegion.getEndOffset();
                foldingModel.removeFoldRegion(this.foldRegion);
                for (FoldRegion region : foldingModel.getRegionsOverlappingWith(startOffset, endOffset)) {
                    if (region.getStartOffset() < startOffset || region.getEndOffset() > endOffset) continue;
                    region.setExpanded(true);
                }
                this.foldRegion = null;
            };
            if (foldingTasks == null) {
                foldingModel.runBatchFoldingOperation(foldingTask, true, false);
            } else {
                foldingTasks.add(foldingTask);
            }
            if (inlayTasks == null) {
                inlayTask.run();
            } else {
                inlayTasks.add(inlayTask);
            }
            if (!DocRenderManager.isDocRenderingEnabled(this.editor)) {
                this.textToRender = null;
            }
        }
        return true;
    }

    private void generateHtmlInBackgroundAndToggle() {
        ReadAction.nonBlocking(() -> DocRenderPassFactory.calcText(this.getComment())).withDocumentsCommitted(Objects.requireNonNull(this.editor.getProject())).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.any(), html -> {
            this.textToRender = html;
            this.toggle();
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    PsiDocCommentBase getComment() {
        PsiDocumentManager psiDocumentManager;
        PsiFile file2;
        if (this.highlighter.isValid() && (file2 = (psiDocumentManager = PsiDocumentManager.getInstance((Project)Objects.requireNonNull(this.editor.getProject()))).getPsiFile(this.editor.getDocument())) != null) {
            return DocumentationManager.getProviderFromElement((PsiElement)file2).findDocComment(file2, TextRange.create((Segment)this.highlighter));
        }
        return null;
    }

    private static void updateInlays(@NotNull Collection<DocRenderItem> items, boolean recreateContent) {
        if (items == null) {
            DocRenderItem.$$$reportNull$$$0(14);
        }
        DocRenderItemUpdater.getInstance().updateInlays(ContainerUtil.mapNotNull(items, i2 -> i2.inlay), recreateContent);
    }

    private static void updateInlays(@NotNull Editor editor, boolean recreateContent) {
        Collection items;
        if (editor == null) {
            DocRenderItem.$$$reportNull$$$0(15);
        }
        if (recreateContent) {
            DocRenderer.clearCachedLoadingPane(editor);
        }
        if ((items = (Collection)editor.getUserData(OUR_ITEMS)) != null) {
            DocRenderItem.updateInlays(items, recreateContent);
        }
    }

    private void updateIcon() {
        boolean iconExists;
        boolean iconEnabled = DocRenderDummyLineMarkerProvider.isGutterIconEnabled();
        boolean bl = iconExists = this.highlighter.getGutterIconRenderer() != null;
        if (iconEnabled != iconExists) {
            if (iconEnabled) {
                this.highlighter.setGutterIconRenderer((GutterIconRenderer)new MyGutterIconRenderer(AllIcons.Gutter.JavadocRead, false));
            } else {
                this.highlighter.setGutterIconRenderer(null);
            }
            if (this.inlay != null) {
                ((DocRenderer)this.inlay.getRenderer()).update(false, false);
            }
        }
    }

    AnAction createToggleAction() {
        return new ToggleRenderingAction(this);
    }

    private void setIconVisible(boolean visible) {
        MyGutterIconRenderer inlayIconRenderer;
        MyGutterIconRenderer iconRenderer = (MyGutterIconRenderer)this.highlighter.getGutterIconRenderer();
        if (iconRenderer != null) {
            iconRenderer.setIconVisible(visible);
            int y = this.editor.visualLineToY(((EditorImpl)this.editor).offsetToVisualLine(this.highlighter.getStartOffset()));
            this.repaintGutter(y);
        }
        if (this.inlay != null && (inlayIconRenderer = (MyGutterIconRenderer)this.inlay.getGutterIconRenderer()) != null) {
            inlayIconRenderer.setIconVisible(visible);
            Rectangle bounds2 = this.inlay.getBounds();
            if (bounds2 != null) {
                this.repaintGutter(bounds2.y);
            }
        }
    }

    private void repaintGutter(int startY) {
        JComponent gutter = (JComponent)this.editor.getGutter();
        gutter.repaint(0, startY, gutter.getWidth(), startY + this.editor.getLineHeight());
    }

    @Nullable
    public String getTextToRender() {
        return this.textToRender;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemsToSet";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlayTasks";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingTasks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidRange";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setItemsToEditor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setupListeners";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "keepScrollingPositionWhile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemAroundOffset";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "resetToDefaultState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createDemoRenderer";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "updateInlays";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class InlayFoldingMapper
    implements EditorInlayFoldingMapper {
        private InlayFoldingMapper() {
        }

        @Override
        @Nullable
        public FoldRegion getAssociatedFoldRegion(@NotNull Inlay<?> inlay) {
            EditorCustomElementRenderer renderer;
            if (inlay == null) {
                InlayFoldingMapper.$$$reportNull$$$0(0);
            }
            return (renderer = inlay.getRenderer()) instanceof DocRenderer ? ((DocRenderer)renderer).myItem.foldRegion : null;
        }

        @Override
        @Nullable
        public Inlay<?> getAssociatedInlay(@NotNull FoldRegion foldRegion) {
            DocRenderItem item;
            if (foldRegion == null) {
                InlayFoldingMapper.$$$reportNull$$$0(1);
            }
            return (item = (DocRenderItem)foldRegion.getUserData(OUR_ITEM)) == null ? null : item.inlay;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "foldRegion";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$InlayFoldingMapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAssociatedFoldRegion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getAssociatedInlay";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IconVisibilityController
    implements EditorMouseListener,
    EditorMouseMotionListener,
    VisibleAreaListener,
    Disposable {
        private DocRenderItem myCurrentItem;
        private Editor myQueuedEditor;

        private IconVisibilityController() {
        }

        public void mouseMoved(@NotNull EditorMouseEvent e) {
            if (e == null) {
                IconVisibilityController.$$$reportNull$$$0(0);
            }
            this.doUpdate(e.getEditor(), e);
        }

        public void mouseExited(@NotNull EditorMouseEvent e) {
            if (e == null) {
                IconVisibilityController.$$$reportNull$$$0(1);
            }
            this.doUpdate(e.getEditor(), e);
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            Editor editor;
            if (e == null) {
                IconVisibilityController.$$$reportNull$$$0(2);
            }
            if (((EditorImpl)(editor = e.getEditor())).isCursorHidden()) {
                return;
            }
            if (this.myQueuedEditor == null) {
                this.myQueuedEditor = editor;
                SwingUtilities.invokeLater(() -> {
                    if (this.myQueuedEditor != null && !this.myQueuedEditor.isDisposed()) {
                        this.doUpdate(this.myQueuedEditor, null);
                    }
                    this.myQueuedEditor = null;
                });
            }
        }

        private void doUpdate(@NotNull Editor editor, @Nullable EditorMouseEvent event) {
            DocRenderItem item;
            if (editor == null) {
                IconVisibilityController.$$$reportNull$$$0(3);
            }
            int y = 0;
            int offset = -1;
            if (event == null) {
                PointerInfo info = MouseInfo.getPointerInfo();
                if (info != null) {
                    Point screenPoint = info.getLocation();
                    JComponent component2 = editor.getComponent();
                    Point componentPoint = new Point(screenPoint);
                    SwingUtilities.convertPointFromScreen(componentPoint, component2);
                    if (new Rectangle(component2.getSize()).contains(componentPoint)) {
                        Point editorPoint = new Point(screenPoint);
                        SwingUtilities.convertPointFromScreen(editorPoint, editor.getContentComponent());
                        y = editorPoint.y;
                        offset = editor.visualPositionToOffset(new VisualPosition(editor.yToVisualLine(y), 0));
                    }
                }
            } else {
                y = event.getMouseEvent().getY();
                offset = event.getOffset();
            }
            DocRenderItem docRenderItem = item = offset < 0 ? null : IconVisibilityController.findItem(editor, y, offset);
            if (item != this.myCurrentItem) {
                if (this.myCurrentItem != null) {
                    this.myCurrentItem.setIconVisible(false);
                }
                this.myCurrentItem = item;
                if (this.myCurrentItem != null) {
                    this.myCurrentItem.setIconVisible(true);
                }
            }
        }

        private static DocRenderItem findItem(Editor editor, int y, int neighborOffset) {
            Document document = editor.getDocument();
            int lineNumber = document.getLineNumber(neighborOffset);
            int searchStartOffset = document.getLineStartOffset(Math.max(0, lineNumber - 1));
            int searchEndOffset = document.getLineEndOffset(lineNumber);
            Collection items = (Collection)editor.getUserData(OUR_ITEMS);
            assert (items != null);
            for (DocRenderItem item : items) {
                RangeHighlighter highlighter = item.highlighter;
                if (!highlighter.isValid() || highlighter.getStartOffset() > searchEndOffset || highlighter.getEndOffset() < searchStartOffset) continue;
                int itemStartY = 0;
                int itemEndY = 0;
                if (item.inlay == null) {
                    itemStartY = editor.visualLineToY(((EditorImpl)editor).offsetToVisualLine(highlighter.getStartOffset()));
                    itemEndY = editor.visualLineToY(((EditorImpl)editor).offsetToVisualLine(highlighter.getEndOffset())) + editor.getLineHeight();
                } else {
                    Rectangle bounds2 = item.inlay.getBounds();
                    if (bounds2 != null) {
                        itemStartY = bounds2.y;
                        itemEndY = bounds2.y + bounds2.height;
                    }
                }
                if (y < itemStartY || y >= itemEndY) break;
                return item;
            }
            return null;
        }

        public void dispose() {
            this.myCurrentItem = null;
            this.myQueuedEditor = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$IconVisibilityController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ChangeFontSize
    extends DumbAwareAction {
        ChangeFontSize() {
            super(CodeInsightBundle.messagePointer((String)"javadoc.adjust.font.size", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                ChangeFontSize.$$$reportNull$$$0(0);
            }
            if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                DocFontSizePopup.show(() -> DocRenderItem.updateInlays(editor, true), editor.getContentComponent());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderItem$ChangeFontSize", "actionPerformed"));
        }
    }

    private static final class ToggleRenderingAction
    extends DumbAwareAction {
        private final DocRenderItem item;

        private ToggleRenderingAction(DocRenderItem item) {
            this.copyFrom(ActionManager.getInstance().getAction("ToggleRenderedDocPresentation"));
            this.item = item;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleRenderingAction.$$$reportNull$$$0(0);
            }
            if (this.item.isValid()) {
                this.item.toggle();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/documentation/render/DocRenderItem$ToggleRenderingAction", "actionPerformed"));
        }
    }

    class MyGutterIconRenderer
    extends GutterIconRenderer
    implements DumbAware {
        private final LayeredIcon icon;

        MyGutterIconRenderer(Icon icon2, boolean iconVisible) {
            this.icon = new LayeredIcon(icon2);
            this.setIconVisible(iconVisible);
        }

        boolean isIconVisible() {
            return this.icon.isLayerEnabled(0);
        }

        void setIconVisible(boolean visible) {
            this.icon.setLayerEnabled(0, visible);
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof MyGutterIconRenderer;
        }

        public int hashCode() {
            return 0;
        }

        @NotNull
        public Icon getIcon() {
            LayeredIcon layeredIcon = this.icon;
            if (layeredIcon == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(0);
            }
            return layeredIcon;
        }

        @NotNull
        public String getAccessibleName() {
            String string = CodeInsightBundle.message((String)"doc.render.icon.accessible.name", (Object[])new Object[0]);
            if (string == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            GutterIconRenderer.Alignment alignment = GutterIconRenderer.Alignment.RIGHT;
            if (alignment == null) {
                MyGutterIconRenderer.$$$reportNull$$$0(2);
            }
            return alignment;
        }

        public boolean isNavigateAction() {
            return true;
        }

        @Nullable
        public String getTooltipText() {
            AnAction action2 = ActionManager.getInstance().getAction("ToggleRenderedDocPresentation");
            if (action2 == null) {
                return null;
            }
            String actionText = action2.getTemplateText();
            if (actionText == null) {
                return null;
            }
            return XmlStringUtil.wrapInHtml((CharSequence)(actionText + HelpTooltip.getShortcutAsHtml((String)KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2))));
        }

        @Nullable
        public AnAction getClickAction() {
            return DocRenderItem.this.createToggleAction();
        }

        public ActionGroup getPopupMenuActions() {
            return (ActionGroup)ObjectUtils.tryCast((Object)ActionManager.getInstance().getAction("DocCommentGutterIconContextMenu"), ActionGroup.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyGutterIconRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAccessibleName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlignment";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class MyInlayListener
    implements InlayModel.Listener {
        private MyInlayListener() {
        }

        public void onRemoved(@NotNull Inlay inlay) {
            EditorCustomElementRenderer renderer;
            if (inlay == null) {
                MyInlayListener.$$$reportNull$$$0(0);
            }
            if ((renderer = inlay.getRenderer()) instanceof DocRenderer) {
                ((DocRenderer)renderer).dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inlay", "com/intellij/codeInsight/documentation/render/DocRenderItem$MyInlayListener", "onRemoved"));
        }
    }

    private static final class MyVisibleAreaListener
    implements VisibleAreaListener {
        private int lastWidth;
        private AffineTransform lastFrcTransform;

        private MyVisibleAreaListener(@NotNull Editor editor) {
            if (editor == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(0);
            }
            this.lastWidth = DocRenderer.calcInlayWidth(editor);
            this.lastFrcTransform = MyVisibleAreaListener.getTransform(editor);
        }

        private static AffineTransform getTransform(Editor editor) {
            return FontInfo.getFontRenderContext(editor.getContentComponent()).getTransform();
        }

        public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
            if (e == null) {
                MyVisibleAreaListener.$$$reportNull$$$0(1);
            }
            if (e.getNewRectangle().isEmpty()) {
                return;
            }
            Editor editor = e.getEditor();
            int newWidth = DocRenderer.calcInlayWidth(editor);
            AffineTransform transform = MyVisibleAreaListener.getTransform(editor);
            if (newWidth != this.lastWidth || !Objects.equals(transform, this.lastFrcTransform)) {
                this.lastWidth = newWidth;
                this.lastFrcTransform = transform;
                DocRenderItem.updateInlays(editor, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyVisibleAreaListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visibleAreaChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCaretListener
    implements CaretListener {
        private MyCaretListener() {
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(0);
            }
            MyCaretListener.onCaretUpdate(event);
        }

        public void caretAdded(@NotNull CaretEvent event) {
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(1);
            }
            MyCaretListener.onCaretUpdate(event);
        }

        private static void onCaretUpdate(@NotNull CaretEvent event) {
            DocRenderItem item;
            Caret caret;
            if (event == null) {
                MyCaretListener.$$$reportNull$$$0(2);
            }
            if ((caret = event.getCaret()) == null) {
                return;
            }
            int caretOffset = caret.getOffset();
            FoldRegion foldRegion = caret.getEditor().getFoldingModel().getCollapsedRegionAtOffset(caretOffset);
            if (foldRegion != null && caretOffset > foldRegion.getStartOffset() && (item = (DocRenderItem)foldRegion.getUserData(OUR_ITEM)) != null) {
                item.toggle();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/codeInsight/documentation/render/DocRenderItem$MyCaretListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCaretUpdate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RelevantOffsets {
        private final int foldStartOffset;
        private final int foldEndOffset;
        private final int inlayOffset;

        private RelevantOffsets(@NotNull RangeHighlighter highlighter) {
            if (highlighter == null) {
                RelevantOffsets.$$$reportNull$$$0(0);
            }
            Document document = highlighter.getDocument();
            int startLine = document.getLineNumber(highlighter.getStartOffset());
            int endLine = document.getLineNumber(highlighter.getEndOffset());
            this.inlayOffset = this.foldStartOffset = document.getLineStartOffset(startLine);
            this.foldEndOffset = endLine < document.getLineCount() - 1 ? document.getLineStartOffset(endLine + 1) : document.getLineEndOffset(endLine);
        }

        private boolean match(FoldRegion foldRegion, Inlay inlay) {
            return foldRegion == null && inlay == null || foldRegion != null && foldRegion.isValid() && foldRegion.getStartOffset() == this.foldStartOffset && foldRegion.getEndOffset() == this.foldEndOffset && inlay != null && inlay.isValid() && inlay.getOffset() == this.inlayOffset;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/documentation/render/DocRenderItem$RelevantOffsets", "<init>"));
        }
    }
}

