/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.PlatformDocumentationUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalFilter {
    private static final Logger LOG = Logger.getInstance(AbstractExternalFilter.class);
    protected static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");
    protected static final Pattern ourHtmlFileSuffix = Pattern.compile("/([^/]*[.][hH][tT][mM][lL]?)$");
    protected static final String HTML = "<HTML>";
    protected static final String HTML_CLOSE = "</HTML>";
    private static final Pattern CLASS_DATA_START = Pattern.compile("START OF CLASS DATA", 2);
    private static final Pattern CLASS_DATA_END = Pattern.compile("SUMMARY ========", 2);
    private static final Pattern NON_CLASS_DATA_END = Pattern.compile("<A (NAME|ID)=", 2);
    private static final Pattern ANNIHILATOR = Pattern.compile("/[^/^.]*/[.][.]/");
    private static final Pattern CHARSET_META = Pattern.compile("<meta[^>]+\\s*charset=\"?([\\w\\-]*)\\s*\">", 2);
    private static final String FIELD_SUMMARY = "<!-- =========== FIELD SUMMARY =========== -->";
    private static final String CLASS_SUMMARY = "<div class=\"summary\">";
    private static final String GREATEST_END_SECTION = "<!-- ========= END OF CLASS DATA ========= -->";
    private static final String JAR_PROTOCOL = "jar:";
    private static final String HR = "<HR>";
    private static final String P = "<P>";
    private static final String DL = "<DL>";
    private static final String H2 = "H2";
    private static final String H2_CLOSE = "</H2>";
    private static final String BR = "<BR>";
    private static final String DT = "<DT>";

    protected static String doAnnihilate(String path) {
        int len = path.length();
        while (len > (len = (path = ANNIHILATOR.matcher(path).replaceAll("/")).length())) {
        }
        return path;
    }

    public CharSequence correctRefs(String root, CharSequence read) {
        CharSequence result2 = read;
        for (RefConvertor converter : this.getRefConverters()) {
            result2 = converter.refFilter(root, result2);
        }
        return result2;
    }

    protected abstract RefConvertor[] getRefConverters();

    @Nullable
    public String getExternalDocInfo(String url) throws Exception {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && app.isDispatchThread() || app.isWriteAccessAllowed()) {
            LOG.error("May block indefinitely: shouldn't be called from EDT or under write lock");
            return null;
        }
        if (url == null || !MyJavadocFetcher.ourFree) {
            return null;
        }
        MyJavadocFetcher fetcher = new MyJavadocFetcher(url, (_url, input, result2) -> this.doBuildFromStream(_url, input, result2));
        try {
            app.executeOnPooledThread((Runnable)fetcher).get();
        }
        catch (Exception e) {
            return null;
        }
        Exception exception = fetcher.myException;
        if (exception != null) {
            fetcher.myException = null;
            throw exception;
        }
        return this.correctDocText(url, fetcher.data);
    }

    @NotNull
    protected String correctDocText(@NotNull String url, @NotNull CharSequence data2) {
        if (url == null) {
            AbstractExternalFilter.$$$reportNull$$$0(0);
        }
        if (data2 == null) {
            AbstractExternalFilter.$$$reportNull$$$0(1);
        }
        CharSequence docText = this.correctRefs(ourAnchorSuffix.matcher(url).replaceAll(""), data2);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Filtered JavaDoc: " + docText + "\n");
        }
        String string = PlatformDocumentationUtil.fixupText(docText);
        if (string == null) {
            AbstractExternalFilter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getExternalDocInfoForElement(String docURL, PsiElement element2) throws Exception {
        return this.getExternalDocInfo(docURL);
    }

    protected void doBuildFromStream(String url, Reader input, StringBuilder data2) throws IOException {
        this.doBuildFromStream(url, input, data2, true, true);
    }

    protected void doBuildFromStream(String url, Reader input, StringBuilder data2, boolean searchForEncoding, boolean matchStart) throws IOException {
        String read;
        ParseSettings settings = this.getParseSettings(url);
        Pattern startSection = settings.startPattern;
        Pattern endSection = settings.endPattern;
        boolean useDt = settings.useDt;
        data2.append(HTML);
        URL baseUrl = VfsUtilCore.convertToURL((String)url);
        if (baseUrl != null) {
            data2.append("<base href=\"").append(baseUrl).append("\">");
        }
        data2.append("<style type=\"text/css\">  ul.inheritance {\n      margin:0;\n      padding:0;\n  }\n  ul.inheritance li {\n       display:inline;\n       list-style-type:none;\n  }\n  ul.inheritance li ul.inheritance {\n    margin-left:15px;\n    padding-left:15px;\n    padding-top:1px;\n  }\n</style>");
        String contentEncoding = null;
        BufferedReader buf = new BufferedReader(input);
        do {
            String foundEncoding;
            if ((read = buf.readLine()) == null || !searchForEncoding || (foundEncoding = AbstractExternalFilter.parseContentEncoding(read)) == null) continue;
            contentEncoding = foundEncoding;
        } while (read != null && matchStart && !startSection.matcher(StringUtil.toUpperCase((String)read)).find());
        if (input instanceof MyReader && contentEncoding != null && !contentEncoding.equalsIgnoreCase("UTF-8") && !contentEncoding.equals(((MyReader)input).getEncoding())) {
            try {
                data2.setLength(0);
                this.doBuildFromStream(url, new MyReader(((MyReader)input).myInputStream, contentEncoding), data2, false, true);
            }
            catch (ProcessCanceledException foundEncoding) {
                // empty catch block
            }
            return;
        }
        if (read == null) {
            data2.setLength(0);
            if (matchStart && !settings.forcePatternSearch && input instanceof MyReader) {
                try {
                    MyReader reader = contentEncoding != null ? new MyReader(((MyReader)input).myInputStream, contentEncoding) : new MyReader(((MyReader)input).myInputStream, ((MyReader)input).getEncoding());
                    this.doBuildFromStream(url, reader, data2, false, false);
                }
                catch (ProcessCanceledException reader) {
                    // empty catch block
                }
            }
            return;
        }
        if (useDt) {
            boolean skip = false;
            do {
                if (StringUtil.containsIgnoreCase((String)read, (String)H2_CLOSE) && !StringUtil.containsIgnoreCase((String)read, (String)H2)) {
                    data2.append(H2_CLOSE);
                    skip = true;
                    continue;
                }
                if (endSection.matcher(read).find() || StringUtil.indexOfIgnoreCase((String)read, (String)GREATEST_END_SECTION, (int)0) != -1) {
                    data2.append(HTML_CLOSE);
                    return;
                }
                if (skip) continue;
                AbstractExternalFilter.appendLine(data2, read);
            } while ((read = buf.readLine()) != null && !StringUtil.toUpperCase((String)read).trim().equals(DL) && !StringUtil.containsIgnoreCase((String)read, (String)"<div class=\"description\""));
            data2.append(DL);
            StringBuilder classDetails = new StringBuilder();
            while ((read = buf.readLine()) != null && !StringUtil.toUpperCase((String)read).equals(HR) && !StringUtil.toUpperCase((String)read).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data2, read, classDetails, endSection)) {
                    return;
                }
                if (AbstractExternalFilter.skipBlockList(read)) continue;
                AbstractExternalFilter.appendLine(classDetails, read);
            }
            while ((read = buf.readLine()) != null && !StringUtil.toUpperCase((String)read).equals(HR) && !StringUtil.toUpperCase((String)read).equals(P)) {
                if (AbstractExternalFilter.reachTheEnd(data2, read, classDetails, endSection)) {
                    return;
                }
                if (AbstractExternalFilter.skipBlockList(read)) continue;
                AbstractExternalFilter.appendLine(data2, StringUtil.replace((String)read, (String)DT, (String)"<DT><BR>"));
            }
            data2.append((CharSequence)classDetails);
            data2.append(P);
        } else {
            AbstractExternalFilter.appendLine(data2, read);
        }
        while ((read = buf.readLine()) != null && !endSection.matcher(read).find() && StringUtil.indexOfIgnoreCase((String)read, (String)GREATEST_END_SECTION, (int)0) == -1) {
            if (AbstractExternalFilter.skipBlockList(read)) continue;
            AbstractExternalFilter.appendLine(data2, read);
        }
        data2.append(HTML_CLOSE);
    }

    private static boolean skipBlockList(String read) {
        return StringUtil.containsIgnoreCase((String)read, (String)HR) || StringUtil.containsIgnoreCase((String)read, (String)"<ul class=\"blockList\">") || StringUtil.containsIgnoreCase((String)read, (String)"<li class=\"blockList\">");
    }

    @NotNull
    protected ParseSettings getParseSettings(@NotNull String url) {
        if (url == null) {
            AbstractExternalFilter.$$$reportNull$$$0(3);
        }
        Pattern startSection = CLASS_DATA_START;
        Pattern endSection = CLASS_DATA_END;
        boolean anchorPresent = false;
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        if (anchorMatcher.find()) {
            anchorPresent = true;
            startSection = Pattern.compile("<a (name|id)=\"" + Pattern.quote(StringUtil.escapeXmlEntities((String)anchorMatcher.group(1))) + "\"", 2);
            endSection = NON_CLASS_DATA_END;
        }
        return new ParseSettings(startSection, endSection, !anchorPresent, anchorPresent);
    }

    private static boolean reachTheEnd(StringBuilder data2, String read, StringBuilder classDetails, Pattern endSection) {
        if (StringUtil.indexOfIgnoreCase((String)read, (String)FIELD_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read, (String)CLASS_SUMMARY, (int)0) != -1 || StringUtil.indexOfIgnoreCase((String)read, (String)GREATEST_END_SECTION, (int)0) != -1 || endSection.matcher(read).find()) {
            data2.append((CharSequence)classDetails);
            data2.append(HTML_CLOSE);
            return true;
        }
        return false;
    }

    @Nullable
    static String parseContentEncoding(@NotNull String htmlLine) {
        Matcher matcher;
        if (htmlLine == null) {
            AbstractExternalFilter.$$$reportNull$$$0(4);
        }
        if (htmlLine.contains("charset") && (matcher = CHARSET_META.matcher(htmlLine)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static void appendLine(StringBuilder buffer, String read) {
        buffer.append(read);
        buffer.append("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/documentation/AbstractExternalFilter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/documentation/AbstractExternalFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "correctDocText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "correctDocText";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getParseSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseContentEncoding";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ParseSettings {
        @NotNull
        private final Pattern startPattern;
        @NotNull
        private final Pattern endPattern;
        private final boolean forcePatternSearch;
        private final boolean useDt;

        public ParseSettings(@NotNull Pattern startPattern, @NotNull Pattern endPattern, boolean useDt, boolean forcePatternSearch) {
            if (startPattern == null) {
                ParseSettings.$$$reportNull$$$0(0);
            }
            if (endPattern == null) {
                ParseSettings.$$$reportNull$$$0(1);
            }
            this.startPattern = startPattern;
            this.endPattern = endPattern;
            this.useDt = useDt;
            this.forcePatternSearch = forcePatternSearch;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "startPattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "endPattern";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/documentation/AbstractExternalFilter$ParseSettings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyReader
    extends InputStreamReader {
        private final ByteArrayInputStream myInputStream;

        MyReader(ByteArrayInputStream in) {
            super(in);
            in.reset();
            this.myInputStream = in;
        }

        MyReader(ByteArrayInputStream in, String charsetName) throws UnsupportedEncodingException {
            super((InputStream)in, charsetName);
            in.reset();
            this.myInputStream = in;
        }
    }

    private static class MyJavadocFetcher
    implements Runnable {
        private static boolean ourFree = true;
        private final StringBuilder data = new StringBuilder();
        private final String url;
        private final MyDocBuilder myBuilder;
        private Exception myException;

        MyJavadocFetcher(String url, MyDocBuilder builder2) {
            this.url = url;
            this.myBuilder = builder2;
            ourFree = false;
        }

        @Override
        public void run() {
            try {
                if (this.url == null) {
                    return;
                }
                if (this.url.startsWith(AbstractExternalFilter.JAR_PROTOCOL)) {
                    VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(BrowserUtil.getDocURL((String)this.url));
                    if (file2 != null) {
                        this.myBuilder.buildFromStream(this.url, new StringReader(VfsUtilCore.loadText((VirtualFile)file2)), this.data);
                    }
                } else {
                    URL parsedUrl = BrowserUtil.getURL((String)this.url);
                    if (parsedUrl != null) {
                        HttpRequests.request((String)parsedUrl.toString()).gzip(false).connect(request -> {
                            String contentEncoding = request.getConnection().getContentEncoding();
                            byte[] bytes = request.readBytes(null);
                            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                            if (contentEncoding == null) {
                                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));){
                                    String htmlLine = reader.readLine();
                                    while (htmlLine != null) {
                                        contentEncoding = AbstractExternalFilter.parseContentEncoding(htmlLine);
                                        if (contentEncoding != null) {
                                            break;
                                        }
                                        htmlLine = reader.readLine();
                                    }
                                }
                            }
                            this.myBuilder.buildFromStream(this.url, contentEncoding != null ? new MyReader(stream, contentEncoding) : new MyReader(stream), this.data);
                            return null;
                        });
                    }
                }
            }
            catch (ProcessCanceledException parsedUrl) {
            }
            catch (IOException e) {
                this.myException = e;
            }
            finally {
                ourFree = true;
            }
        }
    }

    private static interface MyDocBuilder {
        public void buildFromStream(String var1, Reader var2, StringBuilder var3) throws IOException;
    }

    protected static abstract class RefConvertor {
        final Pattern mySelector;

        public RefConvertor(@NotNull Pattern selector) {
            if (selector == null) {
                RefConvertor.$$$reportNull$$$0(0);
            }
            this.mySelector = selector;
        }

        protected abstract String convertReference(String var1, String var2);

        public CharSequence refFilter(String root, @NotNull CharSequence read) {
            if (read == null) {
                RefConvertor.$$$reportNull$$$0(1);
            }
            StringBuilder ready = new StringBuilder();
            int prev2 = 0;
            Matcher matcher = this.mySelector.matcher(read);
            while (matcher.find()) {
                CharSequence before = read.subSequence(prev2, matcher.start(1) - 1);
                CharSequence href = read.subSequence(matcher.start(1), matcher.end(1));
                prev2 = matcher.end(1) + 1;
                ready.append(before);
                ready.append("\"");
                ready.append((String)ReadAction.compute(() -> this.convertReference(root, href.toString())));
                ready.append("\"");
            }
            ready.append(read, prev2, read.length());
            return ready;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selector";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "read";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/documentation/AbstractExternalFilter$RefConvertor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refFilter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

