/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.ProblemHighlightFilter;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WholeFileLocalInspectionsPassFactory
implements TextEditorHighlightingPassFactory,
Disposable {
    private final Set<PsiFile> mySkipWholeInspectionsCache;
    private final ObjectIntMap<PsiFile> myPsiModificationCount;
    private final Project myProject;

    private WholeFileLocalInspectionsPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar registrar) {
        if (project == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(1);
        }
        this.mySkipWholeInspectionsCache = ContainerUtil.createWeakSet();
        this.myPsiModificationCount = ContainerUtil.createWeakKeyIntValueMap();
        this.myProject = project;
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{7}, true, 12);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ProfileChangeAdapter.TOPIC, (Object)new ProfileChangeAdapter(){

            public void profileChanged(InspectionProfile profile) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }

            public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
                WholeFileLocalInspectionsPassFactory.this.clearCaches();
            }
        });
    }

    public void dispose() {
        this.clearCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCaches() {
        Set<PsiFile> set2 = this.mySkipWholeInspectionsCache;
        synchronized (set2) {
            this.mySkipWholeInspectionsCache.clear();
        }
        set2 = this.myPsiModificationCount;
        synchronized (set2) {
            this.myPsiModificationCount.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(final @NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            WholeFileLocalInspectionsPassFactory.$$$reportNull$$$0(3);
        }
        long actualCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
        Object object = this.myPsiModificationCount;
        synchronized (object) {
            if (this.myPsiModificationCount.get((Object)file2) == (int)actualCount) {
                return null;
            }
        }
        if (!ProblemHighlightFilter.shouldHighlightFile((PsiFile)file2)) {
            return null;
        }
        object = this.mySkipWholeInspectionsCache;
        synchronized (object) {
            if (this.mySkipWholeInspectionsCache.contains(file2)) {
                return null;
            }
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new LocalInspectionsPass(file2, editor.getDocument(), 0, file2.getTextLength(), (TextRange)visibleRange, true, new DefaultHighlightInfoProcessor(), false){

            @Override
            protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
                if (wrapper2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return wrapper2.runForWholeFile();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @NotNull
            List<LocalInspectionToolWrapper> getInspectionTools(@NotNull InspectionProfileWrapper profile) {
                List<LocalInspectionToolWrapper> result2;
                if (profile == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((result2 = super.getInspectionTools(profile)).isEmpty()) {
                    Set<PsiFile> set2 = WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache;
                    synchronized (set2) {
                        WholeFileLocalInspectionsPassFactory.this.mySkipWholeInspectionsCache.add(file2);
                    }
                }
                List<LocalInspectionToolWrapper> list2 = result2;
                if (list2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return list2;
            }

            @Override
            protected String getPresentableName() {
                return DaemonBundle.message((String)"pass.whole.inspections", (Object[])new Object[0]);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                long modificationCount = PsiManager.getInstance((Project)this.myProject).getModificationTracker().getModificationCount();
                ObjectIntMap<PsiFile> objectIntMap = WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount;
                synchronized (objectIntMap) {
                    WholeFileLocalInspectionsPassFactory.this.myPsiModificationCount.put((Object)file2, (int)modificationCount);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "wrapper";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getInspectionTools";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isAcceptableLocalTool";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getInspectionTools";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class MyRegistrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        MyRegistrar() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            if (registrar == null) {
                MyRegistrar.$$$reportNull$$$0(0);
            }
            if (project == null) {
                MyRegistrar.$$$reportNull$$$0(1);
            }
            WholeFileLocalInspectionsPassFactory factory2 = new WholeFileLocalInspectionsPassFactory(project, registrar);
            Disposer.register((Disposable)project, (Disposable)factory2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "registrar";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/WholeFileLocalInspectionsPassFactory$MyRegistrar";
            objectArray[2] = "registerHighlightingPassFactory";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

