/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.UtilBundle;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ConfigureInspectionsAction;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.DaemonEditorPopup;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.icons.AllIcons;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.AnalyzingType;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.InspectionsLevel;
import com.intellij.openapi.editor.markup.LanguageHighlightLevel;
import com.intellij.openapi.editor.markup.PassWrapper;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.DeprecatedMethodException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrafficLightRenderer
implements ErrorStripeRenderer,
Disposable {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Document myDocument;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private final SeverityRegistrar mySeverityRegistrar;
    private final TObjectIntHashMap<HighlightSeverity> errorCount;
    private int[] cachedErrors;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public TrafficLightRenderer(Project project, Document document, PsiFile psiFile) {
        this(project, document);
        DeprecatedMethodException.report((String)"Please use TrafficLightRenderer(Project, Document) instead");
    }

    public TrafficLightRenderer(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            TrafficLightRenderer.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TrafficLightRenderer.$$$reportNull$$$0(1);
        }
        this.errorCount = new TObjectIntHashMap();
        this.cachedErrors = ArrayUtilRt.EMPTY_INT_ARRAY;
        this.myProject = project;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
        this.myDocument = document;
        this.mySeverityRegistrar = SeverityRegistrar.getSeverityRegistrar(this.myProject);
        this.refresh(null);
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        model2.addMarkupModelListener(this, new MarkupModelListener(){

            @Override
            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                TrafficLightRenderer.this.incErrorCount(highlighter, 1);
            }

            @Override
            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                if (highlighter == null) {
                    1.$$$reportNull$$$0(1);
                }
                TrafficLightRenderer.this.incErrorCount(highlighter, -1);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "highlighter";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        UIUtil.invokeLaterIfNeeded(() -> {
            for (RangeHighlighter rangeHighlighter : model2.getAllHighlighters()) {
                this.incErrorCount(rangeHighlighter, 1);
            }
        });
    }

    private PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myDocument);
    }

    @NotNull
    public SeverityRegistrar getSeverityRegistrar() {
        SeverityRegistrar severityRegistrar = this.mySeverityRegistrar;
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(2);
        }
        return severityRegistrar;
    }

    protected int @NotNull [] getErrorCount() {
        int[] nArray = (int[])this.cachedErrors.clone();
        if (nArray == null) {
            TrafficLightRenderer.$$$reportNull$$$0(3);
        }
        return nArray;
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
        List<HighlightSeverity> severities = this.mySeverityRegistrar.getAllSeverities();
        if (this.cachedErrors.length != severities.size()) {
            this.cachedErrors = new int[severities.size()];
        }
        for (HighlightSeverity severity : severities) {
            int severityIndex = this.mySeverityRegistrar.getSeverityIdx(severity);
            this.cachedErrors[severityIndex] = this.errorCount.get((Object)severity);
        }
    }

    public void dispose() {
        this.errorCount.clear();
        this.cachedErrors = ArrayUtilRt.EMPTY_INT_ARRAY;
    }

    private void incErrorCount(RangeHighlighter highlighter, int delta) {
        HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
        if (info == null) {
            return;
        }
        HighlightSeverity infoSeverity = info.getSeverity();
        if (infoSeverity.myVal <= HighlightSeverity.INFORMATION.myVal) {
            return;
        }
        if (this.errorCount.containsKey((Object)infoSeverity)) {
            this.errorCount.adjustValue((Object)infoSeverity, delta);
        } else {
            this.errorCount.put((Object)infoSeverity, delta);
        }
    }

    public boolean isValid() {
        return this.getPsiFile() != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    protected DaemonCodeAnalyzerStatus getDaemonCodeAnalyzerStatus(@NotNull SeverityRegistrar severityRegistrar) {
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(4);
        }
        DaemonCodeAnalyzerStatus status = new DaemonCodeAnalyzerStatus();
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null) {
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.no.file", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(5);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (this.myProject.isDisposed()) {
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.project.is.disposed", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(6);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (!this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
            if (!psiFile.isPhysical()) {
                status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.file.is.generated", (Object[])new Object[0]);
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(7);
                }
                return daemonCodeAnalyzerStatus;
            }
            if (psiFile instanceof PsiCompiledElement) {
                status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.file.is.decompiled", (Object[])new Object[0]);
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(8);
                }
                return daemonCodeAnalyzerStatus;
            }
            FileType fileType = psiFile.getFileType();
            if (fileType.isBinary()) {
                status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.file.is.binary", (Object[])new Object[0]);
                status.errorAnalyzingFinished = true;
                DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
                if (daemonCodeAnalyzerStatus == null) {
                    TrafficLightRenderer.$$$reportNull$$$0(9);
                }
                return daemonCodeAnalyzerStatus;
            }
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.highlighting.is.disabled.for.this.file", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(10);
            }
            return daemonCodeAnalyzerStatus;
        }
        FileViewProvider provider2 = psiFile.getViewProvider();
        Set languages = provider2.getLanguages();
        boolean shouldHighlight = languages.isEmpty();
        HighlightingLevelManager hlManager = HighlightingLevelManager.getInstance(this.getProject());
        for (Language language : languages) {
            PsiFile psiRoot = provider2.getPsi(language);
            boolean highlight = hlManager.shouldHighlight((PsiElement)psiRoot);
            boolean inspect = hlManager.shouldInspect((PsiElement)psiRoot);
            shouldHighlight |= highlight;
            status.fullInspect = status.fullInspect & (highlight && inspect);
        }
        if (!shouldHighlight) {
            status.reasonWhyDisabled = DaemonBundle.message((String)"process.title.highlighting.level.is.none", (Object[])new Object[0]);
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(11);
            }
            return daemonCodeAnalyzerStatus;
        }
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
             @Nls Map.Entry processEntry = HeavyProcessLatch.INSTANCE.getRunningOperation();
            if (processEntry != null) {
                status.reasonWhySuspended = (String)processEntry.getKey();
                status.heavyProcessType = (HeavyProcessLatch.Type)processEntry.getValue();
            } else {
                status.reasonWhySuspended = DaemonBundle.message((String)"process.title.heavy.operation.is.running", (Object[])new Object[0]);
                status.heavyProcessType = HeavyProcessLatch.Type.Processing;
            }
            status.errorAnalyzingFinished = true;
            DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
            if (daemonCodeAnalyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(12);
            }
            return daemonCodeAnalyzerStatus;
        }
        status.errorCount = this.getErrorCount();
        status.passes = ContainerUtil.filter(this.myDaemonCodeAnalyzer.getPassesToShowProgressFor(this.myDocument), p -> !StringUtil.isEmpty((String)p.getPresentableName()) && p.getProgress() >= 0.0);
        status.errorAnalyzingFinished = this.myDaemonCodeAnalyzer.isAllAnalysisFinished(psiFile);
        status.reasonWhySuspended = this.myDaemonCodeAnalyzer.isUpdateByTimerEnabled() ? null : DaemonBundle.message((String)"process.title.highlighting.is.paused.temporarily", (Object[])new Object[0]);
        this.fillDaemonCodeAnalyzerErrorsStatus(status, severityRegistrar);
        DaemonCodeAnalyzerStatus daemonCodeAnalyzerStatus = status;
        if (daemonCodeAnalyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(13);
        }
        return daemonCodeAnalyzerStatus;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        if (status == null) {
            TrafficLightRenderer.$$$reportNull$$$0(14);
        }
        if (severityRegistrar == null) {
            TrafficLightRenderer.$$$reportNull$$$0(15);
        }
    }

    @NotNull
    protected final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TrafficLightRenderer.$$$reportNull$$$0(16);
        }
        return project;
    }

    @NotNull
    public AnalyzerStatus getStatus() {
        if (PowerSaveMode.isEnabled()) {
            return new AnalyzerStatus(AllIcons.General.InspectionsPowerSaveMode, InspectionsBundle.message((String)"code.analysis.is.disabled.in.power.save.mode", (Object[])new Object[0]), "", this::createUIController);
        }
        DaemonCodeAnalyzerStatus status = this.getDaemonCodeAnalyzerStatus(this.mySeverityRegistrar);
        ArrayList<StatusItem> statusItems = new ArrayList<StatusItem>();
        Icon mainIcon = null;
        String title = "";
        String details = "";
        boolean isDumb = DumbService.isDumb((Project)this.myProject);
        if (status.errorAnalyzingFinished) {
            if (isDumb) {
                title = DaemonBundle.message((String)"shallow.analysis.completed", (Object[])new Object[0]);
                details = DaemonBundle.message((String)"shallow.analysis.completed.details", (Object[])new Object[0]);
            }
        } else {
            title = DaemonBundle.message((String)"performing.code.analysis", (Object[])new Object[0]);
        }
        int[] errorCount = status.errorCount;
        for (int i2 = errorCount.length - 1; i2 >= 0; --i2) {
            HighlightSeverity severity;
            int count = errorCount[i2];
            if (count <= 0 || (severity = this.mySeverityRegistrar.getSeverityByIndex(i2)) == null) continue;
            Icon icon2 = this.mySeverityRegistrar.getRendererIconByIndex(i2, status.fullInspect);
            statusItems.add(new StatusItem(Integer.toString(count), icon2, severity.getCountMessage(count)));
            if (mainIcon != null) continue;
            mainIcon = icon2;
        }
        if (!statusItems.isEmpty()) {
            if (mainIcon == null) {
                mainIcon = status.fullInspect ? AllIcons.General.InspectionsOK : AllIcons.General.InspectionsOKEmpty;
            }
            AnalyzerStatus result2 = new AnalyzerStatus(mainIcon, title, "", this::createUIController).withNavigation().withExpandedStatus(statusItems);
            AnalyzerStatus analyzerStatus = status.errorAnalyzingFinished ? result2 : result2.withAnalyzingType(AnalyzingType.PARTIAL).withPasses(ContainerUtil.map(status.passes, p -> new PassWrapper(p.getPresentableName(), p.getProgress(), p.isFinished())));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(17);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty((String)status.reasonWhyDisabled)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsTrafficOff, DaemonBundle.message((String)"no.analysis.performed", (Object[])new Object[0]), status.reasonWhyDisabled, this::createUIController).withTextStatus(DaemonBundle.message((String)"iw.status.off", (Object[])new Object[0]));
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(18);
            }
            return analyzerStatus;
        }
        if (StringUtil.isNotEmpty((String)status.reasonWhySuspended)) {
            AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsPause, DaemonBundle.message((String)"analysis.suspended", (Object[])new Object[0]), status.reasonWhySuspended, this::createUIController).withTextStatus(status.heavyProcessType != null ? status.heavyProcessType.toString() : DaemonBundle.message((String)"iw.status.paused", (Object[])new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED);
            if (analyzerStatus == null) {
                TrafficLightRenderer.$$$reportNull$$$0(19);
            }
            return analyzerStatus;
        }
        if (status.errorAnalyzingFinished) {
            return isDumb ? new AnalyzerStatus(AllIcons.General.InspectionsPause, title, details, this::createUIController).withTextStatus(UtilBundle.message((String)"heavyProcess.type.indexing", (Object[])new Object[0])).withAnalyzingType(AnalyzingType.SUSPENDED) : new AnalyzerStatus(status.fullInspect ? AllIcons.General.InspectionsOK : AllIcons.General.InspectionsOKEmpty, DaemonBundle.message((String)"no.errors.or.warnings.found", (Object[])new Object[0]), details, this::createUIController);
        }
        AnalyzerStatus analyzerStatus = new AnalyzerStatus(AllIcons.General.InspectionsEye, title, details, this::createUIController).withTextStatus(DaemonBundle.message((String)"iw.status.analyzing", (Object[])new Object[0])).withAnalyzingType(AnalyzingType.EMPTY).withPasses(ContainerUtil.map(status.passes, p -> new PassWrapper(p.getPresentableName(), p.getProgress(), p.isFinished())));
        if (analyzerStatus == null) {
            TrafficLightRenderer.$$$reportNull$$$0(20);
        }
        return analyzerStatus;
    }

    @NotNull
    protected UIController createUIController() {
        return new SimplifiedUIController();
    }

    @NotNull
    protected final UIController createUIController(@NotNull Editor editor) {
        if (editor == null) {
            TrafficLightRenderer.$$$reportNull$$$0(21);
        }
        boolean mergeEditor = editor.getUserData(DiffUserDataKeys.MERGE_EDITOR_FLAG) == Boolean.TRUE;
        return editor.getEditorKind() == EditorKind.DIFF && !mergeEditor ? new SimplifiedUIController() : new DefaultUIController();
    }

    private static void applyPanel(@NotNull HectorComponentPanel panel2) {
        if (panel2 == null) {
            TrafficLightRenderer.$$$reportNull$$$0(22);
        }
        try {
            panel2.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @NotNull
    private static InspectionsLevel getHighlightLevel(boolean highlight, boolean inspect) {
        if (!highlight && !inspect) {
            InspectionsLevel inspectionsLevel = InspectionsLevel.NONE;
            if (inspectionsLevel == null) {
                TrafficLightRenderer.$$$reportNull$$$0(23);
            }
            return inspectionsLevel;
        }
        if (highlight && !inspect) {
            InspectionsLevel inspectionsLevel = InspectionsLevel.SYNTAX;
            if (inspectionsLevel == null) {
                TrafficLightRenderer.$$$reportNull$$$0(24);
            }
            return inspectionsLevel;
        }
        InspectionsLevel inspectionsLevel = InspectionsLevel.ALL;
        if (inspectionsLevel == null) {
            TrafficLightRenderer.$$$reportNull$$$0(25);
        }
        return inspectionsLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severityRegistrar";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverityRegistrar";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorCount";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDaemonCodeAnalyzerStatus";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "fillDaemonCodeAnalyzerErrorsStatus";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUIController";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "applyPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class SimplifiedUIController
    extends AbstractUIController {
        public boolean enableToolbar() {
            return false;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = Collections.emptyList();
            if (list2 == null) {
                SimplifiedUIController.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$SimplifiedUIController", "getActions"));
        }
    }

    public class DefaultUIController
    extends AbstractUIController {
        private final List<AnAction> myMenuActions;

        public DefaultUIController() {
            this.myMenuActions = this.initActions();
        }

        @NotNull
        private List<AnAction> initActions() {
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            result2.add((AnAction)new ConfigureInspectionsAction());
            result2.add((AnAction)DaemonEditorPopup.createGotoGroup());
            result2.add((AnAction)Separator.create());
            result2.add((AnAction)new ShowImportTooltipAction());
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                DefaultUIController.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @NotNull
        public List<AnAction> getActions() {
            List<AnAction> list2 = this.myMenuActions;
            if (list2 == null) {
                DefaultUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        public boolean enableToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initActions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActions";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class ShowImportTooltipAction
        extends ToggleAction {
            private ShowImportTooltipAction() {
                super(EditorBundle.message((String)"iw.show.import.tooltip", (Object[])new Object[0]));
            }

            public boolean isSelected(@NotNull AnActionEvent e) {
                PsiFile psiFile;
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(0);
                }
                return (psiFile = TrafficLightRenderer.this.getPsiFile()) != null && TrafficLightRenderer.this.myDaemonCodeAnalyzer.isImportHintsEnabled(psiFile);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                PsiFile psiFile;
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(1);
                }
                if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.setImportHintsEnabled(psiFile, state);
                }
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    ShowImportTooltipAction.$$$reportNull$$$0(2);
                }
                super.update(e);
                e.getPresentation().setEnabled(TrafficLightRenderer.this.myDaemonCodeAnalyzer.isAutohintsAvailable(TrafficLightRenderer.this.getPsiFile()));
            }

            public boolean isDumbAware() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController$ShowImportTooltipAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    protected abstract class AbstractUIController
    implements UIController {
        private final boolean inLibrary;
        private final List<LanguageHighlightLevel> myLevelsList;
        private List<HectorComponentPanel> myAdditionalPanels = Collections.emptyList();

        AbstractUIController() {
            PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
            if (psiFile != null) {
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)TrafficLightRenderer.this.getProject()).getFileIndex();
                VirtualFile virtualFile = psiFile.getVirtualFile();
                assert (virtualFile != null);
                this.inLibrary = fileIndex.isInLibrary(virtualFile) && !fileIndex.isInContent(virtualFile);
            } else {
                this.inLibrary = false;
            }
            this.myLevelsList = this.initLevels();
        }

        @NotNull
        private List<LanguageHighlightLevel> initLevels() {
            ArrayList<LanguageHighlightLevel> result2 = new ArrayList<LanguageHighlightLevel>();
            PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
            if (psiFile != null && !TrafficLightRenderer.this.getProject().isDisposed()) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                HighlightingLevelManager hlManager = HighlightingLevelManager.getInstance(TrafficLightRenderer.this.getProject());
                for (Language language : viewProvider.getLanguages()) {
                    PsiFile psiRoot = viewProvider.getPsi(language);
                    result2.add(new LanguageHighlightLevel(language.getID(), TrafficLightRenderer.getHighlightLevel(hlManager.shouldHighlight((PsiElement)psiRoot), hlManager.shouldInspect((PsiElement)psiRoot))));
                }
            }
            ArrayList<LanguageHighlightLevel> arrayList = result2;
            if (arrayList == null) {
                AbstractUIController.$$$reportNull$$$0(0);
            }
            return arrayList;
        }

        @NotNull
        public List<InspectionsLevel> getAvailableLevels() {
            List<InspectionsLevel> list2 = this.inLibrary ? Arrays.asList(InspectionsLevel.NONE, InspectionsLevel.SYNTAX) : Arrays.asList(InspectionsLevel.values());
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(1);
            }
            return list2;
        }

        @NotNull
        public List<LanguageHighlightLevel> getHighlightLevels() {
            List<LanguageHighlightLevel> list2 = Collections.unmodifiableList(this.myLevelsList);
            if (list2 == null) {
                AbstractUIController.$$$reportNull$$$0(2);
            }
            return list2;
        }

        public void setHighLightLevel(@NotNull LanguageHighlightLevel level) {
            PsiFile psiFile;
            if (level == null) {
                AbstractUIController.$$$reportNull$$$0(3);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null && !TrafficLightRenderer.this.getProject().isDisposed() && !this.myLevelsList.contains(level)) {
                FileViewProvider viewProvider = psiFile.getViewProvider();
                Language language = Language.findLanguageByID((String)level.getLangID());
                if (language != null) {
                    PsiFile root = viewProvider.getPsi(language);
                    if (level.getLevel() == InspectionsLevel.NONE) {
                        HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_HIGHLIGHTING);
                    } else if (level.getLevel() == InspectionsLevel.SYNTAX) {
                        HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_INSPECTION);
                    } else {
                        HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.FORCE_HIGHLIGHTING);
                    }
                    this.myLevelsList.replaceAll(l -> l.getLangID().equals(level.getLangID()) ? level : l);
                    InjectedLanguageManager.getInstance((Project)TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
            }
        }

        public void fillHectorPanels(@NotNull Container container, @NotNull GridBag gc) {
            PsiFile psiFile;
            if (container == null) {
                AbstractUIController.$$$reportNull$$$0(4);
            }
            if (gc == null) {
                AbstractUIController.$$$reportNull$$$0(5);
            }
            if ((psiFile = TrafficLightRenderer.this.getPsiFile()) != null) {
                this.myAdditionalPanels = HectorComponentPanelsProvider.EP_NAME.extensions((AreaInstance)TrafficLightRenderer.this.getProject()).map(hp -> hp.createConfigurable(psiFile)).filter(p -> p != null).collect(Collectors.toList());
                for (HectorComponentPanel p2 : this.myAdditionalPanels) {
                    JComponent c;
                    try {
                        p2.reset();
                        c = p2.createComponent();
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        Logger.getInstance(TrafficLightRenderer.class).error(e);
                        continue;
                    }
                    if (c == null) continue;
                    container.add((Component)c, gc.nextLine().next().fillCellHorizontally().coverLine().weightx(1.0));
                }
            }
        }

        public boolean canClosePopup() {
            if (this.myAdditionalPanels.isEmpty()) {
                return true;
            }
            if (this.myAdditionalPanels.stream().allMatch(p -> p.canClose())) {
                PsiFile psiFile = TrafficLightRenderer.this.getPsiFile();
                if (this.myAdditionalPanels.stream().filter(p -> p.isModified()).peek(x$0 -> TrafficLightRenderer.applyPanel(x$0)).count() > 0L) {
                    if (psiFile != null) {
                        InjectedLanguageManager.getInstance((Project)TrafficLightRenderer.this.getProject()).dropFileCaches(psiFile);
                    }
                    TrafficLightRenderer.this.myDaemonCodeAnalyzer.restart();
                }
                return true;
            }
            return false;
        }

        public void onClosePopup() {
            this.myAdditionalPanels.forEach(p -> p.disposeUIResources());
            this.myAdditionalPanels = Collections.emptyList();
        }

        public void toggleProblemsView() {
            PsiFile file2 = TrafficLightRenderer.this.getPsiFile();
            ProblemsView.toggleCurrentFileProblems(TrafficLightRenderer.this.getProject(), file2 == null ? null : file2.getVirtualFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "container";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initLevels";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAvailableLevels";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHighlightLevels";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TrafficLightRenderer$AbstractUIController";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setHighLightLevel";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "fillHectorPanels";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static final class DaemonCodeAnalyzerStatus {
        public boolean errorAnalyzingFinished;
        List<ProgressableTextEditorHighlightingPass> passes = Collections.emptyList();
        public int[] errorCount = ArrayUtilRt.EMPTY_INT_ARRAY;
        @Nls
        public String reasonWhyDisabled;
        @Nls
        public String reasonWhySuspended;
        private HeavyProcessLatch.Type heavyProcessType;
        private boolean fullInspect = true;

        public String toString() {
            StringBuilder s = new StringBuilder("DS: finished=" + this.errorAnalyzingFinished);
            s.append("; pass statuses: ").append(this.passes.size()).append("; ");
            for (ProgressableTextEditorHighlightingPass passStatus : this.passes) {
                s.append(String.format("(%s %2.0f%% %b)", passStatus.getPresentableName(), passStatus.getProgress() * 100.0, passStatus.isFinished()));
            }
            s.append("; error count: ").append(this.errorCount.length).append(": ").append(new TIntArrayList(this.errorCount));
            return s.toString();
        }
    }
}

