/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.IdeBundle;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.util.LayeredTextAttributes;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InjectedGeneralHighlightingPass
extends GeneralHighlightingPass {
    InjectedGeneralHighlightingPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Document document, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(1);
        }
        if (document == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(2);
        }
        if (priorityRange == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(3);
        }
        if (highlightInfoProcessor == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(4);
        }
        super(project, file2, document, startOffset, endOffset, updateAll, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    protected String getPresentableName() {
        return IdeBundle.message((String)"highlighting.pass.injected.presentable.name", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress2) {
        HashSet result2;
        if (progress2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(5);
        }
        if (!Registry.is((String)"editor.injected.highlighting.enabled")) {
            return;
        }
        ArrayList allDivided = new ArrayList();
        Divider.divideInsideAndOutsideAllRoots(this.myFile, this.myRestrictRange, (TextRange)this.myPriorityRange, SHOULD_HIGHLIGHT_FILTER, (Processor<? super Divider.DividedElements>)new CommonProcessors.CollectProcessor(allDivided));
        List allInsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.inside));
        List allOutsideElements = ContainerUtil.concat((Iterable)ContainerUtil.map(allDivided, d -> d.outside));
        Set<PsiFile> injected = this.getInjectedPsiFiles(allInsideElements, allOutsideElements, progress2);
        HashSet injectedResult = new HashSet();
        if (!this.addInjectedPsiHighlights(injected, progress2, Collections.synchronizedSet(injectedResult))) {
            throw new ProcessCanceledException();
        }
        HashSet hashSet = injectedResult;
        synchronized (hashSet) {
            result2 = injectedResult.isEmpty() ? Collections.emptySet() : new HashSet(injectedResult);
        }
        HashSet<HighlightInfo> gotHighlights = new HashSet<HighlightInfo>(100);
        ArrayList<HighlightInfo> injectionsOutside = new ArrayList<HighlightInfo>(gotHighlights.size());
        for (HighlightInfo info : result2) {
            if (this.myRestrictRange.contains((Segment)info)) {
                gotHighlights.add(info);
                continue;
            }
            injectionsOutside.add(info);
        }
        if (!injectionsOutside.isEmpty()) {
            boolean priorityIntersectionHasElements = this.myPriorityRange.intersectsStrict(this.myRestrictRange);
            if (!(allInsideElements.isEmpty() && gotHighlights.isEmpty() || !priorityIntersectionHasElements)) {
                ArrayList toApplyInside = new ArrayList(gotHighlights);
                this.myHighlights.addAll(toApplyInside);
                gotHighlights.clear();
                this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), toApplyInside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
            }
            ArrayList<HighlightInfo> toApply = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : gotHighlights) {
                if (!this.myRestrictRange.contains((Segment)info) || this.myPriorityRange.contains((Segment)info)) continue;
                toApply.add(info);
            }
            toApply.addAll(injectionsOutside);
            this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), toApply, this.myRestrictRange, (TextRange)new ProperTextRange(0, this.myDocument.getTextLength()), this.getId());
        } else {
            this.myHighlights.addAll(gotHighlights);
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.getEditor(), this.myHighlights, this.myRestrictRange, this.myRestrictRange, this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<PsiFile> getInjectedPsiFiles(@NotNull List<? extends PsiElement> elements1, @NotNull List<? extends PsiElement> elements2, @NotNull ProgressIndicator progress2) {
        if (elements1 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(6);
        }
        if (elements2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(7);
        }
        if (progress2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List injected = InjectedLanguageManager.getInstance((Project)this.myProject).getCachedInjectedDocumentsInRange(this.myFile, this.myFile.getTextRange());
        HashSet<PsiLanguageInjectionHost> hosts = new HashSet<PsiLanguageInjectionHost>(elements1.size() + elements2.size() + injected.size());
        for (DocumentWindow documentRange : injected) {
            PsiLanguageInjectionHost context;
            PsiFile file2;
            ProgressManager.checkCanceled();
            if (!documentRange.isValid() || (file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentRange)) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || !context.isValid() || file2.getProject().isDisposed() || !this.myUpdateAll && !this.myRestrictRange.intersects(context.getTextRange())) continue;
            hosts.add(context);
        }
        InjectedLanguageManagerImpl injectedLanguageManager = InjectedLanguageManagerImpl.getInstanceImpl(this.myProject);
        boolean probeUp = false;
        CommonProcessors.CollectProcessor<PsiElement> collectInjectableProcessor = new CommonProcessors.CollectProcessor<PsiElement>(hosts){

            public boolean process(PsiElement t) {
                ProgressManager.checkCanceled();
                if (InjectedLanguageUtil.isInjectable(t, false)) {
                    super.process((Object)t);
                }
                return true;
            }
        };
        injectedLanguageManager.processInjectableElements(elements1, (Processor<? super PsiElement>)collectInjectableProcessor);
        injectedLanguageManager.processInjectableElements(elements2, (Processor<? super PsiElement>)collectInjectableProcessor);
        HashSet outInjected = new HashSet();
        PsiLanguageInjectionHost.InjectedPsiVisitor visitor = (injectedPsi, places) -> {
            Set set2 = outInjected;
            synchronized (set2) {
                ProgressManager.checkCanceled();
                outInjected.add(injectedPsi);
            }
        };
        this.setProgressLimit(hosts.size());
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(hosts), progress2, element2 -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            injectedLanguageManager.enumerateEx((PsiElement)element2, this.myFile, false, visitor);
            this.advanceProgress(1L);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
        HashSet hashSet2 = outInjected;
        // MONITORENTER : hashSet2
        HashSet<PsiFile> hashSet = outInjected.isEmpty() ? Collections.emptySet() : new HashSet<PsiFile>(outInjected);
        // MONITOREXIT : hashSet2
        if (hashSet != null) return hashSet;
        InjectedGeneralHighlightingPass.$$$reportNull$$$0(9);
        return hashSet;
    }

    private boolean addInjectedPsiHighlights(@NotNull Set<? extends PsiFile> injectedFiles, @NotNull ProgressIndicator progress2, @NotNull Collection<? super HighlightInfo> outInfos) {
        if (injectedFiles == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(10);
        }
        if (progress2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(11);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(12);
        }
        if (injectedFiles.isEmpty()) {
            return true;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        TextAttributesKey fragmentKey = EditorColors.createInjectedLanguageFragmentKey((Language)this.myFile.getLanguage());
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<PsiFile>(injectedFiles), progress2, injectedPsi -> this.addInjectedPsiHighlights((PsiFile)injectedPsi, fragmentKey, outInfos, injectedLanguageManager));
    }

    @Override
    protected void queueInfoToUpdateIncrementally(@NotNull HighlightInfo info) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(13);
        }
    }

    private boolean addInjectedPsiHighlights(@NotNull PsiFile injectedPsi, TextAttributesKey attributesKey, @NotNull Collection<? super HighlightInfo> outInfos, @NotNull InjectedLanguageManager injectedLanguageManager) {
        DocumentWindow documentWindow;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(14);
        }
        if (outInfos == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(15);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(16);
        }
        if ((documentWindow = (DocumentWindow)PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(injectedPsi)) == null) {
            return true;
        }
        Place places = InjectedLanguageUtil.getShreds(injectedPsi);
        boolean addTooltips = places.size() < 100;
        Iterator iterator2 = places.iterator();
        while (iterator2.hasNext()) {
            TextRange textRange;
            PsiLanguageInjectionHost.Shred place = (PsiLanguageInjectionHost.Shred)iterator2.next();
            PsiLanguageInjectionHost host = place.getHost();
            if (host == null || (textRange = place.getRangeInsideHost().shiftRight(host.getTextRange().getStartOffset())).isEmpty()) continue;
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(textRange);
            if (attributesKey != null && InjectedLanguageUtil.isHighlightInjectionBackground(host)) {
                builder2.textAttributes(attributesKey);
            }
            if (addTooltips) {
                String desc = injectedPsi.getLanguage().getDisplayName() + ": " + injectedPsi.getText();
                builder2.unescapedToolTip(desc);
            }
            HighlightInfo info = builder2.createUnconditionally();
            info.setFromInjection(true);
            outInfos.add(info);
        }
        HighlightInfoHolder holder = this.createInfoHolder(injectedPsi);
        this.runHighlightVisitorsForInjected(injectedPsi, holder);
        for (int i2 = 0; i2 < holder.size(); ++i2) {
            HighlightInfo info = holder.get(i2);
            int startOffset = documentWindow.injectedToHost(info.startOffset);
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, fixedTextRange, outInfos);
        }
        int injectedStart = holder.size();
        this.highlightInjectedSyntax(injectedPsi, holder);
        for (int i3 = injectedStart; i3 < holder.size(); ++i3) {
            HighlightInfo info = holder.get(i3);
            int startOffset = info.startOffset;
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            if (fixedTextRange == null) {
                info.setFromInjection(true);
                outInfos.add(info);
                continue;
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, fixedTextRange.getStartOffset(), fixedTextRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.getSeverity(), info.isAfterEndOfLine(), null, false, 0, info.getProblemGroup(), info.getInspectionToolId(), info.getGutterIconRenderer(), info.getGroup());
            patched.setFromInjection(true);
            outInfos.add(patched);
        }
        if (!this.isDumbMode()) {
            ArrayList todos = new ArrayList();
            InjectedGeneralHighlightingPass.highlightTodos(injectedPsi, injectedPsi.getText(), 0, injectedPsi.getTextLength(), this.myPriorityRange, todos, todos);
            for (HighlightInfo info : todos) {
                InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, null, outInfos);
            }
        }
        return true;
    }

    @Nullable(value="null means invalid")
    private static @Nullable(value="null means invalid") TextRange getFixedTextRange(@NotNull DocumentWindow documentWindow, int startOffset) {
        ProperTextRange fixedTextRange;
        TextRange textRange;
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(17);
        }
        if ((textRange = documentWindow.getHostRange(startOffset)) == null) {
            textRange = InjectedGeneralHighlightingPass.findNearestTextRange(documentWindow, startOffset);
            if (textRange == null) {
                return null;
            }
            boolean isBefore = startOffset < textRange.getStartOffset();
            fixedTextRange = new ProperTextRange(isBefore ? textRange.getStartOffset() - 1 : textRange.getEndOffset(), isBefore ? textRange.getStartOffset() : textRange.getEndOffset() + 1);
        } else {
            fixedTextRange = null;
        }
        return fixedTextRange;
    }

    private static void addPatchedInfos(@NotNull HighlightInfo info, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull InjectedLanguageManager injectedLanguageManager, @Nullable TextRange fixedTextRange, @NotNull Collection<? super HighlightInfo> out) {
        if (info == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(18);
        }
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(19);
        }
        if (documentWindow == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(20);
        }
        if (injectedLanguageManager == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(21);
        }
        if (out == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(22);
        }
        ProperTextRange textRange = new ProperTextRange(info.startOffset, info.endOffset);
        List editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)textRange);
        for (TextRange editable : editables) {
            TextRange hostRange = fixedTextRange == null ? documentWindow.injectedToHost(editable) : fixedTextRange;
            boolean isAfterEndOfLine = info.isAfterEndOfLine();
            if (isAfterEndOfLine) {
                int hostEndOffset = hostRange.getEndOffset();
                int lineNumber = documentWindow.getDelegate().getLineNumber(hostEndOffset);
                int hostLineEndOffset = documentWindow.getDelegate().getLineEndOffset(lineNumber);
                if (hostEndOffset < hostLineEndOffset) {
                    isAfterEndOfLine = false;
                    hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
                }
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, hostRange.getStartOffset(), hostRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.getSeverity(), isAfterEndOfLine, null, false, 0, info.getProblemGroup(), info.getInspectionToolId(), info.getGutterIconRenderer(), info.getGroup());
            patched.setHint(info.hasHint());
            if (info.quickFixActionRanges != null) {
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange quickfixTextRange = (TextRange)pair.getSecond();
                    List editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, quickfixTextRange);
                    for (TextRange editableRange : editableQF) {
                        HighlightInfo.IntentionActionDescriptor descriptor2 = (HighlightInfo.IntentionActionDescriptor)pair.getFirst();
                        if (patched.quickFixActionRanges == null) {
                            patched.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
                        }
                        TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                        patched.quickFixActionRanges.add((Pair<HighlightInfo.IntentionActionDescriptor, TextRange>)Pair.create((Object)descriptor2, (Object)hostEditableRange));
                    }
                }
            }
            patched.setFromInjection(true);
            out.add(patched);
        }
    }

    @Nullable(value="null means invalid")
    private static @Nullable(value="null means invalid") TextRange findNearestTextRange(DocumentWindow documentWindow, int startOffset) {
        Segment marker;
        ProperTextRange curRange;
        ProperTextRange textRange = null;
        Segment[] segmentArray = documentWindow.getHostRanges();
        int n = segmentArray.length;
        for (int j = 0; j < n && ((curRange = ProperTextRange.create((Segment)(marker = segmentArray[j]))).getStartOffset() <= startOffset || textRange == null); ++j) {
            textRange = curRange;
        }
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHighlightVisitorsForInjected(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(23);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(24);
        }
        HighlightVisitor[] filtered2 = this.getHighlightVisitors(injectedPsi);
        try {
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            for (HighlightVisitor visitor : filtered2) {
                visitor.analyze(injectedPsi, true, holder, () -> {
                    for (PsiElement element2 : elements) {
                        ProgressManager.checkCanceled();
                        visitor.visit(element2);
                    }
                });
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private void highlightInjectedSyntax(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        List<InjectedLanguageUtilBase.TokenInfo> tokens;
        if (injectedPsi == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(25);
        }
        if (holder == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(26);
        }
        if ((tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi)) == null) {
            return;
        }
        Place shreds = InjectedLanguageUtil.getShreds(injectedPsi);
        int shredIndex = -1;
        int injectionHostTextRangeStart = -1;
        for (InjectedLanguageUtilBase.TokenInfo token2 : tokens) {
            ProgressManager.checkCanceled();
            ProperTextRange range2 = token2.rangeInsideInjectionHost;
            if (range2.getLength() == 0) continue;
            if (shredIndex != token2.shredIndex) {
                shredIndex = token2.shredIndex;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(shredIndex);
                PsiLanguageInjectionHost host = shred.getHost();
                if (host == null) {
                    return;
                }
                injectionHostTextRangeStart = host.getTextRange().getStartOffset();
            }
            TextRange shiftedRange = range2.shiftRight(injectionHostTextRangeStart);
            holder.addAll(InjectedGeneralHighlightingPass.overrideDefaultHighlights(this.myGlobalScheme, shiftedRange, token2.textAttributesKeys));
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }

    @NotNull
    public static List<HighlightInfo> overrideDefaultHighlights(@NotNull EditorColorsScheme scheme2, @NotNull TextRange range2, TextAttributesKey @NotNull [] keys2) {
        if (scheme2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(27);
        }
        if (range2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(28);
        }
        if (keys2 == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(29);
        }
        ArrayList<HighlightInfo> result2 = new ArrayList<HighlightInfo>();
        if (range2.isEmpty()) {
            ArrayList<HighlightInfo> arrayList = result2;
            if (arrayList == null) {
                InjectedGeneralHighlightingPass.$$$reportNull$$$0(30);
            }
            return arrayList;
        }
        HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(range2).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
        result2.add(info);
        LayeredTextAttributes injectedAttributes = LayeredTextAttributes.create(scheme2, keys2);
        if (injectedAttributes.isEmpty() || keys2.length == 1 && keys2[0] == HighlighterColors.TEXT) {
            ArrayList<HighlightInfo> arrayList = result2;
            if (arrayList == null) {
                InjectedGeneralHighlightingPass.$$$reportNull$$$0(31);
            }
            return arrayList;
        }
        HighlightInfo injectedInfo = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(range2).textAttributes(injectedAttributes).createUnconditionally();
        result2.add(injectedInfo);
        ArrayList<HighlightInfo> arrayList = result2;
        if (arrayList == null) {
            InjectedGeneralHighlightingPass.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 30: 
            case 31: 
            case 32: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 30: 
            case 31: 
            case 32: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightInfoProcessor";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements2";
                break;
            }
            case 9: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedFiles";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outInfos";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 14: 
            case 19: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedPsi";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedLanguageManager";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentWindow";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInjectedPsiFiles";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "overrideDefaultHighlights";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInformationWithProgress";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedPsiFiles";
                break;
            }
            case 9: 
            case 30: 
            case 31: 
            case 32: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addInjectedPsiHighlights";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "queueInfoToUpdateIncrementally";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getFixedTextRange";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addPatchedInfos";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "runHighlightVisitorsForInjected";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "highlightInjectedSyntax";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "overrideDefaultHighlights";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 30: 
            case 31: 
            case 32: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

