/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.ShowIntentionActionsHandler;
import com.intellij.internal.statistic.service.fus.collectors.TooltipActionsLogger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.awt.event.InputEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B!\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0002J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/codeInsight/daemon/impl/DaemonTooltipAction;", "Lcom/intellij/openapi/editor/ex/TooltipAction;", "myFixText", "", "myActionText", "myActualOffset", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "equals", "", "other", "", "execute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "inputEvent", "Ljava/awt/event/InputEvent;", "getText", "hashCode", "showAllActions", "intellij.platform.lang.impl"})
public final class DaemonTooltipAction
implements TooltipAction {
    private final String myFixText;
    private final String myActionText;
    private final int myActualOffset;

    @Override
    @NotNull
    public String getText() {
        return this.myFixText;
    }

    @Override
    public void execute(@NotNull Editor editor, @Nullable InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"editor.project ?: return");
        Project project2 = project;
        TooltipActionsLogger.Companion.logExecute(project2, inputEvent);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiDocumentManager.getIn\u2026ditor.document) ?: return");
        PsiFile psiFile2 = psiFile;
        List<HighlightInfo.IntentionActionDescriptor> list2 = ShowIntentionsPass.getAvailableFixes(editor, psiFile2, -1, this.myActualOffset);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ShowIntentionsPass.getAv\u2026File, -1, myActualOffset)");
        List<HighlightInfo.IntentionActionDescriptor> intentions = list2;
        Iterator<HighlightInfo.IntentionActionDescriptor> iterator2 = intentions.iterator();
        while (iterator2.hasNext()) {
            IntentionAction action2;
            HighlightInfo.IntentionActionDescriptor descriptor2;
            HighlightInfo.IntentionActionDescriptor intentionActionDescriptor = descriptor2 = iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)intentionActionDescriptor, (String)"descriptor");
            Intrinsics.checkNotNullExpressionValue((Object)intentionActionDescriptor.getAction(), (String)"descriptor.action");
            if (!Intrinsics.areEqual((Object)action2.getText(), (Object)this.myActionText)) continue;
            editor.getCaretModel().moveToOffset(this.myActualOffset);
            ShowIntentionActionsHandler.chooseActionAndInvoke(psiFile2, editor, action2, this.myActionText);
            return;
        }
    }

    @Override
    public void showAllActions(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.getCaretModel().moveToOffset(this.myActualOffset);
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"editor.project ?: return");
        Project project2 = project;
        TooltipActionsLogger.Companion.getShowAllEvent().log(project2);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiDocumentManager.getIn\u2026ditor.document) ?: return");
        PsiFile psiFile2 = psiFile;
        new ShowIntentionActionsHandler().invoke(project2, editor, psiFile2);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        DaemonTooltipAction info = (DaemonTooltipAction)other;
        return this.myActualOffset == info.myActualOffset && Intrinsics.areEqual((Object)this.myFixText, (Object)info.myFixText);
    }

    public int hashCode() {
        return Objects.hash(this.myFixText, this.myActualOffset);
    }

    public DaemonTooltipAction(@NlsActions.ActionText @NotNull String myFixText, @NlsContexts.Command @NotNull String myActionText, int myActualOffset) {
        Intrinsics.checkNotNullParameter((Object)myFixText, (String)"myFixText");
        Intrinsics.checkNotNullParameter((Object)myActionText, (String)"myActionText");
        this.myFixText = myFixText;
        this.myActionText = myActionText;
        this.myActualOffset = myActualOffset;
    }
}

