/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeEditor.printing.ExportToHTMLSettings;
import com.intellij.codeEditor.printing.PrintOption;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.OptionGroup;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class ExportToHTMLDialog
extends DialogWrapper {
    private JRadioButton myRbCurrentFile;
    private JRadioButton myRbSelectedText;
    private JRadioButton myRbCurrentPackage;
    private JCheckBox myCbIncludeSubpackages;
    private JCheckBox myCbLineNumbers;
    private JCheckBox myCbOpenInBrowser;
    private TextFieldWithBrowseButton myTargetDirectoryField;
    private final String myFileName;
    private final String myDirectoryName;
    private final boolean myIsSelectedTextEnabled;
    private final Project myProject;
    private final List<UnnamedConfigurable> myExtensions;

    public ExportToHTMLDialog(String fileName, String directoryName, boolean isSelectedTextEnabled, Project project) {
        super(project, true);
        this.myProject = project;
        this.setOKButtonText(EditorBundle.message((String)"export.to.html.save.button", (Object[])new Object[0]));
        this.myFileName = fileName;
        this.myDirectoryName = directoryName;
        this.myIsSelectedTextEnabled = isSelectedTextEnabled;
        this.setTitle(EditorBundle.message((String)"export.to.html.title", (Object[])new Object[0]));
        this.myExtensions = ContainerUtil.map((Collection)PrintOption.EP_NAME.getExtensionList(), PrintOption::createConfigurable);
        this.init();
    }

    protected JComponent createNorthPanel() {
        OptionGroup optionGroup = new OptionGroup();
        Object @NotNull [] params1 = new Object[]{this.myFileName != null ? this.myFileName : ""};
        this.myRbCurrentFile = new JRadioButton(EditorBundle.message((String)"export.to.html.file.name.radio", (Object[])params1));
        optionGroup.add((JComponent)this.myRbCurrentFile);
        this.myRbSelectedText = new JRadioButton(EditorBundle.message((String)"export.to.html.selected.text.radio", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myRbSelectedText);
        Object @NotNull [] params = new Object[]{this.myDirectoryName != null ? this.myDirectoryName : ""};
        this.myRbCurrentPackage = new JRadioButton(EditorBundle.message((String)"export.to.html.all.files.in.directory.radio", (Object[])params));
        optionGroup.add((JComponent)this.myRbCurrentPackage);
        this.myCbIncludeSubpackages = new JCheckBox(EditorBundle.message((String)"export.to.html.include.subdirectories.checkbox", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbIncludeSubpackages, true);
        FileTextField field = FileChooserFactory.getInstance().createFileTextField(FileChooserDescriptorFactory.createSingleFolderDescriptor(), this.myDisposable);
        this.myTargetDirectoryField = new TextFieldWithBrowseButton(field.getField());
        LabeledComponent<TextFieldWithBrowseButton> labeledComponent = ExportToHTMLDialog.assignLabel(this.myTargetDirectoryField, this.myProject);
        optionGroup.add(labeledComponent);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.myRbCurrentFile);
        buttonGroup2.add(this.myRbSelectedText);
        buttonGroup2.add(this.myRbCurrentPackage);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportToHTMLDialog.this.myCbIncludeSubpackages.setEnabled(ExportToHTMLDialog.this.myRbCurrentPackage.isSelected());
            }
        };
        this.myRbCurrentFile.addActionListener(actionListener);
        this.myRbSelectedText.addActionListener(actionListener);
        this.myRbCurrentPackage.addActionListener(actionListener);
        return optionGroup.createPanel();
    }

    public static LabeledComponent<TextFieldWithBrowseButton> assignLabel(TextFieldWithBrowseButton targetDirectoryField, Project project) {
        LabeledComponent labeledComponent = new LabeledComponent();
        labeledComponent.setText(EditorBundle.message((String)"export.to.html.output.directory.label", (Object[])new Object[0]));
        targetDirectoryField.addBrowseFolderListener(EditorBundle.message((String)"export.to.html.select.output.directory.title", (Object[])new Object[0]), EditorBundle.message((String)"export.to.html.select.output.directory.description", (Object[])new Object[0]), project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        labeledComponent.setComponent((JComponent)targetDirectoryField);
        return labeledComponent;
    }

    protected JComponent createCenterPanel() {
        OptionGroup optionGroup = new OptionGroup(EditorBundle.message((String)"export.to.html.options.group", (Object[])new Object[0]));
        this.myCbLineNumbers = new JCheckBox(EditorBundle.message((String)"export.to.html.options.show.line.numbers.checkbox", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbLineNumbers);
        for (UnnamedConfigurable printOption : this.myExtensions) {
            optionGroup.add(printOption.createComponent());
        }
        this.myCbOpenInBrowser = new JCheckBox(EditorBundle.message((String)"export.to.html.open.generated.html.checkbox", (Object[])new Object[0]));
        optionGroup.add((JComponent)this.myCbOpenInBrowser);
        return optionGroup.createPanel();
    }

    public void reset() {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myProject);
        this.myRbSelectedText.setEnabled(this.myIsSelectedTextEnabled);
        this.myRbSelectedText.setSelected(this.myIsSelectedTextEnabled);
        this.myRbCurrentFile.setEnabled(this.myFileName != null);
        this.myRbCurrentFile.setSelected(this.myFileName != null && !this.myIsSelectedTextEnabled);
        this.myRbCurrentPackage.setEnabled(this.myDirectoryName != null);
        this.myRbCurrentPackage.setSelected(this.myDirectoryName != null && !this.myIsSelectedTextEnabled && this.myFileName == null);
        this.myCbIncludeSubpackages.setSelected(exportToHTMLSettings.isIncludeSubdirectories());
        this.myCbIncludeSubpackages.setEnabled(this.myRbCurrentPackage.isSelected());
        this.myCbLineNumbers.setSelected(exportToHTMLSettings.PRINT_LINE_NUMBERS);
        this.myCbOpenInBrowser.setSelected(exportToHTMLSettings.OPEN_IN_BROWSER);
        this.myTargetDirectoryField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)exportToHTMLSettings.OUTPUT_DIRECTORY)));
        for (UnnamedConfigurable printOption : this.myExtensions) {
            printOption.reset();
        }
    }

    protected void dispose() {
        for (UnnamedConfigurable extension2 : this.myExtensions) {
            extension2.disposeUIResources();
        }
        super.dispose();
    }

    public void apply() throws ConfigurationException {
        ExportToHTMLSettings exportToHTMLSettings = ExportToHTMLSettings.getInstance(this.myProject);
        if (this.myRbCurrentFile.isSelected()) {
            exportToHTMLSettings.setPrintScope(1);
        } else if (this.myRbSelectedText.isSelected()) {
            exportToHTMLSettings.setPrintScope(2);
        } else if (this.myRbCurrentPackage.isSelected()) {
            exportToHTMLSettings.setPrintScope(4);
        }
        exportToHTMLSettings.setIncludeSubpackages(this.myCbIncludeSubpackages.isSelected());
        exportToHTMLSettings.PRINT_LINE_NUMBERS = this.myCbLineNumbers.isSelected();
        exportToHTMLSettings.OPEN_IN_BROWSER = this.myCbOpenInBrowser.isSelected();
        exportToHTMLSettings.OUTPUT_DIRECTORY = FileUtil.toSystemIndependentName((String)this.myTargetDirectoryField.getText());
        for (UnnamedConfigurable printOption : this.myExtensions) {
            printOption.apply();
        }
    }

    protected String getHelpId() {
        return "reference.file.exportToHtml";
    }
}

