/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build.output;

import com.intellij.build.FilePosition;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FileMessageEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.output.BuildOutputInstantReader;
import com.intellij.build.output.BuildOutputParser;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 42\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00100\u0012H\u0002J2\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000b\u0010\u0018\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00192\u000b\u0010\u001a\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001bH\u0002JJ\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u000b\u0010\u0018\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00192\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u000b\u0010\u001a\u001a\u00070\u0004\u00a2\u0006\u0002\b\u001bH\u0002J\u0015\u0010\"\u001a\u00020\u00172\u000b\u0010#\u001a\u00070\u0004\u00a2\u0006\u0002\b$H\u0003J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020)2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u00020*0\u0012H\u0016J\u0014\u0010+\u001a\u00020\u0004*\u00020\u00042\u0006\u0010(\u001a\u00020)H\u0002J\f\u0010,\u001a\u00020 *\u00020\u0004H\u0002J\u0014\u0010,\u001a\u00020 *\u00020\u00042\u0006\u0010-\u001a\u00020 H\u0002J\f\u0010.\u001a\u00020\u000e*\u00020\u0004H\u0002J\u0014\u0010/\u001a\u00020 *\u00020 2\u0006\u0010'\u001a\u00020\u0004H\u0002J\f\u00100\u001a\u00020\u000e*\u00020\u0004H\u0002J\u0014\u00101\u001a\u00020\u0004*\u00020\u00042\u0006\u00102\u001a\u00020 H\u0002J\u0014\u00103\u001a\u00020\u0004*\u00020\u00042\u0006\u00102\u001a\u00020 H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/build/output/KotlincOutputParser;", "Lcom/intellij/build/output/BuildOutputParser;", "()V", "COLON", "", "JAVAC_POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "getKAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "()Ljava/lang/String;", "KOTLIN_POSITION_PATTERN", "LINE_COLON_COLUMN_POSITION_PATTERN", "addMessage", "", "message", "Lcom/intellij/build/events/MessageEvent;", "consumer", "Ljava/util/function/Consumer;", "createMessage", "parentId", "", "messageKind", "Lcom/intellij/build/events/MessageEvent$Kind;", "text", "Lcom/intellij/build/events/BuildEventsNls$Message;", "detail", "Lcom/intellij/build/events/BuildEventsNls$Description;", "createMessageWithLocation", "Lcom/intellij/build/events/impl/FileMessageEventImpl;", "file", "lineNumber", "", "columnIndex", "getMessageKind", "kind", "Lorg/jetbrains/annotations/NonNls;", "isKaptErrorWhileAnnotationProcessing", "parse", "line", "reader", "Lcom/intellij/build/output/BuildOutputInstantReader;", "Lcom/intellij/build/events/BuildEvent;", "amendNextLinesIfNeeded", "colon", "skip", "isNextMessage", "skipDriveOnWin", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "Companion", "intellij.platform.lang.impl"})
public final class KotlincOutputParser
implements BuildOutputParser {
    private final String COLON;
    private final Pattern KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    private final Pattern JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
    private final Pattern LINE_COLON_COLUMN_POSITION_PATTERN = Pattern.compile("([0-9]*):([0-9]*)");
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean parse(@NotNull String line, @NotNull BuildOutputInstantReader reader, @NotNull Consumer<? super BuildEvent> consumer2) {
        Matcher it;
        boolean bl;
        boolean bl2;
        Matcher matcher;
        String position;
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(consumer2, (String)"consumer");
        int colonIndex1 = this.colon(line);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = this.substringBeforeAndTrim(line, colonIndex1);
        if (!this.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = this.substringAfterAndTrim(line, colonIndex1);
        int colonIndex2 = this.skipDriveOnWin(this.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 < 0) {
            return false;
        }
        String path = this.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
        File file2 = new File(path);
        String string = FilesKt.getExtension((File)file2);
        boolean bl3 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String fileExtension = string3;
        if (!file2.isFile() || Intrinsics.areEqual((Object)fileExtension, (Object)"kt") ^ true && Intrinsics.areEqual((Object)fileExtension, (Object)"kts") ^ true && Intrinsics.areEqual((Object)fileExtension, (Object)"java") ^ true) {
            String combinedMessage = this.amendNextLinesIfNeeded(lineWoSeverity, reader);
            Object object = reader.getParentEventId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
            return this.addMessage(this.createMessage(object, this.getMessageKind(severity), lineWoSeverity, combinedMessage), consumer2);
        }
        String lineWoPath = this.substringAfterAndTrim(lineWoSeverity, colonIndex2);
        int lineWoPositionIndex = -1;
        Matcher matcher2 = null;
        if (StringsKt.startsWith$default((CharSequence)lineWoPath, (char)'(', (boolean)false, (int)2, null)) {
            int colonIndex3 = this.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                lineWoPositionIndex = colonIndex3;
            }
            if (lineWoPositionIndex >= 0) {
                position = this.substringBeforeAndTrim(lineWoPath, lineWoPositionIndex);
                matcher = this.KOTLIN_POSITION_PATTERN.matcher(position);
                bl2 = false;
                bl = false;
                it = matcher;
                boolean bl4 = false;
                Matcher matcher3 = it.matches() ? matcher : null;
                if (matcher3 == null) {
                    matcher3 = this.JAVAC_POSITION_PATTERN.matcher(position);
                }
                matcher2 = matcher3;
            }
        } else {
            int colonIndex4 = this.colon(lineWoPath, 1);
            lineWoPositionIndex = colonIndex4 >= 0 ? colonIndex4 : this.colon(lineWoPath);
            if (lineWoPositionIndex >= 0) {
                position = this.substringBeforeAndTrim(lineWoPath, colonIndex4);
                matcher = this.LINE_COLON_COLUMN_POSITION_PATTERN.matcher(position);
                bl2 = false;
                bl = false;
                it = matcher;
                boolean bl5 = false;
                Matcher matcher4 = it.matches() ? matcher : null;
                if (matcher4 == null) {
                    matcher4 = matcher2 = this.JAVAC_POSITION_PATTERN.matcher(position);
                }
            }
        }
        if (lineWoPositionIndex >= 0) {
            String relatedNextLines = this.amendNextLinesIfNeeded("", reader);
            String message2 = this.substringAfterAndTrim(lineWoPath, lineWoPositionIndex) + relatedNextLines;
            String details = line + relatedNextLines;
            if (matcher2 != null && matcher2.matches()) {
                String symbolNumber;
                String lineNumber = matcher2.group(1);
                String string4 = symbolNumber = matcher2.groupCount() >= 2 ? matcher2.group(2) : "1";
                if (lineNumber != null) {
                    String string5 = symbolNumber;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"symbolNumber");
                    String string6 = string5;
                    boolean bl6 = false;
                    int symbolNumberText = Integer.parseInt(string6);
                    Object object = reader.getParentEventId();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
                    string6 = lineNumber;
                    bl6 = false;
                    return this.addMessage(this.createMessageWithLocation(object, this.getMessageKind(severity), message2, path, Integer.parseInt(string6), symbolNumberText, details), consumer2);
                }
            }
            Object object = reader.getParentEventId();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
            return this.addMessage(this.createMessage(object, this.getMessageKind(severity), message2, details), consumer2);
        }
        String combinedMessage = this.amendNextLinesIfNeeded(lineWoSeverity, reader);
        Object object = reader.getParentEventId();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reader.parentEventId");
        return this.addMessage(this.createMessage(object, this.getMessageKind(severity), lineWoSeverity, combinedMessage), consumer2);
    }

    private final String amendNextLinesIfNeeded(String $this$amendNextLinesIfNeeded, BuildOutputInstantReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder2 = new StringBuilder($this$amendNextLinesIfNeeded);
        while (nextLine != null) {
            if (this.isNextMessage(nextLine)) {
                reader.pushBack();
                break;
            }
            builder2.append("\n").append(nextLine);
            nextLine = reader.readLine();
        }
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNextMessage(String $this$isNextMessage) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$this$isNextMessage, (String)this.COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string = $this$isNextMessage;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, colonIndex1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (this.startsWithSeverityPrefix(string3)) return true;
        }
        if (StringUtil.startsWith((CharSequence)$this$isNextMessage, (CharSequence)"Note: ")) return true;
        if (StringUtil.startsWith((CharSequence)$this$isNextMessage, (CharSequence)"> Task :")) return true;
        if (StringUtil.containsIgnoreCase((String)$this$isNextMessage, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$this$isNextMessage, (String)"FAILED")) return false;
        return true;
    }

    private final boolean startsWithSeverityPrefix(String $this$startsWithSeverityPrefix) {
        return this.getMessageKind($this$startsWithSeverityPrefix) != MessageEvent.Kind.SIMPLE;
    }

    @NonNls
    private final MessageEvent.Kind getMessageKind(String kind) {
        MessageEvent.Kind kind2;
        switch (kind) {
            case "e": {
                kind2 = MessageEvent.Kind.ERROR;
                break;
            }
            case "w": {
                kind2 = MessageEvent.Kind.WARNING;
                break;
            }
            case "i": {
                kind2 = MessageEvent.Kind.INFO;
                break;
            }
            case "v": {
                kind2 = MessageEvent.Kind.SIMPLE;
                break;
            }
            default: {
                kind2 = MessageEvent.Kind.SIMPLE;
            }
        }
        return kind2;
    }

    private final String substringAfterAndTrim(String $this$substringAfterAndTrim, int index2) {
        String string = $this$substringAfterAndTrim;
        int n = index2 + 1;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        string = string3;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private final String substringBeforeAndTrim(String $this$substringBeforeAndTrim, int index2) {
        String string = $this$substringBeforeAndTrim;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, index2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        string = string3;
        n = 0;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string4)).toString();
    }

    private final int colon(String $this$colon) {
        return StringsKt.indexOf$default((CharSequence)$this$colon, (String)this.COLON, (int)0, (boolean)false, (int)6, null);
    }

    private final int colon(String $this$colon, int skip) {
        int index2 = -1;
        int n = skip + 1;
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            boolean bl2 = false;
            if ((index2 = StringsKt.indexOf$default((CharSequence)$this$colon, (String)this.COLON, (int)(index2 + 1), (boolean)false, (int)4, null)) >= 0) continue;
            return index2;
        }
        return index2;
    }

    private final int skipDriveOnWin(int $this$skipDriveOnWin, String line) {
        return $this$skipDriveOnWin == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)this.COLON, (int)($this$skipDriveOnWin + 1), (boolean)false, (int)4, null) : $this$skipDriveOnWin;
    }

    private final String getKAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT() {
        return "org.jetbrains.kotlin.kapt3.diagnostic.KaptError: " + LangBundle.message((String)"kapterror.error.while.annotation.processing", (Object[])new Object[0]);
    }

    private final boolean isKaptErrorWhileAnnotationProcessing(MessageEvent message2) {
        if (message2.getKind() != MessageEvent.Kind.ERROR) {
            return false;
        }
        String string = message2.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.message");
        String messageText = string;
        String string2 = IllegalStateException.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IllegalStateException::class.java.name");
        return StringsKt.startsWith$default((String)messageText, (String)string2, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)this.getKAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT(), (boolean)false, (int)2, null);
    }

    private final boolean addMessage(MessageEvent message2, Consumer<? super MessageEvent> consumer2) {
        if (this.isKaptErrorWhileAnnotationProcessing(message2)) {
            return true;
        }
        consumer2.accept((MessageEvent)message2);
        return true;
    }

    private final MessageEvent createMessage(Object parentId, MessageEvent.Kind messageKind, String text2, String detail) {
        String string = text2;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return new MessageEventImpl(parentId, messageKind, KotlincOutputParser.Companion.getCOMPILER_MESSAGES_GROUP(), ((Object)StringsKt.trim((CharSequence)string2)).toString(), detail);
    }

    private final FileMessageEventImpl createMessageWithLocation(Object parentId, MessageEvent.Kind messageKind, String text2, String file2, int lineNumber, int columnIndex, String detail) {
        String string = text2;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return new FileMessageEventImpl(parentId, messageKind, KotlincOutputParser.Companion.getCOMPILER_MESSAGES_GROUP(), ((Object)StringsKt.trim((CharSequence)string2)).toString(), detail, new FilePosition(new File(file2), lineNumber - 1, columnIndex - 1));
    }

    public KotlincOutputParser() {
        this.COLON = ":";
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/build/output/KotlincOutputParser$Companion;", "", "()V", "COMPILER_MESSAGES_GROUP", "", "Lcom/intellij/build/events/BuildEventsNls$Title;", "getCOMPILER_MESSAGES_GROUP", "()Ljava/lang/String;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @BuildEventsNls.Title
        private final String getCOMPILER_MESSAGES_GROUP() {
            String string = LangBundle.message((String)"build.event.title.kotlin.compiler", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"LangBundle.message(\"buil\u2026t.title.kotlin.compiler\")");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

