/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildConsoleView;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.BuildProgressStripe;
import com.intellij.build.BuildTextConsoleView;
import com.intellij.build.BuildTreeFilters;
import com.intellij.build.BuildViewSettingsProvider;
import com.intellij.build.BuildWorkspaceConfiguration;
import com.intellij.build.CompositeView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.ExecutionNode;
import com.intellij.build.FileNavigatable;
import com.intellij.build.FilePosition;
import com.intellij.build.Filterable;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.BuildEventPresentationData;
import com.intellij.build.events.BuildEventsNls;
import com.intellij.build.events.DerivedResult;
import com.intellij.build.events.DuplicateMessageAware;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.FileMessageEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.FinishEvent;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.OutputBuildEvent;
import com.intellij.build.events.PresentableBuildEvent;
import com.intellij.build.events.ProgressBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.build.events.StartEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.OccurenceNavigatorSupport;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.tree.ui.DefaultTreeUI;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;

public class BuildTreeConsoleView
implements ConsoleView,
DataProvider,
BuildConsoleView,
Filterable<ExecutionNode>,
OccurenceNavigator {
    private static final Logger LOG = Logger.getInstance(BuildTreeConsoleView.class);
    @NonNls
    private static final String TREE = "tree";
    @NonNls
    private static final String SPLITTER_PROPERTY = "BuildView.Splitter.Proportion";
    private final JPanel myPanel;
    private final Map<Object, ExecutionNode> nodesMap;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DefaultBuildDescriptor myBuildDescriptor;
    @NotNull
    private final String myWorkingDir;
    private final ConsoleViewHandler myConsoleViewHandler;
    private final AtomicBoolean myFinishedBuildEventReceived;
    private final AtomicBoolean myDisposed;
    private final AtomicBoolean myShownFirstError;
    private final AtomicBoolean myExpandedFirstMessage;
    private final boolean myNavigateToTheFirstErrorLocation;
    private final StructureTreeModel<AbstractTreeStructure> myTreeModel;
    private final Tree myTree;
    private final ExecutionNode myRootNode;
    private final ExecutionNode myBuildProgressRootNode;
    private final Set<Predicate<? super ExecutionNode>> myNodeFilters;
    private final ProblemOccurrenceNavigatorSupport myOccurrenceNavigatorSupport;
    private final Set<BuildEvent> myDeferredEvents;

    public BuildTreeConsoleView(@NotNull Project project, @NotNull BuildDescriptor buildDescriptor, @Nullable ExecutionConsole executionConsole, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
        if (project == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(0);
        }
        if (buildDescriptor == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(1);
        }
        if (buildViewSettingsProvider == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(2);
        }
        this.myPanel = new JPanel();
        this.nodesMap = new ConcurrentHashMap<Object, ExecutionNode>();
        this.myFinishedBuildEventReceived = new AtomicBoolean();
        this.myDisposed = new AtomicBoolean();
        this.myShownFirstError = new AtomicBoolean();
        this.myExpandedFirstMessage = new AtomicBoolean();
        this.myDeferredEvents = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        this.myBuildDescriptor = buildDescriptor instanceof DefaultBuildDescriptor ? (DefaultBuildDescriptor)buildDescriptor : new DefaultBuildDescriptor(buildDescriptor);
        this.myNodeFilters = ContainerUtil.newConcurrentSet();
        this.myWorkingDir = FileUtil.toSystemIndependentName((String)buildDescriptor.getWorkingDir());
        this.myNavigateToTheFirstErrorLocation = ((BuildWorkspaceConfiguration)project.getService(BuildWorkspaceConfiguration.class)).isShowFirstErrorInEditor();
        this.myRootNode = new ExecutionNode(this.myProject, null, true, this::isCorrectThread);
        this.myBuildProgressRootNode = new ExecutionNode(this.myProject, this.myRootNode, true, this::isCorrectThread);
        this.myRootNode.setFilter(this.getFilter());
        this.myRootNode.add(this.myBuildProgressRootNode);
        MyTreeStructure treeStructure = new MyTreeStructure();
        this.myTreeModel = new StructureTreeModel<MyTreeStructure>(treeStructure, null, Invoker.forBackgroundThreadWithoutReadAction((Disposable)this), (Disposable)this);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), (Disposable)this);
        asyncTreeModel.addTreeModelListener(new ExecutionNodeAutoExpandingListener());
        this.myTree = BuildTreeConsoleView.initTree(asyncTreeModel);
        JPanel myContentPanel = new JPanel();
        myContentPanel.setLayout(new CardLayout());
        myContentPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree, (int)0), TREE);
        this.myPanel.setLayout(new BorderLayout());
        OnePixelSplitter myThreeComponentsSplitter = new OnePixelSplitter(SPLITTER_PROPERTY, 0.33f);
        myThreeComponentsSplitter.setFirstComponent((JComponent)myContentPanel);
        List<Filter> filters = this.myBuildDescriptor.getExecutionFilters();
        this.myConsoleViewHandler = new ConsoleViewHandler(this.myProject, this.myTree, this.myBuildProgressRootNode, (Disposable)this, executionConsole, filters, buildViewSettingsProvider);
        myThreeComponentsSplitter.setSecondComponent(this.myConsoleViewHandler.getComponent());
        this.myPanel.add((Component)myThreeComponentsSplitter, "Center");
        BuildTreeFilters.install(this);
        this.myOccurrenceNavigatorSupport = new ProblemOccurrenceNavigatorSupport(this.myTree);
    }

    private boolean isCorrectThread() {
        if (this.myTreeModel != null) {
            return this.myTreeModel.getInvoker().isValidThread();
        }
        return true;
    }

    private void installContextMenu() {
        UIUtil.invokeLaterIfNeeded(() -> {
            final DefaultActionGroup rerunActionGroup = new DefaultActionGroup();
            List<AnAction> restartActions = this.myBuildDescriptor.getRestartActions();
            rerunActionGroup.addAll(restartActions);
            if (!restartActions.isEmpty()) {
                rerunActionGroup.addSeparator();
            }
            final DefaultActionGroup sourceActionGroup = new DefaultActionGroup();
            EditSourceAction edit = new EditSourceAction();
            ActionUtil.copyFrom((AnAction)edit, (String)"EditSource");
            sourceActionGroup.add((AnAction)edit);
            final DefaultActionGroup filteringActionsGroup = BuildTreeFilters.createFilteringActionsGroup(this);
            final DefaultActionGroup navigationActionGroup = new DefaultActionGroup();
            CommonActionsManager actionsManager = CommonActionsManager.getInstance();
            AnAction prevAction = actionsManager.createPrevOccurenceAction((OccurenceNavigator)this);
            navigationActionGroup.add(prevAction);
            AnAction nextAction = actionsManager.createNextOccurenceAction((OccurenceNavigator)this);
            navigationActionGroup.add(nextAction);
            this.myTree.addMouseListener((MouseListener)new PopupHandler(){

                public void invokePopup(Component comp, int x, int y) {
                    ExecutionNode selectedNode;
                    List<AnAction> contextActions;
                    DefaultActionGroup group2 = new DefaultActionGroup();
                    group2.addAll((ActionGroup)rerunActionGroup);
                    group2.addAll((ActionGroup)sourceActionGroup);
                    group2.addSeparator();
                    ExecutionNode[] selectedNodes = BuildTreeConsoleView.this.getSelectedNodes();
                    if (selectedNodes.length == 1 && !(contextActions = BuildTreeConsoleView.this.myBuildDescriptor.getContextActions(selectedNode = selectedNodes[0])).isEmpty()) {
                        group2.addAll(contextActions);
                        group2.addSeparator();
                    }
                    group2.addAll((ActionGroup)filteringActionsGroup);
                    group2.addSeparator();
                    group2.addAll((ActionGroup)navigationActionGroup);
                    ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("BuildView", (ActionGroup)group2);
                    popupMenu.setTargetComponent((JComponent)BuildTreeConsoleView.this.myTree);
                    JPopupMenu menu = popupMenu.getComponent();
                    menu.show(comp, x, y);
                }
            });
        });
    }

    public void clear() {
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> {
            this.getRootElement().removeChildren();
            this.nodesMap.clear();
            this.myConsoleViewHandler.clear();
        });
        this.scheduleUpdate(this.getRootElement(), true);
    }

    @Override
    public boolean isFilteringEnabled() {
        return true;
    }

    @Override
    @NotNull
    public Predicate<ExecutionNode> getFilter() {
        Predicate<ExecutionNode> predicate2 = executionNode -> executionNode == this.getBuildProgressRootNode() || executionNode.isRunning() || executionNode.isFailed() || this.myNodeFilters.stream().anyMatch(predicate2 -> predicate2.test(executionNode));
        if (predicate2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(3);
        }
        return predicate2;
    }

    @Override
    public void addFilter(@NotNull Predicate<? super ExecutionNode> executionTreeFilter) {
        if (executionTreeFilter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(4);
        }
        this.myNodeFilters.add(executionTreeFilter);
        this.updateFilter();
    }

    @Override
    public void removeFilter(@NotNull Predicate<? super ExecutionNode> filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(5);
        }
        this.myNodeFilters.remove(filter);
        this.updateFilter();
    }

    @Override
    public boolean contains(@NotNull Predicate<? super ExecutionNode> filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(6);
        }
        return this.myNodeFilters.contains(filter);
    }

    private void updateFilter() {
        ExecutionNode rootElement = this.getRootElement();
        this.myTreeModel.getInvoker().runOrInvokeLater(() -> {
            rootElement.setFilter(this.getFilter());
            this.scheduleUpdate(rootElement, true);
        });
    }

    private ExecutionNode getRootElement() {
        return this.myRootNode;
    }

    private ExecutionNode getBuildProgressRootNode() {
        return this.myBuildProgressRootNode;
    }

    public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
        if (text2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(7);
        }
        if (contentType == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(8);
        }
    }

    @Nullable
    private ExecutionNode getOrMaybeCreateParentNode(@NotNull BuildEvent event) {
        ExecutionNode parentNode;
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(9);
        }
        ExecutionNode executionNode = parentNode = event.getParentId() == null ? null : this.nodesMap.get(event.getParentId());
        if (event instanceof MessageEvent && (parentNode = this.createMessageParentNodes((MessageEvent)event, parentNode)) != null) {
            this.scheduleUpdate(parentNode, true);
        }
        return parentNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onEventInternal(@NotNull Object buildId, @NotNull BuildEvent event) {
        boolean isMessageEvent;
        Runnable selectErrorNodeTask;
        ExecutionNode buildProgressRootNode;
        ExecutionNode currentNode;
        SmartHashSet structureChanged;
        block38: {
            Object eventId;
            block34: {
                ExecutionNode parentNode;
                block35: {
                    Navigatable messageEventNavigatable;
                    MessageEvent messageEvent;
                    block36: {
                        Iterator iterator2;
                        block37: {
                            block32: {
                                block33: {
                                    if (buildId == null) {
                                        BuildTreeConsoleView.$$$reportNull$$$0(10);
                                    }
                                    if (event == null) {
                                        BuildTreeConsoleView.$$$reportNull$$$0(11);
                                    }
                                    structureChanged = new SmartHashSet();
                                    parentNode = this.getOrMaybeCreateParentNode(event);
                                    eventId = event.getId();
                                    currentNode = this.nodesMap.get(eventId);
                                    buildProgressRootNode = this.getBuildProgressRootNode();
                                    selectErrorNodeTask = null;
                                    isMessageEvent = event instanceof MessageEvent;
                                    if (!(event instanceof StartEvent) && !isMessageEvent) break block32;
                                    if (currentNode != null) {
                                        LOG.warn("start event id collision found:" + eventId + ", was also in node: " + currentNode.getTitle());
                                        return;
                                    }
                                    if (event instanceof DuplicateMessageAware) {
                                        if (!this.myFinishedBuildEventReceived.get()) {
                                            this.myDeferredEvents.add(event);
                                            return;
                                        }
                                        if (parentNode != null && parentNode.findFirstChild(node -> event.getMessage().equals(node.getName())) != null) {
                                            return;
                                        }
                                    }
                                    if (!(event instanceof StartBuildEvent)) break block33;
                                    currentNode = buildProgressRootNode;
                                    this.installContextMenu();
                                    currentNode.setTitle(this.myBuildDescriptor.getTitle());
                                    break block34;
                                }
                                currentNode = new ExecutionNode(this.myProject, parentNode, false, this::isCorrectThread);
                                if (!isMessageEvent) break block35;
                                currentNode.setAlwaysLeaf(event instanceof FileMessageEvent);
                                messageEvent = (MessageEvent)event;
                                currentNode.setStartTime(messageEvent.getEventTime());
                                ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setEndTime(messageEvent.getEventTime())));
                                messageEventNavigatable = messageEvent.getNavigatable(this.myProject);
                                currentNode.setNavigatable(messageEventNavigatable);
                                MessageEventResult messageEventResult = messageEvent.getResult();
                                ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setResult((EventResult)messageEventResult)));
                                if (!(messageEventResult instanceof FailureResult)) break block36;
                                iterator2 = ((FailureResult)messageEventResult).getFailures().iterator();
                                break block37;
                            }
                            boolean isProgress = event instanceof ProgressBuildEvent;
                            currentNode = this.nodesMap.get(eventId);
                            if (currentNode == null) {
                                if (isProgress) {
                                    currentNode = new ExecutionNode(this.myProject, parentNode, parentNode == buildProgressRootNode, this::isCorrectThread);
                                    this.nodesMap.put(eventId, currentNode);
                                    if (parentNode != null) {
                                        structureChanged.add((Object)parentNode);
                                        parentNode.add(currentNode);
                                    }
                                } else if (event instanceof OutputBuildEvent && parentNode != null) {
                                    this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                                } else if (event instanceof PresentableBuildEvent) {
                                    currentNode = this.addAsPresentableEventNode((PresentableBuildEvent)event, (SmartHashSet<ExecutionNode>)structureChanged, parentNode, eventId, buildProgressRootNode);
                                }
                            }
                            if (isProgress) {
                                ProgressBuildEvent progressBuildEvent = (ProgressBuildEvent)event;
                                long total = progressBuildEvent.getTotal();
                                long progress2 = progressBuildEvent.getProgress();
                                if (currentNode == this.myBuildProgressRootNode) {
                                    this.myConsoleViewHandler.updateProgressBar(total, progress2);
                                }
                            }
                            break block38;
                        }
                        while (iterator2.hasNext()) {
                            Failure failure = (Failure)iterator2.next();
                            selectErrorNodeTask = selectErrorNodeTask != null ? selectErrorNodeTask : this.showErrorIfFirst(currentNode, failure.getNavigatable());
                        }
                    }
                    if (messageEvent.getKind() == MessageEvent.Kind.ERROR) {
                        Runnable runnable2 = selectErrorNodeTask = selectErrorNodeTask != null ? selectErrorNodeTask : this.showErrorIfFirst(currentNode, messageEventNavigatable);
                    }
                    if (parentNode != null) {
                        if (parentNode != buildProgressRootNode) {
                            this.myConsoleViewHandler.addOutput(parentNode, buildId, event);
                            this.myConsoleViewHandler.addOutput(parentNode, "\n", true);
                        }
                        this.reportMessageKind(messageEvent.getKind(), parentNode);
                    }
                    this.myConsoleViewHandler.addOutput(currentNode, buildId, event);
                }
                if (parentNode != null) {
                    structureChanged.add((Object)parentNode);
                    parentNode.add(currentNode);
                }
            }
            this.nodesMap.put(eventId, currentNode);
        }
        if (currentNode == null) {
            return;
        }
        currentNode.setName(event.getMessage());
        currentNode.setHint(event.getHint());
        if (currentNode.getStartTime() == 0L) {
            currentNode.setStartTime(event.getEventTime());
        }
        if (event instanceof FinishEvent) {
            EventResult result2 = ((FinishEvent)event).getResult();
            if (result2 instanceof DerivedResult) {
                result2 = BuildTreeConsoleView.calculateDerivedResult((DerivedResult)result2, currentNode);
            }
            ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setResult(result2)));
            ContainerUtil.addIfNotNull((Collection)structureChanged, (Object)((Object)currentNode.setEndTime(event.getEventTime())));
            SkippedResultImpl skippedResult = new SkippedResultImpl();
            BuildTreeConsoleView.finishChildren((Set<? super ExecutionNode>)structureChanged, currentNode, (EventResult)skippedResult);
            if (result2 instanceof FailureResult) {
                for (Failure failure : ((FailureResult)result2).getFailures()) {
                    Runnable task2 = this.addChildFailureNode(currentNode, failure, event.getMessage(), event.getEventTime(), (Set<? super ExecutionNode>)structureChanged);
                    if (selectErrorNodeTask != null) continue;
                    selectErrorNodeTask = task2;
                }
            }
        }
        if (event instanceof FinishBuildEvent) {
            this.myFinishedBuildEventReceived.set(true);
            Object aHint = event.getHint();
            String time = DateFormatUtil.formatDateTime((long)event.getEventTime());
            aHint = aHint == null ? LangBundle.message((String)"build.event.message.at", (Object[])new Object[]{time}) : LangBundle.message((String)"build.event.message.0.at.1", (Object[])new Object[]{aHint, time});
            currentNode.setHint((String)aHint);
            this.myDeferredEvents.forEach(buildEvent -> this.onEventInternal(buildId, (BuildEvent)buildEvent));
            if (this.myConsoleViewHandler.myExecutionNode == null) {
                this.invokeLater(() -> this.myConsoleViewHandler.setNode(buildProgressRootNode));
            }
            this.myConsoleViewHandler.stopProgressBar();
        }
        if (structureChanged.isEmpty()) {
            this.scheduleUpdate(currentNode, false);
        } else {
            for (ExecutionNode node2 : structureChanged) {
                this.scheduleUpdate(node2, true);
            }
        }
        if (selectErrorNodeTask != null) {
            this.myExpandedFirstMessage.set(true);
            Runnable finalSelectErrorTask = selectErrorNodeTask;
            this.myTreeModel.invalidate((Object)this.getRootElement(), true).onProcessed(p -> finalSelectErrorTask.run());
            return;
        }
        if (!isMessageEvent) return;
        if (!this.myExpandedFirstMessage.compareAndSet(false, true)) return;
        ExecutionNode finalCurrentNode = currentNode;
        this.myTreeModel.invalidate((Object)this.getRootElement(), false).onProcessed(p -> TreeUtil.promiseMakeVisible((JTree)this.myTree, (TreeVisitor)BuildTreeConsoleView.visitor(finalCurrentNode)));
    }

    @NotNull
    private ExecutionNode addAsPresentableEventNode(@NotNull PresentableBuildEvent event, @NotNull SmartHashSet<ExecutionNode> structureChanged, @Nullable ExecutionNode parentNode, @NotNull Object eventId, @NotNull ExecutionNode buildProgressRootNode) {
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(12);
        }
        if (structureChanged == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(13);
        }
        if (eventId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(14);
        }
        if (buildProgressRootNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(15);
        }
        ExecutionNode executionNode = new ExecutionNode(this.myProject, parentNode, parentNode == buildProgressRootNode, this::isCorrectThread);
        BuildEventPresentationData presentationData = event.getPresentationData();
        executionNode.applyFrom(presentationData);
        this.nodesMap.put(eventId, executionNode);
        if (parentNode != null) {
            structureChanged.add((Object)parentNode);
            parentNode.add(executionNode);
        }
        this.myConsoleViewHandler.maybeAddExecutionConsole(executionNode, presentationData);
        ExecutionNode executionNode2 = executionNode;
        if (executionNode2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(16);
        }
        return executionNode2;
    }

    @ApiStatus.Internal
    @TestOnly
    @Nullable
    public ExecutionConsole getSelectedNodeConsole() {
        ExecutionConsole console2 = this.myConsoleViewHandler.getCurrentConsole();
        if (console2 instanceof ConsoleViewImpl) {
            ((ConsoleViewImpl)console2).flushDeferredText();
        }
        return console2;
    }

    private static EventResult calculateDerivedResult(DerivedResult result2, ExecutionNode node) {
        if (node.getResult() != null) {
            return node.getResult();
        }
        if (node.isFailed()) {
            return result2.createFailureResult();
        }
        return result2.createDefaultResult();
    }

    private void reportMessageKind(@NotNull MessageEvent.Kind eventKind, @NotNull ExecutionNode parentNode) {
        if (eventKind == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(17);
        }
        if (parentNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(18);
        }
        if (eventKind == MessageEvent.Kind.ERROR || eventKind == MessageEvent.Kind.WARNING || eventKind == MessageEvent.Kind.INFO) {
            ExecutionNode executionNode = parentNode;
            do {
                ExecutionNode updatedRoot;
                if ((updatedRoot = executionNode.reportChildMessageKind(eventKind)) != null) {
                    this.scheduleUpdate(updatedRoot, true);
                    continue;
                }
                this.scheduleUpdate(executionNode, false);
            } while ((executionNode = executionNode.getParent()) != null);
            this.scheduleUpdate(this.getRootElement(), false);
        }
    }

    @Nullable
    private Runnable showErrorIfFirst(@NotNull ExecutionNode node, @Nullable Navigatable navigatable) {
        if (node == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(19);
        }
        if (this.myShownFirstError.compareAndSet(false, true)) {
            return () -> {
                TreeUtil.promiseSelect((JTree)this.myTree, (TreeVisitor)BuildTreeConsoleView.visitor(node));
                if (this.myNavigateToTheFirstErrorLocation && navigatable != null && navigatable != NonNavigatable.INSTANCE) {
                    ApplicationManager.getApplication().invokeLater(() -> navigatable.navigate(true), ModalityState.defaultModalityState(), this.myProject.getDisposed());
                }
            };
        }
        return null;
    }

    public boolean hasNextOccurence() {
        return this.myOccurrenceNavigatorSupport.hasNextOccurence();
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.hasPreviousOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurrenceNavigatorSupport.goNextOccurence();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurrenceNavigatorSupport.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getNextOccurenceActionName();
        if (string == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurrenceNavigatorSupport.getPreviousOccurenceActionName();
        if (string == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static TreeVisitor visitor(@NotNull ExecutionNode executionNode) {
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(22);
        }
        TreePath treePath = TreePathUtil.pathToCustomNode(executionNode, node -> node.getParent());
        return new TreeVisitor.ByTreePath(treePath, o -> (ExecutionNode)((Object)((Object)TreeUtil.getUserObject((Object)o))));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private Runnable addChildFailureNode(@NotNull ExecutionNode parentNode, @NotNull Failure failure, @NotNull String defaultFailureMessage, long eventTime, @NotNull Set<? super ExecutionNode> set2) {
        void structureChanged;
        List<Failure> failures;
        EventResult result2;
        String message2;
        if (parentNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(23);
        }
        if (failure == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(24);
        }
        if (defaultFailureMessage == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(25);
        }
        if (set2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(26);
        }
        if ((message2 = (String)ObjectUtils.chooseNotNull((Object)failure.getMessage(), (Object)failure.getDescription())) == null && failure.getError() != null) {
            message2 = failure.getError().getMessage();
        }
        if (message2 == null) {
            message2 = defaultFailureMessage;
        }
        String failureNodeName = BuildConsoleUtils.getMessageTitle(message2);
        Navigatable failureNavigatable = failure.getNavigatable();
        FilePosition filePosition = null;
        if (failureNavigatable instanceof OpenFileDescriptor) {
            OpenFileDescriptor fileDescriptor = (OpenFileDescriptor)failureNavigatable;
            File file2 = VfsUtilCore.virtualToIoFile((VirtualFile)fileDescriptor.getFile());
            filePosition = new FilePosition(file2, fileDescriptor.getLine(), fileDescriptor.getColumn());
            parentNode = this.createMessageParentNodes(eventTime, filePosition, failureNavigatable, parentNode);
        } else if (failureNavigatable instanceof FileNavigatable) {
            filePosition = ((FileNavigatable)failureNavigatable).getFilePosition();
            parentNode = this.createMessageParentNodes(eventTime, filePosition, failureNavigatable, parentNode);
        }
        ExecutionNode failureNode = parentNode.findFirstChild(executionNode -> failureNodeName.equals(executionNode.getName()));
        if (failureNode == null) {
            failureNode = new ExecutionNode(this.myProject, parentNode, true, this::isCorrectThread);
            failureNode.setName(failureNodeName);
            if (filePosition != null && filePosition.getStartLine() >= 0) {
                String hint = ":" + (filePosition.getStartLine() + 1);
                failureNode.setHint(hint);
            }
            parentNode.add(failureNode);
            this.reportMessageKind(MessageEvent.Kind.ERROR, parentNode);
        }
        if (failureNavigatable != null && failureNavigatable != NonNavigatable.INSTANCE) {
            failureNode.setNavigatable(failureNavigatable);
        }
        if ((result2 = failureNode.getResult()) instanceof FailureResult) {
            failures = new ArrayList<Failure>(((FailureResult)result2).getFailures());
            failures.add(failure);
        } else {
            failures = Collections.singletonList(failure);
        }
        ExecutionNode updatedRoot = failureNode.setResult((EventResult)new FailureResultImpl(failures));
        if (updatedRoot == null) {
            updatedRoot = parentNode;
        }
        structureChanged.add(updatedRoot);
        this.myConsoleViewHandler.addOutput(failureNode, failure);
        return this.showErrorIfFirst(failureNode, failureNavigatable);
    }

    private static void finishChildren(@NotNull Set<? super ExecutionNode> structureChanged, @NotNull ExecutionNode node, @NotNull EventResult result2) {
        List<ExecutionNode> childList;
        if (structureChanged == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(27);
        }
        if (node == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(28);
        }
        if (result2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(29);
        }
        if ((childList = node.getChildList()).isEmpty()) {
            return;
        }
        for (ExecutionNode child2 : new ArrayList<ExecutionNode>(childList)) {
            if (!child2.isRunning()) continue;
            BuildTreeConsoleView.finishChildren(structureChanged, child2, result2);
            ContainerUtil.addIfNotNull(structureChanged, (Object)((Object)child2.setResult(result2)));
        }
    }

    public void scrollTo(int offset) {
    }

    public void attachToProcess(@NotNull ProcessHandler processHandler2) {
        if (processHandler2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(30);
        }
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value2) {
    }

    public boolean hasDeferredOutput() {
        return false;
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(31);
        }
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(32);
        }
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(33);
        }
    }

    public void printHyperlink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        if (hyperlinkText == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(34);
        }
    }

    public int getContentSize() {
        return 0;
    }

    public boolean canPause() {
        return false;
    }

    public AnAction @NotNull [] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(35);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel2 = this.myPanel;
        if (jPanel2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(36);
        }
        return jPanel2;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTree;
    }

    public void dispose() {
        this.myDisposed.set(true);
    }

    public boolean isDisposed() {
        return this.myDisposed.get();
    }

    public void onEvent(@NotNull Object buildId, @NotNull BuildEvent event) {
        if (buildId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(37);
        }
        if (event == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(38);
        }
        this.myTreeModel.getInvoker().invoke(() -> this.onEventInternal(buildId, event));
    }

    void scheduleUpdate(ExecutionNode executionNode, boolean parentStructureChanged) {
        ExecutionNode node = executionNode.getParent() == null || !parentStructureChanged ? executionNode : executionNode.getParent();
        this.myTreeModel.invalidate((Object)node, parentStructureChanged);
    }

    private ExecutionNode createMessageParentNodes(MessageEvent messageEvent, ExecutionNode parentNode) {
        Object messageEventParentId = messageEvent.getParentId();
        if (messageEventParentId == null) {
            return null;
        }
        if (messageEvent instanceof FileMessageEvent) {
            return this.createMessageParentNodes(messageEvent.getEventTime(), ((FileMessageEvent)messageEvent).getFilePosition(), messageEvent.getNavigatable(this.myProject), parentNode);
        }
        return parentNode;
    }

    private ExecutionNode createMessageParentNodes(long eventTime, @NotNull FilePosition filePosition, @Nullable Navigatable navigatable, ExecutionNode executionNode) {
        File userHomeDir;
        ExecutionNode parentNode;
        if (filePosition == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(39);
        }
        String filePath = FileUtil.toSystemIndependentName((String)filePosition.getFile().getPath());
        String parentsPath = "";
        String relativePath = FileUtil.getRelativePath((String)this.myWorkingDir, (String)filePath, (char)'/');
        if (relativePath != null) {
            if (relativePath.equals(".")) {
                return parentNode;
            }
            if (!relativePath.startsWith("../../")) {
                parentsPath = this.myWorkingDir;
            }
        }
        relativePath = StringUtil.isEmpty((String)parentsPath) ? (FileUtil.isAncestor((File)(userHomeDir = new File(SystemProperties.getUserHome())), (File)new File(filePath), (boolean)true) ? FileUtil.getLocationRelativeToUserHome((String)filePath, (boolean)false) : filePath) : BuildTreeConsoleView.getRelativePath(parentsPath, filePath);
        Path path = Paths.get(relativePath, new String[0]);
        String nodeName = path.getFileName().toString();
        Path pathParent = path.getParent();
        String pathHint = pathParent == null ? null : pathParent.toString();
        parentNode = this.getOrCreateMessagesNode(eventTime, filePath, parentNode, nodeName, pathHint, () -> {
            VirtualFile file2 = VfsUtil.findFileByIoFile((File)filePosition.getFile(), (boolean)false);
            if (file2 != null) {
                return file2.getFileType().getIcon();
            }
            return null;
        }, navigatable, this.nodesMap, this.myProject);
        return parentNode;
    }

    private static String getRelativePath(@NotNull String basePath, @NotNull String filePath) {
        if (basePath == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(40);
        }
        if (filePath == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(41);
        }
        String path = (String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((String)basePath, (String)filePath, (char)'/'), (Object)filePath);
        File userHomeDir = new File(SystemProperties.getUserHome());
        if (path.startsWith("..") && FileUtil.isAncestor((File)userHomeDir, (File)new File(filePath), (boolean)true)) {
            return FileUtil.getLocationRelativeToUserHome((String)filePath, (boolean)false);
        }
        return path;
    }

    public void hideRootNode() {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myTree != null) {
                this.myTree.setRootVisible(false);
                this.myTree.setShowsRootHandles(true);
            }
        });
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(42);
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return "reference.build.tool.window";
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
            return this.extractSelectedNodesNavigatables();
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.extractSelectedNodeNavigatable();
        }
        return null;
    }

    @Nullable
    private Object extractSelectedNodeNavigatable() {
        TreePath selectedPath = TreeUtil.getSelectedPathIfOne((JTree)this.myTree);
        if (selectedPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)selectedPath.getLastPathComponent(), DefaultMutableTreeNode.class);
        if (node == null) {
            return null;
        }
        ExecutionNode executionNode = (ExecutionNode)((Object)ObjectUtils.tryCast((Object)node.getUserObject(), ExecutionNode.class));
        if (executionNode == null) {
            return null;
        }
        List<Navigatable> navigatables = executionNode.getNavigatables();
        if (navigatables.size() != 1) {
            return null;
        }
        return navigatables.get(0);
    }

    private Object extractSelectedNodesNavigatables() {
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (ExecutionNode each : this.getSelectedNodes()) {
            List<Navigatable> navigatable = each.getNavigatables();
            navigatables.addAll(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(new Navigatable[0]);
    }

    private ExecutionNode[] getSelectedNodes() {
        ExecutionNode[] result2 = new ExecutionNode[]{};
        if (this.myTree != null) {
            List nodes = TreeUtil.collectSelectedObjects((JTree)this.myTree, path -> (ExecutionNode)((Object)((Object)TreeUtil.getLastUserObject(ExecutionNode.class, (TreePath)path))));
            return nodes.toArray(result2);
        }
        return result2;
    }

    @ApiStatus.Internal
    public JTree getTree() {
        return this.myTree;
    }

    private static Tree initTree(@NotNull AsyncTreeModel model2) {
        if (model2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(43);
        }
        Tree tree = new Tree((TreeModel)((Object)model2));
        tree.setLargeModel(true);
        ComponentUtil.putClientProperty((JComponent)tree, (Key)AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, (Object)true);
        ComponentUtil.putClientProperty((JComponent)tree, DefaultTreeUI.AUTO_EXPAND_ALLOWED, (Object)false);
        tree.setRootVisible(false);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        EditSourceOnEnterKeyHandler.install((JTree)tree);
        new TreeSpeedSearch((JTree)tree).setComparator(new SpeedSearchComparator(false));
        TreeUtil.installActions((JTree)tree);
        tree.setCellRenderer((TreeCellRenderer)((Object)new MyNodeRenderer()));
        tree.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, (Object)true);
        return tree;
    }

    @NotNull
    private ExecutionNode getOrCreateMessagesNode(long eventTime, String nodeId, ExecutionNode parentNode, String nodeName, @Nullable @BuildEventsNls.Hint String hint, @Nullable Supplier<? extends Icon> iconProvider, @Nullable Navigatable navigatable, Map<Object, ExecutionNode> nodesMap, Project project) {
        ExecutionNode node = nodesMap.get(nodeId);
        if (node == null) {
            node = new ExecutionNode(project, parentNode, false, this::isCorrectThread);
            node.setName(nodeName);
            if (hint != null) {
                node.setHint(hint);
            }
            node.setStartTime(eventTime);
            node.setEndTime(eventTime);
            if (iconProvider != null) {
                node.setIconProvider(iconProvider);
            }
            if (navigatable != null) {
                node.setNavigatable(navigatable);
            }
            parentNode.add(node);
            nodesMap.put(nodeId, node);
        }
        ExecutionNode executionNode = node;
        if (executionNode == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(44);
        }
        return executionNode;
    }

    @ApiStatus.Internal
    public Promise<?> invokeLater(@NotNull Runnable task2) {
        if (task2 == null) {
            BuildTreeConsoleView.$$$reportNull$$$0(45);
        }
        return this.myTreeModel.getInvoker().invokeLater(task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 21: 
            case 35: 
            case 36: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 21: 
            case 35: 
            case 36: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildViewSettingsProvider";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 21: 
            case 35: 
            case 36: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionTreeFilter";
                break;
            }
            case 5: 
            case 6: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 13: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureChanged";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProgressRootNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventKind";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionNode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failure";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultFailureMessage";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePosition";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/BuildTreeConsoleView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilter";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addAsPresentableEventNode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMessagesNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 21: 
            case 35: 
            case 36: 
            case 44: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFilter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getOrMaybeCreateParentNode";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onEventInternal";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addAsPresentableEventNode";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportMessageKind";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showErrorIfFirst";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitor";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addChildFailureNode";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "finishChildren";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "onEvent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createMessageParentNodes";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "initTree";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 16: 
            case 20: 
            case 21: 
            case 35: 
            case 36: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ExecutionNodeAutoExpandingListener
    implements TreeModelListener {
        private ExecutionNodeAutoExpandingListener() {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            this.maybeExpand(e.getTreePath());
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        private boolean maybeExpand(TreePath path) {
            if (BuildTreeConsoleView.this.myTree == null || path == null) {
                return false;
            }
            Object last = path.getLastPathComponent();
            if (last instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode mutableTreeNode = (DefaultMutableTreeNode)last;
                boolean expanded = false;
                Enumeration<TreeNode> children2 = mutableTreeNode.children();
                if (children2.hasMoreElements()) {
                    while (children2.hasMoreElements()) {
                        TreeNode next = children2.nextElement();
                        if (next == null) continue;
                        expanded = this.maybeExpand(path.pathByAddingChild(next)) || expanded;
                    }
                    if (expanded) {
                        return true;
                    }
                    Object lastUserObject = mutableTreeNode.getUserObject();
                    if (lastUserObject instanceof ExecutionNode && ((ExecutionNode)((Object)lastUserObject)).isAutoExpandNode() && !BuildTreeConsoleView.this.myTree.isExpanded(path)) {
                        BuildTreeConsoleView.this.myTree.expandPath(path);
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class MyTreeStructure
    extends AbstractTreeStructure {
        private MyTreeStructure() {
        }

        @NotNull
        public Object getRootElement() {
            ExecutionNode executionNode = BuildTreeConsoleView.this.myRootNode;
            if (executionNode == null) {
                MyTreeStructure.$$$reportNull$$$0(0);
            }
            return executionNode;
        }

        @NotNull
        public Object[] getChildElements(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(1);
            }
            Object[] objectArray = ((ExecutionNode)((Object)element2)).getChildList().toArray();
            if (objectArray == null) {
                MyTreeStructure.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        @Nullable
        public Object getParentElement(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(3);
            }
            return ((ExecutionNode)((Object)element2)).getParent();
        }

        @NotNull
        public NodeDescriptor createDescriptor(@NotNull Object element2, @Nullable NodeDescriptor parentDescriptor) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(4);
            }
            NodeDescriptor nodeDescriptor = (NodeDescriptor)element2;
            if (nodeDescriptor == null) {
                MyTreeStructure.$$$reportNull$$$0(5);
            }
            return nodeDescriptor;
        }

        public void commit() {
        }

        public boolean hasSomethingToCommit() {
            return false;
        }

        public boolean isAlwaysLeaf(@NotNull Object element2) {
            if (element2 == null) {
                MyTreeStructure.$$$reportNull$$$0(6);
            }
            return ((ExecutionNode)((Object)element2)).isAlwaysLeaf();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$MyTreeStructure";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootElement";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$MyTreeStructure";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildElements";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildElements";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getParentElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptor";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isAlwaysLeaf";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 6: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyNodeRenderer
    extends NodeRenderer {
        private String myDurationText;
        private Color myDurationColor;
        private int myDurationWidth;
        private int myDurationOffset;

        private MyNodeRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected2, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MyNodeRenderer.$$$reportNull$$$0(0);
            }
            super.customizeCellRenderer(tree, value2, selected2, expanded, leaf, row, hasFocus);
            this.myDurationText = null;
            this.myDurationColor = null;
            this.myDurationWidth = 0;
            this.myDurationOffset = 0;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
            Object userObj = node.getUserObject();
            if (userObj instanceof ExecutionNode) {
                this.myDurationText = ((ExecutionNode)((Object)userObj)).getDuration();
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationOffset = metrics.getHeight() / 2;
                    this.myDurationColor = selected2 ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
        }

        protected void paintComponent(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            Shape clip = null;
            int width = this.getWidth();
            int height = this.getHeight();
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, width, height);
            }
            if (this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
                g.setColor(this.myDurationColor);
                g.setFont(RelativeFont.SMALL.derive(this.getFont()));
                g.drawString(this.myDurationText, width + this.myDurationOffset / 2, MyNodeRenderer.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)height));
                clip = g.getClip();
                g.clipRect(0, 0, width, height);
            }
            super.paintComponent(g);
            if (clip != null) {
                g.setClip(clip);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BuildTreeConsoleView.TREE, "com/intellij/build/BuildTreeConsoleView$MyNodeRenderer", "customizeCellRenderer"));
        }
    }

    private static class ScrollEditorToTheEndAction
    extends ToggleAction
    implements DumbAware {
        @NotNull
        private final ConsoleViewHandler myConsoleViewHandler;

        ScrollEditorToTheEndAction(@NotNull ConsoleViewHandler handler2) {
            if (handler2 == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(0);
            }
            super(ActionsBundle.message((String)"action.EditorConsoleScrollToTheEnd.text", (Object[])new Object[0]), null, AllIcons.RunConfigurations.Scroll_down);
            this.myConsoleViewHandler = handler2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(1);
            }
            if ((editor = this.myConsoleViewHandler.getEditor()) == null) {
                return false;
            }
            Document document = editor.getDocument();
            return document.getLineCount() == 0 || document.getLineNumber(editor.getCaretModel().getOffset()) == document.getLineCount() - 1;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Editor editor;
            if (e == null) {
                ScrollEditorToTheEndAction.$$$reportNull$$$0(2);
            }
            if ((editor = this.myConsoleViewHandler.getEditor()) == null) {
                return;
            }
            if (state) {
                EditorUtil.scrollToTheEnd(editor);
            } else {
                int lastLine = Math.max(0, editor.getDocument().getLineCount() - 1);
                LogicalPosition currentPosition = editor.getCaretModel().getLogicalPosition();
                LogicalPosition position = new LogicalPosition(Math.max(0, Math.min(currentPosition.line, lastLine - 1)), currentPosition.column);
                editor.getCaretModel().moveToLogicalPosition(position);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handler";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ScrollEditorToTheEndAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ProblemOccurrenceNavigatorSupport
    extends OccurenceNavigatorSupport {
        ProblemOccurrenceNavigatorSupport(Tree tree) {
            super((JTree)tree);
        }

        protected Navigatable createDescriptorForNode(@NotNull DefaultMutableTreeNode node) {
            Object userObject;
            if (node == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(0);
            }
            if (!((userObject = node.getUserObject()) instanceof ExecutionNode)) {
                return null;
            }
            ExecutionNode executionNode = (ExecutionNode)((Object)userObject);
            if (node.getChildCount() != 0 || !executionNode.hasWarnings() && !executionNode.isFailed()) {
                return null;
            }
            List<Navigatable> navigatables = executionNode.getNavigatables();
            if (!navigatables.isEmpty()) {
                return navigatables.get(0);
            }
            return null;
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message((String)"action.next.problem", (Object[])new Object[0]);
            if (string == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message((String)"action.previous.problem", (Object[])new Object[0]);
            if (string == null) {
                ProblemOccurrenceNavigatorSupport.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ProblemOccurrenceNavigatorSupport";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ProblemOccurrenceNavigatorSupport";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createDescriptorForNode";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConsoleViewHandler
    implements Disposable {
        private static final String EMPTY_CONSOLE_NAME = "empty";
        private final Project myProject;
        private final JPanel myPanel;
        private final CompositeView<ExecutionConsole> myView;
        private final AtomicReference<String> myNodeConsoleViewName;
        private final Map<String, List<Consumer<? super BuildTextConsoleView>>> deferredNodeOutput;
        @NotNull
        private final BuildViewSettingsProvider myViewSettingsProvider;
        @Nullable
        private ExecutionNode myExecutionNode;
        @NotNull
        private final List<Filter> myExecutionConsoleFilters;
        private final BuildProgressStripe myPanelWithProgress;
        private final DefaultActionGroup myConsoleToolbarActionGroup;
        private final ActionToolbar myToolbar;

        ConsoleViewHandler(@NotNull Project project, @NotNull Tree tree, @NotNull ExecutionNode buildProgressRootNode, @NotNull Disposable parentDisposable, @Nullable ExecutionConsole executionConsole, @NotNull List<Filter> executionConsoleFilters, @NotNull BuildViewSettingsProvider buildViewSettingsProvider) {
            if (project == null) {
                ConsoleViewHandler.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                ConsoleViewHandler.$$$reportNull$$$0(1);
            }
            if (buildProgressRootNode == null) {
                ConsoleViewHandler.$$$reportNull$$$0(2);
            }
            if (parentDisposable == null) {
                ConsoleViewHandler.$$$reportNull$$$0(3);
            }
            if (executionConsoleFilters == null) {
                ConsoleViewHandler.$$$reportNull$$$0(4);
            }
            if (buildViewSettingsProvider == null) {
                ConsoleViewHandler.$$$reportNull$$$0(5);
            }
            this.myNodeConsoleViewName = new AtomicReference();
            this.deferredNodeOutput = new ConcurrentHashMap<String, List<Consumer<? super BuildTextConsoleView>>>();
            this.myProject = project;
            this.myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            this.myPanelWithProgress = new BuildProgressStripe(this.myPanel, parentDisposable, 300);
            this.myViewSettingsProvider = buildViewSettingsProvider;
            this.myExecutionConsoleFilters = executionConsoleFilters;
            Disposer.register((Disposable)parentDisposable, (Disposable)this);
            this.myView = new CompositeView<ExecutionConsole>(null){

                @Override
                public void addView(@NotNull ExecutionConsole view, @NotNull String viewName) {
                    if (view == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (viewName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    super.addView(view, viewName);
                    UIUtil.removeScrollBorder((Component)view.getComponent());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "view";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "viewName";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$1";
                    objectArray[2] = "addView";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            Disposer.register((Disposable)this, this.myView);
            if (executionConsole != null) {
                String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(buildProgressRootNode);
                this.myView.addViewAndShowIfNeeded(executionConsole, nodeConsoleViewName, true);
                this.myNodeConsoleViewName.set(nodeConsoleViewName);
            }
            ConsoleViewImpl emptyConsole = new ConsoleViewImpl(project, GlobalSearchScope.EMPTY_SCOPE, true, false);
            this.myView.addView((ExecutionConsole)emptyConsole, EMPTY_CONSOLE_NAME);
            JComponent consoleComponent = emptyConsole.getComponent();
            consoleComponent.setFocusable(true);
            this.myPanel.add((Component)this.myView.getComponent(), "Center");
            this.myConsoleToolbarActionGroup = new DefaultActionGroup();
            this.myToolbar = ActionManager.getInstance().createActionToolbar("BuildConsole", (ActionGroup)this.myConsoleToolbarActionGroup, false);
            this.showTextConsoleToolbarActions();
            this.myPanel.add((Component)this.myToolbar.getComponent(), "East");
            tree.addTreeSelectionListener(e -> {
                TreePath path = e.getPath();
                if (path == null || !e.isAddedPath()) {
                    return;
                }
                TreePath selectionPath = tree.getSelectionPath();
                this.setNode(selectionPath != null ? (DefaultMutableTreeNode)selectionPath.getLastPathComponent() : null);
            });
        }

        private void showTextConsoleToolbarActions() {
            this.myConsoleToolbarActionGroup.copyFromGroup(this.createDefaultTextConsoleToolbar());
            this.updateToolbarActionsImmediately();
        }

        private void showCustomConsoleToolbarActions(@Nullable ActionGroup actionGroup2) {
            if (actionGroup2 instanceof DefaultActionGroup) {
                this.myConsoleToolbarActionGroup.copyFromGroup((DefaultActionGroup)actionGroup2);
            } else if (actionGroup2 != null) {
                this.myConsoleToolbarActionGroup.copyFrom((AnAction)actionGroup2);
            } else {
                this.myConsoleToolbarActionGroup.removeAll();
            }
            this.updateToolbarActionsImmediately();
        }

        private void updateToolbarActionsImmediately() {
            UIUtil.invokeLaterIfNeeded(() -> this.myToolbar.updateActionsImmediately());
        }

        @NotNull
        private DefaultActionGroup createDefaultTextConsoleToolbar() {
            DefaultActionGroup textConsoleToolbarActionGroup = new DefaultActionGroup();
            textConsoleToolbarActionGroup.add((AnAction)new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE){

                @Override
                @Nullable
                protected Editor getEditor(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return this.getEditor();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$2", "getEditor"));
                }
            });
            textConsoleToolbarActionGroup.add((AnAction)new ScrollEditorToTheEndAction(this));
            DefaultActionGroup defaultActionGroup = textConsoleToolbarActionGroup;
            if (defaultActionGroup == null) {
                ConsoleViewHandler.$$$reportNull$$$0(6);
            }
            return defaultActionGroup;
        }

        private void updateProgressBar(long total, long progress2) {
            this.myPanelWithProgress.updateProgress(total, progress2);
        }

        @Nullable
        private ExecutionConsole getCurrentConsole() {
            String nodeConsoleViewName = this.myNodeConsoleViewName.get();
            if (nodeConsoleViewName == null) {
                return null;
            }
            return this.myView.getView(nodeConsoleViewName);
        }

        @Nullable
        private Editor getEditor() {
            ExecutionConsole console2 = this.getCurrentConsole();
            if (console2 instanceof ConsoleViewImpl) {
                return ((ConsoleViewImpl)console2).getEditor();
            }
            return null;
        }

        private boolean setNode(@NotNull ExecutionNode node) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(7);
            }
            String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
            this.myNodeConsoleViewName.set(nodeConsoleViewName);
            ExecutionConsole view = this.myView.getView(nodeConsoleViewName);
            if (view != null) {
                List<Consumer<? super BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
                if (view instanceof BuildTextConsoleView && deferredOutput != null && !deferredOutput.isEmpty()) {
                    this.deferredNodeOutput.remove(nodeConsoleViewName);
                    deferredOutput.forEach(consumer2 -> consumer2.accept((BuildTextConsoleView)view));
                } else {
                    this.deferredNodeOutput.remove(nodeConsoleViewName);
                }
                this.myView.showView(nodeConsoleViewName, false);
                if (view instanceof PresentableBuildEventExecutionConsole) {
                    this.showCustomConsoleToolbarActions(((PresentableBuildEventExecutionConsole)view).myActions);
                } else {
                    this.showTextConsoleToolbarActions();
                }
                this.myPanel.setVisible(true);
                return true;
            }
            List<Consumer<? super BuildTextConsoleView>> deferredOutput = this.deferredNodeOutput.get(nodeConsoleViewName);
            if (deferredOutput == null || deferredOutput.isEmpty()) {
                this.myView.showView(EMPTY_CONSOLE_NAME, false);
                return true;
            }
            BuildTextConsoleView textConsoleView = new BuildTextConsoleView(this.myProject, true, this.myExecutionConsoleFilters);
            this.deferredNodeOutput.remove(nodeConsoleViewName);
            deferredOutput.forEach(consumer2 -> consumer2.accept(textConsoleView));
            this.myView.addView((ExecutionConsole)textConsoleView, nodeConsoleViewName);
            this.myView.showView(nodeConsoleViewName, false);
            return true;
        }

        public void maybeAddExecutionConsole(@NotNull ExecutionNode node, @NotNull BuildEventPresentationData presentationData) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(8);
            }
            if (presentationData == null) {
                ConsoleViewHandler.$$$reportNull$$$0(9);
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                ExecutionConsole executionConsole = presentationData.getExecutionConsole();
                if (executionConsole == null) {
                    return;
                }
                String nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node);
                PresentableBuildEventExecutionConsole presentableEventView = new PresentableBuildEventExecutionConsole(executionConsole, presentationData.consoleToolbarActions());
                this.myView.addView(presentableEventView, nodeConsoleViewName);
            });
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull String text2, boolean stdOut) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(10);
            }
            if (text2 == null) {
                ConsoleViewHandler.$$$reportNull$$$0(11);
            }
            this.addOutput(node, (? super BuildTextConsoleView view) -> view.append(text2, stdOut));
        }

        private void addOutput(@NotNull ExecutionNode node, @NotNull Object buildId, BuildEvent event) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(12);
            }
            if (buildId == null) {
                ConsoleViewHandler.$$$reportNull$$$0(13);
            }
            this.addOutput(node, (? super BuildTextConsoleView view) -> view.onEvent(buildId, event));
        }

        private void addOutput(@NotNull ExecutionNode node, Failure failure) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(14);
            }
            this.addOutput(node, (? super BuildTextConsoleView view) -> view.append(failure));
        }

        private void addOutput(@NotNull ExecutionNode node, Consumer<? super BuildTextConsoleView> consumer2) {
            String nodeConsoleViewName;
            ExecutionConsole viewView;
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(15);
            }
            if ((viewView = this.myView.getView(nodeConsoleViewName = ConsoleViewHandler.getNodeConsoleViewName(node))) instanceof BuildTextConsoleView) {
                consumer2.accept((BuildTextConsoleView)viewView);
            }
            if (viewView == null) {
                this.deferredNodeOutput.computeIfAbsent(nodeConsoleViewName, s -> new ArrayList()).add(consumer2);
            }
        }

        public void dispose() {
            this.deferredNodeOutput.clear();
        }

        private void stopProgressBar() {
            this.myPanelWithProgress.stopLoading();
        }

        @NotNull
        private static String getNodeConsoleViewName(@NotNull ExecutionNode node) {
            if (node == null) {
                ConsoleViewHandler.$$$reportNull$$$0(16);
            }
            String string = String.valueOf(System.identityHashCode((Object)node));
            if (string == null) {
                ConsoleViewHandler.$$$reportNull$$$0(17);
            }
            return string;
        }

        private void setNode(@Nullable DefaultMutableTreeNode node) {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (node == null || node.getUserObject() == this.myExecutionNode) {
                return;
            }
            if (node.getUserObject() instanceof ExecutionNode) {
                this.myExecutionNode = (ExecutionNode)((Object)node.getUserObject());
                if (this.setNode((ExecutionNode)((Object)node.getUserObject()))) {
                    return;
                }
            }
            this.myExecutionNode = null;
            if (this.myView.getView("consoleView") != null) {
                this.myView.showView("consoleView", false);
                this.myPanel.setVisible(true);
            } else {
                this.myPanel.setVisible(false);
            }
        }

        public JComponent getComponent() {
            return this.myPanelWithProgress;
        }

        public void clear() {
            this.myPanel.setVisible(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 17: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 17: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = BuildTreeConsoleView.TREE;
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildProgressRootNode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executionConsoleFilters";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildViewSettingsProvider";
                    break;
                }
                case 6: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler";
                    break;
                }
                case 7: 
                case 8: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentationData";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDefaultTextConsoleToolbar";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodeConsoleViewName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 17: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setNode";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "maybeAddExecutionConsole";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "addOutput";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "getNodeConsoleViewName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 17: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class PresentableBuildEventExecutionConsole
        implements ExecutionConsole {
            private final ExecutionConsole myExecutionConsole;
            @Nullable
            private final ActionGroup myActions;

            private PresentableBuildEventExecutionConsole(@NotNull ExecutionConsole executionConsole, @Nullable ActionGroup toolbarActions) {
                if (executionConsole == null) {
                    PresentableBuildEventExecutionConsole.$$$reportNull$$$0(0);
                }
                this.myExecutionConsole = executionConsole;
                this.myActions = toolbarActions;
            }

            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = this.myExecutionConsole.getComponent();
                if (jComponent == null) {
                    PresentableBuildEventExecutionConsole.$$$reportNull$$$0(1);
                }
                return jComponent;
            }

            public JComponent getPreferredFocusableComponent() {
                return this.myExecutionConsole.getPreferredFocusableComponent();
            }

            public void dispose() {
                Disposer.dispose((Disposable)this.myExecutionConsole);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executionConsole";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$PresentableBuildEventExecutionConsole";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/build/BuildTreeConsoleView$ConsoleViewHandler$PresentableBuildEventExecutionConsole";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getComponent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }
}

