/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.impl.FontFamilyService;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.AbstractFontCombo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FontFamilyCombo
extends AbstractFontCombo<MyFontItem> {
    public static final int ITEM_WIDTH = 230;
    private final Dimension myItemSize;
    private final boolean myIsPrimary;

    protected FontFamilyCombo(boolean isPrimary) {
        super(new MyModel(!isPrimary));
        this.setSwingPopup(false);
        this.myIsPrimary = isPrimary;
        this.setRenderer((ListCellRenderer)((Object)new MyListCellRenderer()));
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.myItemSize = new Dimension(JBUI.scale((int)230), fontMetrics.getHeight());
    }

    @Override
    @NlsSafe
    @Nullable
    public String getFontName() {
        Object selectedItem = this.getModel().getSelectedItem();
        return selectedItem instanceof MyFontItem ? ((MyFontItem)selectedItem).getFamilyName() : null;
    }

    @Override
    public void setFontName(@NlsSafe @Nullable String fontName) {
        this.getModel().setSelectedItem(fontName);
    }

    @Override
    public boolean isNoFontSelected() {
        return this.getModel().getSelectedItem() instanceof MyNoFontItem;
    }

    @Override
    public void setMonospacedOnly(boolean isMonospacedOnly) {
    }

    @Override
    public boolean isMonospacedOnly() {
        return false;
    }

    @Override
    public boolean isMonospacedOnlySupported() {
        return false;
    }

    private static class MyTitledSeparator
    extends JPanel {
        private final JLabel myLabel;

        @Override
        public AccessibleContext getAccessibleContext() {
            return this.myLabel.getAccessibleContext();
        }

        MyTitledSeparator(@NlsContexts.Separator @NotNull String titleText, boolean withTopLine, boolean isUpdating) {
            if (titleText == null) {
                MyTitledSeparator.$$$reportNull$$$0(0);
            }
            this.setBackground(JBColor.background());
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = JBUI.emptyInsets();
            if (withTopLine) {
                c.fill = 2;
                c.gridwidth = 2;
                this.add((Component)new JSeparator(), c);
                ++c.gridy;
            }
            this.myLabel = new JLabel(titleText);
            this.myLabel.setForeground((Color)JBColor.gray);
            this.myLabel.setFont((Font)JBUI.Fonts.smallFont());
            c.gridwidth = 1;
            c.fill = 0;
            c.anchor = 21;
            this.add((Component)this.myLabel, c);
            if (isUpdating) {
                c.gridx = 1;
                JLabel updatingLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.updating", (Object[])new Object[0]));
                updatingLabel.setForeground((Color)JBColor.gray);
                updatingLabel.setFont((Font)JBUI.Fonts.miniFont());
                this.add((Component)updatingLabel, c);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titleText", "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyTitledSeparator", "<init>"));
        }
    }

    private class MyListCellRenderer
    extends ColoredListCellRenderer<MyFontItem> {
        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends MyFontItem> list2, MyFontItem value2, int index2, boolean selected2, boolean hasFocus) {
            if (value2 instanceof MySeparatorItem) {
                return new MyTitledSeparator(value2.getFamilyName(), !value2.myIsMonospaced, ((MySeparatorItem)value2).isUpdating);
            }
            return super.getListCellRendererComponent(list2, (Object)value2, index2, selected2, hasFocus);
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension dimension = FontFamilyCombo.this.myItemSize;
            if (dimension == null) {
                MyListCellRenderer.$$$reportNull$$$0(0);
            }
            return dimension;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends MyFontItem> list2, MyFontItem value2, int index2, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyListCellRenderer.$$$reportNull$$$0(1);
            }
            if (value2 != null) {
                SimpleTextAttributes attributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (value2.myFont != null) {
                    if (value2.myFontCanDisplayName) {
                        this.setFont(value2.myFont);
                    } else if (FontFamilyCombo.this.myIsPrimary) {
                        attributes = SimpleTextAttributes.EXCLUDED_ATTRIBUTES;
                    }
                }
                this.append(value2.getFamilyName(), attributes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyListCellRenderer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyListCellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyFontItemComparator
    implements Comparator<MyFontItem> {
        private MyFontItemComparator() {
        }

        @Override
        public int compare(MyFontItem item1, MyFontItem item2) {
            if (item1 instanceof MyNoFontItem) {
                return -1;
            }
            if (item2 instanceof MyNoFontItem) {
                return 1;
            }
            if (item1.myIsMonospaced && !item2.myIsMonospaced) {
                return -1;
            }
            if (!item1.myIsMonospaced && item2.myIsMonospaced) {
                return 1;
            }
            if (item1 instanceof MySeparatorItem) {
                return -1;
            }
            if (item2 instanceof MySeparatorItem) {
                return 1;
            }
            return item1.myFamilyName.compareTo(item2.myFamilyName);
        }

        @Override
        public boolean equals(Object obj2) {
            return false;
        }
    }

    private static class MyModel
    extends AbstractListModel<MyFontItem>
    implements ComboBoxModel<MyFontItem> {
        private static final String[] KNOWN_MONOSPACED_FAMILIES = new String[]{"Consolas", "DejaVu Sans Mono", "Droid Sans Mono", "JetBrains Mono", "Fira Code", "Inconsolata", "Menlo", "Monospaced", "Source Code Pro"};
        private final Set<String> myMonospacedFamilies = new HashSet<String>();
        private final List<MyFontItem> myItems = new ArrayList<MyFontItem>();
        @Nullable
        private final MyNoFontItem myNoFontItem;
        @Nullable
        private MyFontItem mySelectedItem;
        private final MySeparatorItem myMonospacedSeparatorItem;
        private final MySeparatorItem myProportionalSeparatorItem;

        private MyModel(boolean withNoneItem) {
            this.myMonospacedFamilies.addAll(Arrays.asList(KNOWN_MONOSPACED_FAMILIES));
            if (withNoneItem) {
                this.myNoFontItem = new MyNoFontItem();
                this.myItems.add(this.myNoFontItem);
            } else {
                this.myNoFontItem = null;
            }
            FontFamilyService.getAvailableFamilies().forEach(name -> this.myItems.add(new MyFontItem((String)name, this.myMonospacedFamilies.contains(name))));
            this.myMonospacedSeparatorItem = new MySeparatorItem(ApplicationBundle.message((String)"settings.editor.font.monospaced", (Object[])new Object[0]), true);
            this.myItems.add(this.myMonospacedSeparatorItem);
            this.myProportionalSeparatorItem = new MySeparatorItem(ApplicationBundle.message((String)"settings.editor.font.proportional", (Object[])new Object[0]), false);
            this.myItems.add(this.myProportionalSeparatorItem);
            Collections.sort(this.myItems, new MyFontItemComparator());
            this.retrieveFontInfo();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null) {
                this.mySelectedItem = this.myNoFontItem;
            } else if (anItem instanceof String) {
                this.mySelectedItem = (MyFontItem)ContainerUtil.find(this.myItems, item -> item.isSelectable() && item.myFamilyName.equals(anItem));
            } else {
                if (anItem instanceof MySeparatorItem) {
                    return;
                }
                if (anItem instanceof MyFontItem) {
                    this.mySelectedItem = (MyFontItem)anItem;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        @Override
        @Nullable
        public MyFontItem getSelectedItem() {
            return this.mySelectedItem;
        }

        @Override
        public int getSize() {
            return this.myItems.size();
        }

        @Override
        public MyFontItem getElementAt(int index2) {
            return this.myItems.get(index2);
        }

        private void retrieveFontInfo() {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                for (MyFontItem item : this.myItems) {
                    if (FontFamilyService.isMonospaced(item.myFamilyName)) {
                        this.myMonospacedFamilies.add(item.myFamilyName);
                    }
                    item.myFont = JBUI.Fonts.create((String)item.myFamilyName, (int)JBUI.Fonts.label().getSize());
                    item.myFontCanDisplayName = item.myFont.canDisplayUpTo(item.myFamilyName) == -1;
                }
                this.updateMonospacedInfo();
            });
        }

        private void updateMonospacedInfo() {
            ApplicationManager.getApplication().invokeLater(() -> {
                for (MyFontItem item : this.myItems) {
                    item.myIsMonospaced = this.myMonospacedFamilies.contains(item.myFamilyName);
                }
                this.myMonospacedSeparatorItem.isUpdating = false;
                this.myProportionalSeparatorItem.isUpdating = false;
                Collections.sort(this.myItems, new MyFontItemComparator());
                this.fireContentsChanged(this, -1, -1);
            }, ModalityState.any());
        }
    }

    private static class MySeparatorItem
    extends MyFontItem {
        private boolean isUpdating;

        private MySeparatorItem(@NotNull String title, boolean isMonospaced) {
            if (title == null) {
                MySeparatorItem.$$$reportNull$$$0(0);
            }
            super(title, isMonospaced);
            this.isUpdating = true;
        }

        @Override
        public boolean isSelectable() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/application/options/editor/fonts/FontFamilyCombo$MySeparatorItem", "<init>"));
        }
    }

    private static class MyNoFontItem
    extends MyFontItem {
        private MyNoFontItem() {
            super("<None>", false);
        }
    }

    protected static class MyFontItem {
        @NotNull
        private final String myFamilyName;
        private boolean myIsMonospaced;
        private boolean myFontCanDisplayName;
        @Nullable
        private Font myFont;

        public MyFontItem(@NotNull String familyName, boolean isMonospaced) {
            if (familyName == null) {
                MyFontItem.$$$reportNull$$$0(0);
            }
            this.myFamilyName = familyName;
            this.myIsMonospaced = isMonospaced;
        }

        public String toString() {
            return this.myFamilyName;
        }

        @NlsSafe
        @NotNull
        public String getFamilyName() {
            String string = this.myFamilyName;
            if (string == null) {
                MyFontItem.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isSelectable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "familyName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyFontItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/editor/fonts/FontFamilyCombo$MyFontItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

