/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor.fonts;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.FontEditorPreview;
import com.intellij.application.options.editor.fonts.AppEditorFontOptionsPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class AppEditorFontPanel
implements Disposable {
    @NotNull
    private final AppEditorFontOptionsPanel myOptionsPanel;
    @NotNull
    private final FontEditorPreview myPreview;
    @NotNull
    private final EditorColorsScheme myPreviewScheme;
    @NotNull
    private final JPanel myTopPanel = new JPanel(new BorderLayout());

    public AppEditorFontPanel() {
        JPanel restorePanel = new JPanel(new FlowLayout(2));
        this.myTopPanel.add((Component)restorePanel, "North");
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0));
        JBSplitter splitter = new JBSplitter(false, 0.3f);
        this.myPreviewScheme = AppEditorFontPanel.createPreviewScheme();
        this.myOptionsPanel = new AppEditorFontOptionsPanel(this.myPreviewScheme);
        this.myOptionsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)5));
        this.myPreview = new FontEditorPreview(() -> this.myPreviewScheme, true){

            @Override
            protected Border getBorder() {
                return JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1);
            }
        };
        splitter.setFirstComponent((JComponent)this.myOptionsPanel);
        splitter.setSecondComponent(this.myPreview.getPanel());
        innerPanel.add((Component)splitter, "Center");
        this.myOptionsPanel.addListener(new ColorAndFontSettingsListener.Abstract(){

            @Override
            public void fontChanged() {
                AppEditorFontPanel.this.updatePreview();
            }
        });
        this.myTopPanel.add((Component)innerPanel, "Center");
    }

    public void updatePreview() {
        if (this.myPreviewScheme instanceof EditorFontCache) {
            ((EditorFontCache)this.myPreviewScheme).reset();
        }
        this.myPreview.updateView();
    }

    public void dispose() {
        this.myPreview.disposeUIResources();
    }

    @NotNull
    private static EditorColorsScheme createPreviewScheme() {
        EditorColorsScheme scheme2 = (EditorColorsScheme)EditorColorsManager.getInstance().getSchemeForCurrentUITheme().clone();
        scheme2.setFontPreferences((FontPreferences)new FontPreferencesImpl());
        EditorColorsScheme editorColorsScheme = scheme2;
        if (editorColorsScheme == null) {
            AppEditorFontPanel.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel2 = this.myTopPanel;
        if (jPanel2 == null) {
            AppEditorFontPanel.$$$reportNull$$$0(1);
        }
        return jPanel2;
    }

    @NotNull
    public AppEditorFontOptionsPanel getOptionsPanel() {
        AppEditorFontOptionsPanel appEditorFontOptionsPanel = this.myOptionsPanel;
        if (appEditorFontOptionsPanel == null) {
            AppEditorFontPanel.$$$reportNull$$$0(2);
        }
        return appEditorFontOptionsPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/application/options/editor/fonts/AppEditorFontPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewScheme";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPanel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

