/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.PreviewPanel;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.EventListener;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FontEditorPreview
implements PreviewPanel {
    private static final String PREVIEW_TEXT_KEY = "FontPreviewText";
    private final EditorEx myEditor;
    private final JPanel myTopPanel;
    private final Supplier<? extends EditorColorsScheme> mySchemeSupplier;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);

    public FontEditorPreview(Supplier<? extends EditorColorsScheme> schemeSupplier, boolean editable) {
        this.mySchemeSupplier = schemeSupplier;
        @Nls String text2 = PropertiesComponent.getInstance().getValue(PREVIEW_TEXT_KEY, FontEditorPreview.getIDEDemoText());
        this.myEditor = (EditorEx)FontEditorPreview.createPreviewEditor(text2, this.mySchemeSupplier.get(), editable);
        this.myEditor.setBorder((Border)JBUI.Borders.empty());
        this.myTopPanel = new JPanel(new BorderLayout());
        this.myTopPanel.add((Component)this.myEditor.getComponent(), "Center");
        JLabel previewLabel = new JLabel(ApplicationBundle.message((String)"settings.editor.font.preview.hint", (Object[])new Object[0]));
        previewLabel.setFont((Font)JBUI.Fonts.smallFont());
        previewLabel.setForeground(UIUtil.getContextHelpForeground());
        previewLabel.setBorder((Border)JBUI.Borders.empty((int)10, (int)15, (int)10, (int)0));
        previewLabel.setBackground(this.myEditor.getBackgroundColor());
        this.myTopPanel.add((Component)previewLabel, "South");
        this.myTopPanel.setBackground(this.myEditor.getBackgroundColor());
        this.myTopPanel.setBorder(this.getBorder());
        FontEditorPreview.registerRestoreAction(this.myEditor);
        FontEditorPreview.installTrafficLights(this.myEditor);
    }

    protected Border getBorder() {
        return JBUI.Borders.customLine((Color)JBColor.border());
    }

    private static void registerRestoreAction(EditorEx editor) {
        editor.putUserData(RestorePreviewTextAction.OUR_EDITOR, Boolean.TRUE);
        AnAction restoreAction2 = ActionManager.getInstance().getAction("RestoreFontPreviewTextAction");
        if (restoreAction2 != null) {
            String originalGroupId = editor.getContextMenuGroupId();
            AnAction originalGroup = originalGroupId == null ? null : ActionManager.getInstance().getAction(originalGroupId);
            DefaultActionGroup group2 = new DefaultActionGroup();
            if (originalGroup instanceof ActionGroup) {
                group2.addAll(((ActionGroup)originalGroup).getChildren(null));
            }
            group2.add(restoreAction2);
            editor.installPopupHandler(new ContextMenuPopupHandler.Simple((ActionGroup)group2));
        }
    }

    private static String getIDEDemoText() {
        return ApplicationNamesInfo.getInstance().getFullProductName() + " is an Integrated \nDevelopment Environment (IDE) designed\nto maximize productivity. It provides\nclever code completion, static code\nanalysis, and refactorings, and lets\nyou focus on the bright side of\nsoftware development making\nit an enjoyable experience.\n\nabcdefghijklmnopqrstuvwxyz\nABCDEFGHIJKLMNOPQRSTUVWXYZ\n 0123456789 (){}[]\n +-*/= .,;:!? #&$%@|^\n\n<!-- -- != := === >= >- >=> |-> -> <$>\n</> #[ |||> |= ~@\n\n";
    }

    static void installTrafficLights(@NotNull EditorEx editor) {
        if (editor == null) {
            FontEditorPreview.$$$reportNull$$$0(0);
        }
        EditorMarkupModel markupModel = (EditorMarkupModel)((Object)editor.getMarkupModel());
        markupModel.setErrorStripeRenderer(new DumbTrafficLightRenderer());
        markupModel.setErrorStripeVisible(true);
    }

    static Editor createPreviewEditor(String text2, EditorColorsScheme scheme2, boolean editable) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)text2);
        FileDocumentManagerBase.registerDocument(editorDocument, (VirtualFile)new LightVirtualFile());
        EditorEx editor = (EditorEx)(editable ? editorFactory.createEditor(editorDocument) : editorFactory.createViewer(editorDocument));
        editor.setColorsScheme(scheme2);
        EditorSettings settings = editor.getSettings();
        settings.setLineNumbersShown(false);
        settings.setWhitespacesShown(true);
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setAdditionalColumnsCount(0);
        settings.setAdditionalLinesCount(0);
        settings.setRightMarginShown(true);
        settings.setRightMargin(60);
        settings.setGutterIconsShown(false);
        settings.setIndentGuidesShown(false);
        ((EditorGutterComponentEx)editor.getGutter()).setPaintBackground(false);
        return editor;
    }

    @Override
    public JComponent getPanel() {
        return this.myTopPanel;
    }

    @Override
    public void updateView() {
        EditorColorsScheme scheme2 = this.updateOptionsScheme(this.mySchemeSupplier.get());
        this.myEditor.setColorsScheme(scheme2);
        this.myEditor.reinitSettings();
    }

    protected EditorColorsScheme updateOptionsScheme(EditorColorsScheme selectedScheme) {
        return selectedScheme;
    }

    @Override
    public void blinkSelectedHighlightType(Object description) {
    }

    @Override
    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            FontEditorPreview.$$$reportNull$$$0(1);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void disposeUIResources() {
        String previewText = this.myEditor.getDocument().getText();
        if (previewText.equals(FontEditorPreview.getIDEDemoText())) {
            PropertiesComponent.getInstance().unsetValue(PREVIEW_TEXT_KEY);
        } else {
            PropertiesComponent.getInstance().setValue(PREVIEW_TEXT_KEY, previewText);
        }
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "installTrafficLights";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class RestorePreviewTextAction
    extends DumbAwareAction {
        private static final Key<Boolean> OUR_EDITOR = Key.create((String)"RestorePreviewTextAction.editor");

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RestorePreviewTextAction.$$$reportNull$$$0(0);
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            e.getPresentation().setEnabledAndVisible(editor != null && editor.getUserData(OUR_EDITOR) != null && !editor.getDocument().getText().equals(FontEditorPreview.getIDEDemoText()));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Editor editor;
            if (e == null) {
                RestorePreviewTextAction.$$$reportNull$$$0(1);
            }
            if ((editor = (Editor)e.getData(CommonDataKeys.EDITOR)) != null) {
                WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), null, null, () -> editor.getDocument().setText((CharSequence)FontEditorPreview.getIDEDemoText()), (PsiFile[])new PsiFile[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/application/options/colors/FontEditorPreview$RestorePreviewTextAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DumbTrafficLightRenderer
    implements ErrorStripeRenderer {
        private DumbTrafficLightRenderer() {
        }

        @NotNull
        public AnalyzerStatus getStatus() {
            return new AnalyzerStatus(AllIcons.General.InspectionsOK, "", "", () -> AnalyzerStatus.getEmptyController());
        }
    }
}

