/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match.tokens;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.tokens.ArrangementRuleAliasConfigurable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedItemsListEditor;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementRuleAliasToken;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import javax.swing.Icon;
import org.jdom.Verifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrangementRuleAliasesListEditor
extends NamedItemsListEditor<StdArrangementRuleAliasToken> {
    private static final Namer<StdArrangementRuleAliasToken> NAMER = new Namer<StdArrangementRuleAliasToken>(){

        public String getName(StdArrangementRuleAliasToken token2) {
            return token2.getName();
        }

        public boolean canRename(StdArrangementRuleAliasToken item) {
            return false;
        }

        public void setName(StdArrangementRuleAliasToken token2, String name) {
            token2.setTokenName(name.replaceAll("\\s+", " "));
        }
    };
    private static final Factory<StdArrangementRuleAliasToken> FACTORY = () -> new StdArrangementRuleAliasToken("");
    private static final Cloner<StdArrangementRuleAliasToken> CLONER = new Cloner<StdArrangementRuleAliasToken>(){

        public StdArrangementRuleAliasToken cloneOf(StdArrangementRuleAliasToken original) {
            return this.copyOf(original);
        }

        public StdArrangementRuleAliasToken copyOf(StdArrangementRuleAliasToken original) {
            return new StdArrangementRuleAliasToken(original.getName(), original.getDefinitionRules());
        }
    };
    private static final BiPredicate<StdArrangementRuleAliasToken, StdArrangementRuleAliasToken> COMPARER = (o1, o2) -> Objects.equals(o1.getId(), o2.getId());
    @NotNull
    private final Set<String> myUsedTokenIds;
    @NotNull
    private final ArrangementStandardSettingsManager mySettingsManager;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;

    ArrangementRuleAliasesListEditor(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull List<StdArrangementRuleAliasToken> items, @NotNull Set<String> usedTokenIds) {
        if (settingsManager == null) {
            ArrangementRuleAliasesListEditor.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementRuleAliasesListEditor.$$$reportNull$$$0(1);
        }
        if (items == null) {
            ArrangementRuleAliasesListEditor.$$$reportNull$$$0(2);
        }
        if (usedTokenIds == null) {
            ArrangementRuleAliasesListEditor.$$$reportNull$$$0(3);
        }
        super(NAMER, FACTORY, CLONER, COMPARER, items, false);
        this.mySettingsManager = settingsManager;
        this.myColorsProvider = colorsProvider;
        this.myUsedTokenIds = usedTokenIds;
        this.reset();
        this.initTree();
    }

    protected UnnamedConfigurable createConfigurable(StdArrangementRuleAliasToken item) {
        return new ArrangementRuleAliasConfigurable(this.mySettingsManager, this.myColorsProvider, item);
    }

    protected boolean canDelete(StdArrangementRuleAliasToken item) {
        return !this.myUsedTokenIds.contains(item.getId());
    }

    @Nls
    public String getDisplayName() {
        return ApplicationBundle.message((String)"configurable.ArrangementRuleAliasesListEditor.display.name", (Object[])new Object[0]);
    }

    @NlsContexts.DialogTitle
    protected String getCopyDialogTitle() {
        return ApplicationBundle.message((String)"dialog.title.copy.alias", (Object[])new Object[0]);
    }

    @NlsContexts.DialogTitle
    protected String getCreateNewDialogTitle() {
        return ApplicationBundle.message((String)"dialog.title.create.new.alias", (Object[])new Object[0]);
    }

    @NlsContexts.Label
    protected String getNewLabelText() {
        return ApplicationBundle.message((String)"label.new.alias.name", (Object[])new Object[0]);
    }

    @Nullable
    public String askForProfileName(@NlsContexts.DialogTitle String title) {
        return Messages.showInputDialog((String)this.getNewLabelText(), (String)title, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String s) {
                return s.length() > 0 && ArrangementRuleAliasesListEditor.this.findByName(s) == null && Verifier.checkElementName((String)s) == null;
            }

            public boolean canClose(String s) {
                return this.checkInput(s);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "settingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "colorsProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "items";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "usedTokenIds";
                break;
            }
        }
        objectArray[1] = "com/intellij/application/options/codeStyle/arrangement/match/tokens/ArrangementRuleAliasesListEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

