/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementSectionRulesControl;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.CompositeArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ArrangementSectionRuleManager {
    private static final Set<ArrangementSettingsToken> MUTEXES = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION});
    private static final Set<ArrangementSettingsToken> TOKENS = ContainerUtil.newHashSet((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION, StdArrangementTokens.Regexp.TEXT});
    private final Commenter myCommenter;
    private final ArrangementSectionRulesControl myControl;
    private final ArrangementMatchingRuleEditor myEditor;

    @Nullable
    public static ArrangementSectionRuleManager getInstance(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (language == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(0);
        }
        if (settingsManager == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(1);
        }
        if (colorsProvider == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(2);
        }
        if (control == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(3);
        }
        if (settingsManager.isSectionRulesSupported()) {
            return new ArrangementSectionRuleManager(language, settingsManager, colorsProvider, control);
        }
        return null;
    }

    private ArrangementSectionRuleManager(@NotNull Language language, @NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementSectionRulesControl control) {
        if (language == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(4);
        }
        if (settingsManager == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(5);
        }
        if (colorsProvider == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(6);
        }
        if (control == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(7);
        }
        this.myCommenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        this.myControl = control;
        ArrayList<CompositeArrangementSettingsToken> tokens = new ArrayList<CompositeArrangementSettingsToken>();
        tokens.add(new CompositeArrangementSettingsToken(StdArrangementTokens.General.TYPE, (Collection)ContainerUtil.newArrayList((Object[])new ArrangementSettingsToken[]{StdArrangementTokens.Section.START_SECTION, StdArrangementTokens.Section.END_SECTION})));
        tokens.add(new CompositeArrangementSettingsToken((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT));
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, tokens, colorsProvider, control);
    }

    public ArrangementMatchingRuleEditor getEditor() {
        return this.myEditor;
    }

    @NotNull
    public static Set<ArrangementSettingsToken> getSectionMutexes() {
        Set<ArrangementSettingsToken> set2 = MUTEXES;
        if (set2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(8);
        }
        return set2;
    }

    public static boolean isEnabled(@NotNull ArrangementSettingsToken token2) {
        if (token2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(9);
        }
        return TOKENS.contains(token2);
    }

    public void showEditor(int rowToEdit) {
        this.myControl.showEditor(this.myEditor, rowToEdit);
    }

    public boolean isSectionRule(@Nullable Object element2) {
        return element2 instanceof StdArrangementMatchRule && this.getSectionRuleData((StdArrangementMatchRule)element2) != null;
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull StdArrangementMatchRule element2) {
        if (element2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(10);
        }
        ArrangementMatchCondition condition = element2.getMatcher().getCondition();
        return this.getSectionRuleData(condition);
    }

    @Nullable
    public ArrangementSectionRuleData getSectionRuleData(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(11);
        }
        final Ref isStart = new Ref();
        final Ref text2 = new Ref();
        condition.invite(new ArrangementMatchConditionVisitor(){

            public void visit(@NotNull ArrangementAtomMatchCondition condition) {
                ArrangementSettingsToken type;
                if (condition == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((type = condition.getType()).equals((Object)StdArrangementTokens.Section.START_SECTION)) {
                    isStart.set((Object)true);
                } else if (type.equals((Object)StdArrangementTokens.Section.END_SECTION)) {
                    isStart.set((Object)false);
                } else if (type.equals((Object)StdArrangementTokens.Regexp.TEXT)) {
                    text2.set((Object)condition.getValue().toString());
                }
            }

            public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
                if (condition == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite((ArrangementMatchConditionVisitor)this);
                    if (text2.isNull() || isStart.isNull()) continue;
                    return;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$1", "visit"));
            }
        });
        if (isStart.isNull()) {
            return null;
        }
        return new ArrangementSectionRuleData(this.processSectionText(StringUtil.notNullize((String)((String)text2.get()))), (Boolean)isStart.get());
    }

    @NotNull
    public StdArrangementMatchRule createDefaultSectionRule() {
        ArrangementAtomMatchCondition type = new ArrangementAtomMatchCondition(StdArrangementTokens.Section.START_SECTION);
        ArrangementAtomMatchCondition text2 = new ArrangementAtomMatchCondition((ArrangementSettingsToken)StdArrangementTokens.Regexp.TEXT, (Object)this.createDefaultSectionText());
        ArrangementMatchCondition condition = ArrangementUtil.combine((ArrangementMatchCondition[])new ArrangementMatchCondition[]{type, text2});
        return new StdArrangementMatchRule(new StdArrangementEntryMatcher(condition));
    }

    @NotNull
    private String processSectionText(@NotNull String text2) {
        String lineCommentPrefix;
        if (text2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(12);
        }
        if ((lineCommentPrefix = this.myCommenter.getLineCommentPrefix()) != null && text2.startsWith(lineCommentPrefix)) {
            String string = text2;
            if (string == null) {
                ArrangementSectionRuleManager.$$$reportNull$$$0(13);
            }
            return string;
        }
        String prefix = this.myCommenter.getBlockCommentPrefix();
        String suffix = this.myCommenter.getBlockCommentSuffix();
        if (prefix != null && suffix != null && text2.length() >= prefix.length() + suffix.length() && text2.startsWith(prefix) && text2.endsWith(suffix)) {
            String string = text2;
            if (string == null) {
                ArrangementSectionRuleManager.$$$reportNull$$$0(14);
            }
            return string;
        }
        return lineCommentPrefix != null ? ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, text2) : (prefix != null && suffix != null ? ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, text2) : "");
    }

    @NotNull
    private String createDefaultSectionText() {
        if (this.myCommenter != null) {
            String lineCommentPrefix = this.myCommenter.getLineCommentPrefix();
            if (StringUtil.isNotEmpty((String)lineCommentPrefix)) {
                String string = ArrangementSectionRuleManager.wrapIntoLineComment(lineCommentPrefix, "");
                if (string == null) {
                    ArrangementSectionRuleManager.$$$reportNull$$$0(15);
                }
                return string;
            }
            String prefix = this.myCommenter.getBlockCommentPrefix();
            String suffix = this.myCommenter.getBlockCommentSuffix();
            if (StringUtil.isNotEmpty((String)prefix) && StringUtil.isNotEmpty((String)suffix)) {
                String string = ArrangementSectionRuleManager.wrapIntoBlockComment(prefix, suffix, " ");
                if (string == null) {
                    ArrangementSectionRuleManager.$$$reportNull$$$0(16);
                }
                return string;
            }
        }
        return "";
    }

    private static String wrapIntoBlockComment(@NotNull String prefix, @NotNull String suffix, @NotNull String text2) {
        if (prefix == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(18);
        }
        if (text2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(19);
        }
        return prefix + text2 + suffix;
    }

    private static String wrapIntoLineComment(@NotNull String lineCommentPrefix, @NotNull String text2) {
        if (lineCommentPrefix == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(20);
        }
        if (text2 == null) {
            ArrangementSectionRuleManager.$$$reportNull$$$0(21);
        }
        return lineCommentPrefix + text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 12: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineCommentPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionMutexes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "processSectionText";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultSectionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSectionRuleData";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processSectionText";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "wrapIntoBlockComment";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "wrapIntoLineComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ArrangementSectionRuleData {
        private final boolean myIsSectionStart;
        private final String myText;

        private ArrangementSectionRuleData(@NotNull String text2, boolean isStart) {
            if (text2 == null) {
                ArrangementSectionRuleData.$$$reportNull$$$0(0);
            }
            this.myText = text2;
            this.myIsSectionStart = isStart;
        }

        public boolean isSectionStart() {
            return this.myIsSectionStart;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                ArrangementSectionRuleData.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$ArrangementSectionRuleData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementSectionRuleManager$ArrangementSectionRuleData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

