/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.RegistryManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.MissingResourceException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="Registry", storages={@Storage(value="ide.general.xml")})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00072\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J\r\u0010\n\u001a\u00070\u0002\u00a2\u0006\u0002\b\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0011H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/application/options/RegistryManagerImpl;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/application/options/RegistryManager;", "()V", "get", "Lcom/intellij/openapi/util/registry/RegistryValue;", "Lorg/jetbrains/annotations/NotNull;", "key", "", "getState", "intValue", "", "defaultValue", "is", "", "loadState", "", "state", "log", "registry", "Lcom/intellij/openapi/util/registry/Registry;", "noStateLoaded", "intellij.platform.ide.impl"})
final class RegistryManagerImpl
implements PersistentStateComponent<Element>,
RegistryManager {
    public boolean is(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry.get((String)key).asBoolean();
    }

    public int intValue(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Registry.get((String)key).asInteger();
    }

    public int intValue(@NotNull String key, int defaultValue) {
        int n;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            n = this.intValue(key);
        }
        catch (MissingResourceException ignore) {
            n = defaultValue;
        }
        return n;
    }

    @NotNull
    public RegistryValue get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        RegistryValue registryValue = Registry.get((String)key);
        Intrinsics.checkNotNullExpressionValue((Object)registryValue, (String)"Registry.get(key)");
        return registryValue;
    }

    @NotNull
    public Element getState() {
        Registry registry = Registry.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"Registry.getInstance()");
        Element element2 = registry.getState();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"Registry.getInstance().state");
        return element2;
    }

    public void noStateLoaded() {
        Registry.getInstance().markAsLoaded();
    }

    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Registry registry = Registry.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)registry, (String)"Registry.getInstance()");
        Registry registry2 = registry;
        registry2.loadState(state);
        this.log(registry2);
    }

    private final void log(Registry registry) {
        Map map2 = registry.getUserProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"registry.userProperties");
        Map userProperties = map2;
        if (userProperties.size() <= (userProperties.containsKey("ide.firstStartup") ? 1 : 0)) {
            return;
        }
        Object[] objectArray = ArrayUtilRt.toStringArray((Collection)userProperties.keySet());
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ArrayUtilRt.toStringArray(userProperties.keys)");
        Object[] keys2 = objectArray;
        Arrays.sort(keys2);
        StringBuilder builder2 = new StringBuilder("Registry values changed by user: ");
        for (Object key : keys2) {
            if (Intrinsics.areEqual((Object)"ide.firstStartup", (Object)key)) continue;
            builder2.append((String)key).append(" = ").append((String)userProperties.get(key)).append(", ");
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RegistryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        logger.info(builder2.substring(0, builder2.length() - 2));
    }
}

