/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.util;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lorg/editorconfig/language/util/EditorConfigTextMatchingUtil;", "", "()V", "textMatchesToIgnoreCase", "", "element", "Lcom/intellij/psi/PsiElement;", "other", "", "first", "second", "intellij.editorconfig"})
public final class EditorConfigTextMatchingUtil {
    @NotNull
    public static final EditorConfigTextMatchingUtil INSTANCE;

    public final boolean textMatchesToIgnoreCase(@NotNull PsiElement element, @NotNull PsiElement other) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (element.getTextLength() != other.getTextLength()) {
            return false;
        }
        if (element.textMatches(other)) {
            return true;
        }
        String string = other.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"other.text");
        return this.textMatchesToIgnoreCase(element, (CharSequence)string);
    }

    public final boolean textMatchesToIgnoreCase(@NotNull PsiElement element, @NotNull CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (element.getTextLength() != other.length()) {
            return false;
        }
        if (element.textMatches(other)) {
            return true;
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.text");
        return StringsKt.regionMatches((CharSequence)string, (int)0, (CharSequence)other, (int)0, (int)other.length(), (boolean)true);
    }

    public final boolean textMatchesToIgnoreCase(@NotNull CharSequence first, @NotNull CharSequence second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (first.length() != second.length()) {
            return false;
        }
        return StringsKt.regionMatches((CharSequence)first, (int)0, (CharSequence)second, (int)0, (int)first.length(), (boolean)true);
    }

    private EditorConfigTextMatchingUtil() {
    }

    static {
        EditorConfigTextMatchingUtil editorConfigTextMatchingUtil;
        INSTANCE = editorConfigTextMatchingUtil = new EditorConfigTextMatchingUtil();
    }
}

