/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;

public final class SourceMapFileType
extends LanguageFileType {
    public static final SourceMapFileType INSTANCE = new SourceMapFileType();
    public static final String DOT_DEFAULT_EXTENSION = ".map";

    private SourceMapFileType() {
        super((Language)JsonLanguage.INSTANCE, true);
    }

    @NotNull
    public String getName() {
        return "SourceMap";
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        return "SourceMap";
    }

    @NotNull
    public String getDefaultExtension() {
        return "map";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Json;
    }

    static final class MyFileTypeDetector
    implements FileTypeRegistry.FileTypeDetector {
        MyFileTypeDetector() {
        }

        @Nullable
        public FileType detect(@NotNull VirtualFile file2, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
            if (file2 == null) {
                MyFileTypeDetector.$$$reportNull$$$0(0);
            }
            if (firstBytes == null) {
                MyFileTypeDetector.$$$reportNull$$$0(1);
            }
            if (!StringUtil.endsWith((CharSequence)file2.getNameSequence(), (CharSequence)SourceMapFileType.DOT_DEFAULT_EXTENSION) || firstCharsIfText == null) {
                return null;
            }
            try {
                JsonReaderEx jsonReader = new JsonReaderEx(firstCharsIfText);
                if (jsonReader.peek() != JsonToken.BEGIN_OBJECT) {
                    return null;
                }
                jsonReader.beginObject();
                String firstName = jsonReader.nextName();
                return firstName.equals("version") && jsonReader.peek() == JsonToken.NUMBER || firstName.equals("names") && jsonReader.peek() == JsonToken.BEGIN_ARRAY ? INSTANCE : null;
            }
            catch (Exception ignored) {
                return null;
            }
        }

        public int getDesiredContentPrefixLength() {
            return 128;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "firstBytes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/debugger/sourcemap/SourceMapFileType$MyFileTypeDetector";
            objectArray[2] = "detect";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

