/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.scripts.SourceContentFile;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystem;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\b\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/scripts/VmScriptFile;", "Lcom/intellij/javascript/debugger/scripts/SourceContentFile;", "script", "Lorg/jetbrains/debugger/Script;", "(Lorg/jetbrains/debugger/Script;)V", "getScript", "()Lorg/jetbrains/debugger/Script;", "setScript", "ensureDownloaded", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "setContent", "", "requestor", "", "content", "", "fireEvent", "", "intellij.javascript.debugger"})
public final class VmScriptFile
extends SourceContentFile {
    @NotNull
    private volatile Script script;

    public void setContent(@Nullable Object requestor, @NotNull CharSequence content, boolean fireEvent) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (Intrinsics.areEqual((Object)content, (Object)this.getContent())) {
            return;
        }
        super.setContent(requestor, content, fireEvent);
        if (fireEvent) {
            AppUIUtil.invokeOnEdt((Runnable)new Runnable(this){
                final /* synthetic */ VmScriptFile this$0;

                public final void run() {
                    FileDocumentManager.getInstance().reloadFiles(new VirtualFile[]{(VirtualFile)this.this$0});
                }
                {
                    this.this$0 = vmScriptFile;
                }
            });
        }
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)VmScriptFileSystem.Companion.getInstance();
    }

    @NotNull
    public final Promise<VirtualFile> ensureDownloaded() {
        if (this.isLoaded()) {
            return Promises.resolvedPromise((Object)((Object)this));
        }
        Script script = this.script;
        Promise promise2 = script.getVm().getScriptManager().getSource(script).then((Function)new Function<String, VirtualFile>(this){
            final /* synthetic */ VmScriptFile this$0;

            public final VirtualFile fun(String it) {
                String string = StringUtilRt.convertLineSeparators((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtilRt.convertLineSeparators(it)");
                this.this$0.setContent(null, string, true);
                return (VirtualFile)this.this$0;
            }
            {
                this.this$0 = vmScriptFile;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"script.vm.scriptManager.\u2026rue)\n        this\n      }");
        return promise2;
    }

    @NotNull
    public final Script getScript() {
        return this.script;
    }

    public final void setScript(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        if (Intrinsics.areEqual((Object)this.script, (Object)script) ^ true) {
            this.setContent(null, "", false);
            this.script = script;
            this.ensureDownloaded();
        }
    }

    public VmScriptFile(@NotNull Script script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        super(script.getUrl(), "");
        this.script = script;
    }
}

