/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport;
import com.intellij.javascript.debugger.scripts.ConsumerOnEdt;
import com.intellij.javascript.debugger.scripts.FileInfo;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.ScriptTreeActionBase;
import com.intellij.javascript.debugger.scripts.SourcesTreeComponent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/scripts/OpenActualScriptSourceAction;", "Lcom/intellij/javascript/debugger/scripts/ScriptTreeActionBase;", "treeComponent", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "(Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;)V", "isApplicable", "", "info", "Lcom/intellij/javascript/debugger/scripts/FileInfo;", "perform", "", "node", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.javascript.debugger"})
final class OpenActualScriptSourceAction
extends ScriptTreeActionBase {
    @Override
    protected boolean isApplicable(@NotNull FileInfo info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        return info.getScripts$intellij_javascript_debugger().size() == 1 && this.getTreeComponent().getDebugProcess().getConnection().getState().getStatus() == ConnectionStatus.CONNECTED;
    }

    @Override
    protected void perform(@NotNull FileNode node, @NotNull DataContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JavaScriptDebugProcess<?> debugProcess = this.getTreeComponent().getDebugProcess();
        JavaScriptDebuggerViewSupport viewSupport = debugProcess.getDebuggerViewSupport();
        viewSupport.getFileByUrlOrVmSource(node.getFileInfo().getFirstScript(), false).onSuccess((Consumer)new ConsumerOnEdt<VirtualFile>(this, this.getProject()){
            final /* synthetic */ OpenActualScriptSourceAction this$0;

            public void consume(@NotNull Project project, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                FileEditorManager.getInstance((Project)project).openFile(file2, true);
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        });
    }

    public OpenActualScriptSourceAction(@NotNull SourcesTreeComponent treeComponent) {
        Intrinsics.checkNotNullParameter((Object)treeComponent, (String)"treeComponent");
        super(treeComponent, JSDebuggerBundle.message("js.scripts.action.open.actual", new Object[0]));
    }
}

