/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.console.HyperLink$WhenMappings;
import com.intellij.javascript.debugger.console.LinkType;
import com.intellij.javascript.debugger.console.PrintableEntity;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/debugger/console/HyperLink;", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "hyperlink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "linkType", "Lcom/intellij/javascript/debugger/console/LinkType;", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lcom/intellij/execution/filters/HyperlinkInfo;Lcom/intellij/javascript/debugger/console/LinkType;)V", "getHyperlink", "()Lcom/intellij/execution/filters/HyperlinkInfo;", "getLinkType", "()Lcom/intellij/javascript/debugger/console/LinkType;", "getJSProps", "", "", "getJSStyles", "", "getJSType", "intellij.javascript.debugger"})
public final class HyperLink
extends PrintableEntity {
    @Nullable
    private final HyperlinkInfo hyperlink;
    @NotNull
    private final LinkType linkType;

    @Override
    @NotNull
    public String getJSType() {
        String string;
        switch (HyperLink$WhenMappings.$EnumSwitchMapping$0[this.linkType.ordinal()]) {
            case 1: {
                string = "source-link";
                break;
            }
            case 2: {
                string = "browser-link";
                break;
            }
            case 3: {
                string = "message-link";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Override
    @NotNull
    public Map<String, Object> getJSProps() {
        Map<String, Object> jsProps = super.getJSProps();
        jsProps.put("styleClasses", this.getJSStyles());
        return jsProps;
    }

    private final List<String> getJSStyles() {
        return CollectionsKt.listOf((Object)this.getJSType());
    }

    @Nullable
    public final HyperlinkInfo getHyperlink() {
        return this.hyperlink;
    }

    @NotNull
    public final LinkType getLinkType() {
        return this.linkType;
    }

    public HyperLink(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable HyperlinkInfo hyperlink, @NotNull LinkType linkType) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)linkType), (String)"linkType");
        super(text, contentType, null, null, 12, null);
        this.hyperlink = hyperlink;
        this.linkType = linkType;
    }
}

