/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.GlobalEvaluator;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.Annotation;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.ConsolePrinter;
import com.intellij.javascript.debugger.console.EditorConsoleGutterProvider;
import com.intellij.javascript.debugger.console.EditorConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.LineAnnotation;
import com.intellij.javascript.debugger.console.LineAnnotationMaps;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.xdebugger.XDebugSession;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ<\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0016J<\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u000eH\u0016J\"\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\fH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0018\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0010\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u001dH\u0016J*\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010)\u001a\u00020\nH\u0016J\b\u0010*\u001a\u00020\fH\u0016J\u001a\u0010+\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\u001a\u0010.\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010/\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/javascript/debugger/console/EditorConsoleMessageBuilder;", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "consoleView", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "gutterProvider", "Lcom/intellij/javascript/debugger/console/EditorConsoleGutterProvider;", "(Lcom/intellij/execution/impl/ConsoleViewImpl;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/javascript/debugger/console/EditorConsoleGutterProvider;)V", "hasNewLines", "", "addHyperLink", "", "url", "", "suggestedLine", "", "suggestedColumn", "functionName", "resolveToScript", "scriptId", "addMessageLink", "append", "text", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "style", "doPrintIndent", "it", "Lcom/intellij/javascript/debugger/console/ConsolePrinter;", "endMessage", "groupEnd", "groupStart", "groupName", "collapsed", "print", "consolePrinter", "printAndStoreValueToInspect", "value", "Lorg/jetbrains/debugger/values/Value;", "expression", "xmlView", "printIndent", "printStackTrace", "stackTrace", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "startMessage", "source", "intellij.javascript.debugger"})
public final class EditorConsoleMessageBuilder
extends ConsoleMessageBuilder {
    private boolean hasNewLines;
    private final EditorConsoleGutterProvider gutterProvider;

    @Override
    public void startMessage(@NotNull ConsoleViewContentType contentType, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
    }

    @Override
    public void endMessage() {
        this.newLine();
    }

    @Override
    public void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, boolean xmlView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.getTasks().add(new Consumer<ConsolePrinter>(this, value, expression, contentType){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            final /* synthetic */ Value $value;
            final /* synthetic */ String $expression;
            final /* synthetic */ ConsoleViewContentType $contentType;

            public final void consume(ConsolePrinter it) {
                GlobalEvaluator globalEvaluator = this.this$0.getDebugProcess().getGlobalEvaluator();
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                Intrinsics.checkNotNull((Object)consoleView);
                globalEvaluator.printAndStoreValueToInspect(this.$value, this.$expression, this.$contentType, consoleView);
            }
            {
                this.this$0 = editorConsoleMessageBuilder;
                this.$value = value;
                this.$expression = string;
                this.$contentType = consoleViewContentType;
            }
        });
    }

    @Override
    public void append(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable String style) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.getTasks().add(new Consumer<ConsolePrinter>(this, text){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            final /* synthetic */ String $text;

            public final void consume(ConsolePrinter it) {
                if (this.$text.length() > 1 && StringsKt.contains$default((CharSequence)this.$text, (char)'\n', (boolean)false, (int)2, null)) {
                    EditorConsoleMessageBuilder.access$setHasNewLines$p(this.this$0, true);
                }
                AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
                decoder.escapeText(this.$text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(it){
                    final /* synthetic */ ConsolePrinter $it;

                    public final void coloredTextAvailable(@NotNull String textChunk, @NotNull Key<Object> attributes) {
                        block0: {
                            Intrinsics.checkNotNullParameter((Object)textChunk, (String)"textChunk");
                            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
                            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(attributes);
                            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"ConsoleViewContentType.g\u2026nsoleViewType(attributes)");
                            ConsoleViewContentType chunkContentType = consoleViewContentType;
                            ConsoleView consoleView = this.$it.getConsoleView$intellij_javascript_debugger();
                            if (consoleView == null) break block0;
                            consoleView.print(textChunk, chunkContentType);
                        }
                    }
                    {
                        this.$it = consolePrinter;
                    }
                });
            }
            {
                this.this$0 = editorConsoleMessageBuilder;
                this.$text = string;
            }
        });
    }

    @Override
    public void printStackTrace(@NotNull ConsoleViewContentType contentType, @Nullable StackTraceValue stackTrace) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (stackTrace == null) {
            return;
        }
        if (stackTrace.callFrames().isEmpty() || Intrinsics.areEqual((Object)"undefined", (Object)((CallFrameValue)CollectionsKt.first((List)stackTrace.callFrames())).url())) {
            return;
        }
        this.newLine();
        this.indentIn();
        for (StackTraceValue currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            if (Intrinsics.areEqual((Object)currentStackTrace, (Object)stackTrace) ^ true) {
                ConsoleMessageBuilder.append$default(this, "Async call from " + currentStackTrace.getDescription(), contentType, null, 4, null);
                this.newLine();
            }
            for (CallFrameValue frame : currentStackTrace.callFrames()) {
                this.printIndent();
                CharSequence charSequence = frame.functionName();
                boolean bl = false;
                ConsoleMessageBuilder.append$default(this, charSequence.length() == 0 ? "(anonymous function)" : frame.functionName(), contentType, null, 4, null);
                ConsoleMessageBuilder.append$default(this, "\t", contentType, null, 4, null);
                this.addHyperLink(frame.url(), frame.getLineNumber(), frame.getColumnNumber(), frame.functionName(), true, frame.scriptId());
                this.newLine();
            }
        }
        this.indentOut();
    }

    @Override
    public void groupStart(@NotNull String groupName, boolean collapsed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getTasks().add(new Consumer<ConsolePrinter>(groupName){
            final /* synthetic */ String $groupName;

            public final void consume(ConsolePrinter it) {
                ConsolePrinter consolePrinter = it;
                int n = consolePrinter.getIndentLevel$intellij_javascript_debugger();
                consolePrinter.setIndentLevel$intellij_javascript_debugger(n + 1);
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                Intrinsics.checkNotNull((Object)consoleView);
                consoleView.print("> " + this.$groupName, ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            {
                this.$groupName = string;
            }
        });
    }

    @Override
    public void groupEnd() {
        this.getTasks().add(groupEnd.1.INSTANCE);
    }

    @Override
    public void addMessageLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.addHyperLink(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
    }

    @Override
    public void addHyperLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int line = suggestedLine;
        int column = suggestedColumn;
        if (resolveToScript) {
            Vm vm = this.getDebugProcess().getActiveOrMainVm();
            if (vm != null) {
                Vm vm2 = vm;
                boolean bl = false;
                boolean bl2 = false;
                Vm vm3 = vm2;
                boolean bl3 = false;
                sourceInfo = this.getDebugProcess().getSourceInfo(vm3, scriptId, url, functionName, line, column);
            } else {
                sourceInfo = null;
            }
        } else {
            sourceInfo = null;
        }
        SourceInfo sourceInfo2 = sourceInfo;
        VirtualFile file2 = null;
        Url parsedUrl = null;
        if (sourceInfo2 == null) {
            parsedUrl = ScriptDebuggerUrls.parse((String)url, (boolean)true);
            file2 = parsedUrl == null ? null : JavaScriptDebugProcess.findFile$default(this.getDebugProcess(), parsedUrl, false, null, 6, null);
        } else {
            file2 = sourceInfo2.getFile();
            line = sourceInfo2.getLine();
            column = sourceInfo2.getColumn();
            parsedUrl = null;
        }
        XDebugSession xDebugSession = this.getDebugProcess().getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
        Project project = xDebugSession.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"debugProcess.session.project");
        Project project2 = project;
        Annotation annotation = null;
        if (file2 == null) {
            Url url2 = parsedUrl;
            if (url2 == null) {
                url2 = Urls.newUnparsable((String)url);
            }
            annotation = new Annotation(url2, line, column);
        } else {
            annotation = line < 0 ? new Annotation(file2, line, column, null) : new Annotation(file2, line, column, LazyRangeMarkerFactory.getInstance((Project)project2).createRangeMarker(file2, line, column, false));
        }
        this.getTasks().add(new Consumer<ConsolePrinter>(this, annotation){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;
            final /* synthetic */ Annotation $annotation;

            public final void consume(ConsolePrinter it) {
                ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
                if (consoleView != null) {
                    int annoLine = this.$annotation.getLine();
                    VirtualFile annoFile = this.$annotation.getFile();
                    Annotation existingAnno = annoLine >= 0 && annoFile != null ? EditorConsoleMessageBuilder.access$getGutterProvider$p(this.this$0).getLineToAnnotation$intellij_javascript_debugger().find(annoFile, annoLine, this.$annotation.getColumn()) : null;
                    LineAnnotationMaps lineAnnotationMaps = EditorConsoleMessageBuilder.access$getGutterProvider$p(this.this$0).getLineToAnnotation$intellij_javascript_debugger();
                    int n = consoleView.getContentSize();
                    Annotation annotation = existingAnno;
                    if (annotation == null) {
                        annotation = this.$annotation;
                    }
                    lineAnnotationMaps.add(n, new LineAnnotation(annotation, 0), existingAnno == null);
                }
            }
            {
                this.this$0 = editorConsoleMessageBuilder;
                this.$annotation = annotation;
            }
        });
    }

    @Override
    public void printIndent() {
        this.getTasks().add(new Consumer<ConsolePrinter>(this){
            final /* synthetic */ EditorConsoleMessageBuilder this$0;

            public final void consume(ConsolePrinter it) {
                ConsolePrinter consolePrinter = it;
                Intrinsics.checkNotNullExpressionValue((Object)consolePrinter, (String)"it");
                EditorConsoleMessageBuilder.access$doPrintIndent(this.this$0, consolePrinter);
            }
            {
                this.this$0 = editorConsoleMessageBuilder;
            }
        });
    }

    private final void doPrintIndent(ConsolePrinter it) {
        int l = it.getIndentLevel$intellij_javascript_debugger();
        while (l-- > 0) {
            ConsoleView consoleView = it.getConsoleView$intellij_javascript_debugger();
            Intrinsics.checkNotNull((Object)consoleView);
            consoleView.print("  ", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(@NotNull ConsolePrinter consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        int startOffset = this.getConsoleView().getContentSize();
        this.hasNewLines = false;
        try {
            if (consolePrinter.getIndentLevel$intellij_javascript_debugger() != 0) {
                this.doPrintIndent(consolePrinter);
            }
            Iterable $this$forEach$iv = this.getTasks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Consumer it = (Consumer)element$iv;
                boolean bl = false;
                it.consume((Object)consolePrinter);
            }
        }
        finally {
            boolean markAsRelatedLines = this.hasNewLines;
            this.hasNewLines = false;
            if (markAsRelatedLines) {
                int endOffset = this.getConsoleView().getContentSize();
                this.gutterProvider.getRelatedLines$intellij_javascript_debugger().add(startOffset, endOffset);
            }
        }
    }

    public EditorConsoleMessageBuilder(@NotNull ConsoleViewImpl consoleView, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull EditorConsoleGutterProvider gutterProvider) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)((Object)gutterProvider), (String)"gutterProvider");
        super((ConsoleView)consoleView, debugProcess);
        this.gutterProvider = gutterProvider;
    }

    public static final /* synthetic */ boolean access$getHasNewLines$p(EditorConsoleMessageBuilder $this) {
        return $this.hasNewLines;
    }

    public static final /* synthetic */ void access$setHasNewLines$p(EditorConsoleMessageBuilder $this, boolean bl) {
        $this.hasNewLines = bl;
    }

    public static final /* synthetic */ EditorConsoleGutterProvider access$getGutterProvider$p(EditorConsoleMessageBuilder $this) {
        return $this.gutterProvider;
    }

    public static final /* synthetic */ void access$doPrintIndent(EditorConsoleMessageBuilder $this, ConsolePrinter it) {
        $this.doPrintIndent(it);
    }
}

