/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.browserConnection;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufOutputStream;
import java.io.OutputStream;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.AboutHttpServiceKt;

public final class IdeService {
    private static final Predicate<Project> NULLIZE_PROJECT_CONDITION = project -> project == null || !project.isInitialized() || project.isDefault();

    public void focusProjectWindow(@NotNull String pageUrl) {
        if (pageUrl == null) {
            IdeService.$$$reportNull$$$0(0);
        }
        IdeService.doFocus(this.findProject(Urls.newFromEncoded((String)pageUrl)));
    }

    public ByteBuf about() {
        ByteBuf buffer = ByteBufAllocator.DEFAULT.ioBuffer();
        boolean success = false;
        try {
            AboutHttpServiceKt.writeApplicationInfoJson((OutputStream)new ByteBufOutputStream(buffer), null, (boolean)false);
            success = true;
        }
        finally {
            if (!success) {
                buffer.release();
            }
        }
        return buffer;
    }

    @Nullable
    public Project findProject(@NotNull Url url) {
        Project lastProject;
        Project[] projects;
        if (url == null) {
            IdeService.$$$reportNull$$$0(1);
        }
        if ((projects = ProjectManager.getInstance().getOpenProjects()).length == 1) {
            return (Project)ObjectUtils.nullizeByCondition((Object)projects[0], NULLIZE_PROJECT_CONDITION);
        }
        if (projects.length == 0) {
            return null;
        }
        IdeFrame lastFocusedFrame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project = lastProject = lastFocusedFrame == null ? null : (Project)ObjectUtils.nullizeByCondition((Object)lastFocusedFrame.getProject(), NULLIZE_PROJECT_CONDITION);
        if (lastProject != null && IdeService.findFile(url, lastProject) != null) {
            return lastProject;
        }
        for (Project project2 : projects) {
            if (NULLIZE_PROJECT_CONDITION.test(project2) || project2 == lastProject || IdeService.findFile(url, project2) == null) continue;
            return project2;
        }
        return (Project)ObjectUtils.nullizeByCondition((Object)projects[projects.length - 1], NULLIZE_PROJECT_CONDITION);
    }

    @Nullable
    private static Project findFile(@NotNull Url url, @NotNull Project project) {
        if (url == null) {
            IdeService.$$$reportNull$$$0(2);
        }
        if (project == null) {
            IdeService.$$$reportNull$$$0(3);
        }
        for (FileUrlMapper mapper : (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions()) {
            if (mapper.getFile(url, project, null) == null) continue;
            return project;
        }
        return null;
    }

    private static void doFocus(@Nullable Project project) {
        if (project == null) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> ProjectUtil.focusProjectWindow((Project)project, (boolean)true), project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pageUrl";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/browserConnection/IdeService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "focusProjectWindow";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

