/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.browserConnection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.browserConnection.BrowserQualifier;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtilRt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public abstract class BrowserConnector {
    static final ExtensionPointName<BrowserConnector> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.browserConnector");

    public abstract boolean canHandle(@NotNull BrowserQualifier var1);

    @NotNull
    public abstract Promise<Void> ensureExtensionInstalled(@NotNull WebBrowser var1, @Nullable Project var2);

    public String[] getLaunchParameters() {
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    public abstract void checkVersion(@NotNull WebBrowser var1, @Nullable String var2, @Nullable Project var3);

    @Nullable
    static BrowserConnector get(@NotNull BrowserQualifier browserQualifier) {
        if (browserQualifier == null) {
            BrowserConnector.$$$reportNull$$$0(0);
        }
        for (BrowserConnector connector : EP_NAME.getExtensionList()) {
            if (!connector.canHandle(browserQualifier)) continue;
            return connector;
        }
        return null;
    }

    @Nullable
    static BrowserConnector get(@NotNull WebBrowser browser) {
        if (browser == null) {
            BrowserConnector.$$$reportNull$$$0(1);
        }
        switch (browser.getFamily()) {
            case CHROME: 
            case OPERA: {
                return BrowserConnector.get(BrowserQualifier.CHROME);
            }
            case FIREFOX: {
                return BrowserConnector.get(BrowserQualifier.FIREFOX);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "browserQualifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "browser";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/debugger/browserConnection/BrowserConnector";
        objectArray[2] = "get";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

