/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "useFileScheme", "", "(Z)V", "()V", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteUrls", "", "file", "intellij.javascript.debugger"})
public class LocalFileSystemFileFinder
implements DebuggableFileFinder {
    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        String projectBasePath;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
        String path = string;
        if (!FileUtil.isAbsolutePlatformIndependent((String)path)) {
            return null;
        }
        VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
        if (file2 == null && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((String)projectBasePath, (String)path, (boolean)true)) {
            file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        if (file2 != null && !GlobalSearchScope.allScope((Project)project).contains(file2)) {
            VirtualFile notNullFile = file2;
            file2 = (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(project, notNullFile){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $notNullFile;

                @NotNull
                public final VirtualFile compute() {
                    return ProjectRootUtil.findSymlinkedFileInContent((Project)this.$project, (VirtualFile)this.$notNullFile);
                }
                {
                    this.$project = project;
                    this.$notNullFile = virtualFile;
                }
            });
        }
        if ((virtualFile = file2) == null) {
            virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(path, project);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return CollectionsKt.listOf((Object)ScriptDebuggerUrls.newLocalFileUrl((String)string));
    }

    @Deprecated(message="useFileScheme is deprecated")
    @ApiStatus.ScheduledForRemoval(inVersion="2020.3")
    public LocalFileSystemFileFinder(boolean useFileScheme) {
        this();
    }

    public /* synthetic */ LocalFileSystemFileFinder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public LocalFileSystemFileFinder() {
    }

    @Override
    @Nullable
    public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.guessFile(this, url, project);
    }

    @Override
    public boolean searchesByName() {
        return DebuggableFileFinder.DefaultImpls.searchesByName(this);
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findNavigatable(this, url, project);
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.canSetRemoteUrl(this, file2, project);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file2);
    }
}

