/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.NameMapper;
import com.intellij.javascript.debugger.NameMapperKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.SideEffectChecker;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a.\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u001a$\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00010\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0003H\u0002\u00a8\u0006\u0013"}, d2={"computeGeneratedName", "", "element", "Lcom/intellij/psi/PsiElement;", "generatedDocument", "Lcom/intellij/openapi/editor/Document;", "sourceMap", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "mappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "doExtractName", "kotlin.jvm.PlatformType", "rawGeneratedName", "", "context", "isValidExpression", "", "generatedCode", "intellij.javascript.debugger"})
public final class JavaScriptNameMapperKt {
    public static final String doExtractName(@Nullable CharSequence rawGeneratedName, @Nullable PsiElement context) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(rawGeneratedName, context){
            final /* synthetic */ CharSequence $rawGeneratedName;
            final /* synthetic */ PsiElement $context;

            public final String compute() {
                String generatedName;
                block11: {
                    if (this.$rawGeneratedName == null) {
                        return null;
                    }
                    String string = generatedName = NameMapperKt.getNAME_TRIMMER().trimFrom(this.$rawGeneratedName);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generatedName");
                    int i = StringsKt.indexOf$default((CharSequence)string, (char)'=', (int)0, (boolean)false, (int)6, null);
                    if (i > 0 && this.$context != null) {
                        PsiElement eqExpr = this.$context;
                        while (!eqExpr.textContains('=') && eqExpr.getParent() != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)eqExpr.getParent(), (String)"eqExpr.parent");
                        }
                        String string2 = eqExpr.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"eqExpr.text");
                        int eqPos = StringsKt.indexOf$default((CharSequence)string2, (char)'=', (int)0, (boolean)false, (int)6, null);
                        if (eqPos == -1) {
                            return null;
                        }
                        String string3 = eqExpr.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"eqExpr.text");
                        CharSequence charSequence = string3;
                        String string4 = this.$context.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.text");
                        int elementPos = StringsKt.indexOf$default((CharSequence)charSequence, (String)string4, (int)0, (boolean)false, (int)6, null);
                        if (elementPos < eqPos) {
                            JSFlexAdapter lexer = new JSFlexAdapter(DialectOptionHolder.ECMA_6);
                            lexer.start((CharSequence)generatedName);
                            while (true) {
                                IElementType tokenType;
                                if (lexer.getTokenType() == null) {
                                    break block11;
                                }
                                Intrinsics.checkNotNullExpressionValue((Object)tokenType, (String)"lexer.tokenType ?: break");
                                if (Intrinsics.areEqual((Object)tokenType, (Object)JSTokenTypes.IDENTIFIER)) {
                                    return lexer.getTokenText();
                                }
                                lexer.advance();
                            }
                        }
                        generatedName = StringsKt.substringAfter$default((String)generatedName, (char)'=', null, (int)2, null);
                    }
                }
                if (JSNamesValidation.isIdentifierName((String)generatedName)) {
                    return generatedName;
                }
                if (this.$context != null && this.$context.getParent() instanceof PsiNamedElement) {
                    String string = generatedName;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generatedName");
                    if (JavaScriptNameMapperKt.access$isValidExpression(string, this.$context)) {
                        return generatedName;
                    }
                }
                return null;
            }
            {
                this.$rawGeneratedName = charSequence;
                this.$context = psiElement;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String computeGeneratedName(@NotNull PsiElement element, @NotNull Document generatedDocument, @NotNull SourceMap sourceMap, @NotNull List<? extends MappingEntry> mappings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)generatedDocument, (String)"generatedDocument");
        Intrinsics.checkNotNullParameter((Object)sourceMap, (String)"sourceMap");
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        boolean isNamedElement = element.getParent() instanceof PsiNamedElement;
        if (isNamedElement && mappings.size() > 1) {
            return null;
        }
        CharSequence charSequence = generatedDocument.getImmutableCharSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"generatedDocument.immutableCharSequence");
        CharSequence charSequence2 = charSequence;
        StringBuilder expressionBuilder = null;
        CharSequence result2 = null;
        int n = 0;
        int n2 = mappings.size();
        while (n < n2) {
            void i;
            MappingEntry mapping = mappings.get((int)i);
            MappingEntry mappingEntry = (MappingEntry)CollectionsKt.getOrNull(mappings, (int)(i + true));
            if (mappingEntry == null) {
                mappingEntry = sourceMap.getGeneratedMappings().getNextOnTheSameLine(mapping);
            }
            MappingEntry nextMapping = mappingEntry;
            int generatedLineStartOffset = generatedDocument.getLineStartOffset(mapping.getGeneratedLine());
            int start = generatedLineStartOffset + mapping.getGeneratedColumn();
            Function1<MappingEntry, Integer> $fun$computeEnd$1 = new Function1<MappingEntry, Integer>(mapping, generatedDocument, generatedLineStartOffset){
                final /* synthetic */ MappingEntry $mapping;
                final /* synthetic */ Document $generatedDocument;
                final /* synthetic */ int $generatedLineStartOffset;

                public final int invoke(@Nullable MappingEntry nextMapping) {
                    return nextMapping == null || nextMapping.getGeneratedLine() != this.$mapping.getGeneratedLine() ? this.$generatedDocument.getLineEndOffset(this.$mapping.getGeneratedLine()) : this.$generatedLineStartOffset + nextMapping.getGeneratedColumn();
                }
                {
                    this.$mapping = mappingEntry;
                    this.$generatedDocument = document;
                    this.$generatedLineStartOffset = n;
                    super(1);
                }
            };
            int end = $fun$computeEnd$1.invoke(nextMapping);
            if (nextMapping != null) {
                if (start > end && nextMapping.getGeneratedColumn() >= mapping.getGeneratedColumn()) {
                    JavaScriptDebugProcessKt.getLOG().warn("incorrect sourcemap, backwards mappings for named element " + element.getText());
                    return null;
                }
                if (isNamedElement && start == end) {
                    MappingEntry m = nextMapping;
                    while (start == (end = $fun$computeEnd$1.invoke(m = sourceMap.getGeneratedMappings().getNext(m))) && m != null) {
                    }
                }
            }
            CharSequence name = charSequence2.subSequence(start, end);
            if (isNamedElement) {
                CharSequence charSequence3 = result2 = (CharSequence)JavaScriptNameMapperKt.doExtractName(name, element);
                return charSequence3 != null ? ((Object)charSequence3).toString() : null;
            }
            if (expressionBuilder == null) {
                expressionBuilder = new StringBuilder();
                result2 = expressionBuilder;
            }
            if (name.length() == 1 && name.charAt(0) == '.') {
                expressionBuilder.append('.');
            } else {
                expressionBuilder.append(NameMapper.Companion.trimName(name, i + true == mappings.size()));
            }
            ++i;
        }
        if (JavaScriptNameMapperKt.isValidExpression(String.valueOf(result2), element)) {
            return String.valueOf(result2);
        }
        return null;
    }

    private static final boolean isValidExpression(String generatedCode, PsiElement context) {
        Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(generatedCode, context){
            final /* synthetic */ String $generatedCode;
            final /* synthetic */ PsiElement $context;

            public final Boolean compute() {
                ASTNode aSTNode = JSChangeUtil.tryCreateExpressionWithContext((String)this.$generatedCode, (PsiElement)this.$context, (JSLanguageDialect)JavaScriptSupportLoader.ECMA_SCRIPT_6);
                PsiElement expr = aSTNode != null ? aSTNode.getPsi() : null;
                return expr instanceof JSExpression && !PsiTreeUtil.hasErrorElements((PsiElement)expr) && !SideEffectChecker.mayHaveSideEffects((JSExpression)((JSExpression)expr));
            }
            {
                this.$generatedCode = string;
                this.$context = psiElement;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026ayHaveSideEffects(expr)\n}");
        return (Boolean)object;
    }

    public static final /* synthetic */ boolean access$isValidExpression(String generatedCode, PsiElement context) {
        return JavaScriptNameMapperKt.isValidExpression(generatedCode, context);
    }
}

