/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.CharPercentEscaper;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.Url;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Location;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a@\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\n\u0010\r\u001a\u00060\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u00122\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0001H\u0000\u001a\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"DIRECT_SLASH_OR_DISK_LETTER", "", "ESCAPED_SLASH", "PATTERN_PARAMETERS_POSTFIX", "SLASH", "createUrlRegExp", "location", "Lorg/jetbrains/debugger/Location;", "useCaseSensitiveUrl", "", "escapePath", "", "backslashAware", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "encodedUrl", "start", "", "end", "match", "regExp", "input", "matches", "url", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
public final class JavaScriptLineBreakpointManagerKt {
    @NotNull
    public static final String PATTERN_PARAMETERS_POSTFIX = "([;?#!].*)?$";
    @NotNull
    public static final String DIRECT_SLASH_OR_DISK_LETTER = "(?:(?:file:\\/\\/)?\\/|(?:[\\w]:))";
    @NotNull
    public static final String SLASH = "[\\/|\\\\]";
    @NotNull
    public static final String ESCAPED_SLASH = "[/\\\\]";

    private static final String createUrlRegExp(Location location, boolean useCaseSensitiveUrl) {
        StringBuilder builder = new StringBuilder();
        Url url = location.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"location.url");
        Url url2 = url;
        String scheme = url2.getScheme();
        if (scheme == null) {
            builder.append('^');
            String string = url2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, string, 0, 0, useCaseSensitiveUrl, 16, null);
        } else {
            String string = PathUtilRt.getFileName((String)url2.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtilRt.getFileName(url.path)");
            String filename = string;
            if (StringsKt.startsWith$default((String)filename, (String)"index.", (boolean)false, (int)2, null) && !url2.isInLocalFileSystem()) {
                builder.append('^');
                builder.append(scheme).append("://");
                String string2 = url2.getAuthority();
                Intrinsics.checkNotNull((Object)string2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"url.authority!!");
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, string2, 0, 0, useCaseSensitiveUrl, 24, null);
                builder.append('/');
                int dirLength = url2.getPath().length() - filename.length();
                if (dirLength > 0) {
                    builder.append('(');
                    String string3 = url2.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"url.path");
                    JavaScriptLineBreakpointManagerKt.escapePath(false, builder, string3, 1, dirLength, useCaseSensitiveUrl);
                    builder.append('|').append("[^.;?#]+");
                    builder.append(')').append('?');
                }
                builder.append('(');
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, filename, 0, 0, useCaseSensitiveUrl, 16, null);
                builder.append(')').append('?');
            } else {
                boolean useDetailed;
                boolean bl = useDetailed = location.getScript() != null;
                if (!useDetailed) {
                    builder.append(ESCAPED_SLASH);
                }
                String string4 = useDetailed ? url2.getPath() : filename;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"if (useDetailed) url.path else filename");
                JavaScriptLineBreakpointManagerKt.escapePath$default(false, builder, string4, 0, 0, useDetailed || useCaseSensitiveUrl, 16, null);
            }
        }
        builder.append(PATTERN_PARAMETERS_POSTFIX);
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        String result2 = string;
        Url url3 = location.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)url3, (String)"location.url");
        if (!JavaScriptLineBreakpointManagerKt.matches(result2, url3)) {
            JavaScriptDebugProcessKt.getLOG().error("Breakpoint regexp doesn't match url: url = " + url2 + ", regexp = " + result2);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public static final void escapePath(boolean backslashAware, @NotNull StringBuilder builder, @NotNull String encodedUrl, int start, int end, boolean useCaseSensitiveUrl) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)encodedUrl, (String)"encodedUrl");
        int n = start;
        int n2 = end;
        while (n < n2) {
            char lowerCasedChar;
            char upperCasedChar;
            void i;
            char c = encodedUrl.charAt((int)i);
            if (backslashAware && c == '\\') {
                builder.append(ESCAPED_SLASH);
            } else if (c == '/') {
                if (backslashAware) {
                    builder.append(ESCAPED_SLASH);
                } else {
                    builder.append(c);
                }
            } else if (StringsKt.contains$default((CharSequence)".?*+^$[](){}|-\\", (char)c, (boolean)false, (int)2, null)) {
                builder.append('\\').append(c);
            } else if (!useCaseSensitiveUrl && Character.isLetter(c) && (upperCasedChar = Character.toUpperCase(c)) != (lowerCasedChar = Character.toLowerCase(c))) {
                if (CharPercentEscaper.isSafe(c)) {
                    builder.append('[').append(lowerCasedChar).append(upperCasedChar).append(']');
                } else {
                    builder.append('(').append(lowerCasedChar).append('|').append(upperCasedChar).append('|');
                    String string = encodedUrl;
                    boolean bl = false;
                    CharPercentEscaper.escape(string.codePointAt((int)i), builder);
                    builder.append(')');
                }
            } else if (!CharPercentEscaper.isSafe(c)) {
                builder.append('(').append(c).append('|');
                String string = encodedUrl;
                boolean bl = false;
                CharPercentEscaper.escape(string.codePointAt((int)i), builder);
                builder.append(')');
            } else {
                builder.append(c);
            }
            ++i;
        }
    }

    public static /* synthetic */ void escapePath$default(boolean bl, StringBuilder stringBuilder, String string, int n, int n2, boolean bl2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n = 0;
        }
        if ((n3 & 0x10) != 0) {
            n2 = string.length();
        }
        if ((n3 & 0x20) != 0) {
            bl2 = true;
        }
        JavaScriptLineBreakpointManagerKt.escapePath(bl, stringBuilder, string, n, n2, bl2);
    }

    public static final boolean matches(@NotNull String regExp, @NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)regExp, (String)"regExp");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.toDecodedForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.toDecodedForm()");
        return JavaScriptLineBreakpointManagerKt.match(regExp, string);
    }

    public static final boolean match(@NotNull String regExp, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)regExp, (String)"regExp");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            return Pattern.compile(regExp).matcher(input).find();
        }
        catch (PatternSyntaxException e) {
            JavaScriptDebugProcessKt.getLOG().error((Throwable)e);
            return false;
        }
    }

    public static final /* synthetic */ String access$createUrlRegExp(Location location, boolean useCaseSensitiveUrl) {
        return JavaScriptLineBreakpointManagerKt.createUrlRegExp(location, useCaseSensitiveUrl);
    }
}

