/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.JSCachingFileFinderKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.javascript.debugger.locationResolving.SearchResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.intellij.util.io.AsarFileFinder;
import com.intellij.util.io.AsarFileSystem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J:\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001f\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u001cJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010\u001f\u001a\u00020\fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/JSCachingFileFinder;", "", "delegate", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "(Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "asarFileFinder", "Lcom/intellij/util/io/AsarFileFinder;", "getDelegate", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "fileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "findByName", "", "sourceContent", "", "script", "Lorg/jetbrains/debugger/Script;", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getAsarFs", "Lcom/intellij/util/io/AsarFileSystem;", "path", "getAsarFs$intellij_javascript_debugger", "getRemoteUrls", "", "file", "setFileMappings", "", "map", "intellij.javascript.debugger"})
public final class JSCachingFileFinder {
    private volatile JSFileUrlMappings fileMappings;
    private final AsarFileFinder asarFileFinder;
    @NotNull
    private final DebuggableFileFinder delegate;

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = this.asarFileFinder.findFileIfAsar(url, project);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            return it;
        }
        return this.fileMappings.findFile(url, sourceContent, findByName2, script, (Function0<SearchResult>)((Function0)new Function0<SearchResult>(this, url, project, sourceContent, findByName2, script){
            final /* synthetic */ JSCachingFileFinder this$0;
            final /* synthetic */ Url $url;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $sourceContent;
            final /* synthetic */ boolean $findByName;
            final /* synthetic */ Script $script;

            @NotNull
            public final SearchResult invoke() {
                VirtualFile result2 = this.this$0.getDelegate().findFile(this.$url, this.$project);
                SearchAccuracy accuracy = SearchAccuracy.BY_CONTENT;
                if (result2 == null && this.$sourceContent != null) {
                    result2 = FileResolverByContentKt.resolveFileBySourceUrl(this.$project, this.$url, this.$sourceContent);
                }
                if (result2 == null) {
                    result2 = this.this$0.getDelegate().guessFile(this.$url, this.$project);
                    accuracy = SearchAccuracy.BY_URL;
                }
                if (result2 == null && this.$sourceContent == null) {
                    result2 = FileResolverByContentKt.resolveFileBySourceUrl(this.$project, this.$url, null);
                    accuracy = SearchAccuracy.BY_URL;
                }
                if (result2 == null && this.this$0.getDelegate().searchesByName() && this.$findByName) {
                    result2 = RemoteDebuggingFileFinderKt.findByName(this.$url, this.$project);
                    accuracy = SearchAccuracy.BY_NAME;
                }
                if (result2 != null && this.$script != null && !JSCachingFileFinderKt.isFileMatchingScript(result2, this.$script)) {
                    result2 = null;
                }
                return new SearchResult(result2, accuracy);
            }
            {
                this.this$0 = jSCachingFileFinder;
                this.$url = url;
                this.$project = project;
                this.$sourceContent = string;
                this.$findByName = bl;
                this.$script = script;
                super(0);
            }
        }));
    }

    public static /* synthetic */ VirtualFile findFile$default(JSCachingFileFinder jSCachingFileFinder, Url url, Project project, boolean bl, String string, Script script, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            script = null;
        }
        return jSCachingFileFinder.findFile(url, project, bl, string, script);
    }

    @NotNull
    public final List<Url> getRemoteUrls(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.fileMappings.findUrls(file2, (Function0<? extends List<? extends Url>>)((Function0)new Function0<List<? extends Url>>(this, file2){
            final /* synthetic */ JSCachingFileFinder this$0;
            final /* synthetic */ VirtualFile $file;

            @NotNull
            public final List<Url> invoke() {
                return this.this$0.getDelegate().getRemoteUrls(this.$file);
            }
            {
                this.this$0 = jSCachingFileFinder;
                this.$file = virtualFile;
                super(0);
            }
        }));
    }

    public final void setFileMappings(@NotNull JSFileUrlMappings map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        this.fileMappings = map2;
    }

    @Nullable
    public final Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Navigatable navigatable = this.delegate.findNavigatable(url, project);
        if (navigatable == null) {
            navigatable = (Navigatable)JsFileUtil.createNavigatable(project, JSCachingFileFinder.findFile$default(this, url, project, true, null, null, 24, null));
        }
        return navigatable;
    }

    @Nullable
    public final AsarFileSystem getAsarFs$intellij_javascript_debugger(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.asarFileFinder.getAsarFs(path, project);
    }

    @NotNull
    public final DebuggableFileFinder getDelegate() {
        return this.delegate;
    }

    public JSCachingFileFinder(@NotNull DebuggableFileFinder delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.fileMappings = new JSFileUrlMappings();
        this.asarFileFinder = new AsarFileFinder();
    }
}

