/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import java.nio.file.InvalidPathException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00050\u001b2\u0006\u0010\u001c\u001a\u00020\u0015H\u0016J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010 \u001a\u00020\bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/javascript/debugger/DebuggableFileFinderImpl;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "project", "Lcom/intellij/openapi/project/Project;", "requestor", "Lcom/intellij/util/Url;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/Url;)V", "authority", "", "getAuthority$intellij_javascript_debugger", "()Ljava/lang/String;", "fileUrlMappers", "", "Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "getFileUrlMappers", "()[Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "lazyFileUrlMappers", "Lkotlin/Lazy;", "scheme", "computeFileUrlMappers", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "findFileByAuthority", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "findRemoteUrlByExtensionMappers", "", "file", "getRemoteUrls", "isDebuggable", "", "toString", "intellij.javascript.debugger"})
public class DebuggableFileFinderImpl
implements DebuggableFileFinder {
    private final String scheme;
    @Nullable
    private final String authority;
    private final Lazy<FileUrlMapper[]> lazyFileUrlMappers;
    private final Project project;
    private final Url requestor;

    @Nullable
    public final String getAuthority$intellij_javascript_debugger() {
        return this.authority;
    }

    private final FileUrlMapper[] getFileUrlMappers() {
        return (FileUrlMapper[])this.lazyFileUrlMappers.getValue();
    }

    @Nullable
    protected FileUrlMapper[] computeFileUrlMappers() {
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            return null;
        }
        FileUrlMapper[] extensions = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
        Intrinsics.checkNotNullExpressionValue((Object)extensions, (String)"extensions");
        FileUrlMapper[] fileUrlMapperArray = extensions;
        boolean bl = false;
        return fileUrlMapperArray.length == 0 ? null : extensions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isDebuggable(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (this.authority == null) return true;
        if (WebServerPathToFileManager.Companion.getInstance(project).getPath(file2) != null) return true;
        Collection collection = this.findRemoteUrlByExtensionMappers(file2);
        boolean bl = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    private final List<Url> findRemoteUrlByExtensionMappers(VirtualFile file2) {
        List list;
        List result2 = null;
        if (this.getFileUrlMappers() != null) {
            FileUrlMapper[] fileUrlMapperArray = this.getFileUrlMappers();
            Intrinsics.checkNotNull((Object)fileUrlMapperArray);
            for (FileUrlMapper mapper : fileUrlMapperArray) {
                List urls = mapper.getUrls(file2, this.project, this.authority);
                Collection collection = urls;
                boolean bl = false;
                if (!(!collection.isEmpty())) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.addAll(urls);
            }
        }
        if ((list = result2) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        FileUrlMapper[] fileUrlMapperArray;
        block7: {
            block6: {
                Object v1;
                block5: {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        return (Navigatable)JsFileUtil.createNavigatable(project, LocalFileFinder.findFile((String)url.getPath()));
                    }
                    fileUrlMapperArray = this.getFileUrlMappers();
                    if (fileUrlMapperArray == null || (fileUrlMapperArray = ArraysKt.asSequence((Object[])fileUrlMapperArray)) == null || (fileUrlMapperArray = SequencesKt.map((Sequence)fileUrlMapperArray, (Function1)((Function1)new Function1<FileUrlMapper, Navigatable>(this, url, project){
                        final /* synthetic */ DebuggableFileFinderImpl this$0;
                        final /* synthetic */ Url $url;
                        final /* synthetic */ Project $project;

                        @Nullable
                        public final Navigatable invoke(@NotNull FileUrlMapper it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it.getNavigatable(this.$url, this.$project, DebuggableFileFinderImpl.access$getRequestor$p(this.this$0));
                        }
                        {
                            this.this$0 = debuggableFileFinderImpl;
                            this.$url = url;
                            this.$project = project;
                            super(1);
                        }
                    }))) == null) break block6;
                    FileUrlMapper[] fileUrlMapperArray2 = fileUrlMapperArray;
                    boolean bl = false;
                    FileUrlMapper[] fileUrlMapperArray3 = fileUrlMapperArray2;
                    boolean bl2 = false;
                    for (Object e : fileUrlMapperArray3) {
                        Navigatable it = (Navigatable)e;
                        boolean bl3 = false;
                        if (!(it != null)) continue;
                        v1 = e;
                        break block5;
                    }
                    v1 = null;
                }
                if ((fileUrlMapperArray = (Navigatable)v1) != null) break block7;
            }
            fileUrlMapperArray = (Navigatable)JsFileUtil.createNavigatable(project, this.findFileByAuthority(url, project));
        }
        return fileUrlMapperArray;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        FileUrlMapper[] fileUrlMapperArray;
        block9: {
            block8: {
                Object v3;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        String string = url.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
                        String path = string;
                        if (LocalFileFinder.windowsDriveExists((String)path)) {
                            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                            VirtualFile virtualFile = localFileSystem.findFileByPath(path);
                            if (virtualFile == null) {
                                virtualFile = localFileSystem.refreshAndFindFileByPath(path);
                            }
                            return virtualFile;
                        }
                        return null;
                    }
                    fileUrlMapperArray = this.getFileUrlMappers();
                    if (fileUrlMapperArray == null || (fileUrlMapperArray = ArraysKt.asSequence((Object[])fileUrlMapperArray)) == null || (fileUrlMapperArray = SequencesKt.map((Sequence)fileUrlMapperArray, (Function1)((Function1)new Function1<FileUrlMapper, VirtualFile>(this, url, project){
                        final /* synthetic */ DebuggableFileFinderImpl this$0;
                        final /* synthetic */ Url $url;
                        final /* synthetic */ Project $project;

                        @Nullable
                        public final VirtualFile invoke(@NotNull FileUrlMapper it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            return it.getFile(this.$url, this.$project, DebuggableFileFinderImpl.access$getRequestor$p(this.this$0));
                        }
                        {
                            this.this$0 = debuggableFileFinderImpl;
                            this.$url = url;
                            this.$project = project;
                            super(1);
                        }
                    }))) == null) break block8;
                    FileUrlMapper[] fileUrlMapperArray2 = fileUrlMapperArray;
                    boolean bl = false;
                    FileUrlMapper[] fileUrlMapperArray3 = fileUrlMapperArray2;
                    boolean bl2 = false;
                    for (Object e : fileUrlMapperArray3) {
                        VirtualFile it = (VirtualFile)e;
                        boolean bl3 = false;
                        if (!(it != null)) continue;
                        v3 = e;
                        break block7;
                    }
                    v3 = null;
                }
                if ((fileUrlMapperArray = (VirtualFile)v3) != null) break block9;
            }
            fileUrlMapperArray = this.findFileByAuthority(url, project);
        }
        return fileUrlMapperArray;
    }

    private final VirtualFile findFileByAuthority(Url url, Project project) {
        VirtualFile virtualFile;
        if (this.authority != null && StringsKt.equals((String)this.authority, (String)url.getAuthority(), (boolean)true)) {
            VirtualFile virtualFile2;
            try {
                WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
                String string = url.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
                virtualFile2 = WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string, (boolean)false, null, (int)6, null);
            }
            catch (InvalidPathException e) {
                JavaScriptDebugProcessKt.getLOG().warn((Throwable)e);
                virtualFile2 = null;
            }
            virtualFile = virtualFile2;
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        List<Url> urls = this.findRemoteUrlByExtensionMappers(file2);
        Object object = urls;
        boolean bl = false;
        if (!object.isEmpty()) {
            return urls;
        }
        if (this.authority != null) {
            String string = WebServerPathToFileManager.Companion.getInstance(this.project).getPath(file2);
            if (string != null) {
                object = string;
                bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                String string2 = this.scheme;
                Intrinsics.checkNotNull((Object)string2);
                return CollectionsKt.listOf((Object)Urls.newUrl((String)string2, (String)this.authority, (String)('/' + (String)it)));
            }
        }
        if (file2 instanceof VmScriptFile) {
            return CollectionsKt.listOf((Object)((VmScriptFile)file2).getScript().getUrl());
        }
        return CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file2));
    }

    @NotNull
    public String toString() {
        return "DefaultFileFinder";
    }

    public DebuggableFileFinderImpl(@NotNull Project project, @Nullable Url requestor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.requestor = requestor;
        this.lazyFileUrlMappers = LazyKt.lazy((Function0)((Function0)new Function0<FileUrlMapper[]>(this){
            final /* synthetic */ DebuggableFileFinderImpl this$0;

            @Nullable
            public final FileUrlMapper[] invoke() {
                return this.this$0.computeFileUrlMappers();
            }
            {
                this.this$0 = debuggableFileFinderImpl;
                super(0);
            }
        }));
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            this.authority = null;
            this.scheme = null;
        } else if (this.requestor == null) {
            this.authority = null;
            this.scheme = null;
        } else {
            this.authority = this.requestor.getAuthority();
            this.scheme = this.requestor.getScheme();
        }
    }

    @Override
    @Nullable
    public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.guessFile(this, url, project);
    }

    @Override
    public boolean searchesByName() {
        return DebuggableFileFinder.DefaultImpls.searchesByName(this);
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.canSetRemoteUrl(this, file2, project);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file2);
    }

    public static final /* synthetic */ Url access$getRequestor$p(DebuggableFileFinderImpl $this) {
        return $this.requestor;
    }
}

