/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Function;
import com.jetbrains.firefox.FirefoxCallFrame;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxSuspendContext;
import com.jetbrains.firefox.FirefoxSuspendContextKt;
import com.jetbrains.firefox.FirefoxValueManager;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Frame;
import com.jetbrains.firefox.rdp.FramesResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.CallFrame;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000'\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0001\u001a-\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\u0010\f\"\u0010\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0002\u00a8\u0006\r"}, d2={"CALL_FRAMES_LOADER", "com/jetbrains/firefox/FirefoxSuspendContextKt$CALL_FRAMES_LOADER$1", "Lcom/jetbrains/firefox/FirefoxSuspendContextKt$CALL_FRAMES_LOADER$1;", "createFrames", "", "Lorg/jetbrains/debugger/CallFrame;", "result", "Lcom/jetbrains/firefox/rdp/FramesResult;", "topFrame", "Lcom/jetbrains/firefox/FirefoxCallFrame;", "valueManager", "Lcom/jetbrains/firefox/FirefoxValueManager;", "(Lcom/jetbrains/firefox/rdp/FramesResult;Lcom/jetbrains/firefox/FirefoxCallFrame;Lcom/jetbrains/firefox/FirefoxValueManager;)[Lorg/jetbrains/debugger/CallFrame;", "intellij.javascript.firefox.connector"})
public final class FirefoxSuspendContextKt {
    private static final CALL_FRAMES_LOADER.1 CALL_FRAMES_LOADER = new PromiseManager<FirefoxSuspendContext, CallFrame[]>(FirefoxSuspendContext.class){

        @NotNull
        public Promise<CallFrame[]> load(@NotNull FirefoxSuspendContext context) {
            Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
            FirefoxVm vm = context.getVm();
            FirefoxCommandProcessor firefoxCommandProcessor = vm.getCommandProcessor();
            String string = vm.getThreadActor();
            Intrinsics.checkNotNull((Object)string);
            Promise promise = firefoxCommandProcessor.send(FirefoxRequest.Companion.getFrames(string, 1)).then((Function)new Function<FramesResult, CallFrame[]>(context){
                final /* synthetic */ FirefoxSuspendContext $context;

                public final CallFrame[] fun(FramesResult it) {
                    FramesResult framesResult = it;
                    Intrinsics.checkNotNullExpressionValue((Object)framesResult, (String)"it");
                    return FirefoxSuspendContextKt.createFrames(framesResult, this.$context.getTopFrame(), this.$context.getValueManager());
                }
                {
                    this.$context = firefoxSuspendContext;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"vm.commandProcessor.send\u2026, context.valueManager) }");
            return promise;
        }
    };

    @NotNull
    public static final CallFrame[] createFrames(@NotNull FramesResult result, @Nullable FirefoxCallFrame topFrame, @NotNull FirefoxValueManager valueManager) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        int offset = topFrame == null ? 0 : 1;
        CallFrame[] frames = new CallFrame[result.frames().size() + offset];
        if (topFrame != null) {
            frames[0] = (CallFrame)topFrame;
        }
        List<Frame> vmFrames = result.frames();
        boolean useBindingsFromFrameData = topFrame == null;
        int n = vmFrames.size();
        for (int i = 0; i < n; ++i) {
            frames[i + offset] = (CallFrame)new FirefoxCallFrame(valueManager, vmFrames.get(i), useBindingsFromFrameData);
            useBindingsFromFrameData = false;
        }
        return frames;
    }

    public static final /* synthetic */ CALL_FRAMES_LOADER.1 access$getCALL_FRAMES_LOADER$p() {
        return CALL_FRAMES_LOADER;
    }
}

