/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.firefox.FirefoxBreakpoint;
import com.jetbrains.firefox.FirefoxCommandProcessor;
import com.jetbrains.firefox.FirefoxRequest;
import com.jetbrains.firefox.FirefoxScript;
import com.jetbrains.firefox.FirefoxVm;
import com.jetbrains.firefox.rdp.Location;
import com.jetbrains.firefox.rdp.SetBreakpointResult;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointManagerBase;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.rpc.RequestPromise;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J:\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J(\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00122\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0014J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u001a2\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001aJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/firefox/FirefoxBreakpointManager;", "Lorg/jetbrains/debugger/BreakpointManagerBase;", "Lcom/jetbrains/firefox/FirefoxBreakpoint;", "vm", "Lcom/jetbrains/firefox/FirefoxVm;", "(Lcom/jetbrains/firefox/FirefoxVm;)V", "createBreakpoint", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "ignoreCount", "enabled", "", "doClearBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "Ljava/lang/Void;", "breakpoint", "doSetBreakpoint", "Lorg/jetbrains/debugger/Breakpoint;", "url", "Lcom/intellij/util/Url;", "findRelatedBreakpoints", "", "breakpointActors", "getMuteMode", "Lorg/jetbrains/debugger/BreakpointManager$MUTE_MODE;", "sendSetBreakpoint", "", "script", "Lcom/jetbrains/firefox/FirefoxScript;", "scriptUrl", "bpPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "intellij.javascript.firefox.connector"})
public final class FirefoxBreakpointManager
extends BreakpointManagerBase<FirefoxBreakpoint> {
    private final FirefoxVm vm;

    @NotNull
    public final List<Breakpoint> findRelatedBreakpoints(@Nullable List<String> breakpointActors) {
        if (ContainerUtil.isEmpty((Collection)breakpointActors)) {
            return CollectionsKt.emptyList();
        }
        SmartList result = new SmartList();
        for (FirefoxBreakpoint breakpoint : this.getBreakpoints()) {
            String actor = breakpoint.getActor();
            if (actor == null) continue;
            List<String> list = breakpointActors;
            Intrinsics.checkNotNull(list);
            if (!list.contains(actor)) continue;
            result.add((Object)breakpoint);
        }
        return (List)result;
    }

    @NotNull
    protected FirefoxBreakpoint createBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new FirefoxBreakpoint(target, line, column, condition, enabled);
    }

    @NotNull
    protected Promise<Breakpoint> doSetBreakpoint(@NotNull BreakpointTarget target, @Nullable Url url, @NotNull FirefoxBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        String string = ((BreakpointTarget.ScriptName)target).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(target as BreakpointTarget.ScriptName).name");
        String scriptUrl = string;
        FirefoxScript firefoxScript = (FirefoxScript)this.vm.getScriptManager().findScriptByUrl(scriptUrl);
        if (firefoxScript == null) {
            return Promises.rejectedPromise((String)("Script wasn't found: " + scriptUrl));
        }
        FirefoxScript script = firefoxScript;
        AsyncPromise result = new AsyncPromise();
        this.sendSetBreakpoint(breakpoint, script, scriptUrl, (AsyncPromise<Breakpoint>)result);
        return (Promise)result;
    }

    private final void sendSetBreakpoint(FirefoxBreakpoint breakpoint, FirefoxScript script, String scriptUrl, AsyncPromise<Breakpoint> bpPromise) {
        String string = this.vm.getThreadActor();
        Intrinsics.checkNotNull((Object)string);
        FirefoxRequest<SetBreakpointResult> message = FirefoxRequest.Companion.setBreakpoint(string, scriptUrl, breakpoint.getLine(), breakpoint.getColumn());
        RequestPromise callback = new RequestPromise(message.getMethodName());
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string2 = this.vm.getThreadActor();
        Intrinsics.checkNotNull((Object)string2);
        firefoxCommandProcessor.doSendFromPaused(message, string2, callback);
        callback.then((Function)new Function<SetBreakpointResult, FirefoxBreakpoint>(this, scriptUrl, breakpoint){
            final /* synthetic */ FirefoxBreakpointManager this$0;
            final /* synthetic */ String $scriptUrl;
            final /* synthetic */ FirefoxBreakpoint $breakpoint;

            public final FirefoxBreakpoint fun(SetBreakpointResult result) {
                org.jetbrains.debugger.Location location = null;
                Location rawLocation = result.actualLocation();
                if (rawLocation == null) {
                    Url url = Urls.parseEncoded((String)this.$scriptUrl);
                    Intrinsics.checkNotNull((Object)url);
                    location = new org.jetbrains.debugger.Location(url, this.$breakpoint.getLine(), this.$breakpoint.getColumn());
                } else {
                    String string = rawLocation.source().url();
                    Intrinsics.checkNotNull((Object)string);
                    Url url = Urls.parseEncoded((String)string);
                    Intrinsics.checkNotNull((Object)url);
                    location = new org.jetbrains.debugger.Location(url, rawLocation.line() - 1, rawLocation.column());
                }
                this.$breakpoint.setRemoteData(result.actor(), location);
                FirefoxBreakpointManager.access$notifyBreakpointResolvedListener(this.this$0, this.$breakpoint);
                return this.$breakpoint;
            }
            {
                this.this$0 = firefoxBreakpointManager;
                this.$scriptUrl = string;
                this.$breakpoint = firefoxBreakpoint;
            }
        }).onSuccess((Consumer)new Consumer<FirefoxBreakpoint>(bpPromise){
            final /* synthetic */ AsyncPromise $bpPromise;

            public final void accept(FirefoxBreakpoint it) {
                this.$bpPromise.setResult((Object)((Object)it));
            }
            {
                this.$bpPromise = asyncPromise;
            }
        }).onError((Consumer)new Consumer<Throwable>(bpPromise){
            final /* synthetic */ AsyncPromise $bpPromise;

            public final void accept(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"it");
                this.$bpPromise.setError(throwable);
            }
            {
                this.$bpPromise = asyncPromise;
            }
        });
    }

    @NotNull
    protected Promise<Void> doClearBreakpoint(@NotNull FirefoxBreakpoint breakpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)breakpoint), (String)"breakpoint");
        FirefoxCommandProcessor firefoxCommandProcessor = this.vm.getCommandProcessor();
        String string = breakpoint.getActor();
        Intrinsics.checkNotNull((Object)string);
        return firefoxCommandProcessor.send(FirefoxRequest.Companion.deleteBreakpoint(string));
    }

    @NotNull
    public BreakpointManager.MUTE_MODE getMuteMode() {
        return BreakpointManager.MUTE_MODE.NONE;
    }

    public FirefoxBreakpointManager(@NotNull FirefoxVm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
    }

    public static final /* synthetic */ void access$notifyBreakpointResolvedListener(FirefoxBreakpointManager $this, FirefoxBreakpoint breakpoint) {
        $this.notifyBreakpointResolvedListener(breakpoint);
    }
}

