/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesReadUtil {
    @Nullable
    public static Map.Entry<String, Plist> retrieveSettingsPlist(Plist rootPlist) {
        String scopeName = null;
        Plist settingsValuePlist = null;
        PListValue value = rootPlist.getPlistValue("scope");
        if (value != null) {
            scopeName = value.getString();
            PListValue settingsValue = rootPlist.getPlistValue("settings");
            if (scopeName != null && !scopeName.isEmpty() && settingsValue != null) {
                settingsValuePlist = settingsValue.getPlist();
            }
        }
        return settingsValuePlist != null ? new AbstractMap.SimpleImmutableEntry<String, Object>(scopeName, settingsValuePlist) : null;
    }

    @Nullable
    public static Set<TextMateBracePair> readPairs(@Nullable PListValue pairsValue) {
        if (pairsValue == null) {
            return null;
        }
        HashSet result = new HashSet();
        List<PListValue> pairs = pairsValue.getArray();
        for (PListValue pair : pairs) {
            List<PListValue> chars = pair.getArray();
            if (chars.size() != 2) continue;
            String left = chars.get(0).getString();
            String right = chars.get(1).getString();
            if (left.length() != 1 || right.length() != 1) continue;
            result.add(new TextMateBracePair(left.charAt(0), right.charAt(0)));
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    @Nullable
    private static TextMateSnippet loadTextMateSnippet(@NotNull Plist plist, @NotNull String filePath, @NotNull Interner<CharSequence> interner) {
        if (plist == null) {
            PreferencesReadUtil.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            PreferencesReadUtil.$$$reportNull$$$0(1);
        }
        if (interner == null) {
            PreferencesReadUtil.$$$reportNull$$$0(2);
        }
        String name = plist.getPlistValue("name", "").getString();
        String key = plist.getPlistValue("tabTrigger", "").getString();
        String content = plist.getPlistValue(Constants.StringKey.CONTENT.value, "").getString();
        String scope = plist.getPlistValue("scope", "").getString();
        String description = plist.getPlistValue("description", "").getString();
        Object uuid = plist.getPlistValue("uuid", "").getString();
        if (!key.isEmpty() && !content.isEmpty()) {
            if (name.isEmpty()) {
                name = key;
            }
            if (((String)uuid).isEmpty()) {
                uuid = filePath + ":" + name;
            }
            return new TextMateSnippet(key, content, (CharSequence)interner.intern((Object)scope), name, description, (String)uuid);
        }
        return null;
    }

    @NotNull
    public static <K, V> Map<K, V> compactMap(@NotNull Map<K, V> map) {
        if (map == null) {
            PreferencesReadUtil.$$$reportNull$$$0(3);
        }
        if (map.isEmpty()) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                PreferencesReadUtil.$$$reportNull$$$0(4);
            }
            return map2;
        }
        if (map.size() == 1) {
            Map.Entry<K, V> singleEntry = map.entrySet().iterator().next();
            Map<K, V> map3 = Collections.singletonMap(singleEntry.getKey(), singleEntry.getValue());
            if (map3 == null) {
                PreferencesReadUtil.$$$reportNull$$$0(5);
            }
            return map3;
        }
        if (!(map instanceof HashMap)) {
            Map<K, V> map4 = map;
            if (map4 == null) {
                PreferencesReadUtil.$$$reportNull$$$0(6);
            }
            return map4;
        }
        HashMap<K, V> result = new HashMap<K, V>(map.size(), 1.0f);
        result.putAll(map);
        HashMap<K, V> hashMap = result;
        if (hashMap == null) {
            PreferencesReadUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    private PreferencesReadUtil() {
    }

    @Nullable
    public static TextMateSnippet loadSnippet(@NotNull File snippetFile, @NotNull Plist plist, @NotNull Interner<CharSequence> interner) {
        if (snippetFile == null) {
            PreferencesReadUtil.$$$reportNull$$$0(8);
        }
        if (plist == null) {
            PreferencesReadUtil.$$$reportNull$$$0(9);
        }
        if (interner == null) {
            PreferencesReadUtil.$$$reportNull$$$0(10);
        }
        return snippetFile.getName().endsWith(".sublime-snippet") ? null : PreferencesReadUtil.loadTextMateSnippet(plist, snippetFile.getAbsolutePath(), interner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plist";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/language/PreferencesReadUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippetFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/language/PreferencesReadUtil";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "compactMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadTextMateSnippet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compactMap";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadSnippet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

