/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.options;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueCodeStyleSettings;
import org.jetbrains.vuejs.options.VueCodeStyleMainPanel;
import org.jetbrains.vuejs.options.VueCodeStyleSettingsProvider$WhenMappings;
import org.jetbrains.vuejs.options.VueIndentOptionsEditor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\n\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Lorg/jetbrains/vuejs/options/VueCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "()V", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "settings", "createFileFromText", "Lcom/intellij/psi/PsiFile;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "customizeDefaults", "", "commonSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "indentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "customizeSettings", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "getCodeSample", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "getLanguage", "Lcom/intellij/lang/Language;", "intellij.vuejs"})
public final class VueCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return (Language)VueLanguage.Companion.getINSTANCE();
    }

    @Nullable
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        return "  <template>\n    <div id=\"app\">\n          <img      alt=\"Vue logo\"        \n src=\"./assets/logo.png\">\n    <HelloWorld  \n msg =  \"Welcome to Your Vue.js App\"/></div>\n <span>{{descr    }}</span>\n <span>{{ (function (){ alert(\"Vue is great!\")   } return \"Really great!\")() }}</span>\n</template>\n\n <script>\n    import HelloWorld  from './components/HelloWorld.vue'\n\n    export  default  {\n  name:    'App'  ,\n     components:     {\n    HelloWorld}\n  }\n</script>\n\n  <style>\n       #app      {\n  font-family: Avenir, Helvetica, Arial, sans-serif;\n   text-align: center;   color    : #2c3e50;}\n</style>";
    }

    @Nullable
    public PsiFile createFileFromText(@NotNull Project project, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a.{{.}}.#@injected@#.html", (Language)VueLanguage.Companion.getINSTANCE(), (CharSequence)text, false, true);
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new VueIndentOptionsEditor();
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        return (CodeStyleConfigurable)new CodeStyleAbstractConfigurable(this, baseSettings, modelSettings, baseSettings, modelSettings, this.getConfigurableDisplayName()){
            final /* synthetic */ VueCodeStyleSettingsProvider this$0;
            final /* synthetic */ CodeStyleSettings $baseSettings;
            final /* synthetic */ CodeStyleSettings $modelSettings;

            @NotNull
            protected CodeStyleAbstractPanel createPanel(@NotNull CodeStyleSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                return (CodeStyleAbstractPanel)new VueCodeStyleMainPanel(this.getCurrentSettings(), settings);
            }

            @Nullable
            public String getHelpTopic() {
                return "reference.settingsdialog.IDE.vuecodestyle";
            }
            {
                this.this$0 = this$0;
                this.$baseSettings = $captured_local_variable$1;
                this.$modelSettings = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        Intrinsics.checkNotNullParameter((Object)commonSettings, (String)"commonSettings");
        Intrinsics.checkNotNullParameter((Object)indentOptions, (String)"indentOptions");
        indentOptions.TAB_SIZE = 2;
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new VueCodeStyleSettings(settings);
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (VueCodeStyleSettingsProvider$WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                consumer.showCustomOption(VueCodeStyleSettings.class, "SPACES_WITHIN_INTERPOLATION_EXPRESSIONS", VueBundle.message("vue.formatting.spacing.within.interpolations", new Object[0]), VueBundle.message("vue.formatting.spacing.within.group", new Object[0]), new Object[0]);
                break;
            }
            case 2: {
                consumer.showCustomOption(VueCodeStyleSettings.class, "INTERPOLATION_WRAP", VueBundle.message("vue.formatting.wrapping.interpolations", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
                consumer.showCustomOption(VueCodeStyleSettings.class, "INTERPOLATION_NEW_LINE_AFTER_START_DELIMITER", VueBundle.message("vue.formatting.wrapping.new-line-after-start-delimiter", new Object[0]), VueBundle.message("vue.formatting.wrapping.interpolations", new Object[0]), new Object[0]);
                consumer.showCustomOption(VueCodeStyleSettings.class, "INTERPOLATION_NEW_LINE_BEFORE_END_DELIMITER", VueBundle.message("vue.formatting.wrapping.new-line-before-end-delimiter", new Object[0]), VueBundle.message("vue.formatting.wrapping.interpolations", new Object[0]), new Object[0]);
                break;
            }
        }
    }
}

